package com.ejianc.business.jlincome.performance.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 绩效管理-销售预报-主表
 *
 * @author generator
 */
public class ForecastRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Integer billState; // 单据状态
    private String billCode; // 单据编码
    private Long orgId; // 项目部主键
    private String orgName; // 项目部名称/区域名称
    private String orgCode; // 项目组织编码
    private Long parentOrgId; // 组织ID
    private String parentOrgName; // 组织名称
    private String parentOrgCode; // 组织编码
    private Long orgPersonId; // 区域统计员id
    private String orgPersonName; // 区域统计员
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date forecastMonth; // 预报月份
    private String forecastName; // 销售预报标题
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date forecastDate; // 预报提交日期
    private BigDecimal saleForecastMny; // 销售任务总额（万元）
    private BigDecimal invoiceForecastMny; // 开票任务总额（万元）
    private BigDecimal incomeForecastMny; // 收款任务总额（万元
    private String memo; // 备注
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long deptId; // 经办部门
    private String deptName; // 经办部门名称
    private Long changeId; // 变更单主键
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeDate; // 变更日期
    private Long changeEmployeeId; // 变更经办人
    private String changeEmployeeName; // 变更经办人名称
    private String changeReason; // 变更原因
    private Integer changeState; // 变更状态(0-未变更1-变更中2-已变更)
    private Integer latestFlag; // 是否最新版本
    private Integer enableState; // 是否生效
    private Integer forecastVersion; // 版本号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date effectDate; //生效时间
    private Integer beforeForecastVersion; // 历史版本号
    private Long lastForecastId; // 上一版本主键
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date oneTime; // 第一版本创建时间
    private Long baseForecastId; // 原始版本主键

    private List<ForecastDetailVO> forecastDetailList = new ArrayList<>(); // 绩效管理-销售预报-子表

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getOrgPersonId() {
        return orgPersonId;
    }

    @ReferDeserialTransfer
    public void setOrgPersonId(Long orgPersonId) {
        this.orgPersonId = orgPersonId;
    }

    public String getOrgPersonName() {
        return orgPersonName;
    }

    public void setOrgPersonName(String orgPersonName) {
        this.orgPersonName = orgPersonName;
    }

    public Date getForecastMonth() {
        return forecastMonth;
    }

    public void setForecastMonth(Date forecastMonth) {
        this.forecastMonth = forecastMonth;
    }

    public String getForecastName() {
        return forecastName;
    }

    public void setForecastName(String forecastName) {
        this.forecastName = forecastName;
    }

    public Date getForecastDate() {
        return forecastDate;
    }

    public void setForecastDate(Date forecastDate) {
        this.forecastDate = forecastDate;
    }

    public BigDecimal getSaleForecastMny() {
        return saleForecastMny;
    }

    public void setSaleForecastMny(BigDecimal saleForecastMny) {
        this.saleForecastMny = saleForecastMny;
    }

    public BigDecimal getInvoiceForecastMny() {
        return invoiceForecastMny;
    }

    public void setInvoiceForecastMny(BigDecimal invoiceForecastMny) {
        this.invoiceForecastMny = invoiceForecastMny;
    }

    public BigDecimal getIncomeForecastMny() {
        return incomeForecastMny;
    }

    public void setIncomeForecastMny(BigDecimal incomeForecastMny) {
        this.incomeForecastMny = incomeForecastMny;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDeptId() {
        return deptId;
    }

    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public Long getChangeEmployeeId() {
        return changeEmployeeId;
    }

    public void setChangeEmployeeId(Long changeEmployeeId) {
        this.changeEmployeeId = changeEmployeeId;
    }

    public String getChangeEmployeeName() {
        return changeEmployeeName;
    }

    public void setChangeEmployeeName(String changeEmployeeName) {
        this.changeEmployeeName = changeEmployeeName;
    }

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }

    public Integer getLatestFlag() {
        return latestFlag;
    }

    public void setLatestFlag(Integer latestFlag) {
        this.latestFlag = latestFlag;
    }

    public Integer getEnableState() {
        return enableState;
    }

    public void setEnableState(Integer enableState) {
        this.enableState = enableState;
    }

    public Integer getForecastVersion() {
        return forecastVersion;
    }

    public void setForecastVersion(Integer forecastVersion) {
        this.forecastVersion = forecastVersion;
    }

    public Integer getBeforeForecastVersion() {
        return beforeForecastVersion;
    }

    public void setBeforeForecastVersion(Integer beforeForecastVersion) {
        this.beforeForecastVersion = beforeForecastVersion;
    }

    public Long getLastForecastId() {
        return lastForecastId;
    }

    public void setLastForecastId(Long lastForecastId) {
        this.lastForecastId = lastForecastId;
    }

    public Date getOneTime() {
        return oneTime;
    }

    public void setOneTime(Date oneTime) {
        this.oneTime = oneTime;
    }

    public Long getBaseForecastId() {
        return baseForecastId;
    }

    public void setBaseForecastId(Long baseForecastId) {
        this.baseForecastId = baseForecastId;
    }

    public Date getEffectDate() {
        return effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }

    public List<ForecastDetailVO> getForecastDetailList() {
        return forecastDetailList;
    }

    public void setForecastDetailList(List<ForecastDetailVO> forecastDetailList) {
        this.forecastDetailList = forecastDetailList;
    }
}
