package com.ejianc.business.jlincome.performance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.jlincome.performance.vo.TaskDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 任务下达-主表
 *
 * @author generator
 *
 */
public class TaskVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    /**
     * 总计划变更状态：未变更
     */
    public static final Integer TASK_CHANGE_STATE_UNCHANGED = 0;

    /**
     * 总计划变更状态：变更中
     */
    public static final Integer TASK_CHANGE_STATE_CHANGING = 1;

    /**
     * 总计划变更状态：已变更
     */
    public static final Integer TASK_CHANGE_STATE_CHANGED = 2;

    private Integer billState; // 单据状态
    private String billCode; // 单据编码
    private Long orgId; // 项目部主键
    private String orgName; // 项目部名称/区域名称
    private String orgCode; // 项目组织编码
    private Long parentOrgId; // 组织ID
    private String parentOrgName; // 组织名称
    private String parentOrgCode; // 组织编码
    private Long orgPersonId; // 区域负责人id
    private String orgPersonName; // 区域负责人

    @JsonFormat(pattern = "yyyy", timezone = "GMT+8")
    private Date taskYear; // 任务年度
    private String taskName; // 任务下达标题
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date taskDate; // 任务下达日期
    private BigDecimal saleTaskMny; // 销售任务总额（万元）
    private BigDecimal invoiceTaskMny; // 开票任务总额（万元）
    private BigDecimal incomeTaskMny; // 收款任务总额（万元
    private String memo; // 备注
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long deptId; // 经办部门
    private String deptName; // 经办部门名称

    private Long changeId; // 变更单主键
    private Integer changeState; // 变更状态(0-未变更1-变更中2-已变更)
    //
    private Boolean latestFlag; // 是否最新版本
    private Boolean enableState; // 是否生效
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date effectDate; // 生效时间

    private Integer taskVersion; // 版本号
    //
    private Integer beforeTaskVersion; // 历史版本号（记录值，变更时记录之前的版本号）

    private Long lastTaskId; // 上一版本主键（变更时赋值）
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date oneTime; // 第一版本创建时间（
    private Long baseTaskId; // 原始版本主键（用于展示变更记录）

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeDate; // 变更日期
    private Long changeEmployeeId; // 变更经办人
    private String changeEmployeeName; // 变更经办人名称
    private String changeReason; // 变更原因

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeEffectDate; // 变更生效时间

    private Integer quarterOneRatio; // 第一季度比例
    private Integer quarterTwoRatio; // 第二季度比例
    private Integer quarterThreeRatio; // 第三季度比例
    private Integer quarterFourRatio; // 第四季度比例

    private String changeStateName; // 变更状态名称
    private String billStateName; // 单据状态名称
    private String taskYearName; // 任务年度名称

    private List<TaskDetailVO> detailList = new ArrayList<>(); // 任务下达-子表
    private List<TaskRecordVO> recordList = new ArrayList<>(); // 变更记录表

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getOrgPersonId() {
        return orgPersonId;
    }
    @ReferDeserialTransfer
    public void setOrgPersonId(Long orgPersonId) {
        this.orgPersonId = orgPersonId;
    }
    public String getOrgPersonName() {
        return orgPersonName;
    }

    public void setOrgPersonName(String orgPersonName) {
        this.orgPersonName = orgPersonName;
    }
    public Date getTaskYear() {
        return taskYear;
    }

    public void setTaskYear(Date taskYear) {
        this.taskYear = taskYear;
    }
    public String getTaskName() {
        return taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }
    public Date getTaskDate() {
        return taskDate;
    }

    public void setTaskDate(Date taskDate) {
        this.taskDate = taskDate;
    }
    public BigDecimal getSaleTaskMny() {
        return saleTaskMny;
    }

    public void setSaleTaskMny(BigDecimal saleTaskMny) {
        this.saleTaskMny = saleTaskMny;
    }
    public BigDecimal getInvoiceTaskMny() {
        return invoiceTaskMny;
    }

    public void setInvoiceTaskMny(BigDecimal invoiceTaskMny) {
        this.invoiceTaskMny = invoiceTaskMny;
    }
    public BigDecimal getIncomeTaskMny() {
        return incomeTaskMny;
    }

    public void setIncomeTaskMny(BigDecimal incomeTaskMny) {
        this.incomeTaskMny = incomeTaskMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDeptId() {
        return deptId;
    }

    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }

    public Boolean getLatestFlag() {
        return latestFlag;
    }

    public void setLatestFlag(Boolean latestFlag) {
        this.latestFlag = latestFlag;
    }

    public Boolean getEnableState() {
        return enableState;
    }

    public void setEnableState(Boolean enableState) {
        this.enableState = enableState;
    }

    public Integer getTaskVersion() {
        return taskVersion;
    }

    public void setTaskVersion(Integer taskVersion) {
        this.taskVersion = taskVersion;
    }
    public Integer getBeforeTaskVersion() {
        return beforeTaskVersion;
    }

    public void setBeforeTaskVersion(Integer beforeTaskVersion) {
        this.beforeTaskVersion = beforeTaskVersion;
    }
    public Long getLastTaskId() {
        return lastTaskId;
    }

    public void setLastTaskId(Long lastTaskId) {
        this.lastTaskId = lastTaskId;
    }
    public Date getOneTime() {
        return oneTime;
    }

    public void setOneTime(Date oneTime) {
        this.oneTime = oneTime;
    }
    public Long getBaseTaskId() {
        return baseTaskId;
    }

    public void setBaseTaskId(Long baseTaskId) {
        this.baseTaskId = baseTaskId;
    }

    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getChangeEmployeeId() {
        return changeEmployeeId;
    }
    @ReferDeserialTransfer
    public void setChangeEmployeeId(Long changeEmployeeId) {
        this.changeEmployeeId = changeEmployeeId;
    }

    public String getChangeEmployeeName() {
        return changeEmployeeName;
    }

    public void setChangeEmployeeName(String changeEmployeeName) {
        this.changeEmployeeName = changeEmployeeName;
    }

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public List<TaskDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<TaskDetailVO> detailList) {
        this.detailList = detailList;
    }

    public List<TaskRecordVO> getRecordList() {
        return recordList;
    }

    public void setRecordList(List<TaskRecordVO> recordList) {
        this.recordList = recordList;
    }

    public Date getEffectDate() {
        return effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }

    public Integer getQuarterOneRatio() {
        return quarterOneRatio;
    }

    public void setQuarterOneRatio(Integer quarterOneRatio) {
        this.quarterOneRatio = quarterOneRatio;
    }

    public Integer getQuarterTwoRatio() {
        return quarterTwoRatio;
    }

    public void setQuarterTwoRatio(Integer quarterTwoRatio) {
        this.quarterTwoRatio = quarterTwoRatio;
    }

    public Integer getQuarterThreeRatio() {
        return quarterThreeRatio;
    }

    public void setQuarterThreeRatio(Integer quarterThreeRatio) {
        this.quarterThreeRatio = quarterThreeRatio;
    }

    public Integer getQuarterFourRatio() {
        return quarterFourRatio;
    }

    public void setQuarterFourRatio(Integer quarterFourRatio) {
        this.quarterFourRatio = quarterFourRatio;
    }

    public String getChangeStateName() {
        return changeStateName;
    }

    public void setChangeStateName(String changeStateName) {
        this.changeStateName = changeStateName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getTaskYearName() {
        return taskYearName;
    }

    public void setTaskYearName(String taskYearName) {
        this.taskYearName = taskYearName;
    }

    public Date getChangeEffectDate() {
        return changeEffectDate;
    }

    public void setChangeEffectDate(Date changeEffectDate) {
        this.changeEffectDate = changeEffectDate;
    }
}
