package com.ejianc.business.jlincome.report.vo;

import com.ejianc.foundation.share.utils.ITreeNodeB;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 战略合作/年度协议详情
 *
 * @author generator
 */
public class StrategyDetailReportVO extends BaseVO implements ITreeNodeB {
    private static final long serialVersionUID = 1L;

    private Long pid; // 主表id
    private Long unitId; // 单位id
    private String unitName; // 单位名称
    private String duty; // 职务
    private Long projectId; // 合作项目id
    private String projectName; // 合作项目名称
    private String projectCode; // 合作项目编码
    private BigDecimal lastFinish; // 上一年累计完成
    private BigDecimal yearFinish; // 本年累计完成
    private BigDecimal monthForecast; // 本月预报
    private BigDecimal yearForecast; // 本年预报
    private Long employeeId; // 业务负责人id
    private String employeeName; // 业务负责人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signingDate; // 签订日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 截止日期
    private Long ways; // 合作方式
    private String waysName; // 合作方式

    private String reportName; // 填报人名称
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private String reportMonth; // 填报月份
    private List<ITreeNodeB> children;

    @Override
    public Long getNodeID() {
        return getId();
    }

    @Override
    public Long getParentID() {
        return pid;
    }

    @Override
    public List<ITreeNodeB> getChildren() {
        if (children == null) {
            children = new ArrayList<>();
        }
        return children;
    }

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    @ReferSerialTransfer(referCode = "support-customer")
    public Long getUnitId() {
        return unitId;
    }

    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getDuty() {
        return duty;
    }

    public void setDuty(String duty) {
        this.duty = duty;
    }

    @ReferSerialTransfer(referCode = "project-archive")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public BigDecimal getLastFinish() {
        return lastFinish;
    }

    public void setLastFinish(BigDecimal lastFinish) {
        this.lastFinish = lastFinish;
    }

    public BigDecimal getYearFinish() {
        return yearFinish;
    }

    public void setYearFinish(BigDecimal yearFinish) {
        this.yearFinish = yearFinish;
    }

    public BigDecimal getMonthForecast() {
        return monthForecast;
    }

    public void setMonthForecast(BigDecimal monthForecast) {
        this.monthForecast = monthForecast;
    }

    public BigDecimal getYearForecast() {
        return yearForecast;
    }

    public void setYearForecast(BigDecimal yearForecast) {
        this.yearForecast = yearForecast;
    }

    @ReferSerialTransfer(referCode = "idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Date getSigningDate() {
        return signingDate;
    }

    public void setSigningDate(Date signingDate) {
        this.signingDate = signingDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Long getWays() {
        return ways;
    }

    public void setWays(Long ways) {
        this.ways = ways;
    }

    public String getReportName() {
        return reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public String getReportMonth() {
        return reportMonth;
    }

    public void setReportMonth(String reportMonth) {
        this.reportMonth = reportMonth;
    }

    public String getWaysName() {
        return waysName;
    }

    public void setWaysName(String waysName) {
        this.waysName = waysName;
    }
}
