package com.ejianc.business.jlincome.report.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 已合作重点客户单位市场分析明细
 * 
 * @author generator
 * 
 */
public class MarketAnalysisDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long analysisId; // 主表主键ID
    private Long detailEmployeeId; // 销售负责人
    private String detailEmployeeName; // 销售负责人名称
    private Long customerId; // 重点客户单位id
    private String customerName; // 重点客户单位名称
    private String customerCode; // 重点客户单位编码
    private BigDecimal lastGccpMny; // 去年工程产品销售额
    private BigDecimal lastSjcpMny; // 去年索具产品销售额
    private BigDecimal gccpSumMny; // 本年工程产品累计完成金额
    private BigDecimal sjcpSumMny; // 本年索具产品累计完成金额
    private BigDecimal ybMny; // 本年本月预报金额
    private BigDecimal yjGccpMny; // 本年预计工程产品销售额
    private BigDecimal yjSjcpMny; // 本年预计索具产品销售额
    private BigDecimal marketScale; // 当前市场占有率
    private String unCooperate; // 未合作产品
    private String memo; // 备注
    

    public Long getAnalysisId() {
        return analysisId;
    }

    public void setAnalysisId(Long analysisId) {
        this.analysisId = analysisId;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getDetailEmployeeId() {
        return detailEmployeeId;
    }
    @ReferDeserialTransfer
    public void setDetailEmployeeId(Long detailEmployeeId) {
        this.detailEmployeeId = detailEmployeeId;
    }
    public String getDetailEmployeeName() {
        return detailEmployeeName;
    }

    public void setDetailEmployeeName(String detailEmployeeName) {
        this.detailEmployeeName = detailEmployeeName;
    }
    @ReferSerialTransfer(referCode="support-customer")
    public Long getCustomerId() {
        return customerId;
    }
    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public String getCustomerCode() {
        return customerCode;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }
    public BigDecimal getLastGccpMny() {
        return lastGccpMny;
    }

    public void setLastGccpMny(BigDecimal lastGccpMny) {
        this.lastGccpMny = lastGccpMny;
    }
    public BigDecimal getLastSjcpMny() {
        return lastSjcpMny;
    }

    public void setLastSjcpMny(BigDecimal lastSjcpMny) {
        this.lastSjcpMny = lastSjcpMny;
    }
    public BigDecimal getGccpSumMny() {
        return gccpSumMny;
    }

    public void setGccpSumMny(BigDecimal gccpSumMny) {
        this.gccpSumMny = gccpSumMny;
    }
    public BigDecimal getSjcpSumMny() {
        return sjcpSumMny;
    }

    public void setSjcpSumMny(BigDecimal sjcpSumMny) {
        this.sjcpSumMny = sjcpSumMny;
    }
    public BigDecimal getYbMny() {
        return ybMny;
    }

    public void setYbMny(BigDecimal ybMny) {
        this.ybMny = ybMny;
    }
    public BigDecimal getYjGccpMny() {
        return yjGccpMny;
    }

    public void setYjGccpMny(BigDecimal yjGccpMny) {
        this.yjGccpMny = yjGccpMny;
    }
    public BigDecimal getYjSjcpMny() {
        return yjSjcpMny;
    }

    public void setYjSjcpMny(BigDecimal yjSjcpMny) {
        this.yjSjcpMny = yjSjcpMny;
    }
    public BigDecimal getMarketScale() {
        return marketScale;
    }

    public void setMarketScale(BigDecimal marketScale) {
        this.marketScale = marketScale;
    }
    public String getUnCooperate() {
        return unCooperate;
    }

    public void setUnCooperate(String unCooperate) {
        this.unCooperate = unCooperate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
