/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.performance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.jlincome.performance.bean.PoolEntity;
import com.ejianc.business.jlincome.performance.bean.SaleContractEntity;
import com.ejianc.business.jlincome.performance.bean.SaleReportEntity;
import com.ejianc.business.jlincome.performance.mapper.SaleReportMapper;
import com.ejianc.business.jlincome.performance.service.IPoolService;
import com.ejianc.business.jlincome.performance.service.ISaleContractService;
import com.ejianc.business.jlincome.performance.service.ISaleReportService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="saleReportService")
public class SaleReportServiceImpl
extends BaseServiceImpl<SaleReportMapper, SaleReportEntity>
implements ISaleReportService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String COLLECT_FILL_QUEUE = "sale_pool_date_queue";
    @Value(value="${spring.cloud.config.profile}")
    private String profile;
    @Autowired
    private IPoolService poolService;
    @Autowired
    private ISaleContractService saleContractService;
    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Override
    public void saveInitPoolDate() {
        this.poolService.deletePoolDetail();
        this.logger.info("\u5220\u9664\u6570\u636e\u5b8c\u6210-");
        List<Object> resList = new ArrayList();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.in(SaleContractEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        List saleContractEntityList = this.saleContractService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)saleContractEntityList)) {
            resList = this.changeSale(saleContractEntityList);
        }
        this.poolService.saveBatch(resList);
        MqMessage mqMessage = new MqMessage();
        mqMessage.setBody((Object)"111");
        this.rabbitTemplate.convertAndSend("sale_pool_date_queue_" + this.profile, (Object)mqMessage);
        this.logger.info("MQ\u961f\u5217\u6807\u8bc6\uff1a{}", (Object)("sale_pool_date_queue_" + this.profile));
    }

    public List<PoolEntity> changeSale(List<SaleContractEntity> saleContractEntityList) {
        ArrayList<PoolEntity> resList = new ArrayList<PoolEntity>();
        saleContractEntityList.forEach(e -> {
            PoolEntity poolEntity = new PoolEntity();
            poolEntity.setId(e.getId());
            poolEntity.setContractId(e.getContractId());
            poolEntity.setContractCode(e.getContractCode());
            poolEntity.setContractName(e.getContractName());
            poolEntity.setProjectId(e.getProjectId());
            poolEntity.setProjectCode(e.getProjectCode());
            poolEntity.setProjectName(e.getProjectName());
            poolEntity.setOrgId(e.getOrgId());
            poolEntity.setOrgCode(e.getOrgCode());
            poolEntity.setOrgName(e.getOrgName());
            poolEntity.setCustomerId(e.getCustomerId());
            poolEntity.setCustomerName(e.getCustomerName());
            poolEntity.setSaleId(e.getSaleId());
            poolEntity.setSaleName(e.getSaleName());
            poolEntity.setSourceType(1);
            poolEntity.setSourceId(e.getId());
            poolEntity.setSourceBillCode(e.getBillCode());
            poolEntity.setSourceDate(e.getRegisterDate());
            SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM");
            try {
                poolEntity.setSourceMonth(format1.format(e.getRegisterDate()));
            }
            catch (Exception exc) {
                this.logger.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38: ", (Throwable)exc);
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
            poolEntity.setSourceYear(simpleDateFormat.format(e.getRegisterDate()));
            poolEntity.setMny(e.getRegisterMny());
            poolEntity.setTaxMny(e.getRegisterMny());
            resList.add(poolEntity);
        });
        return resList;
    }
}

