/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.performance.service.impl;

import com.ejianc.business.jlincome.performance.bean.TaskEntity;
import com.ejianc.business.jlincome.performance.enums.ChangeStateEnum;
import com.ejianc.business.jlincome.performance.service.ITaskService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="task")
public class TaskBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ITaskService taskService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u63d0\u4ea4\u524d\u56de\u8c03");
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u63d0\u4ea4\u5b8c\u56de\u8c03");
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u6709\u5ba1\u6279\u6d41\u7684\u64a4\u56de\u524d\u56de\u8c03");
        TaskEntity taskEntity = (TaskEntity)((Object)this.taskService.selectById(billId));
        if (1 == taskEntity.getTaskVersion() && ChangeStateEnum.\u53d8\u66f4\u4e2d.getCode().toString().equals(taskEntity.getChangeState().toString())) {
            throw new BusinessException("\u8be5\u5355\u636e\u6b63\u5728\u53d8\u66f4\u4e2d\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        taskEntity.setEnableState(false);
        taskEntity.setEffectDate(null);
        this.taskService.saveOrUpdate((Object)taskEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u6709\u5ba1\u6279\u6d41\u7684\u64a4\u56de\u540e\u56de\u8c03");
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        this.logger.info("\u5ba1\u6279\u8282\u70b9\u5ba1\u6279\u4e2d\u65f6\u8282\u70b9\u5ba1\u6279\u524d\u56de\u8c03");
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u524d\u56de\u8c03");
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03");
        TaskEntity taskEntity = (TaskEntity)((Object)this.taskService.selectById(billId));
        taskEntity.setEnableState(true);
        taskEntity.setEffectDate(new Date());
        if (taskEntity.getTaskVersion() != 1) {
            taskEntity.setChangeState(ChangeStateEnum.\u5df2\u53d8\u66f4.getCode());
        }
        this.taskService.saveOrUpdate((Object)taskEntity);
        if (taskEntity.getLastTaskId() != null) {
            TaskEntity revise = (TaskEntity)((Object)this.taskService.selectById(taskEntity.getLastTaskId()));
            revise.setChangeState(ChangeStateEnum.\u5df2\u53d8\u66f4.getCode());
            revise.setEnableState(false);
            revise.setBillCode(revise.getBillCode() + "0000" + taskEntity.getBeforeTaskVersion());
            revise.setChangeEmployeeId(taskEntity.getChangeEmployeeId());
            revise.setChangeEmployeeName(taskEntity.getChangeEmployeeName());
            revise.setChangeDate(taskEntity.getChangeDate());
            revise.setChangeReason(taskEntity.getChangeReason());
            revise.setChangeEffectDate(new Date());
            this.taskService.saveOrUpdate((Object)revise);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5f03\u5ba1\u524d\u4e8b\u4ef6\u56de\u8c03");
        TaskEntity taskEntity = (TaskEntity)((Object)this.taskService.selectById(billId));
        if (1 == taskEntity.getTaskVersion() && ChangeStateEnum.\u53d8\u66f4\u4e2d.getCode().toString().equals(taskEntity.getChangeState().toString())) {
            throw new BusinessException("\u8be5\u5355\u636e\u6b63\u5728\u53d8\u66f4\u4e2d\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        taskEntity.setEnableState(false);
        taskEntity.setEffectDate(null);
        this.taskService.saveOrUpdate((Object)taskEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5f03\u5ba1\u540e\u4e8b\u4ef6\u56de\u8c03");
        return CommonResponse.success();
    }
}

