/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.performance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlincome.performance.bean.ForecastDetailEntity;
import com.ejianc.business.jlincome.performance.service.IForecastDetailService;
import com.ejianc.business.jlincome.performance.service.IForecastService;
import com.ejianc.business.jlincome.performance.service.impl.ForecastDetailServiceImpl;
import com.ejianc.business.jlincome.performance.vo.ForecastLedgerVO;
import com.ejianc.business.jlincome.performance.vo.ForecastVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"forecast"})
public class ForecastController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ForecastDetailServiceImpl forecastDetailService;
    private static final String BILL_CODE = "FORECAST_CODE";
    @Autowired
    private IForecastService service;
    @Autowired
    private IForecastDetailService detailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ForecastVO> saveOrUpdate(@RequestBody ForecastVO saveOrUpdateVO) {
        return this.service.insertOrUpdate(saveOrUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ForecastVO> queryDetail(Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryDetail(id));
    }

    @RequestMapping(value={"/queryChangeDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ForecastVO> queryChangeDetail(Long id) {
        ForecastVO changeVO = this.service.queryChangeDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)changeVO);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ForecastVO> vos) {
        return this.service.deleteVos(vos);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ForecastVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("forecastName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgPersonName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        ComplexParam resultComplexParam = new ComplexParam();
        resultComplexParam.setLogic("and");
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("enableState", new Parameter("eq", (Object)true));
        ComplexParam complex2 = new ComplexParam();
        complex2.setLogic("or");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("and");
        c2.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        complex2.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("and");
        c3.getParams().put("enableState", new Parameter("eq", (Object)false));
        complex2.getComplexParams().add(c3);
        ComplexParam c5 = new ComplexParam();
        c5.setLogic("and");
        c5.getParams().put("forecastVersion", new Parameter("eq", (Object)"1"));
        complex2.getComplexParams().add(c5);
        resultComplexParam.getComplexParams().add(c1);
        resultComplexParam.getComplexParams().add(complex2);
        param.getComplexParams().add(resultComplexParam);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ForecastVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("forecastName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgPersonName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        ComplexParam resultComplexParam = new ComplexParam();
        resultComplexParam.setLogic("and");
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("enableState", new Parameter("eq", (Object)true));
        ComplexParam complex2 = new ComplexParam();
        complex2.setLogic("or");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("and");
        c2.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        complex2.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("and");
        c3.getParams().put("enableState", new Parameter("eq", (Object)false));
        complex2.getComplexParams().add(c3);
        ComplexParam c5 = new ComplexParam();
        c5.setLogic("and");
        c5.getParams().put("forecastVersion", new Parameter("eq", (Object)"1"));
        complex2.getComplexParams().add(c5);
        resultComplexParam.getComplexParams().add(c1);
        resultComplexParam.getComplexParams().add(complex2);
        param.getComplexParams().add(resultComplexParam);
        List list = this.service.queryList(param);
        List voList = BeanMapper.mapList((Iterable)list, ForecastVO.class);
        voList.forEach(vo -> {
            if (vo.getChangeState() == 0) {
                vo.setChangeStateName("\u672a\u53d8\u66f4");
            } else if (vo.getChangeState() == 1) {
                vo.setChangeStateName("\u53d8\u66f4\u4e2d");
            } else {
                vo.setChangeStateName("\u5df2\u53d8\u66f4");
            }
        });
        this.logger.info(((ForecastVO)voList.get(0)).getChangeStateName());
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("Forecast-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refForecastData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ForecastVO>> refForecastData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ForecastVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/checkOrgMonth"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> checkOrgMonth(@RequestParam(value="rowId", required=false) Long rowId, @RequestParam(value="orgId") Long orgId, @RequestParam(value="forecastMonth") String forecastMonth) {
        return this.service.checkOrgMonth(rowId, orgId, forecastMonth);
    }

    @RequestMapping(value={"/queryLedgerList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ForecastLedgerVO>> queryLedgerList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgPersonName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        ComplexParam resultComplexParam = new ComplexParam();
        resultComplexParam.setLogic("and");
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("enableState", new Parameter("eq", (Object)true));
        ComplexParam complex2 = new ComplexParam();
        complex2.setLogic("or");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("and");
        c2.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        complex2.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("and");
        c3.getParams().put("enableState", new Parameter("eq", (Object)false));
        complex2.getComplexParams().add(c3);
        ComplexParam c5 = new ComplexParam();
        c5.setLogic("and");
        c5.getParams().put("forecastVersion", new Parameter("eq", (Object)"1"));
        complex2.getComplexParams().add(c5);
        resultComplexParam.getComplexParams().add(c1);
        resultComplexParam.getComplexParams().add(complex2);
        param.getComplexParams().add(resultComplexParam);
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(1);
        billStateList.add(3);
        param.getParams().put("billState", new Parameter("in", billStateList));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List<ForecastLedgerVO> resDatas = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            resDatas = BeanMapper.mapList((Iterable)page.getRecords(), ForecastLedgerVO.class);
            ArrayList ids = new ArrayList();
            HashMap map = new HashMap();
            if (CollectionUtils.isNotEmpty(resDatas)) {
                resDatas.forEach(e -> {
                    ids.add(e.getId());
                    map.put(e.getId(), e.getBillState());
                });
            }
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.in(ForecastDetailEntity::getPid, ids);
            List resList = this.forecastDetailService.list((Wrapper)lambda);
            List ListVOList = BeanMapper.mapList((Iterable)resList, ForecastLedgerVO.class);
            List list = ListVOList.stream().filter(forecastLedgerVO -> forecastLedgerVO.getParentId() != null).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ForecastLedgerVO>(Comparator.comparing(o -> o.getDetailPersonId() + ";" + o.getPid()))), ArrayList::new));
            List listFather = ListVOList.stream().filter(forecastLedgerVO -> {
                if (forecastLedgerVO.getParentId() == null) {
                    forecastLedgerVO.setParentId(forecastLedgerVO.getPid());
                    forecastLedgerVO.setOrgName(forecastLedgerVO.getDetailOrgName());
                    forecastLedgerVO.setOrgPersonName(forecastLedgerVO.getDetailPersonName());
                    forecastLedgerVO.setSaleForecastMny(forecastLedgerVO.getSaleDetailMny());
                    forecastLedgerVO.setInvoiceForecastMny(forecastLedgerVO.getInvoiceDetailMny());
                    forecastLedgerVO.setIncomeForecastMny(forecastLedgerVO.getIncomeDetailMny());
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
            resDatas.addAll(listFather);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                list.forEach(e -> {
                    e.setOrgName(e.getOrgName());
                    e.setOrgPersonName(e.getDetailPersonName());
                    e.setOrgName(e.getDetailOrgName());
                    LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)wrapper.eq(ForecastDetailEntity::getDetailPersonId, (Object)e.getDetailPersonId())).eq(ForecastDetailEntity::getParentId, (Object)e.getParentId());
                    List list1 = this.detailService.list((Wrapper)wrapper);
                    BigDecimal SaleForecastMny = new BigDecimal(0);
                    BigDecimal InvoiceForecastMny = new BigDecimal(0);
                    BigDecimal IncomeForecastMny = new BigDecimal(0);
                    for (ForecastDetailEntity forecastDetailEntity : list1) {
                        SaleForecastMny = SaleForecastMny.add(forecastDetailEntity.getSaleDetailMny());
                        InvoiceForecastMny = InvoiceForecastMny.add(forecastDetailEntity.getInvoiceDetailMny());
                        IncomeForecastMny = IncomeForecastMny.add(forecastDetailEntity.getIncomeDetailMny());
                    }
                    e.setSaleForecastMny(SaleForecastMny);
                    e.setInvoiceForecastMny(InvoiceForecastMny);
                    e.setIncomeForecastMny(IncomeForecastMny);
                });
                resDatas.addAll(list);
            }
            pageData.setRecords(TreeNodeBUtil.buildTree(resDatas));
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ForecastLedgerVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/LedgerExcelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void LedgerExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgPersonName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        ComplexParam resultComplexParam = new ComplexParam();
        resultComplexParam.setLogic("and");
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("enableState", new Parameter("eq", (Object)true));
        ComplexParam complex2 = new ComplexParam();
        complex2.setLogic("or");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("and");
        c2.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        complex2.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("and");
        c3.getParams().put("enableState", new Parameter("eq", (Object)false));
        complex2.getComplexParams().add(c3);
        ComplexParam c5 = new ComplexParam();
        c5.setLogic("and");
        c5.getParams().put("forecastVersion", new Parameter("eq", (Object)"1"));
        complex2.getComplexParams().add(c5);
        resultComplexParam.getComplexParams().add(c1);
        resultComplexParam.getComplexParams().add(complex2);
        param.getComplexParams().add(resultComplexParam);
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(1);
        billStateList.add(3);
        param.getParams().put("billState", new Parameter("in", billStateList));
        List list = this.service.queryList(param);
        List<ForecastLedgerVO> resDatas = new ArrayList();
        HashMap<String, Object> beans = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resDatas = BeanMapper.mapList((Iterable)list, ForecastLedgerVO.class);
            ArrayList ids = new ArrayList();
            HashMap map = new HashMap();
            if (CollectionUtils.isNotEmpty(resDatas)) {
                resDatas.forEach(e -> {
                    ids.add(e.getId());
                    map.put(e.getId(), e.getBillState());
                });
            }
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.in(ForecastDetailEntity::getPid, ids);
            List DetailEntityList = this.forecastDetailService.list((Wrapper)lambdaQueryWrapper);
            List ListVOList = BeanMapper.mapList((Iterable)DetailEntityList, ForecastLedgerVO.class);
            List list1 = ListVOList.stream().filter(forecastLedgerVO -> forecastLedgerVO.getParentId() != null).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ForecastLedgerVO>(Comparator.comparing(o -> o.getDetailPersonId() + ";" + o.getPid()))), ArrayList::new));
            List listFather = ListVOList.stream().filter(forecastLedgerVO -> {
                if (forecastLedgerVO.getParentId() == null) {
                    forecastLedgerVO.setParentId(forecastLedgerVO.getPid());
                    forecastLedgerVO.setOrgName(forecastLedgerVO.getDetailOrgName());
                    forecastLedgerVO.setOrgPersonName(forecastLedgerVO.getDetailPersonName());
                    forecastLedgerVO.setSaleForecastMny(forecastLedgerVO.getSaleDetailMny());
                    forecastLedgerVO.setInvoiceForecastMny(forecastLedgerVO.getInvoiceDetailMny());
                    forecastLedgerVO.setIncomeForecastMny(forecastLedgerVO.getIncomeDetailMny());
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
            resDatas.addAll(listFather);
            if (CollectionUtils.isNotEmpty((Collection)list1)) {
                list1.forEach(e -> {
                    e.setOrgName(e.getOrgName());
                    e.setOrgPersonName(e.getDetailPersonName());
                    e.setOrgName(e.getDetailOrgName());
                    LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)wrapper.eq(ForecastDetailEntity::getDetailPersonId, (Object)e.getDetailPersonId())).eq(ForecastDetailEntity::getParentId, (Object)e.getParentId());
                    List list2 = this.detailService.list((Wrapper)wrapper);
                    BigDecimal SaleForecastMny = new BigDecimal(0);
                    BigDecimal InvoiceForecastMny = new BigDecimal(0);
                    BigDecimal IncomeForecastMny = new BigDecimal(0);
                    for (ForecastDetailEntity forecastDetailEntity : list2) {
                        SaleForecastMny = SaleForecastMny.add(forecastDetailEntity.getSaleDetailMny());
                        InvoiceForecastMny = InvoiceForecastMny.add(forecastDetailEntity.getInvoiceDetailMny());
                        IncomeForecastMny = IncomeForecastMny.add(forecastDetailEntity.getIncomeDetailMny());
                    }
                    e.setSaleForecastMny(SaleForecastMny);
                    e.setInvoiceForecastMny(InvoiceForecastMny);
                    e.setIncomeForecastMny(IncomeForecastMny);
                    e.setOrgPersonName(e.getDetailPersonName());
                    if (e.getParentId() == null) {
                        e.setParentId(e.getPid());
                        e.setOrgName(e.getDetailOrgName());
                    }
                });
                resDatas.addAll(list1);
            }
            resDatas = TreeNodeBUtil.buildTree(resDatas);
            beans.put("records", resDatas);
            BigDecimal saleForecastMny = new BigDecimal(0);
            BigDecimal invoiceForecastMny = new BigDecimal(0);
            BigDecimal incomeForecastMny = new BigDecimal(0);
            for (ForecastLedgerVO resData : resDatas) {
                saleForecastMny = saleForecastMny.add(resData.getSaleForecastMny());
                invoiceForecastMny = invoiceForecastMny.add(resData.getInvoiceForecastMny());
                incomeForecastMny = incomeForecastMny.add(resData.getIncomeForecastMny());
            }
            beans.put("saleForecastMny", saleForecastMny);
            beans.put("invoiceForecastMny", invoiceForecastMny);
            beans.put("incomeForecastMny", incomeForecastMny);
        } else {
            beans.put("records", resDatas);
        }
        ExcelExport.getInstance().export("Ledger-export.xlsx", beans, response);
    }
}

