/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.performance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.jlincome.performance.bean.ForecastDetailEntity;
import com.ejianc.business.jlincome.performance.bean.ForecastEntity;
import com.ejianc.business.jlincome.performance.enums.ChangeStateEnum;
import com.ejianc.business.jlincome.performance.mapper.ForecastMapper;
import com.ejianc.business.jlincome.performance.service.IForecastService;
import com.ejianc.business.jlincome.performance.vo.ForecastDetailVO;
import com.ejianc.business.jlincome.performance.vo.ForecastRecordVO;
import com.ejianc.business.jlincome.performance.vo.ForecastVO;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="forecastService")
public class ForecastServiceImpl
extends BaseServiceImpl<ForecastMapper, ForecastEntity>
implements IForecastService {
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "FORECAST_CODE";

    @Override
    public CommonResponse<ForecastVO> insertOrUpdate(ForecastVO saveOrUpdateVO) {
        ForecastEntity revise;
        ForecastEntity entity = (ForecastEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ForecastEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            if (null == entity.getLastForecastId()) {
                entity.setForecastVersion(1);
                entity.setOneTime(entity.getCreateTime());
                entity.setChangeState(ChangeStateEnum.\u672a\u53d8\u66f4.getCode());
            }
            entity.setLatestFlag(true);
            entity.setEnableState(false);
            if (null == entity.getBillCode()) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    entity.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
        }
        this.resetPid(entity.getForecastDetailList());
        super.saveOrUpdate((Object)entity, false);
        if (entity.getLastForecastId() != null && (revise = (ForecastEntity)((Object)super.getById((Serializable)entity.getLastForecastId()))).getLatestFlag().booleanValue()) {
            revise.setChangeId(entity.getId());
            revise.setChangeState(ChangeStateEnum.\u53d8\u66f4\u4e2d.getCode());
            revise.setLatestFlag(false);
            revise.setBaseForecastId(null != revise.getBaseForecastId() ? revise.getBaseForecastId() : revise.getId());
            super.saveOrUpdate((Object)revise);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.queryDetail(entity.getId()));
    }

    private void resetPid(List<ForecastDetailEntity> detailList) {
        if (CollectionUtils.isNotEmpty(detailList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (ForecastDetailEntity detail : detailList) {
                if ("del".equals(detail.getRowState())) continue;
                if (detail.getId() == null) {
                    detail.setId(IdWorker.getId());
                }
                idMap.put(detail.getTid(), detail.getId());
                detail.setParentId(null);
            }
            for (ForecastDetailEntity detail : detailList) {
                if ("del".equals(detail.getRowState()) || !StringUtils.isNotEmpty((CharSequence)detail.getTpid())) continue;
                detail.setParentId((Long)idMap.get(detail.getTpid()));
            }
        }
    }

    @Override
    public ForecastVO queryDetail(Long id) {
        ForecastEntity entity = (ForecastEntity)((Object)super.selectById((Serializable)id));
        ForecastVO vo = (ForecastVO)BeanMapper.map((Object)((Object)entity), ForecastVO.class);
        List detailList = vo.getForecastDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            for (ForecastDetailVO detail : detailList) {
                detail.setTid(detail.getId());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            vo.setForecastDetailList(TreeNodeBUtil.buildTree((List)detailList));
        }
        List list = new ArrayList();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ForecastEntity::getBaseForecastId, (Object)entity.getBaseForecastId());
        queryWrapper.in(ForecastEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.ne(BaseEntity::getId, (Object)id);
        queryWrapper.orderByAsc(BaseEntity::getCreateTime);
        List forecastEntityList = super.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)forecastEntityList)) {
            list = BeanMapper.mapList((Iterable)forecastEntityList, ForecastRecordVO.class);
        }
        vo.setRecordList(list);
        return vo;
    }

    @Override
    public ForecastVO queryChangeDetail(Long id) {
        ForecastEntity entity = (ForecastEntity)((Object)super.selectById((Serializable)id));
        ForecastVO vo = (ForecastVO)BeanMapper.map((Object)((Object)entity), ForecastVO.class);
        vo.setId(null);
        vo.setBillState(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setBeforeForecastVersion(vo.getForecastVersion());
        vo.setForecastVersion(Integer.valueOf(vo.getForecastVersion() + 1));
        vo.setLastForecastId(id);
        vo.setBaseForecastId(null != entity.getBaseForecastId() ? entity.getBaseForecastId() : id);
        vo.setChangeEmployeeId(null);
        vo.setChangeEmployeeName(null);
        vo.setChangeReason(null);
        List detailList = vo.getForecastDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            detailList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTid(changeDetailVO.getId());
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : null);
                changeDetailVO.setRowState("add");
            });
            detailList = TreeNodeBUtil.buildTree((List)detailList);
            detailList.forEach(detail -> {
                detail.setId(Long.valueOf(IdWorker.getId()));
                detail.getChildren().forEach(child -> {
                    ((ForecastDetailVO)child).setId(Long.valueOf(IdWorker.getId()));
                    ((ForecastDetailVO)child).setParentId(detail.getId());
                });
            });
            vo.setForecastDetailList(detailList);
        }
        return vo;
    }

    @Override
    public CommonResponse<String> deleteVos(List<ForecastVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ForecastVO forecastVO : vos) {
                ForecastEntity forecastEntity = (ForecastEntity)((Object)super.selectById((Serializable)forecastVO.getId()));
                if (forecastEntity.getLastForecastId() == null) continue;
                ForecastEntity revise = (ForecastEntity)((Object)super.getById((Serializable)forecastEntity.getLastForecastId()));
                revise.setChangeId(null);
                revise.setLatestFlag(true);
                revise.setChangeState(1 == forecastEntity.getForecastVersion() ? ChangeStateEnum.\u672a\u53d8\u66f4.getCode() : ChangeStateEnum.\u5df2\u53d8\u66f4.getCode());
                super.saveOrUpdate((Object)revise);
            }
        }
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<String> checkOrgMonth(Long rowId, Long orgId, String forecastMonth) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"org_id", (Object)orgId);
        query.eq((Object)"forecast_month", (Object)forecastMonth);
        query.notIn((Object)"id", new Object[]{rowId});
        List billList = super.list((Wrapper)query);
        billList.forEach(bill -> System.out.println(bill.getId()));
        return CommonResponse.success((String)(CollectionUtils.isNotEmpty((Collection)billList) ? "\u672c\u533a\u57df + \u9884\u62a5\u6708\u4efd\u5df2\u6709\u9500\u552e\u9884\u62a5\u7684\u5355\u636e\uff01" : null));
    }
}

