/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.performance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ejianc.business.jlincome.performance.bean.GradeAdjustDetailEntity;
import com.ejianc.business.jlincome.performance.bean.GradeAdjustEntity;
import com.ejianc.business.jlincome.performance.bean.PoolEntity;
import com.ejianc.business.jlincome.performance.bean.SaleContractEntity;
import com.ejianc.business.jlincome.performance.bean.SaleReportEntity;
import com.ejianc.business.jlincome.performance.bean.TaskDetailEntity;
import com.ejianc.business.jlincome.performance.bean.TaskEntity;
import com.ejianc.business.jlincome.performance.mapper.SaleReportMapper;
import com.ejianc.business.jlincome.performance.service.IGradeAdjustDetailService;
import com.ejianc.business.jlincome.performance.service.IGradeAdjustService;
import com.ejianc.business.jlincome.performance.service.IPoolService;
import com.ejianc.business.jlincome.performance.service.ISaleContractService;
import com.ejianc.business.jlincome.performance.service.ISaleReportService;
import com.ejianc.business.jlincome.performance.service.ITaskDetailService;
import com.ejianc.business.jlincome.performance.service.ITaskService;
import com.ejianc.business.jlincome.performance.vo.SaleReportTreeVO;
import com.ejianc.business.jlincome.performance.vo.SaleReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="saleReportService")
public class SaleReportServiceImpl
extends BaseServiceImpl<SaleReportMapper, SaleReportEntity>
implements ISaleReportService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String COLLECT_FILL_QUEUE = "sale_pool_date_queue";
    @Value(value="${spring.cloud.config.profile}")
    private String profile;
    @Autowired
    private IPoolService poolService;
    @Autowired
    private ISaleContractService saleContractService;
    @Autowired
    private IGradeAdjustService gradeAdjustService;
    @Autowired
    private IGradeAdjustDetailService gradeAdjustDetailService;
    @Autowired
    private ITaskService taskService;
    @Autowired
    private ITaskDetailService taskDetailService;
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    @Async(value="commonTask")
    public void saveInitPoolDate(String authority) {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = Objects.requireNonNull(requestAttributes).getRequest();
        this.logger.info("\u5f02\u6b65\u6d88\u606f\u901a\u77e5\u7684authority\uff1a{}", (Object)request.getHeader("authority"));
        if (StringUtils.isBlank((CharSequence)request.getHeader("authority"))) {
            InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authority);
            this.logger.info("informMessage-\u5f02\u6b65\u6d88\u606f\u901a\u77e5\u7684authority\uff1a{}", (Object)authority);
        } else {
            InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)request.getHeader("authority"));
            this.logger.info("informMessage-\u5f02\u6b65\u6d88\u606f\u901a\u77e5\u7684authority\uff1a{}", (Object)request.getHeader("authority"));
        }
        this.saveReport();
    }

    public void saveReport() {
        try {
            List<PoolEntity> poolEntityList = this.poolService.queryList();
            this.logger.info("MQ\u53bb\u83b7\u53d6\u5230\u7ed3\u679c--" + JSONObject.toJSONString(poolEntityList));
            ArrayList saleReportEntityList = new ArrayList();
            ArrayList adjustList = new ArrayList();
            ArrayList unAdjustList = new ArrayList();
            ArrayList adjustAfterList = new ArrayList();
            LambdaQueryWrapper lambda2 = new LambdaQueryWrapper();
            lambda2.in(GradeAdjustEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
            lambda2.orderByDesc(BaseEntity::getCreateTime);
            lambda2.groupBy((Object[])new SFunction[]{GradeAdjustEntity::getContractId, GradeAdjustEntity::getInitiationMonth});
            List gradeAdjustList = this.gradeAdjustService.list((Wrapper)lambda2);
            Set adjustContractIds = gradeAdjustList.stream().map(GradeAdjustEntity::getContractId).collect(Collectors.toSet());
            List GradeAdjustIds = gradeAdjustList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper lambda3 = new LambdaQueryWrapper();
            lambda3.in(GradeAdjustDetailEntity::getDetailId, GradeAdjustIds);
            List adjustDetailList = this.gradeAdjustDetailService.list((Wrapper)lambda3);
            Map<Long, List> adjustDetailMap = adjustDetailList.stream().collect(Collectors.toMap(GradeAdjustDetailEntity::getDetailId, Collections::singletonList, (list1, list2) -> {
                ArrayList mergedList = new ArrayList(list1);
                mergedList.addAll(list2);
                return mergedList;
            }));
            Map<Long, List> adjustMap = gradeAdjustList.stream().collect(Collectors.toMap(GradeAdjustEntity::getContractId, Collections::singletonList, (list1, list2) -> {
                ArrayList mergedList = new ArrayList(list1);
                mergedList.addAll(list2);
                return mergedList;
            }));
            poolEntityList.forEach(e -> {
                if (adjustContractIds.contains(e.getContractId())) {
                    adjustList.add(e);
                } else {
                    unAdjustList.add(e);
                }
            });
            adjustList.forEach(e -> {
                List<GradeAdjustDetailEntity> detailEntityList = this.getAdjustDetail(e.getContractId(), e.getSourceMonth(), adjustMap, adjustDetailMap);
                if (CollectionUtils.isNotEmpty(detailEntityList)) {
                    detailEntityList.forEach(k -> {
                        BigDecimal receivablePercentage;
                        PoolEntity poolEntity = (PoolEntity)((Object)((Object)((Object)BeanMapper.map((Object)e, PoolEntity.class))));
                        BigDecimal mny = e.getMny() == null ? BigDecimal.ZERO : e.getMny();
                        BigDecimal taxMny = e.getTaxMny() == null ? BigDecimal.ZERO : e.getTaxMny();
                        BigDecimal salePercentage = k.getSalePercentage() == null ? BigDecimal.ZERO : k.getSalePercentage();
                        BigDecimal invoicePercentage = k.getInvoicePercentage() == null ? BigDecimal.ZERO : k.getInvoicePercentage();
                        BigDecimal bigDecimal = receivablePercentage = k.getReceivablePercentage() == null ? BigDecimal.ZERO : k.getReceivablePercentage();
                        if (1 == poolEntity.getSourceType()) {
                            poolEntity.setMny(mny.multiply(salePercentage).divide(new BigDecimal(100)));
                            poolEntity.setTaxMny(taxMny.multiply(salePercentage).divide(new BigDecimal(100)));
                        } else if (2 == poolEntity.getSourceType()) {
                            poolEntity.setMny(mny.multiply(invoicePercentage).divide(new BigDecimal(100)));
                            poolEntity.setTaxMny(taxMny.multiply(invoicePercentage).divide(new BigDecimal(100)));
                        } else if (3 == poolEntity.getSourceType()) {
                            poolEntity.setMny(mny.multiply(receivablePercentage).divide(new BigDecimal(100)));
                            poolEntity.setTaxMny(taxMny.multiply(receivablePercentage).divide(new BigDecimal(100)));
                        }
                        poolEntity.setSaleId(k.getDetailEmployeeId());
                        poolEntity.setSaleName(k.getDetailEmployeeName());
                        poolEntity.setOrgId(k.getDetailOrgId());
                        poolEntity.setOrgName(k.getDetailOrgName());
                        poolEntity.setOrgCode(k.getDetailOrgCode());
                        adjustAfterList.add(poolEntity);
                    });
                } else {
                    adjustAfterList.add(e);
                }
            });
            adjustAfterList.addAll(unAdjustList);
            HashMap<String, SaleReportVO> yjReportMap = new HashMap<String, SaleReportVO>();
            adjustAfterList.forEach(e -> {
                String org = e.getOrgId() == null ? "" : e.getOrgId() + "";
                String unionId = e.getSaleId() + org + e.getSourceYear();
                if (yjReportMap.containsKey(unionId)) {
                    SaleReportVO saleReportVO = (SaleReportVO)yjReportMap.get(unionId);
                    this.changeSaleReportVO(saleReportVO, e.getSourceMonth(), e.getTaxMny(), e.getSourceType());
                    yjReportMap.put(unionId, saleReportVO);
                } else {
                    SaleReportVO saleReportVO = new SaleReportVO();
                    saleReportVO = this.changeSaleReportVO(saleReportVO, e.getSourceMonth(), e.getTaxMny(), e.getSourceType());
                    saleReportVO.setOrgId(e.getOrgId());
                    saleReportVO.setOrgCode(e.getOrgCode());
                    saleReportVO.setOrgName(e.getOrgName());
                    saleReportVO.setEmployeeId(e.getSaleId());
                    saleReportVO.setEmployeeName(e.getSaleName());
                    saleReportVO.setYear(e.getSourceYear());
                    yjReportMap.put(unionId, saleReportVO);
                }
            });
            LambdaQueryWrapper lambda4 = new LambdaQueryWrapper();
            lambda4.eq(TaskEntity::getEnableState, (Object)true);
            lambda4.in(TaskEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
            lambda4.orderByDesc(BaseEntity::getCreateTime);
            lambda4.groupBy((Object[])new SFunction[]{TaskEntity::getTaskYear});
            List taskEntityList = this.taskService.list((Wrapper)lambda4);
            HashMap<Long, TaskEntity> taskMap = new HashMap<Long, TaskEntity>();
            ArrayList taskIds = new ArrayList();
            taskEntityList.forEach(e -> {
                taskIds.add(e.getId());
                taskMap.put(e.getId(), (TaskEntity)((Object)e));
            });
            LambdaQueryWrapper lambda5 = new LambdaQueryWrapper();
            lambda5.in(TaskDetailEntity::getPid, taskIds);
            List taskDetailList = this.taskDetailService.list((Wrapper)lambda5);
            List<SaleReportEntity> saleReportList = this.changeSaleReport(taskDetailList, taskMap);
            HashMap saleMap = new HashMap();
            HashMap saleOrgMap = new HashMap();
            saleReportList.forEach(e -> {
                String employeeId = e.getEmployeeId() == null ? "" : e.getEmployeeId() + "";
                String org = e.getTeamOrgId() == null ? "" : e.getTeamOrgId() + "";
                String year = e.getYear();
                String unionId = employeeId + org + year;
                saleMap.put(unionId, e);
                if (null != e.getOrgId()) {
                    saleOrgMap.put(e.getOrgId(), e);
                }
            });
            ArrayList resList = new ArrayList();
            ArrayList saveList = new ArrayList();
            ArrayList saveAllList = new ArrayList();
            HashMap havaMap = new HashMap();
            ArrayList unHaveList = new ArrayList();
            yjReportMap.forEach((unionId, saleReportVO) -> {
                if (saleMap.containsKey(unionId)) {
                    havaMap.put(((SaleReportEntity)((Object)((Object)saleMap.get(unionId)))).getId(), this.getSaleReport((SaleReportEntity)((Object)((Object)saleMap.get(unionId))), (SaleReportVO)saleReportVO));
                } else {
                    SaleReportEntity saleEntity = new SaleReportEntity();
                    saleEntity.setYear(saleReportVO.getYear());
                    saleEntity.setOrgId(saleReportVO.getOrgId());
                    saleEntity.setOrgName(saleReportVO.getOrgName());
                    saleEntity.setOrgCode(saleReportVO.getOrgCode());
                    saleEntity.setEmployeeId(saleReportVO.getEmployeeId());
                    saleEntity.setEmployeeName(saleReportVO.getEmployeeName());
                    saleEntity.setId(saleReportVO.getId());
                    Long orgId = saleReportVO.getOrgId();
                    CommonResponse commonResponse = this.iOrgApi.findParentsByOrgId(orgId);
                    List orgVOList = (List)commonResponse.getData();
                    for (OrgVO e : orgVOList) {
                        if (saleOrgMap.containsKey(e.getId())) {
                            saleEntity.setParentId(((SaleReportEntity)((Object)((Object)saleOrgMap.get(e.getId())))).getId());
                            break;
                        }
                        saleEntity.setParentId(999L);
                    }
                    unHaveList.add(this.getSaleReport(saleEntity, (SaleReportVO)saleReportVO));
                }
            });
            saleReportList.forEach(e -> {
                if (havaMap.containsKey(e.getId())) {
                    saveList.add(havaMap.get(e.getId()));
                } else {
                    saveList.add(e);
                }
            });
            if (CollectionUtils.isNotEmpty(unHaveList)) {
                saveList.addAll(unHaveList);
            }
            HashMap mnyMap = new HashMap();
            saveList.forEach(e -> {
                if (null == e.getSaleType()) {
                    saveAllList.add(e);
                }
                if (mnyMap.containsKey(e.getParentId())) {
                    List list = (List)mnyMap.get(e.getParentId());
                    list.add(e);
                    mnyMap.put(e.getParentId(), list);
                } else {
                    ArrayList<SaleReportEntity> list = new ArrayList<SaleReportEntity>();
                    list.add((SaleReportEntity)((Object)e));
                    mnyMap.put(e.getParentId(), list);
                }
            });
            saveList.forEach(e -> {
                if (null != e.getSaleType() && 2 == e.getSaleType()) {
                    saveAllList.add(this.getSumSaleReport((SaleReportEntity)((Object)e), mnyMap));
                }
            });
            saveList.forEach(e -> {
                if (null != e.getSaleType() && 1 == e.getSaleType()) {
                    saveAllList.add(this.getSumSaleReport((SaleReportEntity)((Object)e), mnyMap));
                }
            });
            if (CollectionUtils.isNotEmpty(saveAllList)) {
                super.saveBatch(saveAllList);
            }
            resList.addAll(BeanMapper.mapList(saveAllList, SaleReportTreeVO.class));
            this.logger.info("\u7ed3\u675f---------" + JSONObject.toJSONString((Object)TreeNodeBUtil.buildTree(resList)));
        }
        catch (Exception e2) {
            this.logger.error("\u76d1\u542c\u6d88\u606f\u5f02\u5e38: ", (Throwable)e2);
        }
    }

    public List<PoolEntity> changeSale(List<SaleContractEntity> saleContractEntityList) {
        ArrayList<PoolEntity> resList = new ArrayList<PoolEntity>();
        saleContractEntityList.forEach(e -> {
            PoolEntity poolEntity = new PoolEntity();
            poolEntity.setId(e.getId());
            poolEntity.setContractId(e.getContractId());
            poolEntity.setContractCode(e.getContractCode());
            poolEntity.setContractName(e.getContractName());
            poolEntity.setProjectId(e.getProjectId());
            poolEntity.setProjectCode(e.getProjectCode());
            poolEntity.setProjectName(e.getProjectName());
            poolEntity.setOrgId(e.getOrgId());
            poolEntity.setOrgCode(e.getOrgCode());
            poolEntity.setOrgName(e.getOrgName());
            poolEntity.setCustomerId(e.getCustomerId());
            poolEntity.setCustomerName(e.getCustomerName());
            poolEntity.setSaleId(e.getSaleId());
            poolEntity.setSaleName(e.getSaleName());
            poolEntity.setSourceType(1);
            poolEntity.setSourceId(e.getId());
            poolEntity.setSourceBillCode(e.getBillCode());
            poolEntity.setSourceDate(e.getRegisterDate());
            SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM");
            try {
                poolEntity.setSourceMonth(format1.format(e.getRegisterDate()));
            }
            catch (Exception exc) {
                this.logger.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38: ", (Throwable)exc);
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
            poolEntity.setSourceYear(simpleDateFormat.format(e.getRegisterDate()));
            poolEntity.setMny(e.getRegisterMny());
            poolEntity.setTaxMny(e.getRegisterMny());
            resList.add(poolEntity);
        });
        return resList;
    }

    public List<GradeAdjustDetailEntity> getAdjustDetail(Long contractId, String sourceMonth, Map<Long, List<GradeAdjustEntity>> adjustMap, Map<Long, List<GradeAdjustDetailEntity>> adjustDetailMap) {
        ArrayList adjustList = new ArrayList();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
        List<GradeAdjustEntity> list = adjustMap.get(contractId);
        list.forEach(e -> {
            Date monthDate = null;
            try {
                monthDate = formatter.parse(sourceMonth);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            if (!e.getInitiationMonth().after(monthDate)) {
                adjustList.add(e);
            }
        });
        if (CollectionUtils.isNotEmpty(adjustList)) {
            Collections.sort(adjustList, Comparator.comparing(GradeAdjustEntity::getInitiationMonth, (t1, t2) -> t2.compareTo((Date)t1)));
            return adjustDetailMap.get(((GradeAdjustEntity)((Object)adjustList.get(0))).getId());
        }
        return null;
    }

    public List<SaleReportEntity> changeSaleReport(List<TaskDetailEntity> taskDetailList, Map<Long, TaskEntity> taskMap) {
        ArrayList<SaleReportEntity> resList = new ArrayList<SaleReportEntity>();
        Collection<TaskEntity> collections = taskMap.values();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
        for (TaskEntity e2 : collections) {
            SaleReportEntity saleReportEntity = new SaleReportEntity();
            saleReportEntity.setYear(simpleDateFormat.format(e2.getTaskYear()));
            saleReportEntity.setOrgId(e2.getOrgId());
            saleReportEntity.setOrgName(e2.getOrgName());
            saleReportEntity.setOrgCode(e2.getOrgCode());
            saleReportEntity.setTeamOrgId(e2.getOrgId());
            saleReportEntity.setId(e2.getId());
            saleReportEntity.setParentId(999L);
            saleReportEntity.setSaleType(1);
            resList.add(saleReportEntity);
        }
        taskDetailList.forEach(e -> {
            SaleReportEntity saleReportEntity = new SaleReportEntity();
            TaskEntity taskEntity = (TaskEntity)((Object)((Object)taskMap.get(e.getPid())));
            saleReportEntity.setYear(simpleDateFormat.format(taskEntity.getTaskYear()));
            saleReportEntity.setOrgId(e.getDetailOrgId());
            saleReportEntity.setOrgName(e.getDetailOrgName());
            saleReportEntity.setOrgCode(e.getDetailOrgCode());
            saleReportEntity.setTeamOrgId(e.getDetailBelongOrgId());
            saleReportEntity.setEmployeeId(e.getSalesmanId());
            saleReportEntity.setEmployeeName(e.getSalesmanName());
            saleReportEntity.setId(e.getId());
            if (null == e.getDetailBelongOrgId()) {
                saleReportEntity.setParentId(taskEntity.getId());
                saleReportEntity.setSaleType(2);
            } else if (null == e.getParentId() && null == e.getDetailOrgId()) {
                saleReportEntity.setParentId(taskEntity.getId());
            } else {
                saleReportEntity.setParentId(e.getParentId());
            }
            saleReportEntity.setSaleYearTaskMny(e.getTotalQuarterSaleTaskMny());
            saleReportEntity.setSaleFirstTaskMny(e.getQuarterOneSaleTaskMny());
            saleReportEntity.setSaleSecondTaskMny(e.getQuarterTwoSaleTaskMny());
            saleReportEntity.setSaleThirdTaskMny(e.getQuarterThreeSaleTaskMny());
            saleReportEntity.setSaleFourthTaskMny(e.getQuarterFourSaleTaskMny());
            saleReportEntity.setKpYearTaskMny(e.getTotalQuarterInvoiceTaskMny());
            saleReportEntity.setKpFirstTaskMny(e.getQuarterOneInvoiceTaskMny());
            saleReportEntity.setKpSecondTaskMny(e.getQuarterTwoInvoiceTaskMny());
            saleReportEntity.setKpThirdTaskMny(e.getQuarterThreeInvoiceTaskMny());
            saleReportEntity.setKpFourthTaskMny(e.getQuarterFourInvoiceTaskMny());
            saleReportEntity.setSkYearTaskMny(e.getTotalQuarterIncomeTaskMny());
            saleReportEntity.setSkFirstTaskMny(e.getQuarterOneIncomeTaskMny());
            saleReportEntity.setSkSecondTaskMny(e.getQuarterTwoIncomeTaskMny());
            saleReportEntity.setSkThirdTaskMny(e.getQuarterThreeIncomeTaskMny());
            saleReportEntity.setSkFourthTaskMny(e.getQuarterFourIncomeTaskMny());
            resList.add(saleReportEntity);
        });
        return resList;
    }

    public SaleReportEntity getSaleReport(SaleReportEntity entity, SaleReportVO saleReportVO) {
        SaleReportEntity saleReportEntity = (SaleReportEntity)((Object)BeanMapper.map((Object)((Object)entity), SaleReportEntity.class));
        saleReportEntity.setSaleFirstOneMny(saleReportVO.getSaleFirstOneMny());
        saleReportEntity.setKpFirstOneMny(saleReportVO.getKpFirstOneMny());
        saleReportEntity.setSkFirstOneMny(saleReportVO.getSkFirstOneMny());
        saleReportEntity.setSaleFirstTwoMny(saleReportVO.getSaleFirstTwoMny());
        saleReportEntity.setKpFirstTwoMny(saleReportVO.getKpFirstTwoMny());
        saleReportEntity.setSkFirstTwoMny(saleReportVO.getSkFirstTwoMny());
        saleReportEntity.setSaleFirstThreeMny(saleReportVO.getSaleFirstThreeMny());
        saleReportEntity.setKpFirstThreeMny(saleReportVO.getKpFirstThreeMny());
        saleReportEntity.setSkFirstThreeMny(saleReportVO.getSkFirstThreeMny());
        saleReportEntity.setSaleSecondFourMny(saleReportVO.getSaleSecondFourMny());
        saleReportEntity.setKpSecondFourMny(saleReportVO.getKpSecondFourMny());
        saleReportEntity.setSkSecondFourMny(saleReportVO.getSkSecondFourMny());
        saleReportEntity.setSaleSecondFiveMny(saleReportVO.getSaleSecondFiveMny());
        saleReportEntity.setKpSecondFiveMny(saleReportVO.getKpSecondFiveMny());
        saleReportEntity.setSkSecondFiveMny(saleReportVO.getSkSecondFiveMny());
        saleReportEntity.setSaleSecondSixMny(saleReportVO.getSaleSecondSixMny());
        saleReportEntity.setKpSecondSixMny(saleReportVO.getKpSecondSixMny());
        saleReportEntity.setSkSecondSixMny(saleReportVO.getSkSecondSixMny());
        saleReportEntity.setSaleThirdSevenMny(saleReportVO.getSaleThirdSevenMny());
        saleReportEntity.setKpThirdSevenMny(saleReportVO.getKpThirdSevenMny());
        saleReportEntity.setSkThirdSevenMny(saleReportVO.getSkThirdSevenMny());
        saleReportEntity.setSaleThirdEightMny(saleReportVO.getSaleThirdEightMny());
        saleReportEntity.setKpThirdEightMny(saleReportVO.getKpThirdEightMny());
        saleReportEntity.setSkThirdEightMny(saleReportVO.getSkThirdEightMny());
        saleReportEntity.setSaleThirdNineMny(saleReportVO.getSaleThirdNineMny());
        saleReportEntity.setKpThirdNineMny(saleReportVO.getKpThirdNineMny());
        saleReportEntity.setSkThirdNineMny(saleReportVO.getSkThirdNineMny());
        saleReportEntity.setSaleFourthTenMny(saleReportVO.getSaleFourthTenMny());
        saleReportEntity.setKpFourthTenMny(saleReportVO.getKpFourthTenMny());
        saleReportEntity.setSkFourthTenMny(saleReportVO.getSkFourthTenMny());
        saleReportEntity.setSaleFourthElevenMny(saleReportVO.getSaleFourthElevenMny());
        saleReportEntity.setKpFourthElevenMny(saleReportVO.getKpFourthElevenMny());
        saleReportEntity.setSkFourthElevenMny(saleReportVO.getSkFourthElevenMny());
        saleReportEntity.setSaleFourthTwelveMny(saleReportVO.getSaleFourthTwelveMny());
        saleReportEntity.setKpFourthTwelveMny(saleReportVO.getKpFourthTwelveMny());
        saleReportEntity.setSkFourthTwelveMny(saleReportVO.getSkFourthTwelveMny());
        BigDecimal saleFirstMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getSaleFirstOneMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getSaleFirstTwoMny(), saleReportEntity.getSaleFirstThreeMny()});
        saleReportEntity.setSaleFirstMny(saleFirstMny);
        BigDecimal saleFirstDisparityMny = ComputeUtil.safeSub((BigDecimal)saleFirstMny, (BigDecimal)saleReportEntity.getSaleFirstTaskMny());
        saleReportEntity.setSaleFirstDisparityMny(saleFirstDisparityMny);
        BigDecimal saleFirstScale = ComputeUtil.safeDiv((BigDecimal)saleFirstMny, (BigDecimal)saleReportEntity.getSaleFirstTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSaleFirstScale(saleFirstScale);
        BigDecimal saleSecondMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getSaleSecondFourMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getSaleSecondFiveMny(), saleReportEntity.getSaleSecondSixMny()});
        saleReportEntity.setSaleSecondMny(saleSecondMny);
        BigDecimal saleSecondDisparityMny = ComputeUtil.safeSub((BigDecimal)saleSecondMny, (BigDecimal)saleReportEntity.getSaleSecondTaskMny());
        saleReportEntity.setSaleSecondDisparityMny(saleSecondDisparityMny);
        BigDecimal saleSecondScale = ComputeUtil.safeDiv((BigDecimal)saleSecondMny, (BigDecimal)saleReportEntity.getSaleSecondTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSaleSecondScale(saleSecondScale);
        BigDecimal saleThirdMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getSaleThirdSevenMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getSaleThirdEightMny(), saleReportEntity.getSaleThirdNineMny()});
        saleReportEntity.setSaleThirdMny(saleThirdMny);
        BigDecimal saleThirdDisparityMny = ComputeUtil.safeSub((BigDecimal)saleThirdMny, (BigDecimal)saleReportEntity.getSaleThirdTaskMny());
        saleReportEntity.setSaleThirdDisparityMny(saleThirdDisparityMny);
        BigDecimal saleThirdScale = ComputeUtil.safeDiv((BigDecimal)saleThirdMny, (BigDecimal)saleReportEntity.getSaleThirdTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSaleThirdScale(saleThirdScale);
        BigDecimal saleFourthMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getSaleFourthTenMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getSaleFourthElevenMny(), saleReportEntity.getSaleFourthTwelveMny()});
        saleReportEntity.setSaleFourthMny(saleFourthMny);
        BigDecimal saleFourthDisparityMny = ComputeUtil.safeSub((BigDecimal)saleFourthMny, (BigDecimal)saleReportEntity.getSaleFourthTaskMny());
        saleReportEntity.setSaleFourthDisparityMny(saleFourthDisparityMny);
        BigDecimal saleFourthScale = ComputeUtil.safeDiv((BigDecimal)saleFourthMny, (BigDecimal)saleReportEntity.getSaleFourthTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSaleFourthScale(saleFourthScale);
        BigDecimal saleYearMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getSaleFirstMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getSaleSecondMny(), saleReportEntity.getSaleThirdMny(), saleReportEntity.getSaleFourthMny()});
        saleReportEntity.setSaleYearMny(saleYearMny);
        BigDecimal saleYearDisparityMny = ComputeUtil.safeSub((BigDecimal)saleYearMny, (BigDecimal)saleReportEntity.getSaleYearTaskMny());
        saleReportEntity.setSaleYearDisparityMny(saleYearDisparityMny);
        BigDecimal saleYearScale = ComputeUtil.safeDiv((BigDecimal)saleYearMny, (BigDecimal)saleReportEntity.getSaleYearTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSaleYearScale(saleYearScale);
        BigDecimal KpFirstMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getKpFirstOneMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getKpFirstTwoMny(), saleReportEntity.getKpFirstThreeMny()});
        saleReportEntity.setKpFirstMny(KpFirstMny);
        BigDecimal KpFirstDisparityMny = ComputeUtil.safeSub((BigDecimal)saleFirstMny, (BigDecimal)saleReportEntity.getKpFirstTaskMny());
        saleReportEntity.setKpFirstDisparityMny(KpFirstDisparityMny);
        BigDecimal KpFirstScale = ComputeUtil.safeDiv((BigDecimal)saleFirstMny, (BigDecimal)saleReportEntity.getKpFirstTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setKpFirstScale(KpFirstScale);
        BigDecimal KpSecondMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getKpSecondFourMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getKpSecondFiveMny(), saleReportEntity.getKpSecondSixMny()});
        saleReportEntity.setKpSecondMny(KpSecondMny);
        BigDecimal KpSecondDisparityMny = ComputeUtil.safeSub((BigDecimal)KpSecondMny, (BigDecimal)saleReportEntity.getKpSecondTaskMny());
        saleReportEntity.setKpSecondDisparityMny(KpSecondDisparityMny);
        BigDecimal KpSecondScale = ComputeUtil.safeDiv((BigDecimal)KpSecondMny, (BigDecimal)saleReportEntity.getKpSecondTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setKpSecondScale(KpSecondScale);
        BigDecimal KpThirdMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getKpThirdSevenMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getKpThirdEightMny(), saleReportEntity.getKpThirdNineMny()});
        saleReportEntity.setKpThirdMny(KpThirdMny);
        BigDecimal KpThirdDisparityMny = ComputeUtil.safeSub((BigDecimal)KpThirdMny, (BigDecimal)saleReportEntity.getKpThirdTaskMny());
        saleReportEntity.setKpThirdDisparityMny(KpThirdDisparityMny);
        BigDecimal KpThirdScale = ComputeUtil.safeDiv((BigDecimal)KpThirdMny, (BigDecimal)saleReportEntity.getKpThirdTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setKpThirdScale(KpThirdScale);
        BigDecimal KpFourthMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getKpFourthTenMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getKpFourthElevenMny(), saleReportEntity.getKpFourthTwelveMny()});
        saleReportEntity.setKpFourthMny(KpFourthMny);
        BigDecimal KpFourthDisparityMny = ComputeUtil.safeSub((BigDecimal)KpFourthMny, (BigDecimal)saleReportEntity.getKpFourthTaskMny());
        saleReportEntity.setKpFourthDisparityMny(KpFourthDisparityMny);
        BigDecimal KpFourthScale = ComputeUtil.safeDiv((BigDecimal)KpFourthMny, (BigDecimal)saleReportEntity.getKpFourthTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setKpFourthScale(KpFourthScale);
        BigDecimal KpYearMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getKpFirstMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getKpSecondMny(), saleReportEntity.getKpThirdMny(), saleReportEntity.getKpFourthMny()});
        saleReportEntity.setKpYearMny(KpYearMny);
        BigDecimal KpYearDisparityMny = ComputeUtil.safeSub((BigDecimal)KpYearMny, (BigDecimal)saleReportEntity.getKpYearTaskMny());
        saleReportEntity.setKpYearDisparityMny(KpYearDisparityMny);
        BigDecimal KpYearScale = ComputeUtil.safeDiv((BigDecimal)KpYearMny, (BigDecimal)saleReportEntity.getKpYearTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setKpYearScale(KpYearScale);
        BigDecimal SkFirstMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getSkFirstOneMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getSkFirstTwoMny(), saleReportEntity.getSkFirstThreeMny()});
        saleReportEntity.setSkFirstMny(SkFirstMny);
        BigDecimal SkFirstDisparityMny = ComputeUtil.safeSub((BigDecimal)saleFirstMny, (BigDecimal)saleReportEntity.getSkFirstTaskMny());
        saleReportEntity.setSkFirstDisparityMny(SkFirstDisparityMny);
        BigDecimal SkFirstScale = ComputeUtil.safeDiv((BigDecimal)saleFirstMny, (BigDecimal)saleReportEntity.getSkFirstTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSkFirstScale(SkFirstScale);
        BigDecimal SkSecondMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getSkSecondFourMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getSkSecondFiveMny(), saleReportEntity.getSkSecondSixMny()});
        saleReportEntity.setSkSecondMny(SkSecondMny);
        BigDecimal SkSecondDisparityMny = ComputeUtil.safeSub((BigDecimal)SkSecondMny, (BigDecimal)saleReportEntity.getSkSecondTaskMny());
        saleReportEntity.setSkSecondDisparityMny(SkSecondDisparityMny);
        BigDecimal SkSecondScale = ComputeUtil.safeDiv((BigDecimal)SkSecondMny, (BigDecimal)saleReportEntity.getSkSecondTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSkSecondScale(SkSecondScale);
        BigDecimal SkThirdMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getSkThirdSevenMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getSkThirdEightMny(), saleReportEntity.getSkThirdNineMny()});
        saleReportEntity.setSkThirdMny(SkThirdMny);
        BigDecimal SkThirdDisparityMny = ComputeUtil.safeSub((BigDecimal)SkThirdMny, (BigDecimal)saleReportEntity.getSkThirdTaskMny());
        saleReportEntity.setSkThirdDisparityMny(SkThirdDisparityMny);
        BigDecimal SkThirdScale = ComputeUtil.safeDiv((BigDecimal)SkThirdMny, (BigDecimal)saleReportEntity.getSkThirdTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSkThirdScale(SkThirdScale);
        BigDecimal SkFourthMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getSkFourthTenMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getSkFourthElevenMny(), saleReportEntity.getSkFourthTwelveMny()});
        saleReportEntity.setSkFourthMny(SkFourthMny);
        BigDecimal SkFourthDisparityMny = ComputeUtil.safeSub((BigDecimal)SkFourthMny, (BigDecimal)saleReportEntity.getSkFourthTaskMny());
        saleReportEntity.setSkFourthDisparityMny(SkFourthDisparityMny);
        BigDecimal SkFourthScale = ComputeUtil.safeDiv((BigDecimal)SkFourthMny, (BigDecimal)saleReportEntity.getSkFourthTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSkFourthScale(SkFourthScale);
        BigDecimal SkYearMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getSkFirstMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getSkSecondMny(), saleReportEntity.getSkThirdMny(), saleReportEntity.getSkFourthMny()});
        saleReportEntity.setSkYearMny(SkYearMny);
        BigDecimal SkYearDisparityMny = ComputeUtil.safeSub((BigDecimal)SkYearMny, (BigDecimal)saleReportEntity.getSkYearTaskMny());
        saleReportEntity.setSkYearDisparityMny(SkYearDisparityMny);
        BigDecimal SkYearScale = ComputeUtil.safeDiv((BigDecimal)SkYearMny, (BigDecimal)saleReportEntity.getSkYearTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSkYearScale(SkYearScale);
        return saleReportEntity;
    }

    public SaleReportEntity getSumSaleReport(SaleReportEntity saleReportEntity, Map<Long, List<SaleReportEntity>> mnyMap) {
        List<SaleReportEntity> list = mnyMap.get(saleReportEntity.getId());
        BigDecimal saleFirstOneMny = BigDecimal.ZERO;
        BigDecimal saleFirstTwoMny = BigDecimal.ZERO;
        BigDecimal saleFirstThreeMny = BigDecimal.ZERO;
        BigDecimal saleSecondFourMny = BigDecimal.ZERO;
        BigDecimal saleSecondFiveMny = BigDecimal.ZERO;
        BigDecimal saleSecondSixMny = BigDecimal.ZERO;
        BigDecimal saleThirdSevenMny = BigDecimal.ZERO;
        BigDecimal saleThirdEightMny = BigDecimal.ZERO;
        BigDecimal saleThirdNineMny = BigDecimal.ZERO;
        BigDecimal saleFourthTenMny = BigDecimal.ZERO;
        BigDecimal saleFourthElevenMny = BigDecimal.ZERO;
        BigDecimal saleFourthTwelveMny = BigDecimal.ZERO;
        BigDecimal kpFirstOneMny = BigDecimal.ZERO;
        BigDecimal kpFirstTwoMny = BigDecimal.ZERO;
        BigDecimal kpFirstThreeMny = BigDecimal.ZERO;
        BigDecimal kpSecondFourMny = BigDecimal.ZERO;
        BigDecimal kpSecondFiveMny = BigDecimal.ZERO;
        BigDecimal kpSecondSixMny = BigDecimal.ZERO;
        BigDecimal kpThirdSevenMny = BigDecimal.ZERO;
        BigDecimal kpThirdEightMny = BigDecimal.ZERO;
        BigDecimal kpThirdNineMny = BigDecimal.ZERO;
        BigDecimal kpFourthTenMny = BigDecimal.ZERO;
        BigDecimal kpFourthElevenMny = BigDecimal.ZERO;
        BigDecimal kpFourthTwelveMny = BigDecimal.ZERO;
        BigDecimal skFirstOneMny = BigDecimal.ZERO;
        BigDecimal skFirstTwoMny = BigDecimal.ZERO;
        BigDecimal skFirstThreeMny = BigDecimal.ZERO;
        BigDecimal skSecondFourMny = BigDecimal.ZERO;
        BigDecimal skSecondFiveMny = BigDecimal.ZERO;
        BigDecimal skSecondSixMny = BigDecimal.ZERO;
        BigDecimal skThirdSevenMny = BigDecimal.ZERO;
        BigDecimal skThirdEightMny = BigDecimal.ZERO;
        BigDecimal skThirdNineMny = BigDecimal.ZERO;
        BigDecimal skFourthTenMny = BigDecimal.ZERO;
        BigDecimal skFourthElevenMny = BigDecimal.ZERO;
        BigDecimal skFourthTwelveMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(list)) {
            for (SaleReportEntity e : list) {
                saleFirstOneMny = ComputeUtil.safeAdd((BigDecimal)saleFirstOneMny, (BigDecimal)e.getSaleFirstOneMny());
                saleFirstTwoMny = ComputeUtil.safeAdd((BigDecimal)saleFirstTwoMny, (BigDecimal)e.getSaleFirstTwoMny());
                saleFirstThreeMny = ComputeUtil.safeAdd((BigDecimal)saleFirstThreeMny, (BigDecimal)e.getSaleFirstThreeMny());
                saleSecondFourMny = ComputeUtil.safeAdd((BigDecimal)saleSecondFourMny, (BigDecimal)e.getSaleSecondFourMny());
                saleSecondFiveMny = ComputeUtil.safeAdd((BigDecimal)saleSecondFiveMny, (BigDecimal)e.getSaleSecondFiveMny());
                saleSecondSixMny = ComputeUtil.safeAdd((BigDecimal)saleSecondSixMny, (BigDecimal)e.getSaleSecondSixMny());
                saleThirdSevenMny = ComputeUtil.safeAdd((BigDecimal)saleThirdSevenMny, (BigDecimal)e.getSaleThirdSevenMny());
                saleThirdEightMny = ComputeUtil.safeAdd((BigDecimal)saleThirdEightMny, (BigDecimal)e.getSaleThirdEightMny());
                saleThirdNineMny = ComputeUtil.safeAdd((BigDecimal)saleThirdNineMny, (BigDecimal)e.getSaleThirdNineMny());
                saleFourthTenMny = ComputeUtil.safeAdd((BigDecimal)saleFourthTenMny, (BigDecimal)e.getSaleFourthTenMny());
                saleFourthElevenMny = ComputeUtil.safeAdd((BigDecimal)saleFourthElevenMny, (BigDecimal)e.getSaleFourthElevenMny());
                saleFourthTwelveMny = ComputeUtil.safeAdd((BigDecimal)saleFourthTwelveMny, (BigDecimal)e.getSaleFourthTwelveMny());
                kpFirstOneMny = ComputeUtil.safeAdd((BigDecimal)kpFirstOneMny, (BigDecimal)e.getKpFirstOneMny());
                kpFirstTwoMny = ComputeUtil.safeAdd((BigDecimal)kpFirstTwoMny, (BigDecimal)e.getKpFirstTwoMny());
                kpFirstThreeMny = ComputeUtil.safeAdd((BigDecimal)kpFirstThreeMny, (BigDecimal)e.getKpFirstThreeMny());
                kpSecondFourMny = ComputeUtil.safeAdd((BigDecimal)kpSecondFourMny, (BigDecimal)e.getKpSecondFourMny());
                kpSecondFiveMny = ComputeUtil.safeAdd((BigDecimal)kpSecondFiveMny, (BigDecimal)e.getKpSecondFiveMny());
                kpSecondSixMny = ComputeUtil.safeAdd((BigDecimal)kpSecondSixMny, (BigDecimal)e.getKpSecondSixMny());
                kpThirdSevenMny = ComputeUtil.safeAdd((BigDecimal)kpThirdSevenMny, (BigDecimal)e.getKpThirdSevenMny());
                kpThirdEightMny = ComputeUtil.safeAdd((BigDecimal)kpThirdEightMny, (BigDecimal)e.getKpThirdEightMny());
                kpThirdNineMny = ComputeUtil.safeAdd((BigDecimal)kpThirdNineMny, (BigDecimal)e.getKpThirdNineMny());
                kpFourthTenMny = ComputeUtil.safeAdd((BigDecimal)kpFourthTenMny, (BigDecimal)e.getKpFourthTenMny());
                kpFourthElevenMny = ComputeUtil.safeAdd((BigDecimal)kpFourthElevenMny, (BigDecimal)e.getKpFourthElevenMny());
                kpFourthTwelveMny = ComputeUtil.safeAdd((BigDecimal)kpFourthTwelveMny, (BigDecimal)e.getKpFourthTwelveMny());
                skFirstOneMny = ComputeUtil.safeAdd((BigDecimal)skFirstOneMny, (BigDecimal)e.getSkFirstOneMny());
                skFirstTwoMny = ComputeUtil.safeAdd((BigDecimal)skFirstTwoMny, (BigDecimal)e.getSkFirstTwoMny());
                skFirstThreeMny = ComputeUtil.safeAdd((BigDecimal)skFirstThreeMny, (BigDecimal)e.getSkFirstThreeMny());
                skSecondFourMny = ComputeUtil.safeAdd((BigDecimal)skSecondFourMny, (BigDecimal)e.getSkSecondFourMny());
                skSecondFiveMny = ComputeUtil.safeAdd((BigDecimal)skSecondFiveMny, (BigDecimal)e.getSkSecondFiveMny());
                skSecondSixMny = ComputeUtil.safeAdd((BigDecimal)skSecondSixMny, (BigDecimal)e.getSkSecondSixMny());
                skThirdSevenMny = ComputeUtil.safeAdd((BigDecimal)skThirdSevenMny, (BigDecimal)e.getSkThirdSevenMny());
                skThirdEightMny = ComputeUtil.safeAdd((BigDecimal)skThirdEightMny, (BigDecimal)e.getSkThirdEightMny());
                skThirdNineMny = ComputeUtil.safeAdd((BigDecimal)skThirdNineMny, (BigDecimal)e.getSkThirdNineMny());
                skFourthTenMny = ComputeUtil.safeAdd((BigDecimal)skFourthTenMny, (BigDecimal)e.getSkFourthTenMny());
                skFourthElevenMny = ComputeUtil.safeAdd((BigDecimal)skFourthElevenMny, (BigDecimal)e.getSkFourthElevenMny());
                skFourthTwelveMny = ComputeUtil.safeAdd((BigDecimal)skFourthTwelveMny, (BigDecimal)e.getSkFourthTwelveMny());
            }
        }
        saleReportEntity.setSaleFirstOneMny(saleFirstOneMny);
        saleReportEntity.setKpFirstOneMny(kpFirstOneMny);
        saleReportEntity.setSkFirstOneMny(skFirstOneMny);
        saleReportEntity.setSaleFirstTwoMny(saleFirstTwoMny);
        saleReportEntity.setKpFirstTwoMny(kpFirstTwoMny);
        saleReportEntity.setSkFirstTwoMny(skFirstTwoMny);
        saleReportEntity.setSaleFirstThreeMny(saleFirstThreeMny);
        saleReportEntity.setKpFirstThreeMny(kpFirstThreeMny);
        saleReportEntity.setSkFirstThreeMny(skFirstThreeMny);
        saleReportEntity.setSaleSecondFourMny(saleSecondFourMny);
        saleReportEntity.setKpSecondFourMny(kpSecondFourMny);
        saleReportEntity.setSkSecondFourMny(skSecondFourMny);
        saleReportEntity.setSaleSecondFiveMny(saleSecondFiveMny);
        saleReportEntity.setKpSecondFiveMny(kpSecondFiveMny);
        saleReportEntity.setSkSecondFiveMny(skSecondFiveMny);
        saleReportEntity.setSaleSecondSixMny(saleSecondSixMny);
        saleReportEntity.setKpSecondSixMny(kpSecondSixMny);
        saleReportEntity.setSkSecondSixMny(skSecondSixMny);
        saleReportEntity.setSaleThirdSevenMny(saleThirdSevenMny);
        saleReportEntity.setKpThirdSevenMny(kpThirdSevenMny);
        saleReportEntity.setSkThirdSevenMny(skThirdSevenMny);
        saleReportEntity.setSaleThirdEightMny(saleThirdEightMny);
        saleReportEntity.setKpThirdEightMny(kpThirdEightMny);
        saleReportEntity.setSkThirdEightMny(skThirdEightMny);
        saleReportEntity.setSaleThirdNineMny(saleThirdNineMny);
        saleReportEntity.setKpThirdNineMny(kpThirdNineMny);
        saleReportEntity.setSkThirdNineMny(skThirdNineMny);
        saleReportEntity.setSaleFourthTenMny(saleFourthTenMny);
        saleReportEntity.setKpFourthTenMny(kpFourthTenMny);
        saleReportEntity.setSkFourthTenMny(skFourthTenMny);
        saleReportEntity.setSaleFourthElevenMny(saleFourthElevenMny);
        saleReportEntity.setKpFourthElevenMny(kpFourthElevenMny);
        saleReportEntity.setSkFourthElevenMny(skFourthElevenMny);
        saleReportEntity.setSaleFourthTwelveMny(saleFourthTwelveMny);
        saleReportEntity.setKpFourthTwelveMny(kpFourthTwelveMny);
        saleReportEntity.setSkFourthTwelveMny(skFourthTwelveMny);
        BigDecimal saleFirstMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getSaleFirstOneMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getSaleFirstTwoMny(), saleReportEntity.getSaleFirstThreeMny()});
        saleReportEntity.setSaleFirstMny(saleFirstMny);
        BigDecimal saleFirstDisparityMny = ComputeUtil.safeSub((BigDecimal)saleFirstMny, (BigDecimal)saleReportEntity.getSaleFirstTaskMny());
        saleReportEntity.setSaleFirstDisparityMny(saleFirstDisparityMny);
        BigDecimal saleFirstScale = ComputeUtil.safeDiv((BigDecimal)saleFirstMny, (BigDecimal)saleReportEntity.getSaleFirstTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSaleFirstScale(saleFirstScale);
        BigDecimal saleSecondMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getSaleSecondFourMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getSaleSecondFiveMny(), saleReportEntity.getSaleSecondSixMny()});
        saleReportEntity.setSaleSecondMny(saleSecondMny);
        BigDecimal saleSecondDisparityMny = ComputeUtil.safeSub((BigDecimal)saleSecondMny, (BigDecimal)saleReportEntity.getSaleSecondTaskMny());
        saleReportEntity.setSaleSecondDisparityMny(saleSecondDisparityMny);
        BigDecimal saleSecondScale = ComputeUtil.safeDiv((BigDecimal)saleSecondMny, (BigDecimal)saleReportEntity.getSaleSecondTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSaleSecondScale(saleSecondScale);
        BigDecimal saleThirdMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getSaleThirdSevenMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getSaleThirdEightMny(), saleReportEntity.getSaleThirdNineMny()});
        saleReportEntity.setSaleThirdMny(saleThirdMny);
        BigDecimal saleThirdDisparityMny = ComputeUtil.safeSub((BigDecimal)saleThirdMny, (BigDecimal)saleReportEntity.getSaleThirdTaskMny());
        saleReportEntity.setSaleThirdDisparityMny(saleThirdDisparityMny);
        BigDecimal saleThirdScale = ComputeUtil.safeDiv((BigDecimal)saleThirdMny, (BigDecimal)saleReportEntity.getSaleThirdTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSaleThirdScale(saleThirdScale);
        BigDecimal saleFourthMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getSaleFourthTenMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getSaleFourthElevenMny(), saleReportEntity.getSaleFourthTwelveMny()});
        saleReportEntity.setSaleFourthMny(saleFourthMny);
        BigDecimal saleFourthDisparityMny = ComputeUtil.safeSub((BigDecimal)saleFourthMny, (BigDecimal)saleReportEntity.getSaleFourthTaskMny());
        saleReportEntity.setSaleFourthDisparityMny(saleFourthDisparityMny);
        BigDecimal saleFourthScale = ComputeUtil.safeDiv((BigDecimal)saleFourthMny, (BigDecimal)saleReportEntity.getSaleFourthTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSaleFourthScale(saleFourthScale);
        BigDecimal saleYearMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getSaleFirstMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getSaleSecondMny(), saleReportEntity.getSaleThirdMny(), saleReportEntity.getSaleFourthMny()});
        saleReportEntity.setSaleYearMny(saleYearMny);
        BigDecimal saleYearDisparityMny = ComputeUtil.safeSub((BigDecimal)saleYearMny, (BigDecimal)saleReportEntity.getSaleYearTaskMny());
        saleReportEntity.setSaleYearDisparityMny(saleYearDisparityMny);
        BigDecimal saleYearScale = ComputeUtil.safeDiv((BigDecimal)saleYearMny, (BigDecimal)saleReportEntity.getSaleYearTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSaleYearScale(saleYearScale);
        BigDecimal KpFirstMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getKpFirstOneMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getKpFirstTwoMny(), saleReportEntity.getKpFirstThreeMny()});
        saleReportEntity.setKpFirstMny(KpFirstMny);
        BigDecimal KpFirstDisparityMny = ComputeUtil.safeSub((BigDecimal)saleFirstMny, (BigDecimal)saleReportEntity.getKpFirstTaskMny());
        saleReportEntity.setKpFirstDisparityMny(KpFirstDisparityMny);
        BigDecimal KpFirstScale = ComputeUtil.safeDiv((BigDecimal)saleFirstMny, (BigDecimal)saleReportEntity.getKpFirstTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setKpFirstScale(KpFirstScale);
        BigDecimal KpSecondMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getKpSecondFourMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getKpSecondFiveMny(), saleReportEntity.getKpSecondSixMny()});
        saleReportEntity.setKpSecondMny(KpSecondMny);
        BigDecimal KpSecondDisparityMny = ComputeUtil.safeSub((BigDecimal)KpSecondMny, (BigDecimal)saleReportEntity.getKpSecondTaskMny());
        saleReportEntity.setKpSecondDisparityMny(KpSecondDisparityMny);
        BigDecimal KpSecondScale = ComputeUtil.safeDiv((BigDecimal)KpSecondMny, (BigDecimal)saleReportEntity.getKpSecondTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setKpSecondScale(KpSecondScale);
        BigDecimal KpThirdMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getKpThirdSevenMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getKpThirdEightMny(), saleReportEntity.getKpThirdNineMny()});
        saleReportEntity.setKpThirdMny(KpThirdMny);
        BigDecimal KpThirdDisparityMny = ComputeUtil.safeSub((BigDecimal)KpThirdMny, (BigDecimal)saleReportEntity.getKpThirdTaskMny());
        saleReportEntity.setKpThirdDisparityMny(KpThirdDisparityMny);
        BigDecimal KpThirdScale = ComputeUtil.safeDiv((BigDecimal)KpThirdMny, (BigDecimal)saleReportEntity.getKpThirdTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setKpThirdScale(KpThirdScale);
        BigDecimal KpFourthMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getKpFourthTenMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getKpFourthElevenMny(), saleReportEntity.getKpFourthTwelveMny()});
        saleReportEntity.setKpFourthMny(KpFourthMny);
        BigDecimal KpFourthDisparityMny = ComputeUtil.safeSub((BigDecimal)KpFourthMny, (BigDecimal)saleReportEntity.getKpFourthTaskMny());
        saleReportEntity.setKpFourthDisparityMny(KpFourthDisparityMny);
        BigDecimal KpFourthScale = ComputeUtil.safeDiv((BigDecimal)KpFourthMny, (BigDecimal)saleReportEntity.getKpFourthTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setKpFourthScale(KpFourthScale);
        BigDecimal KpYearMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getKpFirstMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getKpSecondMny(), saleReportEntity.getKpThirdMny(), saleReportEntity.getKpFourthMny()});
        saleReportEntity.setKpYearMny(KpYearMny);
        BigDecimal KpYearDisparityMny = ComputeUtil.safeSub((BigDecimal)KpYearMny, (BigDecimal)saleReportEntity.getKpYearTaskMny());
        saleReportEntity.setKpYearDisparityMny(KpYearDisparityMny);
        BigDecimal KpYearScale = ComputeUtil.safeDiv((BigDecimal)KpYearMny, (BigDecimal)saleReportEntity.getKpYearTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setKpYearScale(KpYearScale);
        BigDecimal SkFirstMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getSkFirstOneMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getSkFirstTwoMny(), saleReportEntity.getSkFirstThreeMny()});
        saleReportEntity.setSkFirstMny(SkFirstMny);
        BigDecimal SkFirstDisparityMny = ComputeUtil.safeSub((BigDecimal)saleFirstMny, (BigDecimal)saleReportEntity.getSkFirstTaskMny());
        saleReportEntity.setSkFirstDisparityMny(SkFirstDisparityMny);
        BigDecimal SkFirstScale = ComputeUtil.safeDiv((BigDecimal)saleFirstMny, (BigDecimal)saleReportEntity.getSkFirstTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSkFirstScale(SkFirstScale);
        BigDecimal SkSecondMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getSkSecondFourMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getSkSecondFiveMny(), saleReportEntity.getSkSecondSixMny()});
        saleReportEntity.setSkSecondMny(SkSecondMny);
        BigDecimal SkSecondDisparityMny = ComputeUtil.safeSub((BigDecimal)SkSecondMny, (BigDecimal)saleReportEntity.getSkSecondTaskMny());
        saleReportEntity.setSkSecondDisparityMny(SkSecondDisparityMny);
        BigDecimal SkSecondScale = ComputeUtil.safeDiv((BigDecimal)SkSecondMny, (BigDecimal)saleReportEntity.getSkSecondTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSkSecondScale(SkSecondScale);
        BigDecimal SkThirdMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getSkThirdSevenMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getSkThirdEightMny(), saleReportEntity.getSkThirdNineMny()});
        saleReportEntity.setSkThirdMny(SkThirdMny);
        BigDecimal SkThirdDisparityMny = ComputeUtil.safeSub((BigDecimal)SkThirdMny, (BigDecimal)saleReportEntity.getSkThirdTaskMny());
        saleReportEntity.setSkThirdDisparityMny(SkThirdDisparityMny);
        BigDecimal SkThirdScale = ComputeUtil.safeDiv((BigDecimal)SkThirdMny, (BigDecimal)saleReportEntity.getSkThirdTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSkThirdScale(SkThirdScale);
        BigDecimal SkFourthMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getSkFourthTenMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getSkFourthElevenMny(), saleReportEntity.getSkFourthTwelveMny()});
        saleReportEntity.setSkFourthMny(SkFourthMny);
        BigDecimal SkFourthDisparityMny = ComputeUtil.safeSub((BigDecimal)SkFourthMny, (BigDecimal)saleReportEntity.getSkFourthTaskMny());
        saleReportEntity.setSkFourthDisparityMny(SkFourthDisparityMny);
        BigDecimal SkFourthScale = ComputeUtil.safeDiv((BigDecimal)SkFourthMny, (BigDecimal)saleReportEntity.getSkFourthTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSkFourthScale(SkFourthScale);
        BigDecimal SkYearMny = ComputeUtil.safeAdd((BigDecimal)saleReportEntity.getSkFirstMny(), (BigDecimal[])new BigDecimal[]{saleReportEntity.getSkSecondMny(), saleReportEntity.getSkThirdMny(), saleReportEntity.getSkFourthMny()});
        saleReportEntity.setSkYearMny(SkYearMny);
        BigDecimal SkYearDisparityMny = ComputeUtil.safeSub((BigDecimal)SkYearMny, (BigDecimal)saleReportEntity.getSkYearTaskMny());
        saleReportEntity.setSkYearDisparityMny(SkYearDisparityMny);
        BigDecimal SkYearScale = ComputeUtil.safeDiv((BigDecimal)SkYearMny, (BigDecimal)saleReportEntity.getSkYearTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSkYearScale(SkYearScale);
        return saleReportEntity;
    }

    public SaleReportVO changeSaleReportVO(SaleReportVO saleReportVO, String month, BigDecimal taxMny, Integer sourceType) {
        if ("01".equals(month.substring(5, 7))) {
            if (1 == sourceType) {
                saleReportVO.setSaleFirstOneMny(taxMny);
            } else if (2 == sourceType) {
                saleReportVO.setKpFirstOneMny(taxMny);
            } else if (3 == sourceType) {
                saleReportVO.setSkFirstOneMny(taxMny);
            }
        } else if ("02".equals(month.substring(5, 7))) {
            if (1 == sourceType) {
                saleReportVO.setSaleFirstTwoMny(taxMny);
            } else if (2 == sourceType) {
                saleReportVO.setKpFirstTwoMny(taxMny);
            } else if (3 == sourceType) {
                saleReportVO.setSkFirstTwoMny(taxMny);
            }
        } else if ("03".equals(month.substring(5, 7))) {
            if (1 == sourceType) {
                saleReportVO.setSaleFirstThreeMny(taxMny);
            } else if (2 == sourceType) {
                saleReportVO.setKpFirstThreeMny(taxMny);
            } else if (3 == sourceType) {
                saleReportVO.setSkFirstThreeMny(taxMny);
            }
        } else if ("04".equals(month.substring(5, 7))) {
            if (1 == sourceType) {
                saleReportVO.setSaleSecondFourMny(taxMny);
            } else if (2 == sourceType) {
                saleReportVO.setKpSecondFourMny(taxMny);
            } else if (3 == sourceType) {
                saleReportVO.setSkSecondFourMny(taxMny);
            }
        } else if ("05".equals(month.substring(5, 7))) {
            if (1 == sourceType) {
                saleReportVO.setSaleSecondFiveMny(taxMny);
            } else if (2 == sourceType) {
                saleReportVO.setKpSecondFiveMny(taxMny);
            } else if (3 == sourceType) {
                saleReportVO.setSkSecondFiveMny(taxMny);
            }
        } else if ("06".equals(month.substring(5, 7))) {
            if (1 == sourceType) {
                saleReportVO.setSaleSecondSixMny(taxMny);
            } else if (2 == sourceType) {
                saleReportVO.setKpSecondSixMny(taxMny);
            } else if (3 == sourceType) {
                saleReportVO.setSkSecondSixMny(taxMny);
            }
        } else if ("07".equals(month.substring(5, 7))) {
            if (1 == sourceType) {
                saleReportVO.setSaleThirdSevenMny(taxMny);
            } else if (2 == sourceType) {
                saleReportVO.setKpThirdSevenMny(taxMny);
            } else if (3 == sourceType) {
                saleReportVO.setSkThirdSevenMny(taxMny);
            }
        } else if ("08".equals(month.substring(5, 7))) {
            if (1 == sourceType) {
                saleReportVO.setSaleThirdEightMny(taxMny);
            } else if (2 == sourceType) {
                saleReportVO.setKpThirdEightMny(taxMny);
            } else if (3 == sourceType) {
                saleReportVO.setSkThirdEightMny(taxMny);
            }
        } else if ("09".equals(month.substring(5, 7))) {
            if (1 == sourceType) {
                saleReportVO.setSaleThirdNineMny(taxMny);
            } else if (2 == sourceType) {
                saleReportVO.setKpThirdNineMny(taxMny);
            } else if (3 == sourceType) {
                saleReportVO.setSkThirdNineMny(taxMny);
            }
        } else if ("10".equals(month.substring(5, 7))) {
            if (1 == sourceType) {
                saleReportVO.setSaleFourthTenMny(taxMny);
            } else if (2 == sourceType) {
                saleReportVO.setKpFourthTenMny(taxMny);
            } else if (3 == sourceType) {
                saleReportVO.setSkFourthTenMny(taxMny);
            }
        } else if ("11".equals(month.substring(5, 7))) {
            if (1 == sourceType) {
                saleReportVO.setSaleFourthElevenMny(taxMny);
            } else if (2 == sourceType) {
                saleReportVO.setKpFourthElevenMny(taxMny);
            } else if (3 == sourceType) {
                saleReportVO.setSkFourthElevenMny(taxMny);
            }
        } else if ("12".equals(month.substring(5, 7))) {
            if (1 == sourceType) {
                saleReportVO.setSaleFourthTwelveMny(taxMny);
            } else if (2 == sourceType) {
                saleReportVO.setKpFourthTwelveMny(taxMny);
            } else if (3 == sourceType) {
                saleReportVO.setSkFourthTwelveMny(taxMny);
            }
        }
        return saleReportVO;
    }
}

