package com.ejianc.business.jlincome.performance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.jlincome.performance.bean.ForecastDetailEntity;
import com.ejianc.business.jlincome.performance.enums.ChangeStateEnum;
import com.ejianc.business.jlincome.performance.vo.*;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlincome.performance.mapper.ForecastMapper;
import com.ejianc.business.jlincome.performance.bean.ForecastEntity;
import com.ejianc.business.jlincome.performance.service.IForecastService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 绩效管理-销售预报-主表
 *
 * @author generator
 */
@Service("forecastService")
public class ForecastServiceImpl extends BaseServiceImpl<ForecastMapper, ForecastEntity> implements IForecastService {
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "FORECAST_CODE";//此处需要根据实际修改

    @Override
    public CommonResponse<ForecastVO> insertOrUpdate(ForecastVO saveOrUpdateVO) {
        ForecastEntity entity = BeanMapper.map(saveOrUpdateVO, ForecastEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            //第一版设置版本号、原始版本主键、第一版本创建时间
            if (null == entity.getLastForecastId()) {
                entity.setForecastVersion(1);

                entity.setOneTime(entity.getCreateTime());
                entity.setChangeState(ChangeStateEnum.未变更.getCode());
            }

            entity.setLatestFlag(true);//新增时默认最新版本
            entity.setEnableState(false);//新增时默认不生效

            if (null == entity.getBillCode()) {
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
        }
        //重置父id
        this.resetPid(entity.getForecastDetailList());
        super.saveOrUpdate(entity, false);

        //如果是变更单，则原单据保存变更信息
        if (entity.getLastForecastId() != null) {
            ForecastEntity revise = super.getById(entity.getLastForecastId());
            if (revise.getLatestFlag()) {

                revise.setChangeId(entity.getId());
                revise.setChangeState(ChangeStateEnum.变更中.getCode());
                //变更单保存后，原单据就不是最新版本！（这里是否变更单生效后再把原单据改为 非最新版本）
                revise.setLatestFlag(false);
                //第一次变更保存，设置原单据初始版本id
                revise.setBaseForecastId(null != revise.getBaseForecastId() ? revise.getBaseForecastId() : revise.getId());

                super.saveOrUpdate(revise);
            }
        }
        return CommonResponse.success("保存或修改单据成功！", this.queryDetail(entity.getId()));
    }

    private void resetPid(List<ForecastDetailEntity> detailList) {
        if (CollectionUtils.isNotEmpty(detailList)) {
            Map<String, Long> idMap = new HashMap<>();
            for (ForecastDetailEntity detail : detailList) {
                if (!("del").equals(detail.getRowState())) {
                    if (detail.getId() == null) {
                        detail.setId(IdWorker.getId());
                    }
                    idMap.put(detail.getTid(), detail.getId());
                    detail.setParentId(null);
                }
            }
            for (ForecastDetailEntity detail : detailList) {
                if (!("del").equals(detail.getRowState())) {
                    if (StringUtils.isNotEmpty(detail.getTpid())) {
                        detail.setParentId(idMap.get(detail.getTpid()));
                    }
                }
            }
        }
    }

    @Override
    public ForecastVO queryDetail(Long id) {
        ForecastEntity entity = super.selectById(id);
        ForecastVO vo = BeanMapper.map(entity, ForecastVO.class);

        //子表
        List<ForecastDetailVO> detailList = vo.getForecastDetailList();
        //明细子表排序为树形
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (ForecastDetailVO detail : detailList) {
                detail.setTid(detail.getId());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            vo.setForecastDetailList(TreeNodeBUtil.buildTree(detailList));
        }
        //记录表
        List<ForecastRecordVO> list = new ArrayList<>();
        LambdaQueryWrapper<ForecastEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ForecastEntity::getBaseForecastId, entity.getBaseForecastId());
        queryWrapper.in(ForecastEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.ne(ForecastEntity::getId, id);
        queryWrapper.orderByAsc(ForecastEntity::getCreateTime);
        List<ForecastEntity> forecastEntityList = super.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(forecastEntityList)) {
            list = BeanMapper.mapList(forecastEntityList, ForecastRecordVO.class);
        }
        vo.setRecordList(list);
        return vo;
    }

    //变更单赋值
    @Override
    public ForecastVO queryChangeDetail(Long id) {
        ForecastEntity entity = super.selectById(id);
        ForecastVO vo = BeanMapper.map(entity, ForecastVO.class);
        vo.setId(null);
//        vo.setBillCode(null);
        vo.setBillState(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);

        vo.setBeforeForecastVersion(vo.getForecastVersion());
        vo.setForecastVersion(vo.getForecastVersion() + 1);
        vo.setLastForecastId(id);
        vo.setBaseForecastId(null != entity.getBaseForecastId() ? entity.getBaseForecastId() : id);

        vo.setChangeEmployeeId(null);
        vo.setChangeEmployeeName(null);
        vo.setChangeReason(null);

        List<ForecastDetailVO> detailList = vo.getForecastDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            detailList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTid(changeDetailVO.getId());
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0 ? changeDetailVO.getParentId().toString() : null);
                changeDetailVO.setRowState("add");
            });
            detailList = TreeNodeBUtil.buildTree(detailList);
            detailList.forEach((detail) -> {
                detail.setId(IdWorker.getId());
                detail.getChildren().forEach((child) -> {
                    ((ForecastDetailVO) child).setId(IdWorker.getId());
                    ((ForecastDetailVO) child).setParentId(detail.getId());
                });
            });
            vo.setForecastDetailList(detailList);

        }
        return vo;
    }

    @Override
    public CommonResponse<String> deleteVos(List<ForecastVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ForecastVO forecastVO : vos) {
                ForecastEntity forecastEntity = super.selectById(forecastVO.getId());
                //删除变更中的数据、回写原数据
                // （这里是否有问题，如果变更一次后，第二次变更怎么显示？版本号是不是这里体现意义？这里得价格版本号）
                if (forecastEntity.getLastForecastId() != null) {
                    ForecastEntity revise = super.getById(forecastEntity.getLastForecastId());
                    revise.setChangeId(null);
                    revise.setLatestFlag(true);

                    //可能不是第一次变更
                    revise.setChangeState(1 == forecastEntity.getForecastVersion() ? ChangeStateEnum.未变更.getCode() : ChangeStateEnum.已变更.getCode());
                    super.saveOrUpdate(revise);
                }
            }
        }
        super.removeByIds(vos.stream().map(ForecastVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @Override
    public CommonResponse<String> checkOrgMonth(Long rowId, Long orgId, String forecastMonth) {
        QueryWrapper<ForecastEntity> query = new QueryWrapper<>();
        query.eq("org_id", orgId);
        query.eq("forecast_month", forecastMonth);
        if (rowId != null) {
            query.ne("id", rowId);
        }
        List<ForecastEntity> billList = super.list(query);
        billList.forEach((bill) -> {
            System.out.println(bill.getId());
        });
        return CommonResponse.success(CollectionUtils.isNotEmpty(billList) ? "本区域 + 预报月份已有销售预报的单据！" : null);
    }
}
