/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.performance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.jlincome.performance.bean.TaskDetailEntity;
import com.ejianc.business.jlincome.performance.bean.TaskEntity;
import com.ejianc.business.jlincome.performance.enums.ChangeStateEnum;
import com.ejianc.business.jlincome.performance.mapper.TaskMapper;
import com.ejianc.business.jlincome.performance.service.ITaskService;
import com.ejianc.business.jlincome.performance.vo.TaskDetailVO;
import com.ejianc.business.jlincome.performance.vo.TaskRecordVO;
import com.ejianc.business.jlincome.performance.vo.TaskVO;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="taskService")
public class TaskServiceImpl
extends BaseServiceImpl<TaskMapper, TaskEntity>
implements ITaskService {
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "TASK_CODE";

    @Override
    public CommonResponse<TaskVO> insertOrUpdate(TaskVO saveOrUpdateVO) {
        TaskEntity revise;
        TaskEntity entity = (TaskEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, TaskEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            if (null == entity.getLastTaskId()) {
                entity.setTaskVersion(1);
                entity.setOneTime(entity.getCreateTime());
                entity.setChangeState(ChangeStateEnum.\u672a\u53d8\u66f4.getCode());
            }
            entity.setLatestFlag(true);
            entity.setEnableState(false);
            if (null == entity.getBillCode()) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    entity.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
        }
        this.resetPid(entity.getDetailList());
        super.saveOrUpdate((Object)entity, false);
        if (entity.getLastTaskId() != null && (revise = (TaskEntity)((Object)super.getById((Serializable)entity.getLastTaskId()))).getLatestFlag().booleanValue()) {
            revise.setChangeId(entity.getId());
            revise.setChangeState(ChangeStateEnum.\u53d8\u66f4\u4e2d.getCode());
            revise.setLatestFlag(false);
            revise.setBaseTaskId(null != revise.getBaseTaskId() ? revise.getBaseTaskId() : revise.getId());
            super.saveOrUpdate((Object)revise);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.queryDetail(entity.getId()));
    }

    private void resetPid(List<TaskDetailEntity> detailList) {
        if (CollectionUtils.isNotEmpty(detailList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (TaskDetailEntity detail : detailList) {
                if ("del".equals(detail.getRowState())) continue;
                if (detail.getId() == null) {
                    detail.setId(IdWorker.getId());
                }
                idMap.put(detail.getTid(), detail.getId());
                detail.setParentId(null);
            }
            for (TaskDetailEntity detail : detailList) {
                if ("del".equals(detail.getRowState()) || !StringUtils.isNotEmpty((CharSequence)detail.getTpid())) continue;
                detail.setParentId((Long)idMap.get(detail.getTpid()));
            }
        }
    }

    @Override
    public TaskVO queryDetail(Long id) {
        TaskEntity entity = (TaskEntity)((Object)super.selectById((Serializable)id));
        TaskVO vo = (TaskVO)BeanMapper.map((Object)((Object)entity), TaskVO.class);
        List detailList = vo.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            for (TaskDetailVO detail : detailList) {
                detail.setTid(detail.getId());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            vo.setDetailList(TreeNodeBUtil.buildTree((List)detailList));
        }
        List list = new ArrayList();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TaskEntity::getBaseTaskId, (Object)entity.getBaseTaskId());
        queryWrapper.in(TaskEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.ne(BaseEntity::getId, (Object)id);
        queryWrapper.orderByAsc(BaseEntity::getCreateTime);
        List taskEntityList = super.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)taskEntityList)) {
            list = BeanMapper.mapList((Iterable)taskEntityList, TaskRecordVO.class);
        }
        vo.setRecordList(list);
        return vo;
    }

    @Override
    public TaskVO queryChangeDetail(Long id) {
        TaskEntity entity = (TaskEntity)((Object)super.selectById((Serializable)id));
        TaskVO vo = (TaskVO)BeanMapper.map((Object)((Object)entity), TaskVO.class);
        vo.setId(null);
        vo.setBillState(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setBeforeTaskVersion(vo.getTaskVersion());
        vo.setTaskVersion(Integer.valueOf(vo.getTaskVersion() + 1));
        vo.setLastTaskId(id);
        vo.setBaseTaskId(null != entity.getBaseTaskId() ? entity.getBaseTaskId() : id);
        vo.setChangeEmployeeId(null);
        vo.setChangeEmployeeName(null);
        vo.setChangeReason(null);
        List detailList = vo.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            detailList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTid(changeDetailVO.getId());
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : null);
                changeDetailVO.setRowState("add");
            });
            vo.setDetailList(TreeNodeBUtil.buildTree((List)detailList));
        }
        return vo;
    }

    @Override
    public CommonResponse<String> deleteVos(List<TaskVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (TaskVO taskVO : vos) {
                TaskEntity taskEntity = (TaskEntity)((Object)super.selectById((Serializable)taskVO.getId()));
                if (taskEntity.getLastTaskId() == null) continue;
                TaskEntity revise = (TaskEntity)((Object)super.getById((Serializable)taskEntity.getLastTaskId()));
                revise.setChangeId(null);
                revise.setLatestFlag(true);
                revise.setChangeState(1 == taskEntity.getTaskVersion() ? ChangeStateEnum.\u672a\u53d8\u66f4.getCode() : ChangeStateEnum.\u5df2\u53d8\u66f4.getCode());
                super.saveOrUpdate((Object)revise);
            }
        }
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<String> checkOrgYear(Long orgId, String taskYear, Long taskId) {
        List billList;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"org_id", (Object)orgId);
        query.eq((Object)"task_year", (Object)(taskYear + "-01-01"));
        if (null != taskId) {
            query.ne((Object)"id", (Object)taskId);
        }
        return CommonResponse.success((String)(CollectionUtils.isNotEmpty((Collection)(billList = super.list((Wrapper)query))) ? "\u672c\u533a\u57df + \u4efb\u52a1\u4e0b\u8fbe\u5e74\u5ea6\u5df2\u6709\u4efb\u52a1\u4e0b\u5355\u7684\u5355\u636e\uff01" : null));
    }
}

