package com.ejianc.business.jlincome.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlincome.income.bean.SettleEntity;
import com.ejianc.business.jlincome.income.service.ISettleService;
import com.ejianc.business.jlincome.income.vo.SettleDetailVO;
import com.ejianc.business.jlincome.income.vo.SettleVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 收入管理-对甲结算
 *
 * @author generator
 */
@Controller
@RequestMapping("settle")
public class SettleController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "DJJSC";//此处需要根据实际修改

    @Autowired
    private ISettleService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettleVO> saveOrUpdate(@RequestBody SettleVO saveOrUpdateVO) {
        return service.saveOrUpdate(saveOrUpdateVO);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleVO> queryDetail(Long id) {
        SettleEntity entity = service.selectById(id);
        SettleVO vo = BeanMapper.map(entity, SettleVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettleVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SettleVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SettleVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettleVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
//        单据编码、合同名称、项目名称、客户名称、经办人
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgCode");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("parentOrgCode");
        fuzzyFields.add("customerName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<SettleEntity> page = service.queryPage(param, false);
        IPage<SettleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<SettleVO> settleVOS = BeanMapper.mapList(pageData.getRecords(), SettleVO.class);
        settleVOS.stream().forEach(vo -> {
            vo.setSettleTypeStr(vo.getSettleType() == 1 ? "过程结算" : "完工结算");
        });
        pageData.setRecords(settleVOS);

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgCode");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("parentOrgCode");
        fuzzyFields.add("customerName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SettleEntity> settleEntities = service.queryList(param);
        List<SettleVO> settleVOS = BeanMapper.mapList(settleEntities, SettleVO.class);
        settleVOS.stream().forEach(vo -> {
            vo.setSettleTypeStr(vo.getSettleType() == 1 ? "过程结算" : "完工结算");
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", settleVOS);
        ExcelExport.getInstance().export("Settle-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSettleData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SettleVO>> refSettleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                         String condition,
                                                         String searchObject,
                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SettleEntity> page = service.queryPage(param, false);
        IPage<SettleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettleVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @RequestMapping(value = "/querySettle", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleVO> querySettle(Long contractId) {
        return service.querySettle(contractId);
    }

    @RequestMapping(value = "/querySettleDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<Long, SettleDetailVO>> querySettleDetail(String sourceDetailIds) {
        List<String> strings = Arrays.asList(sourceDetailIds.split(","));
        return service.querySettleDetail(strings);
    }


    /**
     * @Description 合同查询结算记录
     * @Return void
     */
    @RequestMapping(value = "/querySettleRecordByContId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> querySettleRecordByContId(@RequestParam Long contractId) {
        return CommonResponse.success("合同查询结算成功！", service.querySettleRecordByContId(contractId));
    }
}
