package com.ejianc.business.jlincome.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jlincome.income.bean.ContractRegisterDetailEntity;
import com.ejianc.business.jlincome.income.bean.ContractRegisterEntity;
import com.ejianc.business.jlincome.income.service.IContractRegisterService;
import com.ejianc.business.jlincome.income.vo.ContractRegisterChangeClauseVO;
import com.ejianc.business.jlincome.income.vo.ContractRegisterChangeDetailVO;
import com.ejianc.business.jlincome.income.vo.ContractRegisterChangeVO;
import com.ejianc.business.jlincome.income.vo.ContractRegisterRecordVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlincome.income.mapper.ContractRegisterChangeMapper;
import com.ejianc.business.jlincome.income.bean.ContractRegisterChangeEntity;
import com.ejianc.business.jlincome.income.service.IContractRegisterChangeService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * 收入管理-合同登记-变更
 * 
 * @author generator
 * 
 */
@Service("contractRegisterChangeService")
public class ContractRegisterChangeServiceImpl extends BaseServiceImpl<ContractRegisterChangeMapper, ContractRegisterChangeEntity> implements IContractRegisterChangeService{
    @Autowired
    private IContractRegisterService contractRegisterService;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public ContractRegisterChangeVO addConvertByConId(Long contractId) {
        ContractRegisterEntity entity = contractRegisterService.selectById(contractId);
        ContractRegisterChangeVO changeVo = BeanMapper.map(entity, ContractRegisterChangeVO.class);
        //新增逻辑处理
        changeVo.setContractId(contractId);
        //新增即点变更按钮穿透过来，此时ID为合同id
        changeVo.setId(IdWorker.getId());
        changeVo.setBillState(null);
        changeVo.setCreateUserCode(null);
        changeVo.setCreateTime(null);
        changeVo.setUpdateUserCode(null);
        changeVo.setUpdateTime(null);
        changeVo.setChangeDate(new Date());
        changeVo.setBeforeContractName(entity.getContractName());
        changeVo.setBeforeChangeMny(entity.getContractMny());
        changeVo.setBeforeChangeTaxMny(entity.getContractTaxMny());
        changeVo.setBeforeContractName(changeVo.getContractName());


        if (CollectionUtils.isNotEmpty(changeVo.getDetailList())){
            for (ContractRegisterChangeDetailVO contractRegisterChangeDetailVO : changeVo.getDetailList()) {
                contractRegisterChangeDetailVO.setContractDetailId(contractRegisterChangeDetailVO.getId());
                contractRegisterChangeDetailVO.setContractId(contractId);
                contractRegisterChangeDetailVO.setBeforeChangeNum(contractRegisterChangeDetailVO.getDetailNum());
                contractRegisterChangeDetailVO.setBeforeChangePrice(contractRegisterChangeDetailVO.getDetailTaxPrice());
                contractRegisterChangeDetailVO.setBeforeChangeRate(contractRegisterChangeDetailVO.getDetailRate());
                contractRegisterChangeDetailVO.setRowState("add");
            }
        }

        if (CollectionUtils.isNotEmpty(changeVo.getClauseList())) {
            for (ContractRegisterChangeClauseVO contractRegisterChangeClauseVO : changeVo.getClauseList()) {
                contractRegisterChangeClauseVO.setContractClauseId(contractId);
                contractRegisterChangeClauseVO.setContractId(contractId);
                contractRegisterChangeClauseVO.setRowState("add");
            }
        }
        //复制附件
        //附件
        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(contractId), "EJCBT202405000039", "contractRegisterFile", String.valueOf(changeVo.getId()), "EJCBT202405000046", "contractRegisterChangeFile");
        //管理
        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(contractId), "EJCBT202405000039", "contractMgrFile", String.valueOf(changeVo.getId()), "EJCBT202405000046", "contractRegisterMgrChangeFile");
        return changeVo;
    }

    @Override
    public ContractRegisterChangeVO queryChangeRecordByContId(Long id) {
        ContractRegisterChangeVO changeVO = new ContractRegisterChangeVO();
        ContractRegisterEntity entity = contractRegisterService.selectById(id);
        BigDecimal baseTaxMny = entity.getBaseTaxMny() == null ? BigDecimal.ZERO : entity.getBaseTaxMny();
        BigDecimal contractTaxMny = entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny();

        changeVO.setId(id);
        changeVO.setBaseTaxMny(baseTaxMny);
        //现合同金额（含税）
        changeVO.setContractTaxMny(contractTaxMny);

        changeVO.setSumChangeMny(contractTaxMny.subtract(baseTaxMny));
        if (changeVO.getSumChangeMny().compareTo(BigDecimal.ZERO) != 0 && baseTaxMny.compareTo(BigDecimal.ZERO) != 0) {
            changeVO.setSumScale(new BigDecimal(100).multiply(changeVO.getSumChangeMny().divide(baseTaxMny, 8, ROUND_HALF_DOWN)));
        } else {
            changeVO.setSumScale(BigDecimal.ZERO);
        }

        if (entity.getChangeVersion() > 0) {
            //合同版本号>0说明会有变更记录
            LambdaQueryWrapper<ContractRegisterChangeEntity> lambda = Wrappers.<ContractRegisterChangeEntity>lambdaQuery();
            lambda.eq(ContractRegisterChangeEntity::getContractId, id);
            lambda.in(ContractRegisterChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
            lambda.orderByDesc(ContractRegisterChangeEntity::getChangeVersion);
            List<ContractRegisterChangeEntity> entities = super.list(lambda);
            changeVO.setChangeRecord(BeanMapper.mapList(entities, ContractRegisterChangeVO.class));
        }
        return changeVO;
    }

}
