package com.ejianc.business.jlincome.performance.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jlincome.performance.bean.ForecastDetailEntity;
import com.ejianc.business.jlincome.performance.service.IForecastDetailService;
import com.ejianc.business.jlincome.performance.service.impl.ForecastDetailServiceImpl;
import com.ejianc.business.jlincome.performance.vo.ForecastLedgerVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.sun.xml.bind.v2.TODO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlincome.performance.bean.ForecastEntity;
import com.ejianc.business.jlincome.performance.service.IForecastService;
import com.ejianc.business.jlincome.performance.vo.ForecastVO;

/**
 * 绩效管理-销售预报-主表
 *
 * @author generator
 */
@Controller
@RequestMapping("forecast")
public class ForecastController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ForecastDetailServiceImpl forecastDetailService;

    private static final String BILL_CODE = "FORECAST_CODE";//此处需要根据实际修改

    @Autowired
    private IForecastService service;

    @Autowired
    private IForecastDetailService detailService;
    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ForecastVO> saveOrUpdate(@RequestBody ForecastVO saveOrUpdateVO) {
        return service.insertOrUpdate(saveOrUpdateVO);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ForecastVO> queryDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！", service.queryDetail(id));
    }

    /**
     * @param id
     * @Description queryChangeDetail 复制为变更单 取详情 （场景：点击变更）
     */
    @RequestMapping(value = "/queryChangeDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ForecastVO> queryChangeDetail(Long id) {
        ForecastVO changeVO = service.queryChangeDetail(id);
        return CommonResponse.success("查询详情数据成功！", changeVO);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ForecastVO> vos) {
        return service.deleteVos(vos);
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ForecastVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //单据编码、销售预报标题、区域名称、区域负责人、经办人
        fuzzyFields.add("billCode");
        fuzzyFields.add("forecastName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgPersonName");
        fuzzyFields.add("employeeName");

        if (null != param.getParams().get("forecastMonth")) {
            String forecastMonth = (String) param.getParams().get("forecastMonth").getValue();
            param.getParams().remove("forecastMonth");
            System.out.println(forecastMonth);
            String forecastMonth1 = forecastMonth.substring(0, 7);
            String forecastMonth2 = forecastMonth.substring(8, 15);
            param.getParams().put("forecastMonth", new Parameter(QueryParam.BETWEEN, (forecastMonth1 + "-01") + "," + (forecastMonth2 + "-31")));
        }
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        //复合条件
        ComplexParam resultComplexParam = new ComplexParam();
        resultComplexParam.setLogic("and");

        //生效单据
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("enableState", new Parameter(QueryParam.EQ, true));//生效

        ComplexParam complex2 = new ComplexParam();
        complex2.setLogic("or");

        //不生效（只有第一版本的 不生效的能被查出来，其他版本的都是生效的，不生效的是从变更中进入的）
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("and");
        c2.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));//非已提交和已通过
        complex2.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("and");
        c3.getParams().put("enableState", new Parameter(QueryParam.EQ, false));//不生效
        complex2.getComplexParams().add(c3);

        ComplexParam c5 = new ComplexParam();
        c5.setLogic("and");
        c5.getParams().put("forecastVersion", new Parameter(QueryParam.EQ, "1"));//第一版本
        complex2.getComplexParams().add(c5);

        resultComplexParam.getComplexParams().add(c1);
        resultComplexParam.getComplexParams().add(complex2);
        param.getComplexParams().add(resultComplexParam);

        IPage<ForecastEntity> page = service.queryPage(param, false);
        IPage<ForecastVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ForecastVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //单据编码、销售预报标题、区域名称、区域负责人、经办人
        fuzzyFields.add("billCode");
        fuzzyFields.add("forecastName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgPersonName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        //复合条件
        ComplexParam resultComplexParam = new ComplexParam();
        resultComplexParam.setLogic("and");

        //生效单据
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("enableState", new Parameter(QueryParam.EQ, true));//生效

        ComplexParam complex2 = new ComplexParam();
        complex2.setLogic("or");

        //不生效（只有第一版本的 不生效的能被查出来，其他版本的都是生效的，不生效的是从变更中进入的）
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("and");
        c2.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));//非已提交和已通过
        complex2.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("and");
        c3.getParams().put("enableState", new Parameter(QueryParam.EQ, false));//不生效
        complex2.getComplexParams().add(c3);

        ComplexParam c5 = new ComplexParam();
        c5.setLogic("and");
        c5.getParams().put("forecastVersion", new Parameter(QueryParam.EQ, "1"));//第一版本
        complex2.getComplexParams().add(c5);

        resultComplexParam.getComplexParams().add(c1);
        resultComplexParam.getComplexParams().add(complex2);
        param.getComplexParams().add(resultComplexParam);
        List<ForecastEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<ForecastVO> voList = BeanMapper.mapList(list, ForecastVO.class);
        voList.forEach((vo) -> {
            if (vo.getChangeState() == 0) {
                vo.setChangeStateName("未变更");
            } else if (vo.getChangeState() == 1) {
                vo.setChangeStateName("变更中");
            } else {
                vo.setChangeStateName("已变更");
            }
        });
        logger.info(voList.get(0).getChangeStateName());
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("Forecast-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refForecastData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ForecastVO>> refForecastData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                             String condition,
                                                             String searchObject,
                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ForecastEntity> page = service.queryPage(param, false);
        IPage<ForecastVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ForecastVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @RequestMapping(value = "/checkOrgMonth", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> checkOrgMonth(@RequestParam(value = "rowId", required = false) Long rowId, @RequestParam(value = "orgId") Long orgId, @RequestParam(value = "forecastMonth") String forecastMonth) {
        return service.checkOrgMonth(rowId, orgId, forecastMonth);
    }


    //销售预报台账
    @RequestMapping(value = "/queryLedgerList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ForecastLedgerVO>> queryLedgerList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */  // 搜索：区域名称、客户单位名称、负责人，模糊搜索
        List<String> fuzzyFields = param.getFuzzyFields();
        //区域名称orgName
        fuzzyFields.add("orgName");
        //客户单位名称
        // fuzzyFields.add("customerName");
        //负责人orgPersonName
        fuzzyFields.add("orgPersonName");
        if (null != param.getParams().get("forecastMonth")) {
            String forecastMonth = (String) param.getParams().get("forecastMonth").getValue();
            param.getParams().remove("forecastMonth");
            System.out.println(forecastMonth);
            String forecastMonth1 = forecastMonth.substring(0, 7);
            String forecastMonth2 = forecastMonth.substring(8, 15);
            param.getParams().put("forecastMonth", new Parameter(QueryParam.BETWEEN, (forecastMonth1 + "-01") + "," + (forecastMonth2 + "-31")));
        }

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        //复合条件
        ComplexParam resultComplexParam = new ComplexParam();
        resultComplexParam.setLogic("and");

        //生效单据
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("enableState", new Parameter(QueryParam.EQ, true));//生效

        ComplexParam complex2 = new ComplexParam();
        complex2.setLogic("or");

        //不生效（只有第一版本的 不生效的能被查出来，其他版本的都是生效的，不生效的是从变更中进入的）
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("and");
        c2.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));//非已提交和已通过
        complex2.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("and");
        c3.getParams().put("enableState", new Parameter(QueryParam.EQ, false));//不生效
        complex2.getComplexParams().add(c3);

        ComplexParam c5 = new ComplexParam();
        c5.setLogic("and");
        c5.getParams().put("forecastVersion", new Parameter(QueryParam.EQ, "1"));//第一版本
        complex2.getComplexParams().add(c5);

        resultComplexParam.getComplexParams().add(c1);
        resultComplexParam.getComplexParams().add(complex2);
        param.getComplexParams().add(resultComplexParam);
        List<Integer> billStateList = new ArrayList<>();
        billStateList.add(1);
        billStateList.add(3);
        param.getParams().put("billState", new Parameter(QueryParam.IN, billStateList));
        IPage<ForecastEntity> page = service.queryPage(param, false);
        IPage<ForecastLedgerVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ForecastLedgerVO> resDatas = new ArrayList<>();

        if (CollectionUtils.isNotEmpty(page.getRecords())) {
            resDatas = BeanMapper.mapList(page.getRecords(), ForecastLedgerVO.class);
            List<Long> ids = new ArrayList<>();
            Map<Long, Integer> map = new HashMap<>();
            if (CollectionUtils.isNotEmpty(resDatas)) {
                resDatas.forEach(e -> {
                    ids.add(e.getId());
                    map.put(e.getId(), e.getBillState());

                });
            }
            LambdaQueryWrapper<ForecastDetailEntity> lambda = Wrappers.<ForecastDetailEntity>lambdaQuery();
            lambda.in(ForecastDetailEntity::getPid, ids);
            List<ForecastDetailEntity> resList = forecastDetailService.list(lambda);
            List<ForecastLedgerVO> ListVOList = BeanMapper.mapList(resList, ForecastLedgerVO.class);

            //过滤出  子表中 孙级
            List<ForecastLedgerVO> listThirdStage = ListVOList.stream().filter(forecastLedgerVO -> forecastLedgerVO.getParentId() != null).collect(
                    Collectors.collectingAndThen(
                            Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(o -> o.getDetailPersonId() + ";" + o.getPid()))), ArrayList::new)
            );
            //过滤出 子表中 父级
            List<ForecastLedgerVO> listFather = ListVOList.stream()
                    .filter(forecastLedgerVO -> {
                        if (forecastLedgerVO.getParentId() == null) {
                            forecastLedgerVO.setParentId(forecastLedgerVO.getPid());
                            forecastLedgerVO.setOrgName(forecastLedgerVO.getDetailOrgName());
                            forecastLedgerVO.setOrgPersonName(forecastLedgerVO.getDetailPersonName());
                            forecastLedgerVO.setSaleForecastMny(forecastLedgerVO.getSaleDetailMny());
                            forecastLedgerVO.setInvoiceForecastMny(forecastLedgerVO.getInvoiceDetailMny());
                            forecastLedgerVO.setIncomeForecastMny(forecastLedgerVO.getIncomeDetailMny());
                            forecastLedgerVO.setType(2); //父级
                            return true;
                        } else {
                            return false;
                        }
                    }).collect(Collectors.toList());
            resDatas.addAll(listFather);

            if (CollectionUtils.isNotEmpty(listThirdStage)) {
                listThirdStage.forEach(e -> {
                    e.setOrgName(e.getOrgName());
                    e.setOrgPersonName(e.getDetailPersonName());
                    //子表父级的区域名
                    e.setOrgName(e.getDetailOrgName());

                    //todo 构建查询条件  查询出 一个合同中 一个负责人 对应 多个客户的 金额数相加
                    LambdaQueryWrapper<ForecastDetailEntity> wrapper = new LambdaQueryWrapper<>();
                    wrapper.eq(ForecastDetailEntity::getDetailPersonId, e.getDetailPersonId())
                            .eq(ForecastDetailEntity::getParentId, e.getParentId());
                    List<ForecastDetailEntity> list1 = detailService.list(wrapper);

                    BigDecimal SaleForecastMny = new BigDecimal(0);
                    BigDecimal InvoiceForecastMny = new BigDecimal(0);
                    BigDecimal IncomeForecastMny = new BigDecimal(0);

                    for (ForecastDetailEntity forecastDetailEntity : list1) {
                        SaleForecastMny = SaleForecastMny.add(forecastDetailEntity.getSaleDetailMny());
                        InvoiceForecastMny = InvoiceForecastMny.add(forecastDetailEntity.getInvoiceDetailMny());
                        IncomeForecastMny = IncomeForecastMny.add(forecastDetailEntity.getIncomeDetailMny());
                    }

                    //销售 开票 收款 预报金额
                    e.setSaleForecastMny(SaleForecastMny);//预报
                    e.setInvoiceForecastMny(InvoiceForecastMny);//开票
                    e.setIncomeForecastMny(IncomeForecastMny);//收款
                    //todo 2024/4/26 销售的  完成金额 完成差距 已经在  updateResDatas 方法中设置了。后续的 开票和回款记得写！

                });

                resDatas.addAll(listThirdStage);
            }
            //这是当进行 模糊查询的时候。对子表也进行查询。合并之后 再过滤出重复数据
            List<ForecastLedgerVO> list=null;
            if(param.getSearchText()!=null){
                String searchText = param.getSearchText();
                list = forecastDetailService.selectAll(searchText);
                resDatas.addAll(list);
            }
            List<ForecastLedgerVO> resDatas1=null;
            //这是在 过滤 主表 子表 合并后的重复数据
           if(CollectionUtils.isNotEmpty(resDatas)&&CollectionUtils.isNotEmpty(list)){

                resDatas1 = resDatas.stream().collect(
                       Collectors.collectingAndThen(
                               Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(o -> o.getId()))), ArrayList::new)
               );
           }
            List<ForecastLedgerVO> forecastLedgerVOS = null;
           //如果为空那么就加 原本的数据
            if (CollectionUtils.isEmpty(resDatas1)) {
                forecastLedgerVOS = TreeNodeBUtil.buildTree(resDatas);
            } else {
                //如果为不空那么就加 合并后的数据
                forecastLedgerVOS = TreeNodeBUtil.buildTree(resDatas1);
            }
            //todo 为三级的 完成金额 完成差距 进行赋值
            service.updateResDatas(forecastLedgerVOS);
            pageData.setRecords(forecastLedgerVOS);
            return CommonResponse.success("查询列表数据成功！", pageData);
        } else {
            //模糊查询 主表中不存在数据  去查子表数据
            String searchText1 = param.getSearchText();
            List<ForecastLedgerVO> list1 = forecastDetailService.selectAll(searchText1);
            //todo 为三级的 完成金额 完成差距 进行赋值
            service.updateResDatas(list1);
            pageData.setRecords(list1);
            return CommonResponse.success("查询列表数据成功！", pageData);
        }
    }


    /**
     * @param param
     * @Description 台账导出
     * @Return void
     */
    @RequestMapping(value = "/LedgerExcelExport", method = RequestMethod.POST)
    @ResponseBody
    public void LedgerExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //区域名称orgName
        fuzzyFields.add("orgName");
        //客户单位名称
        // fuzzyFields.add("customerName");
        //负责人orgPersonName
        fuzzyFields.add("orgPersonName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (null != param.getParams().get("forecastMonth")) {
            String forecastMonth = (String) param.getParams().get("forecastMonth").getValue();
            param.getParams().remove("forecastMonth");
            System.out.println(forecastMonth);
            String forecastMonth1 = forecastMonth.substring(0, 7);
            String forecastMonth2 = forecastMonth.substring(8, 15);
            param.getParams().put("forecastMonth", new Parameter(QueryParam.BETWEEN, (forecastMonth1 + "-01") + "," + (forecastMonth2 + "-31")));
        }
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //复合条件
        ComplexParam resultComplexParam = new ComplexParam();
        resultComplexParam.setLogic("and");

        //生效单据
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("enableState", new Parameter(QueryParam.EQ, true));//生效

        ComplexParam complex2 = new ComplexParam();
        complex2.setLogic("or");

        //不生效（只有第一版本的 不生效的能被查出来，其他版本的都是生效的，不生效的是从变更中进入的）
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("and");
        c2.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));//非已提交和已通过
        complex2.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("and");
        c3.getParams().put("enableState", new Parameter(QueryParam.EQ, false));//不生效
        complex2.getComplexParams().add(c3);

        ComplexParam c5 = new ComplexParam();
        c5.setLogic("and");
        c5.getParams().put("forecastVersion", new Parameter(QueryParam.EQ, "1"));//第一版本
        complex2.getComplexParams().add(c5);

        resultComplexParam.getComplexParams().add(c1);
        resultComplexParam.getComplexParams().add(complex2);
        param.getComplexParams().add(resultComplexParam);
        List<Integer> billStateList = new ArrayList<>();
        billStateList.add(1);
        billStateList.add(3);
        param.getParams().put("billState", new Parameter(QueryParam.IN, billStateList));
        List<ForecastEntity> list = service.queryList(param);

        List<ForecastLedgerVO> resDatas = new ArrayList<>();
        Map<String, Object> beans = new HashMap<>();
        if (CollectionUtils.isNotEmpty(list)) {
            resDatas = BeanMapper.mapList(list, ForecastLedgerVO.class);
            List<Long> ids = new ArrayList<>();
            Map<Long, Integer> map = new HashMap<>();
            if (CollectionUtils.isNotEmpty(resDatas)) {
                resDatas.forEach(e -> {
                    ids.add(e.getId());
                    map.put(e.getId(), e.getBillState());
                });
            }
            //构建查询条件
            LambdaQueryWrapper<ForecastDetailEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
            lambdaQueryWrapper.in(ForecastDetailEntity::getPid, ids);
            List<ForecastDetailEntity> DetailEntityList = forecastDetailService.list(lambdaQueryWrapper);

            List<ForecastLedgerVO> ListVOList = BeanMapper.mapList(DetailEntityList, ForecastLedgerVO.class);

            //子表数据过滤出 孙级
            List<ForecastLedgerVO> listThirdStage = ListVOList.stream().filter(forecastLedgerVO -> forecastLedgerVO.getParentId() != null).collect(
                    Collectors.collectingAndThen(
                            Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(o -> o.getDetailPersonId() + ";" + o.getPid()))), ArrayList::new)
            );
            //子表数据过滤出 父级
            List<ForecastLedgerVO> listFather = ListVOList.stream()
                    .filter(forecastLedgerVO -> {
                        if (forecastLedgerVO.getParentId() == null) {
                            forecastLedgerVO.setParentId(forecastLedgerVO.getPid());
                            forecastLedgerVO.setOrgName(forecastLedgerVO.getDetailOrgName());
                            forecastLedgerVO.setOrgPersonName(forecastLedgerVO.getDetailPersonName());
                            forecastLedgerVO.setSaleForecastMny(forecastLedgerVO.getSaleDetailMny());
                            forecastLedgerVO.setInvoiceForecastMny(forecastLedgerVO.getInvoiceDetailMny());
                            forecastLedgerVO.setIncomeForecastMny(forecastLedgerVO.getIncomeDetailMny());
                            return true;
                        } else {
                            return false;
                        }
                    }).collect(Collectors.toList());
            resDatas.addAll(listFather);
            if (CollectionUtils.isNotEmpty(listThirdStage)) {
                listThirdStage.forEach(e -> {
                    e.setOrgName(e.getOrgName());
                    e.setOrgPersonName(e.getDetailPersonName());
                    //子表父级的区域名
                    e.setOrgName(e.getDetailOrgName());

                    LambdaQueryWrapper<ForecastDetailEntity> wrapper = new LambdaQueryWrapper<>();

                    wrapper.eq(ForecastDetailEntity::getDetailPersonId, e.getDetailPersonId())
                            .eq(ForecastDetailEntity::getParentId, e.getParentId());
                    List<ForecastDetailEntity> list2 = detailService.list(wrapper);

                    BigDecimal SaleForecastMny = new BigDecimal(0);
                    BigDecimal InvoiceForecastMny = new BigDecimal(0);
                    BigDecimal IncomeForecastMny = new BigDecimal(0);

                    for (ForecastDetailEntity forecastDetailEntity : list2) {
                        SaleForecastMny = SaleForecastMny.add(forecastDetailEntity.getSaleDetailMny());
                        InvoiceForecastMny = InvoiceForecastMny.add(forecastDetailEntity.getInvoiceDetailMny());
                        IncomeForecastMny = IncomeForecastMny.add(forecastDetailEntity.getIncomeDetailMny());
                    }


                    //销售 开票 收款 预报金额
                    e.setSaleForecastMny(SaleForecastMny);//预报
                    e.setInvoiceForecastMny(InvoiceForecastMny);//开票
                    e.setIncomeForecastMny(IncomeForecastMny);//收款
                    e.setOrgPersonName(e.getDetailPersonName());
                    //todo 2024/4/26 销售的  完成金额 完成差距 已经在  updateResDatas 方法中设置了。后续的 开票和回款记得写！

                    if (e.getParentId() == null) {
                        e.setParentId(e.getPid());
                        e.setOrgName(e.getDetailOrgName());
                    }
                });
                resDatas.addAll(listThirdStage);
            }

            List<ForecastLedgerVO> forecastDetailList=null;
            if(param.getSearchText()!=null){
                String searchText = param.getSearchText();
                forecastDetailList = forecastDetailService.selectAll(searchText);
                resDatas.addAll(forecastDetailList);
            }
            List<ForecastLedgerVO> resDatas2=null;
            if(CollectionUtils.isNotEmpty(resDatas)&&CollectionUtils.isNotEmpty(forecastDetailList)){

                resDatas2 = resDatas.stream().collect(
                        Collectors.collectingAndThen(
                                Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(o -> o.getId()))), ArrayList::new)
                );
            }
            List<ForecastLedgerVO> forecastLedgerVOS = null;
            if (CollectionUtils.isEmpty(resDatas2)) {
                forecastLedgerVOS = TreeNodeBUtil.buildTree(resDatas);
            } else {
                forecastLedgerVOS = TreeNodeBUtil.buildTree(resDatas2);
            }
           // resDatas = TreeNodeBUtil.buildTree(resDatas);
            //todo 为三级的 完成金额 完成差距 进行赋值
            service.updateResDatas(forecastLedgerVOS);
            //过滤重复数据
            List<ForecastLedgerVO> resDatas1 = forecastLedgerVOS.stream().collect(
                    Collectors.collectingAndThen(
                            Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(o -> o.getBillCode()))), ArrayList::new)
            );
            beans.put("records", resDatas1);
            extracted(resDatas1, beans);
        } else {
            String searchText = param.getSearchText();
            List<ForecastLedgerVO> list1 = forecastDetailService.selectAll(searchText);
            //todo 为三级的 完成金额 完成差距 进行赋值
            service.updateResDatas(list1);
            //过滤重复数据
            List<ForecastLedgerVO> resDatas1 = list1.stream().collect(
                    Collectors.collectingAndThen(
                            Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(o -> o.getBillCode()))), ArrayList::new)
            );
            resDatas.addAll(resDatas1);
            beans.put("records", resDatas);
            //调方法 完成 合计功能
            extracted(resDatas, beans);
        }
        ExcelExport.getInstance().export("Ledger-export.xlsx", beans, response);
    }

    private static void extracted(List<ForecastLedgerVO> resDatas, Map<String, Object> beans) {
        //合计 销售预报金额
        BigDecimal saleForecastMny = new BigDecimal(0);

        //合计 开票预报金额
        BigDecimal invoiceForecastMny = new BigDecimal(0);

        //合计 收入预报金额
        BigDecimal incomeForecastMny = new BigDecimal(0);

        //合计 销售完成金额
        BigDecimal saleCompletionMny = new BigDecimal(0);
        //合计销完成差距
        BigDecimal saleCompletionGap = new BigDecimal(0);



        for (ForecastLedgerVO resData : resDatas) {
            saleForecastMny = saleForecastMny.add(resData.getSaleForecastMny());
            invoiceForecastMny = invoiceForecastMny.add(resData.getInvoiceForecastMny());
            incomeForecastMny = incomeForecastMny.add(resData.getIncomeForecastMny());
            saleCompletionMny=saleCompletionMny.add(resData.getSaleCompletionMny());
            saleCompletionGap =saleCompletionGap.add(resData.getSaleCompletionGap());
        }
        beans.put("saleForecastMny", saleForecastMny);
        beans.put("invoiceForecastMny", invoiceForecastMny);
        beans.put("incomeForecastMny", incomeForecastMny);
        beans.put("saleCompletionMny", saleCompletionMny);
        beans.put("saleCompletionGap", saleCompletionGap);
    }
}
