package com.ejianc.business.jlincome.performance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.jlincome.performance.bean.*;
import com.ejianc.business.jlincome.performance.service.*;
import com.ejianc.business.jlincome.performance.vo.SaleReportTreeVO;
import com.ejianc.business.jlincome.performance.vo.SaleReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.mq.common.MqMessage;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlincome.performance.mapper.SaleReportMapper;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 绩效管理_业绩完成报表
 * 
 * @author generator
 * 
 */
@Service("saleReportService")
public class SaleReportServiceImpl extends BaseServiceImpl<SaleReportMapper, SaleReportEntity> implements ISaleReportService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final static String COLLECT_FILL_QUEUE = "sale_pool_date_queue";

    @Value("${spring.cloud.config.profile}")
    private String profile;

    @Autowired
    private IPoolService poolService;

    @Autowired
    private ISaleContractService saleContractService;

    @Autowired
    private IGradeAdjustService gradeAdjustService;

    @Autowired
    private IGradeAdjustDetailService gradeAdjustDetailService;

    @Autowired
    private ITaskService taskService;
    @Autowired
    private ITaskDetailService taskDetailService;
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    @Async(value = "commonTask")
    public void saveInitPoolDate(String authority) {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = Objects.requireNonNull(requestAttributes).getRequest();
        logger.info("异步消息通知的authority：{}", request.getHeader("authority"));

        if (StringUtils.isBlank(request.getHeader("authority"))) {
            InvocationInfoProxy.setExtendAttribute("authority", authority);
            logger.info("informMessage-异步消息通知的authority：{}", authority);
        } else {
            InvocationInfoProxy.setExtendAttribute("authority", request.getHeader("authority"));
            logger.info("informMessage-异步消息通知的authority：{}", request.getHeader("authority"));
        }

        //1，删除数据
        poolService.deletePoolDetail();
        logger.info("删除数据完成-");

        //2.1抽取销售业绩合同数据
        List<PoolEntity> resList = new ArrayList<>();
        LambdaQueryWrapper<SaleContractEntity> lambda = new LambdaQueryWrapper<SaleContractEntity>();
        lambda.in(SaleContractEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
        List<SaleContractEntity> saleContractEntityList = saleContractService.list(lambda);
        if(CollectionUtils.isNotEmpty(saleContractEntityList)){
           resList = changeSale(saleContractEntityList);
        }

        //todo 2.2 抽取开票数据
        //todo 2.3 抽取收款数据
        poolService.saveBatch(resList); // 使用批量插入，后续会查不到主键信息

        baseMapper.deleteReportDetail();
        //根据抽取数据  生成报表
        saveReport();

    }


    public void saveReport(){
            List<PoolEntity> poolEntityList = poolService.queryList();
            logger.info("MQ去获取到结果--"+JSONObject.toJSONString(poolEntityList));

            //todo 第一步  得到adjustAfterList
            //1 区分出来 有成绩调整的合同adjustList      与没有成绩调整的合同unAdjustList  没有成绩调整的不需要拆分
            List<PoolEntity> adjustList = new ArrayList<>();
            List<PoolEntity> unAdjustList = new ArrayList<>();
            List<PoolEntity> adjustAfterList = new ArrayList<>();


            LambdaQueryWrapper<GradeAdjustEntity> lambda2 = new LambdaQueryWrapper<GradeAdjustEntity>();
            lambda2.in(GradeAdjustEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
            lambda2.orderByDesc(GradeAdjustEntity::getCreateTime);
            lambda2.groupBy(GradeAdjustEntity::getContractId,GradeAdjustEntity::getInitiationMonth);//合同+月份  取最新 的数据
            List<GradeAdjustEntity> gradeAdjustList = gradeAdjustService.list(lambda2);
            //set<合同主键>
            Set<Long> adjustContractIds = gradeAdjustList.stream().map(GradeAdjustEntity::getContractId).collect(Collectors.toSet());
            //List<调整单主表主键>
            List<Long> GradeAdjustIds = gradeAdjustList.stream().map(GradeAdjustEntity::getId).collect(Collectors.toList());


            LambdaQueryWrapper<GradeAdjustDetailEntity> lambda3 = new LambdaQueryWrapper<GradeAdjustDetailEntity>();
            lambda3.in(GradeAdjustDetailEntity::getDetailId,GradeAdjustIds );
            List<GradeAdjustDetailEntity> adjustDetailList = gradeAdjustDetailService.list(lambda3);

            //  成绩调整--子表  map<主表主键，子表信息>>
            Map<Long,List<GradeAdjustDetailEntity>> adjustDetailMap = adjustDetailList.stream().collect(Collectors.toMap(GradeAdjustDetailEntity::getDetailId,
                    Collections::singletonList,
                    (list1, list2) -> {
                        List<GradeAdjustDetailEntity> mergedList = new ArrayList<>(list1);
                        mergedList.addAll(list2);
                        return mergedList;
                    }));

            //  成绩调整  map<合同主键，List(合同每月对应的成绩调整)>
            Map<Long,List<GradeAdjustEntity>> adjustMap = gradeAdjustList.stream().collect(Collectors.toMap(GradeAdjustEntity::getContractId,
                    Collections::singletonList,
                    (list1, list2) -> {
                        List<GradeAdjustEntity> mergedList = new ArrayList<>(list1);
                        mergedList.addAll(list2);
                        return mergedList;
                    }));


            poolEntityList.forEach(e->{
                if(adjustContractIds.contains(e.getContractId())){
                    adjustList.add(e);
                }else{
                    unAdjustList.add(e);
                }
            });

            //2 根据成绩调整  拆分 adjustList
            adjustList.forEach(e->{
                List<GradeAdjustDetailEntity> detailEntityList = getAdjustDetail(e.getContractId(),e.getSourceMonth(),adjustMap,adjustDetailMap);
                if(org.apache.commons.collections.CollectionUtils.isNotEmpty(detailEntityList)){
                    //当前数据年月有对应调整，需要根据子表 人员  拆分
                    detailEntityList.forEach(k->{
                        PoolEntity poolEntity = BeanMapper.map(e,PoolEntity.class);
                        BigDecimal mny = e.getMny()==null?BigDecimal.ZERO:e.getMny();
                        BigDecimal taxMny = e.getTaxMny()==null?BigDecimal.ZERO:e.getTaxMny();
                        BigDecimal salePercentage = k.getSalePercentage()==null?BigDecimal.ZERO:k.getSalePercentage(); // 销售占比
                        BigDecimal invoicePercentage = k.getInvoicePercentage()==null?BigDecimal.ZERO:k.getInvoicePercentage(); // 开票占比
                        BigDecimal receivablePercentage = k.getReceivablePercentage()==null?BigDecimal.ZERO:k.getReceivablePercentage(); // 收款占比
                        if(1==poolEntity.getSourceType()){
                            //销售业绩
                            poolEntity.setMny(mny.multiply(salePercentage).divide(new BigDecimal(100)));
                            poolEntity.setTaxMny(taxMny.multiply(salePercentage).divide(new BigDecimal(100)));
                        }else if(2==poolEntity.getSourceType()){
                            //开票
                            poolEntity.setMny(mny.multiply(invoicePercentage).divide(new BigDecimal(100)));
                            poolEntity.setTaxMny(taxMny.multiply(invoicePercentage).divide(new BigDecimal(100)));
                        }else if(3==poolEntity.getSourceType()){
                            //收款
                            poolEntity.setMny(mny.multiply(receivablePercentage).divide(new BigDecimal(100)));
                            poolEntity.setTaxMny(taxMny.multiply(receivablePercentage).divide(new BigDecimal(100)));
                        }
                        poolEntity.setSaleId(k.getDetailEmployeeId());
                        poolEntity.setSaleName(k.getDetailEmployeeName());
                        poolEntity.setOrgId(k.getDetailOrgId());
                        poolEntity.setOrgName(k.getDetailOrgName());
                        poolEntity.setOrgCode(k.getDetailOrgCode());
                        adjustAfterList.add(poolEntity);
                    });

                }else{
                    //当前数据年月没有对应的 最新调整  比如 数据是2024-03  最新一次调整是 2024-04  此时不需要调整
                    adjustAfterList.add(e);
                }
            });

            adjustAfterList.addAll(unAdjustList);



            //todo 第二步  得到业绩的  Map<人+区域+ 年度，对应详情(所属区域 pid 2024-01	2024-02	2024-03	一季度)>   结果yjReportMap
            Map<String,SaleReportVO> yjReportMap = new HashMap<>();
            adjustAfterList.forEach(e->{
                String org = e.getOrgId()==null?"":e.getOrgId()+"";
                String unionId = e.getSaleId()+org+e.getSourceYear();
                if(yjReportMap.containsKey(unionId)){
                    SaleReportVO saleReportVO= yjReportMap.get(unionId);
                    changeSaleReportVO(saleReportVO,e.getSourceMonth(),e.getTaxMny(),e.getSourceType());
                    yjReportMap.put(unionId,saleReportVO);
                }else{
                    SaleReportVO saleReportVO = new SaleReportVO();
                    saleReportVO = changeSaleReportVO(saleReportVO,e.getSourceMonth(),e.getTaxMny(),e.getSourceType());
                    saleReportVO.setOrgId(e.getOrgId());
                    saleReportVO.setOrgCode(e.getOrgCode());
                    saleReportVO.setOrgName(e.getOrgName());
                    saleReportVO.setEmployeeId(e.getSaleId());
                    saleReportVO.setEmployeeName(e.getSaleName());
                    saleReportVO.setYear(e.getSourceYear());
                    yjReportMap.put(unionId,saleReportVO);
                }
            });


            //todo 第三步 获取任务下达数据  得到 任务下达的  Map<人+区域+年度,任务下达>   结果 saleReportList
            LambdaQueryWrapper<TaskEntity> lambda4 = new LambdaQueryWrapper<TaskEntity>();
//            lambda4.eq(TaskEntity::getId,838795274942951482L);
            lambda4.eq(TaskEntity::getEnableState,true);
            lambda4.in(TaskEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());

            lambda4.orderByDesc(TaskEntity::getCreateTime);
            lambda4.groupBy(TaskEntity::getTaskYear);//合同+月份  取最新 的数据
            List<TaskEntity> taskEntityList = taskService.list(lambda4);

            Map<Long,TaskEntity> taskMap = new HashMap<>();
            List<Long> taskIds = new ArrayList<>();
            taskEntityList.forEach(e->{
                taskIds.add(e.getId());
                taskMap.put(e.getId(),e);
            });

            LambdaQueryWrapper<TaskDetailEntity> lambda5 = new LambdaQueryWrapper<TaskDetailEntity>();
            lambda5.in(TaskDetailEntity::getPid,taskIds );
            List<TaskDetailEntity> taskDetailList = taskDetailService.list(lambda5);

            //   任务下达得到的数据   主子孙
            List<SaleReportEntity> saleReportList = changeSaleReport(taskDetailList,taskMap);

            //    任务下达   Map<人+区域+ 年度，对应详情(对应的销售任务)>
            Map<String,SaleReportEntity> saleMap = new HashMap<>();
            Map<String,SaleReportEntity> saleOrgMap = new HashMap<>();
            saleReportList.forEach(e->{
                String employeeId = e.getEmployeeId()==null?"":e.getEmployeeId()+"";
                String org = e.getTeamOrgId()==null?"":e.getTeamOrgId()+"";
                String year = e.getYear();
                String unionId = employeeId+org+year;
                saleMap.put(unionId,e);

                if(null!=e.getOrgId()){
                    saleOrgMap.put(e.getOrgId()+year,e);
                }
            });



            //todo 第四步  整合 二 三 结果 合并最后结果  得到resList
            List<SaleReportTreeVO> resList = new ArrayList<>();//最终数据
            List<SaleReportEntity> saveList = new ArrayList<>();//
            List<SaleReportEntity> saveAllList = new ArrayList<>();//最终保存数据
            Map<Long,SaleReportEntity> havaMap = new HashMap<>();//能合并的数据
            List<SaleReportEntity> unHaveList = new ArrayList<>();//不能合并的数据  新组装的数据
            yjReportMap.forEach((unionId,saleReportVO)->{
                if(saleMap.containsKey(unionId)){
                    //合并
                    havaMap.put(saleMap.get(unionId).getId(),getSaleReport(saleMap.get(unionId),saleReportVO));
                }else{
                    //无法合并 找不到对应销售业绩下达
                    //组装一个假的任务下达  人+区域+年
                    SaleReportEntity saleEntity = new SaleReportEntity();
                    saleEntity.setYear(saleReportVO.getYear());
                    saleEntity.setOrgId(saleReportVO.getOrgId());
                    saleEntity.setOrgName(saleReportVO.getOrgName());
                    saleEntity.setOrgCode(saleReportVO.getOrgCode());
                    saleEntity.setEmployeeId(saleReportVO.getEmployeeId());
                    saleEntity.setEmployeeName(saleReportVO.getEmployeeName());
                    saleEntity.setId(saleReportVO.getId());
                    //根据 业绩的区域 找 任务下达的数据 匹配上 泽挂上  匹配不上 则上业绩的区域上级  直到找到
                    Long orgId = saleReportVO.getOrgId();
                    CommonResponse<List<OrgVO>> commonResponse = iOrgApi.findParentsByOrgId(orgId);
                    List<OrgVO> orgVOList = commonResponse.getData();
                    for(OrgVO e:orgVOList ){
                        if(saleOrgMap.containsKey(e.getId()+saleReportVO.getYear())){
                            saleEntity.setParentId(saleOrgMap.get(e.getId()+saleReportVO.getYear()).getId());
                            break ;
                        }else{
                            //如果业绩的区域  所有上级都匹配不上，则设置为和大区平级的
                            saleEntity.setParentId(999L);
                        }
                    }
//                    if(saleOrgMap.containsKey(1765202378132295681L)){
//                        saleEntity.setParentId(saleOrgMap.get(1765202378132295681L).getId());
//                    }else{
//                        //如果业绩的区域  所有上级都匹配不上，则设置为和大区平级的
//                        saleEntity.setParentId(999L);
//                    }
                    unHaveList.add(getSaleReport(saleEntity,saleReportVO));
                }
            });

            saleReportList.forEach(e->{
                if(havaMap.containsKey(e.getId())){
                    saveList.add(havaMap.get(e.getId()));
                }else{
                    //没有业绩的 也需要算一下
                    saveList.add(getSaleReport(e,new SaleReportVO()));
                }
            });

            if(org.apache.commons.collections.CollectionUtils.isNotEmpty(unHaveList)){
                saveList.addAll(unHaveList);
            }

            //todo 逐级向上汇总金额
            Map<Long,List<SaleReportEntity>> mnyMap = new HashMap<>();//map<父级主键，List<SaleReportEntity>>
            saveList.forEach(e->{
                if(null==e.getSaleType()){
                    //末级数据  不需要汇总
                    if(null==e.getOrgId()){
                        //为了销售预报，个人台账 好查询个人业绩的
                        e.setOrgId(e.getTeamOrgId());
                    }
                    if(null==e.getTeamOrgId()){
                        //末级不显示区域名称
                       e.setOrgName(null);
                    }
                    saveAllList.add(e);
                }
                if(mnyMap.containsKey(e.getParentId())){
                    List<SaleReportEntity> list = mnyMap.get(e.getParentId());
                    list.add(e);
                    mnyMap.put(e.getParentId(),list);
                }else{
                    List<SaleReportEntity> list = new ArrayList<>();
                    list.add(e);
                    mnyMap.put(e.getParentId(),list);
                }
            });
            //汇总 小组数据

            saveList.forEach(e->{
                if(null!=e.getSaleType()&&2==e.getSaleType()){
                    saveAllList.add(getSumSaleReport(e,mnyMap)) ;
                }
            });
            //汇总 区域
            saveList.forEach(e->{
                if(null!=e.getSaleType()&&1==e.getSaleType()){
                    saveAllList.add(getSumSaleReport(e,mnyMap)) ;
                }
            });

            if(org.apache.commons.collections.CollectionUtils.isNotEmpty(saveAllList)){
                super.saveBatch(saveAllList);
            }

            resList.addAll(BeanMapper.mapList(saveAllList,SaleReportTreeVO.class));


            logger.info("结束---------"+JSONObject.toJSONString(TreeNodeBUtil.buildTree(resList)));
    }

    public List<PoolEntity> changeSale(List<SaleContractEntity> saleContractEntityList){
        List<PoolEntity> resList = new ArrayList<>();
        saleContractEntityList.forEach(e->{
            PoolEntity poolEntity = new PoolEntity();
            poolEntity.setId(e.getId());
            poolEntity.setContractId(e.getContractId());
            poolEntity.setContractCode(e.getContractCode());
            poolEntity.setContractName(e.getContractName());
            poolEntity.setProjectId(e.getProjectId());
            poolEntity.setProjectCode(e.getProjectCode());
            poolEntity.setProjectName(e.getProjectName());
            poolEntity.setOrgId(e.getOrgId());
            poolEntity.setOrgCode(e.getOrgCode());
            poolEntity.setOrgName(e.getOrgName());
            poolEntity.setCustomerId(e.getCustomerId());
            poolEntity.setCustomerName(e.getCustomerName());
            poolEntity.setSaleId(e.getSaleId());
            poolEntity.setSaleName(e.getSaleName());
            poolEntity.setSourceType(1);
            poolEntity.setSourceId(e.getId());
            poolEntity.setSourceBillCode(e.getBillCode());
            poolEntity.setSourceDate(e.getRegisterDate());
            DateFormat format1 = new SimpleDateFormat("yyyy-MM");
            try {
                poolEntity.setSourceMonth(format1.format(e.getRegisterDate()));
            }catch (Exception exc){
                logger.error("日期转换异常: ", exc);
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
            poolEntity.setSourceYear(simpleDateFormat.format(e.getRegisterDate()));
            poolEntity.setMny(e.getRegisterMny());
            poolEntity.setTaxMny(e.getRegisterMny());
            resList.add(poolEntity);
        });
        return resList;
    }

    //根据合同+月份 取最近一次的调整比例信息
    public List<GradeAdjustDetailEntity> getAdjustDetail(Long contractId,String sourceMonth,Map<Long,List<GradeAdjustEntity>> adjustMap,Map<Long,List<GradeAdjustDetailEntity>> adjustDetailMap){
        List<GradeAdjustEntity> adjustList = new ArrayList<>();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
        List<GradeAdjustEntity> list = adjustMap.get(contractId);
        list.forEach(e->{
            Date monthDate = null;
            try {
                monthDate =formatter.parse(sourceMonth);
            } catch (Exception exc) {
                exc.printStackTrace();
            }
            if(!e.getInitiationMonth().after(monthDate)){
                //取到当前日期之前的 成绩调整单
                adjustList.add(e);
            }
        });
        //取adjustList  根据日期排序，取最新一期
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(adjustList)){
            Collections.sort(adjustList,Comparator.comparing(GradeAdjustEntity::getInitiationMonth,(t1,t2)->t2.compareTo(t1)));
            return adjustDetailMap.get(adjustList.get(0).getId());
        }
        return null;
    }

    public List<SaleReportEntity> changeSaleReport(List<TaskDetailEntity> taskDetailList,Map<Long,TaskEntity> taskMap){

        List<SaleReportEntity> resList = new ArrayList<>();
        Collection<TaskEntity> collections =  taskMap.values();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
        for (TaskEntity e: collections){
            SaleReportEntity saleReportEntity = new SaleReportEntity();
            saleReportEntity.setYear(simpleDateFormat.format(e.getTaskYear()));
            saleReportEntity.setOrgId(e.getOrgId());
            saleReportEntity.setOrgName(e.getOrgName());
            saleReportEntity.setOrgCode(e.getOrgCode());
            saleReportEntity.setTeamOrgId(e.getOrgId());//所属区域
            saleReportEntity.setId(e.getId());
            saleReportEntity.setParentId(999L);
            saleReportEntity.setSaleType(1);//大区
            resList.add(saleReportEntity);
        }

        taskDetailList.forEach(e->{
            SaleReportEntity saleReportEntity = new SaleReportEntity();
            TaskEntity taskEntity = taskMap.get(e.getPid());
            saleReportEntity.setYear(simpleDateFormat.format(taskEntity.getTaskYear()));
            saleReportEntity.setOrgId(e.getDetailOrgId());
            saleReportEntity.setOrgName(e.getDetailOrgName());
            saleReportEntity.setOrgCode(e.getDetailOrgCode());
            saleReportEntity.setTeamOrgId(e.getDetailBelongOrgId());//所属区域
            saleReportEntity.setEmployeeId(e.getSalesmanId());
            saleReportEntity.setEmployeeName(e.getSalesmanName());
            saleReportEntity.setId(e.getId());
            if(null==e.getDetailBelongOrgId()){
                //说明改组数据 是一级  且 选了人+ 区域
                saleReportEntity.setParentId(taskEntity.getId());
                saleReportEntity.setSaleType(2);//小组
            }else if(null==e.getParentId()&&null==e.getDetailOrgId()){
                //说明是该组数据 是一级  但是只选了人员
                saleReportEntity.setParentId(taskEntity.getId());
            }else{
                saleReportEntity.setParentId(e.getParentId());
            }
            saleReportEntity.setSaleYearTaskMny(e.getTotalQuarterSaleTaskMny());// 销售_全年任务
            saleReportEntity.setSaleFirstTaskMny(e.getQuarterOneSaleTaskMny());// 销售_第一季度(任务)
            saleReportEntity.setSaleSecondTaskMny(e.getQuarterTwoSaleTaskMny());        // 销售_第二季度(任务)
            saleReportEntity.setSaleThirdTaskMny(e.getQuarterThreeSaleTaskMny());       // 销售_第三季度(任务)
            saleReportEntity.setSaleFourthTaskMny(e.getQuarterFourSaleTaskMny());  // 销售_第四季度(任务)

            saleReportEntity.setKpYearTaskMny(e.getTotalQuarterInvoiceTaskMny());// 开票_全年任务
            saleReportEntity.setKpFirstTaskMny(e.getQuarterOneInvoiceTaskMny());// 开票_第一季度(任务)
            saleReportEntity.setKpSecondTaskMny(e.getQuarterTwoInvoiceTaskMny());        // 开票_第二季度(任务)
            saleReportEntity.setKpThirdTaskMny(e.getQuarterThreeInvoiceTaskMny());       // 开票_第三季度(任务)
            saleReportEntity.setKpFourthTaskMny(e.getQuarterFourInvoiceTaskMny());  // 开票_第四季度(任务)

            saleReportEntity.setSkYearTaskMny(e.getTotalQuarterIncomeTaskMny());// 收款_全年任务
            saleReportEntity.setSkFirstTaskMny(e.getQuarterOneIncomeTaskMny());// 收款_第一季度(任务)
            saleReportEntity.setSkSecondTaskMny(e.getQuarterTwoIncomeTaskMny());        // 收款_第二季度(任务)
            saleReportEntity.setSkThirdTaskMny(e.getQuarterThreeIncomeTaskMny());       // 收款_第三季度(任务)
            saleReportEntity.setSkFourthTaskMny(e.getQuarterFourIncomeTaskMny());  // 收款_第四季度(任务)

            resList.add(saleReportEntity);
        });
        return resList;
    }

    public SaleReportEntity getSaleReport(SaleReportEntity entity,SaleReportVO saleReportVO){
        SaleReportEntity saleReportEntity = BeanMapper.map(entity,SaleReportEntity.class);
        saleReportEntity.setSaleFirstOneMny(saleReportVO.getSaleFirstOneMny());
        saleReportEntity.setKpFirstOneMny(saleReportVO.getKpFirstOneMny());
        saleReportEntity.setSkFirstOneMny(saleReportVO.getSkFirstOneMny());
        saleReportEntity.setSaleFirstTwoMny(saleReportVO.getSaleFirstTwoMny());
        saleReportEntity.setKpFirstTwoMny(saleReportVO.getKpFirstTwoMny());
        saleReportEntity.setSkFirstTwoMny(saleReportVO.getSkFirstTwoMny());
        saleReportEntity.setSaleFirstThreeMny(saleReportVO.getSaleFirstThreeMny());
        saleReportEntity.setKpFirstThreeMny(saleReportVO.getKpFirstThreeMny());
        saleReportEntity.setSkFirstThreeMny(saleReportVO.getSkFirstThreeMny());
        saleReportEntity.setSaleSecondFourMny(saleReportVO.getSaleSecondFourMny());
        saleReportEntity.setKpSecondFourMny(saleReportVO.getKpSecondFourMny());
        saleReportEntity.setSkSecondFourMny(saleReportVO.getSkSecondFourMny());
        saleReportEntity.setSaleSecondFiveMny(saleReportVO.getSaleSecondFiveMny());
        saleReportEntity.setKpSecondFiveMny(saleReportVO.getKpSecondFiveMny());
        saleReportEntity.setSkSecondFiveMny(saleReportVO.getSkSecondFiveMny());
        saleReportEntity.setSaleSecondSixMny(saleReportVO.getSaleSecondSixMny());
        saleReportEntity.setKpSecondSixMny(saleReportVO.getKpSecondSixMny());
        saleReportEntity.setSkSecondSixMny(saleReportVO.getSkSecondSixMny());
        saleReportEntity.setSaleThirdSevenMny(saleReportVO.getSaleThirdSevenMny());
        saleReportEntity.setKpThirdSevenMny(saleReportVO.getKpThirdSevenMny());
        saleReportEntity.setSkThirdSevenMny(saleReportVO.getSkThirdSevenMny());
        saleReportEntity.setSaleThirdEightMny(saleReportVO.getSaleThirdEightMny());
        saleReportEntity.setKpThirdEightMny(saleReportVO.getKpThirdEightMny());
        saleReportEntity.setSkThirdEightMny(saleReportVO.getSkThirdEightMny());
        saleReportEntity.setSaleThirdNineMny(saleReportVO.getSaleThirdNineMny());
        saleReportEntity.setKpThirdNineMny(saleReportVO.getKpThirdNineMny());
        saleReportEntity.setSkThirdNineMny(saleReportVO.getSkThirdNineMny());
        saleReportEntity.setSaleFourthTenMny(saleReportVO.getSaleFourthTenMny());
        saleReportEntity.setKpFourthTenMny(saleReportVO.getKpFourthTenMny());
        saleReportEntity.setSkFourthTenMny(saleReportVO.getSkFourthTenMny());
        saleReportEntity.setSaleFourthElevenMny(saleReportVO.getSaleFourthElevenMny());
        saleReportEntity.setKpFourthElevenMny(saleReportVO.getKpFourthElevenMny());
        saleReportEntity.setSkFourthElevenMny(saleReportVO.getSkFourthElevenMny());
        saleReportEntity.setSaleFourthTwelveMny(saleReportVO.getSaleFourthTwelveMny());
        saleReportEntity.setKpFourthTwelveMny(saleReportVO.getKpFourthTwelveMny());
        saleReportEntity.setSkFourthTwelveMny(saleReportVO.getSkFourthTwelveMny());


        //计算销售 一 二 三 四 季度业绩合计
        BigDecimal saleFirstMny = ComputeUtil.safeAdd(saleReportEntity.getSaleFirstOneMny(),saleReportEntity.getSaleFirstTwoMny(),saleReportEntity.getSaleFirstThreeMny());
        saleReportEntity.setSaleFirstMny(saleFirstMny);
        // 销售_一季度完成差距  本季度完成-季度任务
        BigDecimal saleFirstDisparityMny = ComputeUtil.safeSub(saleFirstMny,saleReportEntity.getSaleFirstTaskMny());
        saleReportEntity.setSaleFirstDisparityMny(saleFirstDisparityMny);
        // 销售_一季度完成差距比
        BigDecimal saleFirstScale = ComputeUtil.safeDiv(saleFirstMny,saleReportEntity.getSaleFirstTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSaleFirstScale(saleFirstScale);



        BigDecimal saleSecondMny = ComputeUtil.safeAdd(saleReportEntity.getSaleSecondFourMny(),saleReportEntity.getSaleSecondFiveMny(),saleReportEntity.getSaleSecondSixMny());
        saleReportEntity.setSaleSecondMny(saleSecondMny);

        // 销售_二季度完成差距  本季度完成-季度任务
        BigDecimal saleSecondDisparityMny = ComputeUtil.safeSub(saleSecondMny,saleReportEntity.getSaleSecondTaskMny());
        saleReportEntity.setSaleSecondDisparityMny(saleSecondDisparityMny);
        // 销售_二季度完成差距比
        BigDecimal saleSecondScale = ComputeUtil.safeDiv(saleSecondMny,saleReportEntity.getSaleSecondTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSaleSecondScale(saleSecondScale);


        BigDecimal saleThirdMny = ComputeUtil.safeAdd(saleReportEntity.getSaleThirdSevenMny(),saleReportEntity.getSaleThirdEightMny(),saleReportEntity.getSaleThirdNineMny());
        saleReportEntity.setSaleThirdMny(saleThirdMny);

        // 销售_三季度完成差距  本季度完成-季度任务
        BigDecimal saleThirdDisparityMny = ComputeUtil.safeSub(saleThirdMny,saleReportEntity.getSaleThirdTaskMny());
        saleReportEntity.setSaleThirdDisparityMny(saleThirdDisparityMny);
        // 销售_三季度完成差距比
        BigDecimal saleThirdScale = ComputeUtil.safeDiv(saleThirdMny,saleReportEntity.getSaleThirdTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSaleThirdScale(saleThirdScale);


        BigDecimal saleFourthMny = ComputeUtil.safeAdd(saleReportEntity.getSaleFourthTenMny(),saleReportEntity.getSaleFourthElevenMny(),saleReportEntity.getSaleFourthTwelveMny());
        saleReportEntity.setSaleFourthMny(saleFourthMny);

        // 销售_四季度完成差距  本季度完成-季度任务
        BigDecimal saleFourthDisparityMny = ComputeUtil.safeSub(saleFourthMny,saleReportEntity.getSaleFourthTaskMny());
        saleReportEntity.setSaleFourthDisparityMny(saleFourthDisparityMny);
        // 销售_四季度完成差距比
        BigDecimal saleFourthScale = ComputeUtil.safeDiv(saleFourthMny,saleReportEntity.getSaleFourthTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSaleFourthScale(saleFourthScale);

        //年度
        BigDecimal saleYearMny = ComputeUtil.safeAdd(saleReportEntity.getSaleFirstMny(),saleReportEntity.getSaleSecondMny(),saleReportEntity.getSaleThirdMny(),saleReportEntity.getSaleFourthMny());
        saleReportEntity.setSaleYearMny(saleYearMny);

        BigDecimal saleYearDisparityMny = ComputeUtil.safeSub(saleYearMny,saleReportEntity.getSaleYearTaskMny());; // 本年完成差距
        saleReportEntity.setSaleYearDisparityMny(saleYearDisparityMny);

        BigDecimal saleYearScale = ComputeUtil.safeDiv(saleYearMny,saleReportEntity.getSaleYearTaskMny()).multiply(new BigDecimal(100));; // 本年完成差距比
        saleReportEntity.setSaleYearScale(saleYearScale);


        //todo 计算开票 一 二 三 四 季度业绩合计
        BigDecimal KpFirstMny = ComputeUtil.safeAdd(saleReportEntity.getKpFirstOneMny(),saleReportEntity.getKpFirstTwoMny(),saleReportEntity.getKpFirstThreeMny());
        saleReportEntity.setKpFirstMny(KpFirstMny);
        // _一季度完成差距  本季度完成-季度任务
        BigDecimal KpFirstDisparityMny = ComputeUtil.safeSub(saleFirstMny,saleReportEntity.getKpFirstTaskMny());
        saleReportEntity.setKpFirstDisparityMny(KpFirstDisparityMny);
        // _一季度完成差距比
        BigDecimal KpFirstScale = ComputeUtil.safeDiv(saleFirstMny,saleReportEntity.getKpFirstTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setKpFirstScale(KpFirstScale);



        BigDecimal KpSecondMny = ComputeUtil.safeAdd(saleReportEntity.getKpSecondFourMny(),saleReportEntity.getKpSecondFiveMny(),saleReportEntity.getKpSecondSixMny());
        saleReportEntity.setKpSecondMny(KpSecondMny);

        // _二季度完成差距  本季度完成-季度任务
        BigDecimal KpSecondDisparityMny = ComputeUtil.safeSub(KpSecondMny,saleReportEntity.getKpSecondTaskMny());
        saleReportEntity.setKpSecondDisparityMny(KpSecondDisparityMny);
        // _二季度完成差距比
        BigDecimal KpSecondScale = ComputeUtil.safeDiv(KpSecondMny,saleReportEntity.getKpSecondTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setKpSecondScale(KpSecondScale);


        BigDecimal KpThirdMny = ComputeUtil.safeAdd(saleReportEntity.getKpThirdSevenMny(),saleReportEntity.getKpThirdEightMny(),saleReportEntity.getKpThirdNineMny());
        saleReportEntity.setKpThirdMny(KpThirdMny);

        // _三季度完成差距  本季度完成-季度任务
        BigDecimal KpThirdDisparityMny = ComputeUtil.safeSub(KpThirdMny,saleReportEntity.getKpThirdTaskMny());
        saleReportEntity.setKpThirdDisparityMny(KpThirdDisparityMny);
        // _三季度完成差距比
        BigDecimal KpThirdScale = ComputeUtil.safeDiv(KpThirdMny,saleReportEntity.getKpThirdTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setKpThirdScale(KpThirdScale);


        BigDecimal KpFourthMny = ComputeUtil.safeAdd(saleReportEntity.getKpFourthTenMny(),saleReportEntity.getKpFourthElevenMny(),saleReportEntity.getKpFourthTwelveMny());
        saleReportEntity.setKpFourthMny(KpFourthMny);

        // _四季度完成差距  本季度完成-季度任务
        BigDecimal KpFourthDisparityMny = ComputeUtil.safeSub(KpFourthMny,saleReportEntity.getKpFourthTaskMny());
        saleReportEntity.setKpFourthDisparityMny(KpFourthDisparityMny);
        // _四季度完成差距比
        BigDecimal KpFourthScale = ComputeUtil.safeDiv(KpFourthMny,saleReportEntity.getKpFourthTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setKpFourthScale(KpFourthScale);

        //年度
        BigDecimal KpYearMny = ComputeUtil.safeAdd(saleReportEntity.getKpFirstMny(),saleReportEntity.getKpSecondMny(),saleReportEntity.getKpThirdMny(),saleReportEntity.getKpFourthMny());
        saleReportEntity.setKpYearMny(KpYearMny);

        BigDecimal KpYearDisparityMny = ComputeUtil.safeSub(KpYearMny,saleReportEntity.getKpYearTaskMny());; // 本年完成差距
        saleReportEntity.setKpYearDisparityMny(KpYearDisparityMny);

        BigDecimal KpYearScale = ComputeUtil.safeDiv(KpYearMny,saleReportEntity.getKpYearTaskMny()).multiply(new BigDecimal(100));; // 本年完成差距比
        saleReportEntity.setKpYearScale(KpYearScale);


        //todo 计算收款 一 二 三 四 季度业绩合计
        BigDecimal SkFirstMny = ComputeUtil.safeAdd(saleReportEntity.getSkFirstOneMny(),saleReportEntity.getSkFirstTwoMny(),saleReportEntity.getSkFirstThreeMny());
        saleReportEntity.setSkFirstMny(SkFirstMny);
        // _一季度完成差距  本季度完成-季度任务
        BigDecimal SkFirstDisparityMny = ComputeUtil.safeSub(saleFirstMny,saleReportEntity.getSkFirstTaskMny());
        saleReportEntity.setSkFirstDisparityMny(SkFirstDisparityMny);
        // _一季度完成差距比
        BigDecimal SkFirstScale = ComputeUtil.safeDiv(saleFirstMny,saleReportEntity.getSkFirstTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSkFirstScale(SkFirstScale);



        BigDecimal SkSecondMny = ComputeUtil.safeAdd(saleReportEntity.getSkSecondFourMny(),saleReportEntity.getSkSecondFiveMny(),saleReportEntity.getSkSecondSixMny());
        saleReportEntity.setSkSecondMny(SkSecondMny);

        // _二季度完成差距  本季度完成-季度任务
        BigDecimal SkSecondDisparityMny = ComputeUtil.safeSub(SkSecondMny,saleReportEntity.getSkSecondTaskMny());
        saleReportEntity.setSkSecondDisparityMny(SkSecondDisparityMny);
        // _二季度完成差距比
        BigDecimal SkSecondScale = ComputeUtil.safeDiv(SkSecondMny,saleReportEntity.getSkSecondTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSkSecondScale(SkSecondScale);


        BigDecimal SkThirdMny = ComputeUtil.safeAdd(saleReportEntity.getSkThirdSevenMny(),saleReportEntity.getSkThirdEightMny(),saleReportEntity.getSkThirdNineMny());
        saleReportEntity.setSkThirdMny(SkThirdMny);

        // _三季度完成差距  本季度完成-季度任务
        BigDecimal SkThirdDisparityMny = ComputeUtil.safeSub(SkThirdMny,saleReportEntity.getSkThirdTaskMny());
        saleReportEntity.setSkThirdDisparityMny(SkThirdDisparityMny);
        // _三季度完成差距比
        BigDecimal SkThirdScale = ComputeUtil.safeDiv(SkThirdMny,saleReportEntity.getSkThirdTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSkThirdScale(SkThirdScale);


        BigDecimal SkFourthMny = ComputeUtil.safeAdd(saleReportEntity.getSkFourthTenMny(),saleReportEntity.getSkFourthElevenMny(),saleReportEntity.getSkFourthTwelveMny());
        saleReportEntity.setSkFourthMny(SkFourthMny);

        // _四季度完成差距  本季度完成-季度任务
        BigDecimal SkFourthDisparityMny = ComputeUtil.safeSub(SkFourthMny,saleReportEntity.getSkFourthTaskMny());
        saleReportEntity.setSkFourthDisparityMny(SkFourthDisparityMny);
        // _四季度完成差距比
        BigDecimal SkFourthScale = ComputeUtil.safeDiv(SkFourthMny,saleReportEntity.getSkFourthTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSkFourthScale(SkFourthScale);


        //年度
        BigDecimal SkYearMny = ComputeUtil.safeAdd(saleReportEntity.getSkFirstMny(),saleReportEntity.getSkSecondMny(),saleReportEntity.getSkThirdMny(),saleReportEntity.getSkFourthMny());
        saleReportEntity.setSkYearMny(SkYearMny);

        BigDecimal SkYearDisparityMny = ComputeUtil.safeSub(SkYearMny,saleReportEntity.getSkYearTaskMny());; // 本年完成差距
        saleReportEntity.setSkYearDisparityMny(SkYearDisparityMny);

        BigDecimal SkYearScale = ComputeUtil.safeDiv(SkYearMny,saleReportEntity.getSkYearTaskMny()).multiply(new BigDecimal(100));; // 本年完成差距比
        saleReportEntity.setSkYearScale(SkYearScale);


        return saleReportEntity;
    }


    public SaleReportEntity getSumSaleReport(SaleReportEntity saleReportEntity,Map<Long,List<SaleReportEntity>> mnyMap){
        List<SaleReportEntity> list = mnyMap.get(saleReportEntity.getId());
        BigDecimal saleFirstOneMny = BigDecimal.ZERO; // 销售_一月份完成
        BigDecimal saleFirstTwoMny =BigDecimal.ZERO; // 销售_二月份完成
        BigDecimal saleFirstThreeMny =BigDecimal.ZERO; // 销售_三月份完成
        BigDecimal saleSecondFourMny= BigDecimal.ZERO; // 销售_四月份完成
        BigDecimal saleSecondFiveMny= BigDecimal.ZERO; // 销售_五月份完成
        BigDecimal saleSecondSixMny= BigDecimal.ZERO; // 销售_六月份完成
        BigDecimal saleThirdSevenMny= BigDecimal.ZERO; // 销售_七月份完成
        BigDecimal saleThirdEightMny= BigDecimal.ZERO; // 销售_八月份完成
        BigDecimal saleThirdNineMny= BigDecimal.ZERO; // 销售_九月份完成
        BigDecimal saleFourthTenMny= BigDecimal.ZERO; // 销售_十月份完成
        BigDecimal saleFourthElevenMny= BigDecimal.ZERO; // 销售_十一月份完成
        BigDecimal saleFourthTwelveMny= BigDecimal.ZERO; // 销售_十二月份完成
        BigDecimal kpFirstOneMny= BigDecimal.ZERO; // 开票_一月份完成
        BigDecimal kpFirstTwoMny= BigDecimal.ZERO; // 开票_二月份完成
        BigDecimal kpFirstThreeMny= BigDecimal.ZERO; // 开票_三月份完成
        BigDecimal kpSecondFourMny= BigDecimal.ZERO; // 开票_四月份完成
        BigDecimal kpSecondFiveMny= BigDecimal.ZERO; // 开票_五月份完成
        BigDecimal kpSecondSixMny= BigDecimal.ZERO; // 开票_六月份完成
        BigDecimal kpThirdSevenMny= BigDecimal.ZERO; // 开票_七月份完成
        BigDecimal kpThirdEightMny= BigDecimal.ZERO; // 开票_八月份完成
        BigDecimal kpThirdNineMny= BigDecimal.ZERO; // 开票_九月份完成
        BigDecimal kpFourthTenMny= BigDecimal.ZERO; // 开票_十月份完成
        BigDecimal kpFourthElevenMny= BigDecimal.ZERO; // 开票_十一月份完成
        BigDecimal kpFourthTwelveMny= BigDecimal.ZERO; // 开票_十二月份完成
        BigDecimal skFirstOneMny= BigDecimal.ZERO; // 收款_一月份完成
        BigDecimal skFirstTwoMny= BigDecimal.ZERO; // 收款_二月份完成
        BigDecimal skFirstThreeMny= BigDecimal.ZERO; // 收款_三月份完成
        BigDecimal skSecondFourMny= BigDecimal.ZERO; // 收款_四月份完成
        BigDecimal skSecondFiveMny= BigDecimal.ZERO; // 收款_五月份完成
        BigDecimal skSecondSixMny= BigDecimal.ZERO; // 收款_六月份完成
        BigDecimal skThirdSevenMny= BigDecimal.ZERO; // 收款_七月份完成
        BigDecimal skThirdEightMny= BigDecimal.ZERO; // 收款_八月份完成
        BigDecimal skThirdNineMny= BigDecimal.ZERO; // 收款_九月份完成
        BigDecimal skFourthTenMny= BigDecimal.ZERO; // 收款_十月份完成
        BigDecimal skFourthElevenMny= BigDecimal.ZERO; // 收款_十一月份完成
        BigDecimal skFourthTwelveMny= BigDecimal.ZERO; // 收款_十二月份完成

        BigDecimal saleYearTaskMny= BigDecimal.ZERO; //销售_全年任务
        BigDecimal saleFirstTaskMny= BigDecimal.ZERO; //销售_第一季度(任务)
        BigDecimal saleSecondTaskMny= BigDecimal.ZERO; //销售_第二季度(任务)
        BigDecimal saleThirdTaskMny= BigDecimal.ZERO; //销售_第三季度(任务)
        BigDecimal saleFourthTaskMny= BigDecimal.ZERO; //销售_第四季度(任务)

        BigDecimal kpYearTaskMny= BigDecimal.ZERO; //销售_全年任务
        BigDecimal kpFirstTaskMny= BigDecimal.ZERO; //销售_第一季度(任务)
        BigDecimal kpSecondTaskMny= BigDecimal.ZERO; //销售_第二季度(任务)
        BigDecimal kpThirdTaskMny= BigDecimal.ZERO; //销售_第三季度(任务)
        BigDecimal kpFourthTaskMny= BigDecimal.ZERO; //销售_第四季度(任务)

        BigDecimal skYearTaskMny= BigDecimal.ZERO; //销售_全年任务
        BigDecimal skFirstTaskMny= BigDecimal.ZERO; //销售_第一季度(任务)
        BigDecimal skSecondTaskMny= BigDecimal.ZERO; //销售_第二季度(任务)
        BigDecimal skThirdTaskMny= BigDecimal.ZERO; //销售_第三季度(任务)
        BigDecimal skFourthTaskMny= BigDecimal.ZERO; //销售_第四季度(任务)


        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(list)){
            for(SaleReportEntity e:list){
                saleFirstOneMny = ComputeUtil.safeAdd(saleFirstOneMny,e.getSaleFirstOneMny());
                saleFirstTwoMny = ComputeUtil.safeAdd(saleFirstTwoMny,e.getSaleFirstTwoMny());
                saleFirstThreeMny = ComputeUtil.safeAdd(saleFirstThreeMny,e.getSaleFirstThreeMny());
                saleSecondFourMny = ComputeUtil.safeAdd(saleSecondFourMny,e.getSaleSecondFourMny());
                saleSecondFiveMny = ComputeUtil.safeAdd(saleSecondFiveMny,e.getSaleSecondFiveMny());
                saleSecondSixMny = ComputeUtil.safeAdd(saleSecondSixMny,e.getSaleSecondSixMny());
                saleThirdSevenMny = ComputeUtil.safeAdd(saleThirdSevenMny,e.getSaleThirdSevenMny());
                saleThirdEightMny = ComputeUtil.safeAdd(saleThirdEightMny,e.getSaleThirdEightMny());
                saleThirdNineMny = ComputeUtil.safeAdd(saleThirdNineMny,e.getSaleThirdNineMny());
                saleFourthTenMny = ComputeUtil.safeAdd(saleFourthTenMny,e.getSaleFourthTenMny());
                saleFourthElevenMny = ComputeUtil.safeAdd(saleFourthElevenMny,e.getSaleFourthElevenMny());
                saleFourthTwelveMny = ComputeUtil.safeAdd(saleFourthTwelveMny,e.getSaleFourthTwelveMny());
                kpFirstOneMny = ComputeUtil.safeAdd(kpFirstOneMny,e.getKpFirstOneMny());
                kpFirstTwoMny = ComputeUtil.safeAdd(kpFirstTwoMny,e.getKpFirstTwoMny());
                kpFirstThreeMny = ComputeUtil.safeAdd(kpFirstThreeMny,e.getKpFirstThreeMny());
                kpSecondFourMny = ComputeUtil.safeAdd(kpSecondFourMny,e.getKpSecondFourMny());
                kpSecondFiveMny = ComputeUtil.safeAdd(kpSecondFiveMny,e.getKpSecondFiveMny());
                kpSecondSixMny = ComputeUtil.safeAdd(kpSecondSixMny,e.getKpSecondSixMny());
                kpThirdSevenMny = ComputeUtil.safeAdd(kpThirdSevenMny,e.getKpThirdSevenMny());
                kpThirdEightMny = ComputeUtil.safeAdd(kpThirdEightMny,e.getKpThirdEightMny());
                kpThirdNineMny = ComputeUtil.safeAdd(kpThirdNineMny,e.getKpThirdNineMny());
                kpFourthTenMny = ComputeUtil.safeAdd(kpFourthTenMny,e.getKpFourthTenMny());
                kpFourthElevenMny = ComputeUtil.safeAdd(kpFourthElevenMny,e.getKpFourthElevenMny());
                kpFourthTwelveMny = ComputeUtil.safeAdd(kpFourthTwelveMny,e.getKpFourthTwelveMny());
                skFirstOneMny = ComputeUtil.safeAdd(skFirstOneMny,e.getSkFirstOneMny());
                skFirstTwoMny = ComputeUtil.safeAdd(skFirstTwoMny,e.getSkFirstTwoMny());
                skFirstThreeMny = ComputeUtil.safeAdd(skFirstThreeMny,e.getSkFirstThreeMny());
                skSecondFourMny = ComputeUtil.safeAdd(skSecondFourMny,e.getSkSecondFourMny());
                skSecondFiveMny = ComputeUtil.safeAdd(skSecondFiveMny,e.getSkSecondFiveMny());
                skSecondSixMny = ComputeUtil.safeAdd(skSecondSixMny,e.getSkSecondSixMny());
                skThirdSevenMny = ComputeUtil.safeAdd(skThirdSevenMny,e.getSkThirdSevenMny());
                skThirdEightMny = ComputeUtil.safeAdd(skThirdEightMny,e.getSkThirdEightMny());
                skThirdNineMny = ComputeUtil.safeAdd(skThirdNineMny,e.getSkThirdNineMny());
                skFourthTenMny = ComputeUtil.safeAdd(skFourthTenMny,e.getSkFourthTenMny());
                skFourthElevenMny = ComputeUtil.safeAdd(skFourthElevenMny,e.getSkFourthElevenMny());
                skFourthTwelveMny = ComputeUtil.safeAdd(skFourthTwelveMny,e.getSkFourthTwelveMny());
                if(null!=saleReportEntity.getSaleType()&&1==saleReportEntity.getSaleType()){
                    //区域汇总时，需要汇总任务下达

                    saleYearTaskMny = ComputeUtil.safeAdd(saleYearTaskMny,e.getSaleYearTaskMny());
                    saleFirstTaskMny = ComputeUtil.safeAdd(saleFirstTaskMny,e.getSaleFirstTaskMny());
                    saleSecondTaskMny = ComputeUtil.safeAdd(saleSecondTaskMny,e.getSaleSecondTaskMny());
                    saleThirdTaskMny = ComputeUtil.safeAdd(saleThirdTaskMny,e.getSaleThirdTaskMny());
                    saleFourthTaskMny = ComputeUtil.safeAdd(saleFourthTaskMny,e.getSaleFourthTaskMny());

                    kpYearTaskMny = ComputeUtil.safeAdd(kpYearTaskMny,e.getKpYearTaskMny());
                    kpFirstTaskMny = ComputeUtil.safeAdd(kpFirstTaskMny,e.getKpFirstTaskMny());
                    kpSecondTaskMny = ComputeUtil.safeAdd(kpSecondTaskMny,e.getKpSecondTaskMny());
                    kpThirdTaskMny = ComputeUtil.safeAdd(kpThirdTaskMny,e.getKpThirdTaskMny());
                    kpFourthTaskMny = ComputeUtil.safeAdd(kpFourthTaskMny,e.getKpFourthTaskMny());

                    skYearTaskMny = ComputeUtil.safeAdd(skYearTaskMny,e.getSkYearTaskMny());
                    skFirstTaskMny = ComputeUtil.safeAdd(skFirstTaskMny,e.getSkFirstTaskMny());
                    skSecondTaskMny = ComputeUtil.safeAdd(skSecondTaskMny,e.getSkSecondTaskMny());
                    skThirdTaskMny = ComputeUtil.safeAdd(skThirdTaskMny,e.getSkThirdTaskMny());
                    skFourthTaskMny = ComputeUtil.safeAdd(skFourthTaskMny,e.getSkFourthTaskMny());
                }
            }
        }
        saleReportEntity.setSaleFirstOneMny(saleFirstOneMny);
        saleReportEntity.setKpFirstOneMny(kpFirstOneMny);
        saleReportEntity.setSkFirstOneMny(skFirstOneMny);
        saleReportEntity.setSaleFirstTwoMny(saleFirstTwoMny);
        saleReportEntity.setKpFirstTwoMny(kpFirstTwoMny);
        saleReportEntity.setSkFirstTwoMny(skFirstTwoMny);
        saleReportEntity.setSaleFirstThreeMny(saleFirstThreeMny);
        saleReportEntity.setKpFirstThreeMny(kpFirstThreeMny);
        saleReportEntity.setSkFirstThreeMny(skFirstThreeMny);
        saleReportEntity.setSaleSecondFourMny(saleSecondFourMny);
        saleReportEntity.setKpSecondFourMny(kpSecondFourMny);
        saleReportEntity.setSkSecondFourMny(skSecondFourMny);
        saleReportEntity.setSaleSecondFiveMny(saleSecondFiveMny);
        saleReportEntity.setKpSecondFiveMny(kpSecondFiveMny);
        saleReportEntity.setSkSecondFiveMny(skSecondFiveMny);
        saleReportEntity.setSaleSecondSixMny(saleSecondSixMny);
        saleReportEntity.setKpSecondSixMny(kpSecondSixMny);
        saleReportEntity.setSkSecondSixMny(skSecondSixMny);
        saleReportEntity.setSaleThirdSevenMny(saleThirdSevenMny);
        saleReportEntity.setKpThirdSevenMny(kpThirdSevenMny);
        saleReportEntity.setSkThirdSevenMny(skThirdSevenMny);
        saleReportEntity.setSaleThirdEightMny(saleThirdEightMny);
        saleReportEntity.setKpThirdEightMny(kpThirdEightMny);
        saleReportEntity.setSkThirdEightMny(skThirdEightMny);
        saleReportEntity.setSaleThirdNineMny(saleThirdNineMny);
        saleReportEntity.setKpThirdNineMny(kpThirdNineMny);
        saleReportEntity.setSkThirdNineMny(skThirdNineMny);
        saleReportEntity.setSaleFourthTenMny(saleFourthTenMny);
        saleReportEntity.setKpFourthTenMny(kpFourthTenMny);
        saleReportEntity.setSkFourthTenMny(skFourthTenMny);
        saleReportEntity.setSaleFourthElevenMny(saleFourthElevenMny);
        saleReportEntity.setKpFourthElevenMny(kpFourthElevenMny);
        saleReportEntity.setSkFourthElevenMny(skFourthElevenMny);
        saleReportEntity.setSaleFourthTwelveMny(saleFourthTwelveMny);
        saleReportEntity.setKpFourthTwelveMny(kpFourthTwelveMny);
        saleReportEntity.setSkFourthTwelveMny(skFourthTwelveMny);
        if(null!=saleReportEntity.getSaleType()&&1==saleReportEntity.getSaleType()){
            saleReportEntity.setSaleYearTaskMny(saleYearTaskMny);
            saleReportEntity.setSaleFirstTaskMny(saleFirstTaskMny);
            saleReportEntity.setSaleSecondTaskMny(saleSecondTaskMny);
            saleReportEntity.setSaleThirdTaskMny(saleThirdTaskMny);
            saleReportEntity.setSaleFourthTaskMny(saleFourthTaskMny);

            saleReportEntity.setKpYearTaskMny(kpYearTaskMny);
            saleReportEntity.setKpFirstTaskMny(kpFirstTaskMny);
            saleReportEntity.setKpSecondTaskMny(kpSecondTaskMny);
            saleReportEntity.setKpThirdTaskMny(kpThirdTaskMny);
            saleReportEntity.setKpFourthTaskMny(kpFourthTaskMny);

            saleReportEntity.setSkYearTaskMny(skYearTaskMny);
            saleReportEntity.setSkFirstTaskMny(skFirstTaskMny);
            saleReportEntity.setSkSecondTaskMny(skSecondTaskMny);
            saleReportEntity.setSkThirdTaskMny(skThirdTaskMny);
            saleReportEntity.setSkFourthTaskMny(skFourthTaskMny);

        }


        //计算销售 一 二 三 四 季度业绩合计
        BigDecimal saleFirstMny = ComputeUtil.safeAdd(saleReportEntity.getSaleFirstOneMny(),saleReportEntity.getSaleFirstTwoMny(),saleReportEntity.getSaleFirstThreeMny());
        saleReportEntity.setSaleFirstMny(saleFirstMny);
        // 销售_一季度完成差距  本季度完成-季度任务
        BigDecimal saleFirstDisparityMny = ComputeUtil.safeSub(saleFirstMny,saleReportEntity.getSaleFirstTaskMny());
        saleReportEntity.setSaleFirstDisparityMny(saleFirstDisparityMny);
        // 销售_一季度完成差距比
        BigDecimal saleFirstScale = ComputeUtil.safeDiv(saleFirstMny,saleReportEntity.getSaleFirstTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSaleFirstScale(saleFirstScale);



        BigDecimal saleSecondMny = ComputeUtil.safeAdd(saleReportEntity.getSaleSecondFourMny(),saleReportEntity.getSaleSecondFiveMny(),saleReportEntity.getSaleSecondSixMny());
        saleReportEntity.setSaleSecondMny(saleSecondMny);

        // 销售_二季度完成差距  本季度完成-季度任务
        BigDecimal saleSecondDisparityMny = ComputeUtil.safeSub(saleSecondMny,saleReportEntity.getSaleSecondTaskMny());
        saleReportEntity.setSaleSecondDisparityMny(saleSecondDisparityMny);
        // 销售_二季度完成差距比
        BigDecimal saleSecondScale = ComputeUtil.safeDiv(saleSecondMny,saleReportEntity.getSaleSecondTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSaleSecondScale(saleSecondScale);


        BigDecimal saleThirdMny = ComputeUtil.safeAdd(saleReportEntity.getSaleThirdSevenMny(),saleReportEntity.getSaleThirdEightMny(),saleReportEntity.getSaleThirdNineMny());
        saleReportEntity.setSaleThirdMny(saleThirdMny);

        // 销售_三季度完成差距  本季度完成-季度任务
        BigDecimal saleThirdDisparityMny = ComputeUtil.safeSub(saleThirdMny,saleReportEntity.getSaleThirdTaskMny());
        saleReportEntity.setSaleThirdDisparityMny(saleThirdDisparityMny);
        // 销售_三季度完成差距比
        BigDecimal saleThirdScale = ComputeUtil.safeDiv(saleThirdMny,saleReportEntity.getSaleThirdTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSaleThirdScale(saleThirdScale);


        BigDecimal saleFourthMny = ComputeUtil.safeAdd(saleReportEntity.getSaleFourthTenMny(),saleReportEntity.getSaleFourthElevenMny(),saleReportEntity.getSaleFourthTwelveMny());
        saleReportEntity.setSaleFourthMny(saleFourthMny);

        // 销售_四季度完成差距  本季度完成-季度任务
        BigDecimal saleFourthDisparityMny = ComputeUtil.safeSub(saleFourthMny,saleReportEntity.getSaleFourthTaskMny());
        saleReportEntity.setSaleFourthDisparityMny(saleFourthDisparityMny);
        // 销售_四季度完成差距比
        BigDecimal saleFourthScale = ComputeUtil.safeDiv(saleFourthMny,saleReportEntity.getSaleFourthTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSaleFourthScale(saleFourthScale);

        //年度
        BigDecimal saleYearMny = ComputeUtil.safeAdd(saleReportEntity.getSaleFirstMny(),saleReportEntity.getSaleSecondMny(),saleReportEntity.getSaleThirdMny(),saleReportEntity.getSaleFourthMny());
        saleReportEntity.setSaleYearMny(saleYearMny);

        BigDecimal saleYearDisparityMny = ComputeUtil.safeSub(saleYearMny,saleReportEntity.getSaleYearTaskMny());; // 本年完成差距
        saleReportEntity.setSaleYearDisparityMny(saleYearDisparityMny);

        BigDecimal saleYearScale = ComputeUtil.safeDiv(saleYearMny,saleReportEntity.getSaleYearTaskMny()).multiply(new BigDecimal(100));; // 本年完成差距比
        saleReportEntity.setSaleYearScale(saleYearScale);


        //todo 计算开票 一 二 三 四 季度业绩合计
        BigDecimal KpFirstMny = ComputeUtil.safeAdd(saleReportEntity.getKpFirstOneMny(),saleReportEntity.getKpFirstTwoMny(),saleReportEntity.getKpFirstThreeMny());
        saleReportEntity.setKpFirstMny(KpFirstMny);
        // _一季度完成差距  本季度完成-季度任务
        BigDecimal KpFirstDisparityMny = ComputeUtil.safeSub(saleFirstMny,saleReportEntity.getKpFirstTaskMny());
        saleReportEntity.setKpFirstDisparityMny(KpFirstDisparityMny);
        // _一季度完成差距比
        BigDecimal KpFirstScale = ComputeUtil.safeDiv(saleFirstMny,saleReportEntity.getKpFirstTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setKpFirstScale(KpFirstScale);



        BigDecimal KpSecondMny = ComputeUtil.safeAdd(saleReportEntity.getKpSecondFourMny(),saleReportEntity.getKpSecondFiveMny(),saleReportEntity.getKpSecondSixMny());
        saleReportEntity.setKpSecondMny(KpSecondMny);

        // _二季度完成差距  本季度完成-季度任务
        BigDecimal KpSecondDisparityMny = ComputeUtil.safeSub(KpSecondMny,saleReportEntity.getKpSecondTaskMny());
        saleReportEntity.setKpSecondDisparityMny(KpSecondDisparityMny);
        // _二季度完成差距比
        BigDecimal KpSecondScale = ComputeUtil.safeDiv(KpSecondMny,saleReportEntity.getKpSecondTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setKpSecondScale(KpSecondScale);


        BigDecimal KpThirdMny = ComputeUtil.safeAdd(saleReportEntity.getKpThirdSevenMny(),saleReportEntity.getKpThirdEightMny(),saleReportEntity.getKpThirdNineMny());
        saleReportEntity.setKpThirdMny(KpThirdMny);

        // _三季度完成差距  本季度完成-季度任务
        BigDecimal KpThirdDisparityMny = ComputeUtil.safeSub(KpThirdMny,saleReportEntity.getKpThirdTaskMny());
        saleReportEntity.setKpThirdDisparityMny(KpThirdDisparityMny);
        // _三季度完成差距比
        BigDecimal KpThirdScale = ComputeUtil.safeDiv(KpThirdMny,saleReportEntity.getKpThirdTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setKpThirdScale(KpThirdScale);


        BigDecimal KpFourthMny = ComputeUtil.safeAdd(saleReportEntity.getKpFourthTenMny(),saleReportEntity.getKpFourthElevenMny(),saleReportEntity.getKpFourthTwelveMny());
        saleReportEntity.setKpFourthMny(KpFourthMny);

        // _四季度完成差距  本季度完成-季度任务
        BigDecimal KpFourthDisparityMny = ComputeUtil.safeSub(KpFourthMny,saleReportEntity.getKpFourthTaskMny());
        saleReportEntity.setKpFourthDisparityMny(KpFourthDisparityMny);
        // _四季度完成差距比
        BigDecimal KpFourthScale = ComputeUtil.safeDiv(KpFourthMny,saleReportEntity.getKpFourthTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setKpFourthScale(KpFourthScale);

        //年度
        BigDecimal KpYearMny = ComputeUtil.safeAdd(saleReportEntity.getKpFirstMny(),saleReportEntity.getKpSecondMny(),saleReportEntity.getKpThirdMny(),saleReportEntity.getKpFourthMny());
        saleReportEntity.setKpYearMny(KpYearMny);

        BigDecimal KpYearDisparityMny = ComputeUtil.safeSub(KpYearMny,saleReportEntity.getKpYearTaskMny());; // 本年完成差距
        saleReportEntity.setKpYearDisparityMny(KpYearDisparityMny);

        BigDecimal KpYearScale = ComputeUtil.safeDiv(KpYearMny,saleReportEntity.getKpYearTaskMny()).multiply(new BigDecimal(100));; // 本年完成差距比
        saleReportEntity.setKpYearScale(KpYearScale);


        //todo 计算收款 一 二 三 四 季度业绩合计
        BigDecimal SkFirstMny = ComputeUtil.safeAdd(saleReportEntity.getSkFirstOneMny(),saleReportEntity.getSkFirstTwoMny(),saleReportEntity.getSkFirstThreeMny());
        saleReportEntity.setSkFirstMny(SkFirstMny);
        // _一季度完成差距  本季度完成-季度任务
        BigDecimal SkFirstDisparityMny = ComputeUtil.safeSub(saleFirstMny,saleReportEntity.getSkFirstTaskMny());
        saleReportEntity.setSkFirstDisparityMny(SkFirstDisparityMny);
        // _一季度完成差距比
        BigDecimal SkFirstScale = ComputeUtil.safeDiv(saleFirstMny,saleReportEntity.getSkFirstTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSkFirstScale(SkFirstScale);



        BigDecimal SkSecondMny = ComputeUtil.safeAdd(saleReportEntity.getSkSecondFourMny(),saleReportEntity.getSkSecondFiveMny(),saleReportEntity.getSkSecondSixMny());
        saleReportEntity.setSkSecondMny(SkSecondMny);

        // _二季度完成差距  本季度完成-季度任务
        BigDecimal SkSecondDisparityMny = ComputeUtil.safeSub(SkSecondMny,saleReportEntity.getSkSecondTaskMny());
        saleReportEntity.setSkSecondDisparityMny(SkSecondDisparityMny);
        // _二季度完成差距比
        BigDecimal SkSecondScale = ComputeUtil.safeDiv(SkSecondMny,saleReportEntity.getSkSecondTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSkSecondScale(SkSecondScale);


        BigDecimal SkThirdMny = ComputeUtil.safeAdd(saleReportEntity.getSkThirdSevenMny(),saleReportEntity.getSkThirdEightMny(),saleReportEntity.getSkThirdNineMny());
        saleReportEntity.setSkThirdMny(SkThirdMny);

        // _三季度完成差距  本季度完成-季度任务
        BigDecimal SkThirdDisparityMny = ComputeUtil.safeSub(SkThirdMny,saleReportEntity.getSkThirdTaskMny());
        saleReportEntity.setSkThirdDisparityMny(SkThirdDisparityMny);
        // _三季度完成差距比
        BigDecimal SkThirdScale = ComputeUtil.safeDiv(SkThirdMny,saleReportEntity.getSkThirdTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSkThirdScale(SkThirdScale);


        BigDecimal SkFourthMny = ComputeUtil.safeAdd(saleReportEntity.getSkFourthTenMny(),saleReportEntity.getSkFourthElevenMny(),saleReportEntity.getSkFourthTwelveMny());
        saleReportEntity.setSkFourthMny(SkFourthMny);

        // _四季度完成差距  本季度完成-季度任务
        BigDecimal SkFourthDisparityMny = ComputeUtil.safeSub(SkFourthMny,saleReportEntity.getSkFourthTaskMny());
        saleReportEntity.setSkFourthDisparityMny(SkFourthDisparityMny);
        // _四季度完成差距比
        BigDecimal SkFourthScale = ComputeUtil.safeDiv(SkFourthMny,saleReportEntity.getSkFourthTaskMny()).multiply(new BigDecimal(100));
        saleReportEntity.setSkFourthScale(SkFourthScale);


        //年度
        BigDecimal SkYearMny = ComputeUtil.safeAdd(saleReportEntity.getSkFirstMny(),saleReportEntity.getSkSecondMny(),saleReportEntity.getSkThirdMny(),saleReportEntity.getSkFourthMny());
        saleReportEntity.setSkYearMny(SkYearMny);

        BigDecimal SkYearDisparityMny = ComputeUtil.safeSub(SkYearMny,saleReportEntity.getSkYearTaskMny());; // 本年完成差距
        saleReportEntity.setSkYearDisparityMny(SkYearDisparityMny);

        BigDecimal SkYearScale = ComputeUtil.safeDiv(SkYearMny,saleReportEntity.getSkYearTaskMny()).multiply(new BigDecimal(100));; // 本年完成差距比
        saleReportEntity.setSkYearScale(SkYearScale);


        return saleReportEntity;
    }

    public SaleReportVO changeSaleReportVO(SaleReportVO saleReportVO,String month,BigDecimal taxMny,Integer sourceType){
        if("01".equals(month.substring(5,7))){
            if(1==sourceType){
                saleReportVO.setSaleFirstOneMny(taxMny);
            }else if(2==sourceType){
                saleReportVO.setKpFirstOneMny(taxMny);
            }else if(3==sourceType){
                saleReportVO.setSkFirstOneMny(taxMny);
            }
        }else if("02".equals(month.substring(5,7))){
            if(1==sourceType){
                saleReportVO.setSaleFirstTwoMny(taxMny);
            }else if(2==sourceType){
                saleReportVO.setKpFirstTwoMny(taxMny);
            }else if(3==sourceType){
                saleReportVO.setSkFirstTwoMny(taxMny);
            }
        }else if("03".equals(month.substring(5,7))){
            if(1==sourceType){
                saleReportVO.setSaleFirstThreeMny(taxMny);
            }else if(2==sourceType){
                saleReportVO.setKpFirstThreeMny(taxMny);
            }else if(3==sourceType){
                saleReportVO.setSkFirstThreeMny(taxMny);
            }
        }else if("04".equals(month.substring(5,7))){
            if(1==sourceType){
                saleReportVO.setSaleSecondFourMny(taxMny);
            }else if(2==sourceType){
                saleReportVO.setKpSecondFourMny(taxMny);
            }else if(3==sourceType){
                saleReportVO.setSkSecondFourMny(taxMny);
            }
        }else if("05".equals(month.substring(5,7))){
            if(1==sourceType){
                saleReportVO.setSaleSecondFiveMny(taxMny);
            }else if(2==sourceType){
                saleReportVO.setKpSecondFiveMny(taxMny);
            }else if(3==sourceType){
                saleReportVO.setSkSecondFiveMny(taxMny);
            }
        }else if("06".equals(month.substring(5,7))){
            if(1==sourceType){
                saleReportVO.setSaleSecondSixMny(taxMny);
            }else if(2==sourceType){
                saleReportVO.setKpSecondSixMny(taxMny);
            }else if(3==sourceType){
                saleReportVO.setSkSecondSixMny(taxMny);
            }
        }else if("07".equals(month.substring(5,7))){
            if(1==sourceType){
                saleReportVO.setSaleThirdSevenMny(taxMny);
            }else if(2==sourceType){
                saleReportVO.setKpThirdSevenMny(taxMny);
            }else if(3==sourceType){
                saleReportVO.setSkThirdSevenMny(taxMny);
            }
        }else if("08".equals(month.substring(5,7))){
            if(1==sourceType){
                saleReportVO.setSaleThirdEightMny(taxMny);
            }else if(2==sourceType){
                saleReportVO.setKpThirdEightMny(taxMny);
            }else if(3==sourceType){
                saleReportVO.setSkThirdEightMny(taxMny);
            }
        }else if("09".equals(month.substring(5,7))){
            if(1==sourceType){
                saleReportVO.setSaleThirdNineMny(taxMny);
            }else if(2==sourceType){
                saleReportVO.setKpThirdNineMny(taxMny);
            }else if(3==sourceType){
                saleReportVO.setSkThirdNineMny(taxMny);
            }
        }else if("10".equals(month.substring(5,7))){
            if(1==sourceType){
                saleReportVO.setSaleFourthTenMny(taxMny);
            }else if(2==sourceType){
                saleReportVO.setKpFourthTenMny(taxMny);
            }else if(3==sourceType){
                saleReportVO.setSkFourthTenMny(taxMny);
            }
        }else if("11".equals(month.substring(5,7))){
            if(1==sourceType){
                saleReportVO.setSaleFourthElevenMny(taxMny);
            }else if(2==sourceType){
                saleReportVO.setKpFourthElevenMny(taxMny);
            }else if(3==sourceType){
                saleReportVO.setSkFourthElevenMny(taxMny);
            }
        }else if("12".equals(month.substring(5,7))){
            if(1==sourceType){
                saleReportVO.setSaleFourthTwelveMny(taxMny);
            }else if(2==sourceType){
                saleReportVO.setKpFourthTwelveMny(taxMny);
            }else if(3==sourceType){
                saleReportVO.setSkFourthTwelveMny(taxMny);
            }
        }

        return saleReportVO;
    }

}
