package com.ejianc.business.jlincome.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlincome.income.vo.ReviewDetailVO;
import com.ejianc.foundation.usercenter.vo.UserRefVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlincome.income.mapper.ReviewMapper;
import com.ejianc.business.jlincome.income.bean.ReviewEntity;
import com.ejianc.business.jlincome.income.service.IReviewService;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 收入管理-合同评审
 * 
 * @author generator
 * 
 */
@Service("reviewService")
public class ReviewServiceImpl extends BaseServiceImpl<ReviewMapper, ReviewEntity> implements IReviewService{

    @Autowired
    private ReviewMapper mapper;
    @Override
    public IPage<ReviewDetailVO> queryPage(Map<String, Object> queryParam, Integer pageIndex, Integer pageSize) {
        queryParam.put("pageIndex", pageIndex);
        queryParam.put("pageSize", pageSize);
        queryParam.put("tenantId", InvocationInfoProxy.getTenantid());
        Long count =  mapper.queryCount(queryParam);
        List<ReviewDetailVO> jsonObjectList =  new ArrayList<>();
        if(count > 0) {
            jsonObjectList = mapper.queryList(queryParam);
        }
        IPage<ReviewDetailVO> page = new Page<>();
        page.setRecords(jsonObjectList);
        page.setSize(count);
        return page;
    }
}
