package com.ejianc.business.jlincome.bid.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.jlincome.bid.bean.BusinessEntity;
import com.ejianc.business.jlincome.bid.bean.ResultRegisterEntity;
import com.ejianc.business.jlincome.bid.enums.BusinessStageEnum;
import com.ejianc.business.jlincome.bid.service.IBusinessService;
import com.ejianc.business.jlincome.bid.service.IResultRegisterService;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Map;

@Service("resultRegister") 
public class ResultRegisterBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IResultRegisterService service;
	@Autowired
	private IBusinessService businessService;


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		ResultRegisterEntity entity = service.selectById(billId);
		logger.info("查到招标结果登记单据信息----" + JSONObject.toJSONString(entity));
		//1.生成或修改项目信息
		if(null != entity){
			CommonResponse<String> pushResult = service.pushResultRegisterProjectArchive(entity);
			if(!pushResult.isSuccess()) {
				logger.info("推送项目信息失败，失败原因----" + pushResult.getMsg());
				throw new BusinessException(pushResult.getMsg());
			}
		}

		//2.如果是已中标，且引用商机登记，回写商机登记状态为中标，
		if (null != entity && entity.getBidWinFlag() && null != entity.getSourceType() && 1 == entity.getSourceType()){
			UpdateWrapper<BusinessEntity> updateWrapper = new UpdateWrapper<>();
			updateWrapper.eq("id", entity.getSourceId());
			updateWrapper.set("business_stage", BusinessStageEnum.中标.getCode());
			if (!businessService.update(updateWrapper)){
				throw new BusinessException("更新商机登记状态失败！");
			}
		}

		//3.发消息
		// 是否涉及安装：当为“是”时，单据生效后给安装负责人发送一条系统消息：客户名称：-工程名称：-+区域名称：已中标，需要现场安装，请注意
		//（如果修订，更改了是否安装和安装负责人，走同样的逻辑，即保存的时候需要判断，原安装负责人和现安装负责任人的，人员ID是否一致）
		if (null != entity && entity.getRelateInstallFlag()){
			service.sendMsgToInstallPerson(entity);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("弃审前事件回调");
		return CommonResponse.error("该单据不支持撤回/弃审操作");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
