package com.ejianc.business.jlincome.income.service.impl;

import com.ejianc.business.jlincome.income.bean.ContractRegisterEntity;
import com.ejianc.business.jlincome.income.enums.PerformanceStatusEnum;
import com.ejianc.business.jlincome.income.service.IContractRegisterService;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.consts.ArchiveProjectStatusEnum;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;
import java.util.Map;

@Service("contractRegister") 
public class ContractRegisterBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IProjectArchiveApi projectArchiveApi;
	@Autowired
	private IContractRegisterService contractRegisterService;


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}


	;

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ContractRegisterEntity contractRegisterEntity = contractRegisterService.selectById(billId);
		//1.反写项目信息
		ProjectArchiveVO projectArchiveVO = new ProjectArchiveVO();
		projectArchiveVO.setId(contractRegisterEntity.getProjectId());
		projectArchiveVO.setCustomId(contractRegisterEntity.getCustomerId());
		projectArchiveVO.setCustomName(contractRegisterEntity.getCustomerName());
		projectArchiveVO.setCustomCode(contractRegisterEntity.getCustomerCode());
		projectArchiveVO.setProjectStatus(ArchiveProjectStatusEnum.合同阶段.getCode());
		CommonResponse<String> updateResponse = projectArchiveApi.updateProjectData(projectArchiveVO);
		if (!updateResponse.isSuccess()){
			throw new BusinessException("更新项目信息-客户信息异常！");
		}
		//2.更新合同状态
		contractRegisterEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
		contractRegisterEntity.setEffectDate(new Date());
		contractRegisterService.saveOrUpdate(contractRegisterEntity);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}


	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		//合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());

		if (!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}

		ContractRegisterEntity contractRegisterEntity = contractRegisterService.selectById(billId);
		//1.反写项目信息
		ProjectArchiveVO projectArchiveVO = new ProjectArchiveVO();
		projectArchiveVO.setId(contractRegisterEntity.getProjectId());
		projectArchiveVO.setCustomId(null);
		projectArchiveVO.setCustomName(null);
		projectArchiveVO.setCustomCode(null);
		projectArchiveVO.setProjectStatus(ArchiveProjectStatusEnum.合同阶段.getCode());
		CommonResponse<String> updateResponse = projectArchiveApi.updateProjectData(projectArchiveVO);
		if (!updateResponse.isSuccess()){
			throw new BusinessException("更新项目信息-客户信息异常！");
		}
		//2.更新合同状态
		contractRegisterEntity.setPerformanceStatus(PerformanceStatusEnum.未签订.getCode());
		contractRegisterEntity.setEffectDate(null);
		contractRegisterService.saveOrUpdate(contractRegisterEntity);

		return CommonResponse.success();
	}

}
