package com.ejianc.business.jlincome.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jlincome.income.bean.ContractRegisterChangeDetailEntity;
import com.ejianc.business.jlincome.income.bean.ContractRegisterEntity;
import com.ejianc.business.jlincome.income.enums.ChangeStatusEnum;
import com.ejianc.business.jlincome.income.enums.ChangeTypeEnum;
import com.ejianc.business.jlincome.income.service.IContractRegisterChangeDetailService;
import com.ejianc.business.jlincome.income.service.IContractRegisterService;
import com.ejianc.business.jlincome.income.vo.*;
import com.ejianc.business.jlincome.performance.enums.ChangeStateEnum;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlincome.income.mapper.ContractRegisterChangeMapper;
import com.ejianc.business.jlincome.income.bean.ContractRegisterChangeEntity;
import com.ejianc.business.jlincome.income.service.IContractRegisterChangeService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * 收入管理-合同登记-变更
 * 
 * @author generator
 * 
 */
@Service("contractRegisterChangeService")
public class ContractRegisterChangeServiceImpl extends BaseServiceImpl<ContractRegisterChangeMapper, ContractRegisterChangeEntity> implements IContractRegisterChangeService{
    @Autowired
    private IContractRegisterService contractRegisterService;
    @Autowired
    private IContractRegisterChangeDetailService contractChangeDetailService;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public ContractRegisterChangeVO addConvertByConId(Long contractId) {
        ContractRegisterEntity entity = contractRegisterService.selectById(contractId);
        ContractRegisterChangeVO changeVo = BeanMapper.map(entity, ContractRegisterChangeVO.class);
        //新增逻辑处理
        changeVo.setContractId(contractId);
        //新增即点变更按钮穿透过来，此时ID为合同id
        changeVo.setId(IdWorker.getId());
        changeVo.setBillState(null);
        changeVo.setCreateUserCode(null);
        changeVo.setCreateTime(null);
        changeVo.setUpdateUserCode(null);
        changeVo.setUpdateTime(null);
        changeVo.setChangeDate(new Date());
        changeVo.setBeforeContractName(entity.getContractName());
        changeVo.setBeforeChangeMny(entity.getContractMny());
        changeVo.setBeforeChangeTaxMny(entity.getContractTaxMny());
        changeVo.setBeforeContractName(changeVo.getContractName());


        List<ContractRegisterChangeDetailVO> detailVOList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(changeVo.getDetailList())){
            for (ContractRegisterChangeDetailVO detailVO : changeVo.getDetailList()) {
                if (null != detailVO.getChangeType() && ChangeTypeEnum.终止项.getCode().toString().equals(detailVO.getChangeType())){
                    continue;
                }
                detailVO.setChangeType(ChangeTypeEnum.未变更.getCode().toString());
                detailVO.setContractDetailId(detailVO.getId());
                detailVO.setContractId(contractId);
                detailVO.setBeforeChangeNum(detailVO.getDetailNum());
                detailVO.setBeforeChangePrice(detailVO.getDetailTaxPrice());
                detailVO.setBeforeChangeRate(detailVO.getDetailRate());
                detailVO.setRowState("edit");
                detailVOList.add(detailVO);
            }
            changeVo.setDetailList(detailVOList);
        }

        if (CollectionUtils.isNotEmpty(changeVo.getClauseList())) {
            for (ContractRegisterChangeClauseVO contractRegisterChangeClauseVO : changeVo.getClauseList()) {
                contractRegisterChangeClauseVO.setContractClauseId(contractId);
                contractRegisterChangeClauseVO.setContractId(contractId);
                contractRegisterChangeClauseVO.setRowState("add");
            }
        }
        //复制附件
        //附件
        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(contractId), "EJCBT202405000039", "contractRegisterFile", String.valueOf(changeVo.getId()), "EJCBT202405000046", "contractRegisterChangeFile");
        //管理
        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(contractId), "EJCBT202405000039", "contractMgrFile", String.valueOf(changeVo.getId()), "EJCBT202405000046", "contractRegisterMgrChangeFile");
        return changeVo;
    }

    @Override
    public ContractRegisterChangeVO queryChangeRecordByContId(Long id) {
        ContractRegisterChangeVO changeVO = new ContractRegisterChangeVO();
        ContractRegisterEntity entity = contractRegisterService.selectById(id);
        BigDecimal baseTaxMny = entity.getBaseTaxMny() == null ? BigDecimal.ZERO : entity.getBaseTaxMny();
        BigDecimal contractTaxMny = entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny();

        changeVO.setId(id);
        changeVO.setBaseTaxMny(baseTaxMny);
        changeVO.setPerformanceStatus(entity.getPerformanceStatus());
        changeVO.setChangeStatus(entity.getChangeStatus());
        //现合同金额（含税）
        changeVO.setContractTaxMny(contractTaxMny);

        changeVO.setSumChangeMny(contractTaxMny.subtract(baseTaxMny));
        if (changeVO.getSumChangeMny().compareTo(BigDecimal.ZERO) != 0 && baseTaxMny.compareTo(BigDecimal.ZERO) != 0) {
            changeVO.setSumScale(new BigDecimal(100).multiply(changeVO.getSumChangeMny().divide(baseTaxMny, 8, ROUND_HALF_DOWN)));
        } else {
            changeVO.setSumScale(BigDecimal.ZERO);
        }

        if (null != entity.getChangeVersion() && entity.getChangeVersion() > 0) {
            //合同版本号>0说明会有变更记录
            LambdaQueryWrapper<ContractRegisterChangeEntity> lambda = Wrappers.<ContractRegisterChangeEntity>lambdaQuery();
            lambda.eq(ContractRegisterChangeEntity::getContractId, id);
            lambda.in(ContractRegisterChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
            lambda.orderByDesc(ContractRegisterChangeEntity::getChangeVersion);
            List<ContractRegisterChangeEntity> entities = super.list(lambda);
            changeVO.setChangeRecord(BeanMapper.mapList(entities, ContractRegisterChangeVO.class));
        }
        return changeVO;
    }

    @Override
    public CommonResponse<ContractRegisterChangeVO> saveOrUpdate(ContractRegisterChangeVO contractChangeVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        ContractRegisterChangeEntity entity = null;
        List<ContractRegisterEntity> entitiesc = null;
        List<ContractRegisterChangeEntity> entities = null;


        //变更合同只能存在一条未生效的
        LambdaQueryWrapper<ContractRegisterChangeEntity> lambdachange = Wrappers.<ContractRegisterChangeEntity>lambdaQuery();
        lambdachange.eq(ContractRegisterChangeEntity::getContractId, contractChangeVO.getContractId());
        if (contractChangeVO.getId() != null && contractChangeVO.getId() > 0) {
            lambdachange.ne(ContractRegisterChangeEntity::getId, contractChangeVO.getId());
        }
        lambdachange.ne(ContractRegisterChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(ContractRegisterChangeEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count(lambdachange);
        if (num > 0) {
            throw new BusinessException("该合同已存在未生效的变更单!");
        }

        ContractRegisterEntity parentEntity = contractRegisterService.selectById(contractChangeVO.getContractId());
        if (contractChangeVO.getId() != null && contractChangeVO.getId() > 0 && super.getById(contractChangeVO.getId()) != null) {
            //修改 校验合同编号唯一，变更单除去本单，合同  同时唯一
            LambdaQueryWrapper<ContractRegisterChangeEntity> lambda = Wrappers.<ContractRegisterChangeEntity>lambdaQuery();
            lambda.eq(ContractRegisterChangeEntity::getBillCode, contractChangeVO.getBillCode());
            lambda.ne(ContractRegisterChangeEntity::getContractId, contractChangeVO.getContractId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, contractChangeVO.getBillCode()));
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, contractChangeVO.getContractId()));
            entitiesc = contractRegisterService.queryList(queryParam, false);
            parentEntity.setId(contractChangeVO.getContractId());
        } else {
            //校验合同编号是否重复
            LambdaQueryWrapper<ContractRegisterChangeEntity> lambda = Wrappers.<ContractRegisterChangeEntity>lambdaQuery();
            lambda.eq(ContractRegisterChangeEntity::getBillCode, contractChangeVO.getBillCode());
            lambda.ne(ContractRegisterChangeEntity::getContractId, contractChangeVO.getContractId());
            entities = super.list(lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, contractChangeVO.getBillCode()));
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, contractChangeVO.getContractId()));
            entitiesc = contractRegisterService.queryList(queryParam, false);
            //新增即点变更按钮穿透过来，此时ID为合同id
            parentEntity.setId(contractChangeVO.getContractId());
            parentEntity.setChangeVersion(contractChangeVO.getChangeVersion() + 1);
            contractChangeVO.setChangeVersion(contractChangeVO.getChangeVersion() + 1);
        }
        if (CollectionUtils.isNotEmpty(entities) || CollectionUtils.isNotEmpty(entitiesc)) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        if (CollectionUtils.isNotEmpty(contractChangeVO.getDetailList())) {
            contractChangeVO.getDetailList().forEach(vo -> {
                //变更类型1-增补，2-变更，3-中止
                if (this.isInsertContractChange(contractChangeVO)) {
                    vo.setId(null);
                }
                if ("del".equals(vo.getRowState()) && null != vo.getContractId()){
                    vo.setChangeType(ChangeTypeEnum.终止项.getCode().toString());
                    vo.setRowState("edit");
                }
            });
        }
        if (CollectionUtils.isNotEmpty(contractChangeVO.getClauseList())) {
            contractChangeVO.getClauseList().forEach(vo -> {
                if (this.isInsertContractChange(contractChangeVO)) {
                    vo.setId(null);
                }
            });
        }
        entity = BeanMapper.map(contractChangeVO, ContractRegisterChangeEntity.class);
        entity.setChangeCode(entity.getBillCode() + "-" + entity.getChangeVersion());
        super.saveOrUpdate(entity, false);
        //回写合同表
        parentEntity.setChangeStatus(ChangeStatusEnum.变更中.getCode());
        parentEntity.setChangingMny(entity.getContractMny());//修改变更中金额
        parentEntity.setChangingTaxMny(entity.getContractTaxMny());
        parentEntity.setChangeDate(entity.getChangeDate());
        parentEntity.setChangeCode(entity.getBillCode() + "-" + entity.getChangeVersion());
        parentEntity.setChangeId(entity.getId());
        parentEntity.setChangeContractName(entity.getContractName());
        contractRegisterService.update(parentEntity, new QueryWrapper<ContractRegisterEntity>().eq("id", parentEntity.getId()), false);
        ContractRegisterChangeVO res = BeanMapper.map(this.queryDetail(entity.getId()), ContractRegisterChangeVO.class);

        return CommonResponse.success(res);
    }


    /**
     * 是否合同变更新增
     *
     * @param contractChangeVO 合同变更数据
     * @return 是否新增
     */
    private boolean isInsertContractChange(ContractRegisterChangeVO contractChangeVO) {
        return contractChangeVO.getId() == null || contractChangeVO.getId() == 0;
    }
    
    @Override
    public void deleteContractChange(List<ContractRegisterChangeVO> vos) {
        ContractRegisterChangeVO changeVo = vos.get(0);
        ContractRegisterChangeEntity entity = super.selectById(changeVo.getId());
        //合同变更只有详情页有删除
        ContractRegisterEntity parentEntity = contractRegisterService.selectById(entity.getContractId());
        //回写合同表
        parentEntity.setId(entity.getContractId());
        parentEntity.setChangeVersion(parentEntity.getChangeVersion() - 1);
        parentEntity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
        parentEntity.setChangingMny(BigDecimal.ZERO);//修改变更中金额
        parentEntity.setChangingTaxMny(BigDecimal.ZERO);
        parentEntity.setChangeCode(null);
        parentEntity.setChangeId(null);
        contractRegisterService.update(parentEntity, new QueryWrapper<ContractRegisterEntity>().eq("id", parentEntity.getId()), false);
        super.removeByIds(vos.stream().map(ContractRegisterChangeVO::getId).collect(Collectors.toList()), false);
    }

    @Override
    public ContractRegisterChangeVO queryDetail(Long id) {
        ContractRegisterChangeEntity entity = super.selectById(id);
        entity.setDetailList(null);
        ContractRegisterChangeVO contractVo = BeanMapper.map(entity, ContractRegisterChangeVO.class);
        List<ContractRegisterChangeDetailEntity> details = null;
        LambdaQueryWrapper<ContractRegisterChangeDetailEntity> lambda = Wrappers.<ContractRegisterChangeDetailEntity>lambdaQuery();
        lambda.eq(ContractRegisterChangeDetailEntity::getContractRegisterId, id);
        lambda.ne(ContractRegisterChangeDetailEntity::getChangeType, ChangeTypeEnum.终止项.getCode());
        details = contractChangeDetailService.list(lambda);
        if (CollectionUtils.isNotEmpty(details)) {
            contractVo.setDetailList(BeanMapper.mapList(details, ContractRegisterChangeDetailVO.class));
        }
        return contractVo;
    }

}
