package com.ejianc.business.jlincome.performance.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.server.PathParam;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlincome.performance.bean.SaleContractEntity;
import com.ejianc.business.jlincome.performance.service.ISaleContractService;
import com.ejianc.business.jlincome.performance.vo.SaleContractVO;

/**
 * 绩效管理-销售业绩合同
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("saleContract")
public class SaleContractController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SALE_CONTRACT_CODE";//此处需要根据实际修改

    @Autowired
    private ISaleContractService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SaleContractVO> saveOrUpdate(@RequestBody SaleContractVO saveOrUpdateVO) {
    	SaleContractEntity entity = BeanMapper.map(saveOrUpdateVO, SaleContractEntity.class);
        LambdaQueryWrapper<SaleContractEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.notIn(SaleContractEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambdaQueryWrapper.eq(SaleContractEntity::getContractId,saveOrUpdateVO.getContractId());
        lambdaQueryWrapper.eq(SaleContractEntity::getDr,0);
        //修改的情况  去除本身
        if (entity.getId()!=null){
            lambdaQueryWrapper.ne(SaleContractEntity::getId,saveOrUpdateVO.getId());
        }
        List<SaleContractEntity> list = service.list(lambdaQueryWrapper);
        if (CollectionUtils.isNotEmpty(list)){
            throw new BusinessException("当前合同存在未提交单据，请提交后再操作！");
        }
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	SaleContractVO vo = BeanMapper.map(entity, SaleContractVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SaleContractVO> queryDetail(Long id) {
    	SaleContractEntity entity = service.selectById(id);
    	SaleContractVO vo = BeanMapper.map(entity, SaleContractVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryTotal 查询累计金额
     * @param
     */
    @RequestMapping(value = "/queryTotal", method = RequestMethod.GET)
    @ResponseBody
    public BigDecimal queryTotal(@PathParam("contractId") Long contractId) {
//    public BigDecimal queryTotal() {
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        HashMap<String, Parameter> map = new HashMap<>();
        map.put("billState", new Parameter(QueryParam.EQ, 1));
        map.put("contractId", new Parameter(QueryParam.EQ, contractId));
        param.setParams(map);
        List<SaleContractEntity> saleContractEntities = service.queryList(param);
        BigDecimal add = saleContractEntities.stream().map(SaleContractEntity::getRegisterMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        System.out.println("add  = " + add);
        return add;
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SaleContractVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SaleContractVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SaleContractVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SaleContractVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //模糊搜索单据编码、合同名称、销售大区、销售负责人、客户名称、经办人
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("saleName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("employeeName");
        String searchText = param.getSearchText();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
            IPage<SaleContractEntity> page = service.queryPage(param, false);
            IPage<SaleContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(BeanMapper.mapList(page.getRecords(), SaleContractVO.class));

            return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        //模糊搜索单据编码、合同名称、销售大区、销售负责人、客户名称、经办人
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("saleName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<SaleContractEntity> list = service.queryList(param);
        //字段翻译
        List<SaleContractVO> resDatas = BeanMapper.mapList(list, SaleContractVO.class);
        for (SaleContractVO resData : resDatas) {
            switch (resData.getBillState()) {
                case 0:
                    resData.setBillStateName("自由态");
                    break;
                case 1:
                    resData.setBillStateName("已提交");
                    break;
                case 2:
                case 5:
                    resData.setBillStateName("审批中");
                    break;
                case 3:
                    resData.setBillStateName("审批通过");
                    break;
                case 4:
                    resData.setBillStateName("审批驳回");
                    break;
            }
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", resDatas);
        ExcelExport.getInstance().export("SaleContract-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refSaleContractData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SaleContractVO>> refSaleContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SaleContractEntity> page = service.queryPage(param,false);
        IPage<SaleContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SaleContractVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
