package com.ejianc.business.jlincome.performance.service.impl;

import com.ejianc.business.jlincome.performance.bean.ForecastEntity;
import com.ejianc.business.jlincome.performance.enums.ChangeStateEnum;
import com.ejianc.business.jlincome.performance.service.IForecastService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;
import java.util.Map;

@Service("forecast")
public class ForecastBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IForecastService forecastService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
//     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        logger.info("撤回前事件回调");

        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批后回调
     *
     * @param billId       //单据id
     * @param state        //单据状态
     * @param billTypeCode //单据类型code
     * @param forecastId   //该流程id
     * @param isEnd        //该节点是否结束
     * @return
     */
    @Override
    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String forecastId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("终审审核完回调");
        ForecastEntity forecastEntity = forecastService.selectById(billId);
        forecastEntity.setEnableState(true);
        forecastEntity.setEffectDate(new Date());
        //变更单审批通过自己也是已变更
        if (forecastEntity.getForecastVersion() != 1) {
            forecastEntity.setChangeState(ChangeStateEnum.已变更.getCode());
        }
        forecastService.saveOrUpdate(forecastEntity);


        //弃审,存在前版本，单据是否生效为是
        if (forecastEntity.getLastForecastId() != null) {
            ForecastEntity revise = forecastService.selectById(forecastEntity.getLastForecastId());
            revise.setChangeState(ChangeStateEnum.已变更.getCode());
            revise.setEnableState(false);

            //更改原单据编号，变更单单据编号改为原单据编号
            revise.setBillCode(revise.getBillCode() + "0000" + revise.getForecastVersion());

            revise.setChangeEmployeeId(forecastEntity.getChangeEmployeeId());
            revise.setChangeEmployeeName(forecastEntity.getChangeEmployeeName());
            revise.setChangeDate(forecastEntity.getChangeDate());
            revise.setChangeReason(forecastEntity.getChangeReason());

            forecastService.saveOrUpdate(revise);
        }
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        ForecastEntity forecastEntity = forecastService.selectById(billId);
        //第一版本撤回时校验，是否在变更中
        if(1 == forecastEntity.getForecastVersion()) {
            if (ChangeStateEnum.变更中.getCode().toString().equals(forecastEntity.getChangeState().toString())) {
                throw new BusinessException("该单据正在变更中，不能撤回！");
            }else if (ChangeStateEnum.已变更.getCode().toString().equals(forecastEntity.getChangeState().toString())){
                throw new BusinessException("单据已变更，不能撤回！");
            }
        }else {
            throw new BusinessException("单据已变更，不能撤回！");
        }
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
