/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.bid.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlincome.bid.bean.BusinessEntity;
import com.ejianc.business.jlincome.bid.bean.EngineeringReportEntity;
import com.ejianc.business.jlincome.bid.mapper.BusinessMapper;
import com.ejianc.business.jlincome.bid.service.IBusinessService;
import com.ejianc.business.jlincome.bid.service.IEngineeringReportService;
import com.ejianc.business.jlincome.bid.vo.EngineeringReportExportVO;
import com.ejianc.business.jlincome.bid.vo.EngineeringReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"engineeringReport"})
public class EngineeringReportController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBusinessService businessService;
    private static final String BILL_CODE = "EResearch";
    @Autowired
    private IEngineeringReportService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private BusinessMapper businessMapper;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<EngineeringReportVO> saveOrUpdate(@RequestBody EngineeringReportVO saveOrUpdateVO) {
        EngineeringReportEntity entity = (EngineeringReportEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, EngineeringReportEntity.class));
        if (saveOrUpdateVO.getIsAssist().booleanValue()) {
            entity.setIsAssist(1);
        } else {
            entity.setIsAssist(0);
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            if (this.service.checkIsExist((EngineeringReportVO)BeanMapper.map((Object)((Object)entity), EngineeringReportVO.class))) {
                throw new BusinessException("\u8be5\u5de5\u7a0b\u5df2\u7ecf\u88ab\u5f15\u7528\uff0c\u4e0d\u53ef\u91cd\u590d\u5f15\u7528");
            }
        } else if (this.service.checkIsExist((EngineeringReportVO)BeanMapper.map((Object)((Object)entity), EngineeringReportVO.class))) {
            throw new BusinessException("\u8be5\u5de5\u7a0b\u5df2\u7ecf\u88ab\u5f15\u7528\uff0c\u4e0d\u53ef\u91cd\u590d\u5f15\u7528");
        }
        this.service.saveOrUpdate((Object)entity, false);
        EngineeringReportVO vo = (EngineeringReportVO)BeanMapper.map((Object)((Object)entity), EngineeringReportVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<EngineeringReportVO> queryDetail(Long id) {
        EngineeringReportEntity entity = (EngineeringReportEntity)((Object)this.service.selectById(id));
        EngineeringReportVO vo = (EngineeringReportVO)BeanMapper.map((Object)((Object)entity), EngineeringReportVO.class);
        if (entity.getIsAssist() == 1) {
            vo.setIsAssist(Boolean.valueOf(true));
        } else {
            vo.setIsAssist(Boolean.valueOf(false));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EngineeringReportVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (EngineeringReportVO engineeringReportVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<EngineeringReportVO>> queryList(@RequestBody QueryParam param) {
        Map params = param.getParams();
        for (Map.Entry stringParameterEntry : params.entrySet()) {
            String key = (String)stringParameterEntry.getKey();
            Parameter value = (Parameter)stringParameterEntry.getValue();
            Object value1 = value.getValue();
            if (key.equals("isAssist") && value1.equals("0")) {
                param.getParams().put("isAssist", new Parameter("eq", (Object)1));
            }
            if (!key.equals("isAssist") || !value1.equals("1")) continue;
            param.getParams().put("isAssist", new Parameter("eq", (Object)0));
        }
        EngineeringReportController.extracted(param);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), EngineeringReportVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        EngineeringReportController.extracted(param);
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List engineeringReportExportList = BeanMapper.mapList((Iterable)list, EngineeringReportExportVO.class);
        for (EngineeringReportExportVO engineeringReportExportVO : engineeringReportExportList) {
            if (engineeringReportExportVO.getIsAssist() == 1) {
                engineeringReportExportVO.setNeedAssistance("\u662f");
            } else {
                engineeringReportExportVO.setNeedAssistance("\u5426");
            }
            if (engineeringReportExportVO.getBillState() == 0) {
                engineeringReportExportVO.setState("\u81ea\u7531\u6001");
            }
            if (engineeringReportExportVO.getBillState() == 2 || engineeringReportExportVO.getBillState() == 5) {
                engineeringReportExportVO.setState("\u5ba1\u6279\u4e2d");
            }
            if (engineeringReportExportVO.getBillState() == 1) {
                engineeringReportExportVO.setState("\u5df2\u63d0\u4ea4");
            }
            if (engineeringReportExportVO.getBillState() == 3) {
                engineeringReportExportVO.setState("\u5ba1\u6279\u901a\u8fc7");
            }
            if (engineeringReportExportVO.getBillState() != 4) continue;
            engineeringReportExportVO.setState("\u5ba1\u6279\u9a73\u56de");
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", engineeringReportExportList);
        ExcelExport.getInstance().export("EngineeringReport-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refEngineeringReportData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<EngineeringReportVO>> refEngineeringReportData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), EngineeringReportVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/selectLatest"})
    @ResponseBody
    public CommonResponse selectMoney(String id) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getId, (Object)id);
        BusinessEntity businessEntity = (BusinessEntity)((Object)this.businessMapper.selectOne((Wrapper)wrapper));
        return CommonResponse.success((String)"\u6210\u529f", (Object)((Object)businessEntity));
    }

    private static void extracted(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("customName");
        fuzzyFields.add("ownerCompany");
        fuzzyFields.add("designCompany");
        fuzzyFields.add("employeeName");
    }
}

