/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.bid.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.jlincome.bid.bean.BusinessEntity;
import com.ejianc.business.jlincome.bid.bean.ResultRegisterEntity;
import com.ejianc.business.jlincome.bid.enums.BusinessStageEnum;
import com.ejianc.business.jlincome.bid.mapper.BusinessMapper;
import com.ejianc.business.jlincome.bid.service.IBidInitiationService;
import com.ejianc.business.jlincome.bid.service.IBusinessService;
import com.ejianc.business.jlincome.bid.service.IResultRegisterService;
import com.ejianc.business.jlincome.bid.service.ITenderEvaluationService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.consts.ArchiveProjectStatusEnum;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="businessService")
public class BusinessServiceImpl
extends BaseServiceImpl<BusinessMapper, BusinessEntity>
implements IBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectArchiveApi projectArchiveApi;
    @Autowired
    private IResultRegisterService resultRegisterService;
    @Autowired
    private IBidInitiationService bidInitiationService;
    @Autowired
    private ITenderEvaluationService tenderEvaluationService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> pushProjectArchive(BusinessEntity businessEntity) {
        ProjectArchiveVO projectArchiveVO = new ProjectArchiveVO();
        projectArchiveVO.setProjectStatus(ArchiveProjectStatusEnum.\u5546\u673a\u9636\u6bb5.getCode());
        projectArchiveVO.setName(businessEntity.getProjectName());
        projectArchiveVO.setOrgId(businessEntity.getOrgId());
        projectArchiveVO.setOrgCode(businessEntity.getOrgCode());
        projectArchiveVO.setOrgName(businessEntity.getOrgName());
        projectArchiveVO.setProjectTypeId(businessEntity.getProjectTypeId());
        projectArchiveVO.setProjectTypeName(businessEntity.getProjectTypeName());
        projectArchiveVO.setProductType(businessEntity.getProductType());
        projectArchiveVO.setProductTypeName(businessEntity.getProductTypeName());
        projectArchiveVO.setBusinessCustomName(businessEntity.getCustomName());
        projectArchiveVO.setCustomLinkName(businessEntity.getCustomLinkName());
        projectArchiveVO.setCustomLinkPhone(businessEntity.getCustomLinkPhone());
        projectArchiveVO.setAddress(businessEntity.getDetailedAddress());
        projectArchiveVO.setPlanDeliverDate(businessEntity.getPlanDeliverDate());
        projectArchiveVO.setProductName(businessEntity.getProductName());
        projectArchiveVO.setSpec(businessEntity.getSpec());
        projectArchiveVO.setNum(businessEntity.getNum());
        projectArchiveVO.setSaleLeaderId(businessEntity.getSaleLeaderId());
        projectArchiveVO.setSaleLeaderName(businessEntity.getSaleLeaderName());
        projectArchiveVO.setSaleLeaderPhone(businessEntity.getSaleLeaderPhone());
        projectArchiveVO.setProjectSituation(businessEntity.getProjectSituation());
        projectArchiveVO.setSourceType("business");
        projectArchiveVO.setSourceBillId(businessEntity.getId());
        projectArchiveVO.setSourceBillCode(businessEntity.getBillCode());
        this.logger.info("\u5546\u673a\u767b\u8bb0-\u63a8\u9001\u9879\u76ee\u4fe1\u606f\u6570\u636e----" + JSONObject.toJSONString((Object)projectArchiveVO));
        return this.projectArchiveApi.pushProjectArchive(projectArchiveVO);
    }

    @Override
    public CommonResponse<String> updateAbandonFlag(Long id, Boolean abandonFlag) {
        BusinessEntity businessEntity = (BusinessEntity)((Object)super.selectById((Serializable)id));
        if (!businessEntity.getSaleLeaderId().toString().equals(InvocationInfoProxy.getEmployeeId())) {
            return CommonResponse.error((String)"\u653e\u5f03\u5931\u8d25\uff0c\u53ea\u6709\u9500\u552e\u8d1f\u8d23\u4eba\u672c\u4eba\u53ef\u4ee5\u653e\u5f03\uff01");
        }
        if (null != businessEntity.getBillState() && (BillStateEnum.COMMITED_STATE.getBillStateCode() == businessEntity.getBillState() || BillStateEnum.PASSED_STATE.getBillStateCode() == businessEntity.getBillState())) {
            CommonResponse projectArchiveRes = this.projectArchiveApi.getProjectArchiveBySourceId(id);
            if (!projectArchiveRes.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u5224\u65ad\u9879\u76ee\u9636\u6bb5\u5931\u8d25\uff0c\u539f\u56e0-" + projectArchiveRes.getMsg());
            }
            ProjectArchiveVO projectArchiveVO = (ProjectArchiveVO)projectArchiveRes.getData();
            if (null != projectArchiveVO && Integer.valueOf(projectArchiveVO.getProjectStatus()) > Integer.valueOf(ArchiveProjectStatusEnum.\u5df2\u4e2d\u6807.getCode())) {
                return CommonResponse.error((String)("\u4fee\u6539\u5931\u8d25\uff0c\u9879\u76ee\u5df2\u8fdb\u5165'" + ArchiveProjectStatusEnum.getByCode((String)projectArchiveVO.getProjectStatus()) + "'\uff01"));
            }
        }
        String projectStatus = ArchiveProjectStatusEnum.\u672a\u4e2d\u6807.getCode();
        businessEntity.setAbandonFlag(abandonFlag);
        if (abandonFlag.booleanValue()) {
            businessEntity.setBusinessStage(BusinessStageEnum.\u653e\u5f03.getCode());
        } else {
            QueryParam param = new QueryParam();
            param.getParams().put("sourceType", new Parameter("eq", (Object)1));
            param.getParams().put("sourceId", new Parameter("eq", (Object)businessEntity.getId()));
            param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
            List registerEntityList = this.resultRegisterService.queryList(param);
            if (CollectionUtils.isNotEmpty((Collection)registerEntityList) && registerEntityList.size() > 0) {
                if (((ResultRegisterEntity)((Object)registerEntityList.get(0))).getBidWinFlag().booleanValue()) {
                    businessEntity.setBusinessStage(BusinessStageEnum.\u4e2d\u6807.getCode());
                    projectStatus = ArchiveProjectStatusEnum.\u5df2\u4e2d\u6807.getCode();
                } else {
                    businessEntity.setBusinessStage(BusinessStageEnum.\u653e\u5f03.getCode());
                }
            } else {
                businessEntity.setBusinessStage(BusinessStageEnum.\u8ddf\u8e2a.getCode());
                QueryParam bidParam = new QueryParam();
                bidParam.getParams().put("projectId", new Parameter("eq", (Object)businessEntity.getId()));
                bidParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
                List bidInitiationEntityList = this.bidInitiationService.queryList(bidParam);
                QueryParam tendParam = new QueryParam();
                tendParam.getParams().put("engineeringId", new Parameter("eq", (Object)businessEntity.getId()));
                tendParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
                List tenderEvaluationEntityList = this.tenderEvaluationService.queryList(tendParam);
                projectStatus = bidInitiationEntityList.size() > 0 || tenderEvaluationEntityList.size() > 0 ? ArchiveProjectStatusEnum.\u6295\u6807\u9636\u6bb5.getCode() : ArchiveProjectStatusEnum.\u5546\u673a\u9636\u6bb5.getCode();
            }
        }
        CommonResponse projectArchiveRes = this.projectArchiveApi.updateProjectStatus(projectStatus, businessEntity.getId());
        if (!projectArchiveRes.isSuccess()) {
            throw new BusinessException("\u4fee\u6539\u9879\u76ee\u9636\u6bb5\u5931\u8d25\uff0c\u539f\u56e0-" + projectArchiveRes.getMsg());
        }
        if (!super.saveOrUpdate((Object)businessEntity)) {
            return CommonResponse.error((String)"\u4fee\u6539\u72b6\u6001\u5931\u8d25\uff01");
        }
        return CommonResponse.success((String)"\u4fee\u6539\u72b6\u6001\u6210\u529f\uff01");
    }
}

