/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.performance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlincome.performance.bean.GradeAdjustDetailEntity;
import com.ejianc.business.jlincome.performance.bean.GradeAdjustEntity;
import com.ejianc.business.jlincome.performance.service.IGradeAdjustDetailService;
import com.ejianc.business.jlincome.performance.service.IGradeAdjustService;
import com.ejianc.business.jlincome.performance.vo.GradeAdjustDetailVO;
import com.ejianc.business.jlincome.performance.vo.GradeAdjustVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"gradeAdjust"})
public class GradeAdjustController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "GRADE_ADJUST_CODE";
    @Autowired
    private IGradeAdjustService service;
    @Autowired
    private IGradeAdjustDetailService detailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<GradeAdjustVO> saveOrUpdate(@RequestBody GradeAdjustVO saveOrUpdateVO) {
        GradeAdjustEntity entity = (GradeAdjustEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, GradeAdjustEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        GradeAdjustVO vo = (GradeAdjustVO)BeanMapper.map((Object)((Object)entity), GradeAdjustVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<GradeAdjustVO> queryDetail(Long id) {
        GradeAdjustEntity entity = (GradeAdjustEntity)((Object)this.service.selectById(id));
        GradeAdjustVO vo = (GradeAdjustVO)BeanMapper.map((Object)((Object)entity), GradeAdjustVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<GradeAdjustVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (GradeAdjustVO gradeAdjustVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<GradeAdjustVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("contract_name");
        fuzzyFields.add("customer_name");
        fuzzyFields.add("org_name");
        fuzzyFields.add("employee_name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (ObjectUtils.isNotEmpty(param.getParams().get("initiationMonth"))) {
            param.getParams().put("initiationMonth", new Parameter("in", (Object)(((Parameter)param.getParams().get("initiationMonth")).getValue() + "-01")));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), GradeAdjustVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("contract_name");
        fuzzyFields.add("customer_name");
        fuzzyFields.add("org_name");
        fuzzyFields.add("employee_name");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (ObjectUtils.isNotEmpty(param.getParams().get("initiationMonth"))) {
            param.getParams().put("initiationMonth", new Parameter("in", (Object)(((Parameter)param.getParams().get("initiationMonth")).getValue() + "-01")));
        }
        List list = this.service.queryList(param);
        HashMap<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        beans.put("contractMnySum", list.stream().map(GradeAdjustEntity::getContractMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        ExcelExport.getInstance().export("GradeAdjust-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refGradeAdjustData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<GradeAdjustVO>> refGradeAdjustData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), GradeAdjustVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/selectByContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<GradeAdjustDetailVO>> selectByContract(Long contractId) {
        this.logger.info("\u5408\u540cselectByContract" + contractId);
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.in(GradeAdjustEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        lambda.eq(GradeAdjustEntity::getContractId, (Object)contractId);
        lambda.orderByDesc(BaseEntity::getCreateTime);
        List list = this.service.list((Wrapper)lambda);
        if (ObjectUtils.isNotEmpty((Object)list)) {
            LambdaQueryWrapper lambda2 = new LambdaQueryWrapper();
            lambda2.eq(GradeAdjustDetailEntity::getDetailId, (Object)((GradeAdjustEntity)((Object)list.get(0))).getId());
            List result = this.detailService.list((Wrapper)lambda2);
            List gradeAdjustDetailVOS = BeanMapper.mapList((Iterable)result, GradeAdjustDetailVO.class);
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)gradeAdjustDetailVOS);
        }
        return CommonResponse.success((String)"\u4e0d\u5b58\u5728\u4ef7\u683c\u8c03\u6574");
    }
}

