package com.ejianc.business.jlincome.bid.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.jlincome.bid.bean.BidInitiationEntity;
import com.ejianc.business.jlincome.bid.bean.ResultRegisterEntity;
import com.ejianc.business.jlincome.bid.bean.TenderEvaluationEntity;
import com.ejianc.business.jlincome.bid.enums.BusinessStageEnum;
import com.ejianc.business.jlincome.bid.service.IBidInitiationService;
import com.ejianc.business.jlincome.bid.service.IResultRegisterService;
import com.ejianc.business.jlincome.bid.service.ITenderEvaluationService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.consts.ArchiveProjectStatusEnum;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlincome.bid.mapper.BusinessMapper;
import com.ejianc.business.jlincome.bid.bean.BusinessEntity;
import com.ejianc.business.jlincome.bid.service.IBusinessService;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.List;

/**
 * 投标-商机登记
 *
 * @author generator
 *
 */
@Service("businessService")
public class BusinessServiceImpl extends BaseServiceImpl<BusinessMapper, BusinessEntity> implements IBusinessService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectArchiveApi projectArchiveApi;

    @Autowired
    private IResultRegisterService resultRegisterService;
    @Autowired
    private IBidInitiationService bidInitiationService;
    @Autowired
    private ITenderEvaluationService tenderEvaluationService;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public CommonResponse<String> pushProjectArchive(BusinessEntity businessEntity) {
        ProjectArchiveVO projectArchiveVO = new ProjectArchiveVO();

        projectArchiveVO.setProjectStatus(ArchiveProjectStatusEnum.商机阶段.getCode());
        projectArchiveVO.setName(businessEntity.getProjectName());
        projectArchiveVO.setOrgId(businessEntity.getOrgId());
        projectArchiveVO.setOrgCode(businessEntity.getOrgCode());
        projectArchiveVO.setOrgName(businessEntity.getOrgName());

        projectArchiveVO.setProjectTypeId(businessEntity.getProjectTypeId());
        projectArchiveVO.setProjectTypeName(businessEntity.getProjectTypeName());
        projectArchiveVO.setProductType(businessEntity.getProductType());
        projectArchiveVO.setProductTypeName(businessEntity.getProductTypeName());

        projectArchiveVO.setBusinessCustomName(businessEntity.getCustomName());
        projectArchiveVO.setCustomLinkName(businessEntity.getCustomLinkName());
        projectArchiveVO.setCustomLinkPhone(businessEntity.getCustomLinkPhone());
        projectArchiveVO.setAddress(businessEntity.getDetailedAddress());
        projectArchiveVO.setPlanDeliverDate(businessEntity.getPlanDeliverDate());
        projectArchiveVO.setProductName(businessEntity.getProductName());
        projectArchiveVO.setSpec(businessEntity.getSpec());
        projectArchiveVO.setNum(businessEntity.getNum());
        projectArchiveVO.setSaleLeaderId(businessEntity.getSaleLeaderId());
        projectArchiveVO.setSaleLeaderName(businessEntity.getSaleLeaderName());
        projectArchiveVO.setSaleLeaderPhone(businessEntity.getSaleLeaderPhone());
        projectArchiveVO.setProjectSituation(businessEntity.getProjectSituation());

        projectArchiveVO.setSourceType("business");
        projectArchiveVO.setSourceBillId(businessEntity.getId());
        projectArchiveVO.setSourceBillCode(businessEntity.getBillCode());


        logger.info("商机登记-推送项目信息数据----" + JSONObject.toJSONString(projectArchiveVO));
        return projectArchiveApi.pushProjectArchive(projectArchiveVO);
    }

    @Override
    public CommonResponse<String> updateAbandonFlag(Long id, Boolean abandonFlag) {
        BusinessEntity businessEntity = super.selectById(id);
        if (!businessEntity.getSaleLeaderId().toString().equals(InvocationInfoProxy.getEmployeeId())){
            return CommonResponse.error("放弃失败，只有销售负责人本人可以放弃！");
        }

        //todo: 这里需要校验商机状态生成项目是否被合同引用，如果被引用则不能修改（等合同那边完成后再做）
        if (null != businessEntity.getBillState() && (BillStateEnum.COMMITED_STATE.getBillStateCode() == businessEntity.getBillState() || BillStateEnum.PASSED_STATE.getBillStateCode() == businessEntity.getBillState())){
            CommonResponse<ProjectArchiveVO> projectArchiveRes = projectArchiveApi.getProjectArchiveBySourceId(id);
            if (!projectArchiveRes.isSuccess()){
                throw new BusinessException("查询项目信息失败，判断项目阶段失败，原因-" + projectArchiveRes.getMsg());
            }
            ProjectArchiveVO projectArchiveVO = projectArchiveRes.getData();
            if (null != projectArchiveVO && Integer.valueOf(projectArchiveVO.getProjectStatus()) > Integer.valueOf(ArchiveProjectStatusEnum.已中标.getCode())){
                return CommonResponse.error("修改失败，项目已进入'" + ArchiveProjectStatusEnum.getByCode(projectArchiveVO.getProjectStatus()) + "'！");
            }
        }

        String projectStatus = ArchiveProjectStatusEnum.未中标.getCode();
        businessEntity.setAbandonFlag(abandonFlag);
        if (abandonFlag){
            businessEntity.setBusinessStage(BusinessStageEnum.放弃.getCode());
            //改项目阶段为未中标
        }else {
            //判断是跟踪还是中标
            QueryParam param = new QueryParam();
            param.getParams().put("sourceType", new Parameter(QueryParam.EQ, 1));
            param.getParams().put("sourceId", new Parameter(QueryParam.EQ, businessEntity.getId()));
            param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(
                    BillStateEnum.COMMITED_STATE.getBillStateCode(),
                    BillStateEnum.PASSED_STATE.getBillStateCode()
            )));
            List<ResultRegisterEntity> registerEntityList = resultRegisterService.queryList(param);
            if (CollectionUtils.isNotEmpty(registerEntityList) && registerEntityList.size() > 0){
                if (registerEntityList.get(0).getBidWinFlag()){
                    businessEntity.setBusinessStage(BusinessStageEnum.中标.getCode());
                    //改项目阶段为已中标
                    projectStatus = ArchiveProjectStatusEnum.已中标.getCode();
                }else {
                    //投标结果登记是未中标，则这里改为放弃（原来也是放弃，也可不做修改），也不改项目阶段
                    businessEntity.setBusinessStage(BusinessStageEnum.放弃.getCode());
                    //改项目阶段为未中标
                }
            }else {
                businessEntity.setBusinessStage(BusinessStageEnum.跟踪.getCode());
                //改项目阶段为
                //使用新接口通过子表判断到底改为 商机阶段、投标阶段

                QueryParam bidParam = new QueryParam();
                bidParam.getParams().put("projectId", new Parameter(QueryParam.EQ, businessEntity.getId()));
                bidParam.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(
                        BillStateEnum.COMMITED_STATE.getBillStateCode(),
                        BillStateEnum.PASSED_STATE.getBillStateCode()
                )));

                List<BidInitiationEntity> bidInitiationEntityList = bidInitiationService.queryList(bidParam);
                QueryParam tendParam = new QueryParam();
                tendParam.getParams().put("engineeringId", new Parameter(QueryParam.EQ, businessEntity.getId()));
                tendParam.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(
                        BillStateEnum.COMMITED_STATE.getBillStateCode(),
                        BillStateEnum.PASSED_STATE.getBillStateCode()
                )));
                List<TenderEvaluationEntity> tenderEvaluationEntityList = tenderEvaluationService.queryList(tendParam);
                if (bidInitiationEntityList.size() > 0 || tenderEvaluationEntityList.size() > 0){
                    projectStatus = ArchiveProjectStatusEnum.投标阶段.getCode();
                }else {
                    projectStatus = ArchiveProjectStatusEnum.商机阶段.getCode();
                }
            }
        }
        CommonResponse<String> projectArchiveRes = projectArchiveApi.updateProjectStatus(projectStatus, businessEntity.getId());
        if (!projectArchiveRes.isSuccess()){
            throw new BusinessException("修改项目阶段失败，原因-" + projectArchiveRes.getMsg());
        }
        if (!super.saveOrUpdate(businessEntity)){
            return CommonResponse.error("修改状态失败！");
        }
        return CommonResponse.success("修改状态成功！");
    }
}
