package com.ejianc.business.jlincome.income.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.jlincome.income.vo.SettleDetailVO;
import com.ejianc.business.jlincome.income.vo.SettleVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.jlincome.income.bean.SettleEntity;

import java.util.List;
import java.util.Map;

/**
 * 收入管理-对甲结算
 * 
 * @author generator
 * 
 */
public interface ISettleService extends IBaseService<SettleEntity> {


    CommonResponse<SettleVO> saveOrUpdate(SettleVO saveOrUpdateVO);
    /**
     * 查询合同相关结算详情
     * @param contractId
     * @return
     */
    CommonResponse<SettleVO> querySettle(Long contractId);
    CommonResponse<Map<Long, SettleDetailVO>> querySettleDetail(List<String> sourceDetailIds);


    void querySettleByContractId(Long contractId,Long id);

    JSONObject querySettleRecordByContId(Long contractId);

    Map<Long, JSONObject> querySettleRecordByContIdList(List<Long> contractIds);
}
