package com.ejianc.business.jlincome.performance.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jlincome.performance.bean.ForecastDetailEntity;
import com.ejianc.business.jlincome.performance.vo.ForecastLedgerVO;
import com.ejianc.business.jlincome.performance.vo.SaleReportTreeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlincome.performance.bean.SaleReportEntity;
import com.ejianc.business.jlincome.performance.service.ISaleReportService;
import com.ejianc.business.jlincome.performance.vo.SaleReportVO;

/**
 * 绩效管理_业绩完成报表
 *
 * @author generator
 */
@Controller
@RequestMapping("saleReport")
public class SaleReportController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";// 此处需要根据实际修改

    @Autowired
    private ISaleReportService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SaleReportVO> saveOrUpdate(@RequestBody SaleReportVO saveOrUpdateVO) {
        SaleReportEntity entity = BeanMapper.map(saveOrUpdateVO, SaleReportEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                // entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                // entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        SaleReportVO vo = BeanMapper.map(entity, SaleReportVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SaleReportVO> queryDetail(Long id) {
        SaleReportEntity entity = service.selectById(id);
        SaleReportVO vo = BeanMapper.map(entity, SaleReportVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SaleReportVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SaleReportVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SaleReportVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SaleReportTreeVO>> queryList(@RequestBody QueryParam param) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        /** 租户隔离 */
        // param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        //默认当前年度
        // param.getParams().put("year", new Parameter(QueryParam.EQ, LocalDate.now().getYear()));
        IPage<SaleReportEntity> page = service.queryPage(param, false);
        List<SaleReportTreeVO> resDatas = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(page.getRecords())) {
            resDatas = BeanMapper.mapList(page.getRecords(),SaleReportTreeVO.class);
            if(StringUtils.isNotEmpty(param.getSearchText())){
                //说明是模糊搜索  需要补全树形  逐级往下找
                Map<Long,SaleReportTreeVO> map = resDatas.stream().collect(Collectors.toMap(SaleReportTreeVO::getId,Function.identity()));
                LambdaQueryWrapper<SaleReportEntity> lambda = new LambdaQueryWrapper<SaleReportEntity>();
                lambda.in(SaleReportEntity::getParentId, map.keySet());
                List<SaleReportEntity> saleReportEntityList = service.list(lambda);
                if(CollectionUtils.isNotEmpty(saleReportEntityList)){
                    for(SaleReportEntity e:saleReportEntityList){
                        if(!map.containsKey(e.getId())){
                            resDatas.add(BeanMapper.map(e,SaleReportTreeVO.class));
                        }
                    }
                }
            }

            return CommonResponse.success("查询列表数据成功！(tree)", TreeNodeBUtil.buildTree(resDatas));
        }

        return CommonResponse.success("查询列表数据成功！", resDatas);
    }
    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList2", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SaleReportVO>> queryList2(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("year");
        /** 租户隔离 */
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        Long employeeId = sessionManager.getUserContext().getEmployeeId();
        param.getParams().put("employeeId", new Parameter(QueryParam.EQ, employeeId));
        IPage<SaleReportEntity> page = service.queryPage(param,false);
        IPage<SaleReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<SaleReportVO> resList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(page.getRecords())){
            resList = BeanMapper.mapList(page.getRecords(), SaleReportVO.class);
            //处理大区，区域名称问题
            Set<Long> parentIds = new HashSet<>();
            resList.forEach(e->{
                parentIds.add(e.getParentId());
            });
            LambdaQueryWrapper<SaleReportEntity> lambda = new LambdaQueryWrapper<SaleReportEntity>();
            lambda.in(SaleReportEntity::getId, parentIds);
            List<SaleReportEntity> saleReportEntityList = service.list(lambda);//小组数据
            Map<Long,SaleReportEntity> map = saleReportEntityList.stream().collect(Collectors.toMap(SaleReportEntity::getId,Function.identity()));
            Map<Long,SaleReportEntity> dqMap = new HashMap<>();
            Set<Long> dqIds = new HashSet<>();
            saleReportEntityList.forEach(e->{
                dqIds.add(e.getParentId());
            });
            if(CollectionUtils.isNotEmpty(dqIds)){
                LambdaQueryWrapper<SaleReportEntity> lambda2 = new LambdaQueryWrapper<SaleReportEntity>();
                lambda2.in(SaleReportEntity::getId, dqIds);
                List<SaleReportEntity> saleReportList = service.list(lambda2);//大区数据
                dqMap = saleReportList.stream().collect(Collectors.toMap(SaleReportEntity::getId,Function.identity()));
            }

            for(SaleReportVO e:resList){
                SaleReportEntity saleReportEntity = map.get(e.getParentId());  //上级信息
                if(null!=saleReportEntity&&null!=saleReportEntity.getSaleType()&&2==saleReportEntity.getSaleType()){
                    //说明上级是小组  需要再去上级大区的名称
                    e.setParentOrgName(dqMap.get(saleReportEntity.getParentId()).getOrgName());
                }
                if(null!=saleReportEntity){
                    e.setOrgName(saleReportEntity.getOrgName());
                }
            }
            pageData.setRecords(resList);
        }
        return CommonResponse.success("查询列表数据成功！",pageData);
    }



    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出 全部字段
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        // param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 模糊搜索配置字段示例 */
        fuzzyFields.add("orgName");
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SaleReportEntity> list = service.queryList(param);
        List<SaleReportTreeVO> resDatas = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            resDatas = BeanMapper.mapList(list,SaleReportTreeVO.class);
            if(StringUtils.isNotEmpty(param.getSearchText())){
                //说明是模糊搜索  需要补全树形  逐级往下找
                Map<Long,SaleReportTreeVO> map = resDatas.stream().collect(Collectors.toMap(SaleReportTreeVO::getId,Function.identity()));
                LambdaQueryWrapper<SaleReportEntity> lambda = new LambdaQueryWrapper<SaleReportEntity>();
                lambda.in(SaleReportEntity::getParentId, map.keySet());
                List<SaleReportEntity> saleReportEntityList = service.list(lambda);
                if(CollectionUtils.isNotEmpty(saleReportEntityList)){
                    for(SaleReportEntity e:saleReportEntityList){
                        if(!map.containsKey(e.getId())){
                            resDatas.add(BeanMapper.map(e,SaleReportTreeVO.class));
                        }
                    }
                }
            }
        }
        // todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", resDatas);
        ExcelExport.getInstance().export("SaleReportCurrentYear-export.xlsx", beans, response);
    }

    @RequestMapping(value = "/personalGradeExcelExport", method = RequestMethod.POST)
    @ResponseBody
    public void personalGradeExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        // param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SaleReportEntity> list = service.queryList(param);
        // todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PersonalGrade-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSaleReportData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SaleReportVO>> refSaleReportData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                 String condition,
                                                                 String searchObject,
                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SaleReportEntity> page = service.queryPage(param, false);
        IPage<SaleReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SaleReportVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * @Description 定时任务-抽取数据，计算实际完成业绩
     */
    @RequestMapping(value = "/savePoolDate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> savePoolDate(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray(param);
        logger.info("抽取数据，计算实际完成业绩  获取到的参数JSON是：" + param + "----");
        service.saveInitPoolDate(request.getHeader("authority"));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return CommonResponse.success("数据加载成功",simpleDateFormat.format(new Date()));
    }
}
