package com.ejianc.business.jlincome.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jlincome.income.bean.ContractRegisterDetailEntity;
import com.ejianc.business.jlincome.income.bean.DeductionEntity;
import com.ejianc.business.jlincome.income.enums.ChangeTypeEnum;
import com.ejianc.business.jlincome.income.service.IContractRegisterDetailService;
import com.ejianc.business.jlincome.income.vo.ContractRegisterDetailVO;
import com.ejianc.business.jlincome.income.vo.ContractRegisterVO;
import com.ejianc.business.jlincome.income.vo.ImportContractRegisterDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlincome.income.mapper.ContractRegisterMapper;
import com.ejianc.business.jlincome.income.bean.ContractRegisterEntity;
import com.ejianc.business.jlincome.income.service.IContractRegisterService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;

/**
 * 收入管理-合同登记
 *
 * @author generator
 *
 */
@Service("contractRegisterService")
public class ContractRegisterServiceImpl extends BaseServiceImpl<ContractRegisterMapper, ContractRegisterEntity> implements IContractRegisterService{
    @Autowired
    private IContractRegisterDetailService contractDetailService;

    @Override
    public boolean checkSameBillCode(ContractRegisterVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<ContractRegisterEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ContractRegisterEntity::getBillCode, vo.getBillCode());
        lambda.eq(ContractRegisterEntity::getTenantId, tenantId);
        if (null != vo.getId() && vo.getId() > 0) {
            lambda.ne(ContractRegisterEntity::getId, vo.getId());
        }
        return super.list(lambda).size() > 0;
    }

    @Override
    public void performanceStatusUp(Long id, Integer performanceStatus) {
        UpdateWrapper<ContractRegisterEntity> updateWrapper = new UpdateWrapper();
        updateWrapper.in("id",id);
        updateWrapper.set("performance_status",performanceStatus);
        super.update(updateWrapper);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<ImportContractRegisterDetailVO> successList = new ArrayList<>();
            List<ImportContractRegisterDetailVO> errorList = new ArrayList<>();

            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 9) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                if (result.size()>=1000){
                    throw new BusinessException("文件数据不能超过1000行，超过请分批次多次导入");
                }

                for (int i = 1; i < result.size(); i++) {
                    StringBuilder errorMessage = new StringBuilder();
                    List<String> datas = result.get(i);
                    ImportContractRegisterDetailVO importVO = new ImportContractRegisterDetailVO();

                    //产品名称
                    if (StringUtils.isBlank(datas.get(0))) {
                        errorMessage.append("[产品名称为必填项]");
                    } else {
                        if (datas.get(0).length() > 200){
                            importVO.setErrorMessage("填写产品名称长度为1~200字");
                        }
                        importVO.setDetailProductName(datas.get(0).trim());
                    }

                    //规格型号
                    if (StringUtils.isBlank(datas.get(1))) {
                        errorMessage.append("[规格型号为必填项]");
                    } else {
                        if (datas.get(1).length() > 200){
                            importVO.setErrorMessage("填写规格型号长度为1~200字");
                        }
                        importVO.setDetailSpec(datas.get(1).trim());
                    }

                    //单位
                    if (StringUtils.isBlank(datas.get(2))) {
                        errorMessage.append("[单位为必填项]");
                    } else {
                        if (datas.get(2).length() > 50){
                            importVO.setErrorMessage("填写单位长度为1~50字");
                        }
                        importVO.setDetailUnit(datas.get(2).trim());
                    }

                    //数量
                    if (StringUtils.isBlank(datas.get(3))) {
                        errorMessage.append("[数量为必填项]");
                    } else {
                        try {
                            importVO.setDetailNum(new BigDecimal(datas.get(3)));
                        } catch (Exception e) {
                            errorMessage.append("[数量必须为数字]");
                        }
                    }

                    //单价
                    if (StringUtils.isBlank(datas.get(4))) {
                        errorMessage.append("[单价为必填项]");
                    } else {
                        try {
                            importVO.setDetailTaxPrice(new BigDecimal(datas.get(4)));
                        } catch (Exception e) {
                            errorMessage.append("[单价必须为数字]");
                        }
                    }

                    //税率
                    if (StringUtils.isBlank(datas.get(5))) {
                        errorMessage.append("[税率为必填项]");
                    } else {
                        try {
                            importVO.setDetailRate(new BigDecimal(datas.get(5)));
                        } catch (Exception e) {
                            errorMessage.append("[税率必须为数字]");
                        }
                    }

                    //金额
                    if (StringUtils.isNotBlank(datas.get(6))) {
                        try {
                            importVO.setDetailTaxMny(new BigDecimal(datas.get(6)));
                        } catch (Exception e) {
                            errorMessage.append("[金额必须为数字]");
                        }
                    }

                    //预计交货日期
                    if (StringUtils.isNotBlank(datas.get(7))) {
                        try {
                            importVO.setDetailPlanDeliverDate(DateUtils.parseDate(datas.get(7), "YYYY-MM-dd"));
                        } catch (ParseException e) {
                            errorMessage.append("[预计交货日期填写格式错误，请填写 YYYY-MM-dd 类型的日期格式]");
                            e.printStackTrace();
                        }
                    }

                    //备注
                    if (datas.get(8).length() > 200) {
                        importVO.setErrorMessage("填写备注长度为0~200字");
                    }
                    importVO.setDetailMemo(datas.get(8));

                    importVO.setId(IdWorker.getId());
                    importVO.setSourceType(2);


                    if (StringUtils.isBlank(errorMessage)) {
                        //重算金额
                        importVO.setDetailTaxMny(ComputeUtil.safeMultiply(importVO.getDetailTaxPrice(), importVO.getDetailNum()));
                        //公式：无税=含税/（1+税率）
                        importVO.setDetailMny(ComputeUtil.safeDiv(importVO.getDetailTaxMny(), ComputeUtil.safeAdd(new BigDecimal(1), ComputeUtil.safeDiv(importVO.getDetailRate(), new BigDecimal(100)))));
                        importVO.setDetailPrice(ComputeUtil.safeDiv(importVO.getDetailTaxPrice(), ComputeUtil.safeAdd(new BigDecimal(1), ComputeUtil.safeDiv(importVO.getDetailRate(), new BigDecimal(100)))));
                        importVO.setDetailTax(ComputeUtil.safeSub(importVO.getDetailTaxMny(), importVO.getDetailMny()));
                        importVO.setChangeType(ChangeTypeEnum.未变更.getCode().toString());
                        successList.add(importVO);
                    }else {
                        importVO.setErrorMessage(String.valueOf(errorMessage));
                        errorList.add(importVO);
                    }
                }
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

    @Override
    public JSONObject queryContractMnyByProjectId(Long projectId) {
        LambdaQueryWrapper<ContractRegisterEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ContractRegisterEntity::getProjectId, projectId);
        queryWrapper.in(ContractRegisterEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<ContractRegisterEntity> contractList = super.list(queryWrapper);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("projectId", projectId);
        if (CollectionUtils.isNotEmpty(contractList) && contractList.size() > 0){
            jsonObject.put("contractMny", contractList.stream().filter(e -> null != e.getContractMny()).map(ContractRegisterEntity::getContractMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            jsonObject.put("contractTaxMny", contractList.stream().filter(e -> null != e.getContractTaxMny()).map(ContractRegisterEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            jsonObject.put("contractTax", contractList.stream().filter(e -> null != e.getContractTax()).map(ContractRegisterEntity::getContractTax).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        return jsonObject;
    }

    @Override
    public ContractRegisterVO queryDetail(Long id) {
        ContractRegisterEntity entity = super.selectById(id);
        entity.setDetailList(null);
        ContractRegisterVO contractVo = BeanMapper.map(entity, ContractRegisterVO.class);
        List<ContractRegisterDetailEntity> details = null;
        LambdaQueryWrapper<ContractRegisterDetailEntity> lambda = Wrappers.<ContractRegisterDetailEntity>lambdaQuery();
        lambda.eq(ContractRegisterDetailEntity::getContractRegisterId, id);
        lambda.ne(ContractRegisterDetailEntity::getChangeType, ChangeTypeEnum.终止项.getCode());
        details = contractDetailService.list(lambda);
        if (CollectionUtils.isNotEmpty(details)) {
            contractVo.setDetailList(BeanMapper.mapList(details, ContractRegisterDetailVO.class));
        }
        return contractVo;
    }

    @Override
    public Map<String, BigDecimal> queryContractMnyByReviewId(Long reviewId) {
        LambdaQueryWrapper<ContractRegisterEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ContractRegisterEntity::getReviewId, reviewId);
        queryWrapper.in(ContractRegisterEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<ContractRegisterEntity> contractList = super.list(queryWrapper);

        Map<String, BigDecimal> map = new HashMap<>();
        if (CollectionUtils.isNotEmpty(contractList) && contractList.size() > 0){
            map.put("contractMny", contractList.stream().filter(e -> null != e.getContractMny()).map(ContractRegisterEntity::getContractMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            map.put("contractTaxMny", contractList.stream().filter(e -> null != e.getContractTaxMny()).map(ContractRegisterEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        }else {
            map.put("contractMny", BigDecimal.ZERO);
            map.put("contractTaxMny", BigDecimal.ZERO);
        }
        return map;
    }
}
