/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlincome.income.bean.ContractRegisterChangeEntity;
import com.ejianc.business.jlincome.income.bean.ContractRegisterClauseEntity;
import com.ejianc.business.jlincome.income.bean.ContractRegisterDetailEntity;
import com.ejianc.business.jlincome.income.bean.ContractRegisterEntity;
import com.ejianc.business.jlincome.income.bean.ContractRegisterRecordEntity;
import com.ejianc.business.jlincome.income.enums.ChangeStatusEnum;
import com.ejianc.business.jlincome.income.service.IContractRegisterChangeService;
import com.ejianc.business.jlincome.income.service.IContractRegisterClauseService;
import com.ejianc.business.jlincome.income.service.IContractRegisterRecordService;
import com.ejianc.business.jlincome.income.service.IContractRegisterService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.consts.ArchiveProjectStatusEnum;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractRegisterChange")
public class ContractRegisterChangeBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IProjectArchiveApi projectArchiveApi;
    @Autowired
    private IContractRegisterChangeService contractRegisterChangeService;
    @Autowired
    private IContractRegisterService contractRegisterService;
    @Autowired
    private IContractRegisterRecordService contractRegisterRecordService;
    @Autowired
    private IContractRegisterClauseService contractClauseService;
    @Autowired
    private IAttachmentApi attachmentApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        ContractRegisterChangeEntity changeEntity = (ContractRegisterChangeEntity)((Object)this.contractRegisterChangeService.selectById(billId));
        changeEntity.setEffectDate(new Date());
        ContractRegisterEntity contractEntity = (ContractRegisterEntity)((Object)this.contractRegisterService.selectById(changeEntity.getContractId()));
        if (!contractEntity.getCustomerId().toString().equals(changeEntity.getCustomerId().toString())) {
            ProjectArchiveVO projectArchiveVO = new ProjectArchiveVO();
            projectArchiveVO.setId(changeEntity.getProjectId());
            projectArchiveVO.setCustomId(changeEntity.getCustomerId());
            projectArchiveVO.setCustomName(changeEntity.getCustomerName());
            projectArchiveVO.setCustomCode(changeEntity.getCustomerCode());
            projectArchiveVO.setProjectStatus(ArchiveProjectStatusEnum.\u5408\u540c\u9636\u6bb5.getCode());
            CommonResponse updateResponse = this.projectArchiveApi.updateProjectData(projectArchiveVO);
            if (!updateResponse.isSuccess()) {
                throw new BusinessException("\u66f4\u65b0\u9879\u76ee\u4fe1\u606f-\u5ba2\u6237\u4fe1\u606f\u5f02\u5e38\uff01");
            }
        }
        ContractRegisterRecordEntity recordEntity = (ContractRegisterRecordEntity)((Object)BeanMapper.map((Object)((Object)contractEntity), ContractRegisterRecordEntity.class));
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--- changeEntity:" + (Object)((Object)changeEntity) + "  contractEntity:" + (Object)((Object)contractEntity));
        recordEntity.setContractId(recordEntity.getId());
        recordEntity.setId(null);
        if (CollectionUtils.isNotEmpty(recordEntity.getDetailList())) {
            recordEntity.getDetailList().forEach(vo -> {
                vo.setContractId(contractEntity.getId());
                vo.setContractDetailId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getClauseList())) {
            recordEntity.getClauseList().forEach(vo -> {
                vo.setContractId(contractEntity.getId());
                vo.setContractClauseId(vo.getId());
                vo.setId(null);
            });
        }
        this.contractRegisterRecordService.saveOrUpdate((Object)recordEntity, false);
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--2");
        contractEntity.setChangeStatus(ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
        contractEntity.setBillCode(changeEntity.getBillCode());
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setUndertakeUnitId(changeEntity.getUndertakeUnitId());
        contractEntity.setUndertakeUnitName(changeEntity.getUndertakeUnitName());
        contractEntity.setCustomerId(changeEntity.getCustomerId());
        contractEntity.setCustomerCode(changeEntity.getCustomerCode());
        contractEntity.setCustomerName(changeEntity.getCustomerName());
        contractEntity.setCustomLinkName(changeEntity.getCustomLinkName());
        contractEntity.setCustomLinkPhone(changeEntity.getCustomLinkPhone());
        contractEntity.setProjectTypeId(changeEntity.getProjectTypeId());
        contractEntity.setProjectTypeName(changeEntity.getProjectTypeName());
        contractEntity.setProductType(changeEntity.getProductType());
        contractEntity.setProductTypeName(changeEntity.getProductTypeName());
        contractEntity.setDeliveryDate(changeEntity.getDeliveryDate());
        contractEntity.setSignDate(changeEntity.getSignDate());
        contractEntity.setReceiveDate(changeEntity.getReceiveDate());
        contractEntity.setTaxRate(changeEntity.getTaxRate());
        contractEntity.setSpecNum(changeEntity.getSpecNum());
        contractEntity.setContractTaxMny(changeEntity.getContractTaxMny());
        contractEntity.setContractMny(changeEntity.getContractMny());
        contractEntity.setContractTax(changeEntity.getContractTax());
        contractEntity.setWarrantyTaxMny(changeEntity.getWarrantyTaxMny());
        contractEntity.setWarrantyMny(changeEntity.getWarrantyMny());
        contractEntity.setSaleLeaderId(changeEntity.getSaleLeaderId());
        contractEntity.setSaleLeaderName(changeEntity.getSaleLeaderName());
        contractEntity.setSaleLeaderPhone(changeEntity.getSaleLeaderPhone());
        contractEntity.setEmployeeId(changeEntity.getEmployeeId());
        contractEntity.setEmployeeName(changeEntity.getEmployeeName());
        contractEntity.setDepartmentId(changeEntity.getDepartmentId());
        contractEntity.setDepartmentName(changeEntity.getDepartmentName());
        contractEntity.setPayCondition(changeEntity.getPayCondition());
        contractEntity.setMemo(changeEntity.getMemo());
        QueryWrapper deleteWrapper = new QueryWrapper();
        deleteWrapper.eq((Object)"contract_register_id", (Object)changeEntity.getContractId());
        this.contractClauseService.remove((Wrapper)deleteWrapper);
        contractEntity.setClauseList(null);
        if (CollectionUtils.isNotEmpty(changeEntity.getDetailList())) {
            this.logger.info("\u590d\u5236\u5b50\u8868\u5f00\u59cb--" + changeEntity.getDetailList());
            changeEntity.getDetailList().forEach(vo -> {
                this.logger.info("\u590d\u5236\u5b50\u8868--" + vo.getContractDetailId());
                if (null != vo.getContractDetailId()) {
                    Map<Long, Integer> map = contractEntity.getDetailList().stream().collect(Collectors.toMap(BaseEntity::getId, BaseEntity::getVersion));
                    vo.setId(vo.getContractDetailId());
                    vo.setVersion(map.get(vo.getContractDetailId()));
                }
            });
            contractEntity.setDetailList(BeanMapper.mapList(changeEntity.getDetailList(), ContractRegisterDetailEntity.class));
        }
        if (CollectionUtils.isNotEmpty(changeEntity.getClauseList())) {
            changeEntity.getClauseList().forEach(vo -> vo.setId(null));
            contractEntity.setClauseList(BeanMapper.mapList(changeEntity.getClauseList(), ContractRegisterClauseEntity.class));
        }
        boolean flag = this.contractRegisterService.saveOrUpdate((Object)contractEntity, false);
        this.contractRegisterChangeService.saveOrUpdate((Object)changeEntity);
        this.logger.info("\u4e1a\u52a1\u903b\u8f91\u5b8c\u6210--\u8fd4\u56de" + flag);
        if (flag) {
            this.attachmentApi.copyFiles(String.valueOf(billId), "EJCBT202405000046", "contractRegisterChangeFile", String.valueOf(contractEntity.getId()), "EJCBT202405000039", "contractRegisterFile", true);
            this.attachmentApi.copyFiles(String.valueOf(billId), "EJCBT202405000046", "contractRegisterMgrChangeFile", String.valueOf(contractEntity.getId()), "EJCBT202405000039", "contractMgrFile", true);
            return CommonResponse.success();
        }
        return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u8be5\u5355\u636e\u4e0d\u53ef\u64a4\u56de\uff01");
    }
}

