package com.ejianc.business.jlincome.income.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 收入管理-合同评审
 * 
 * @author generator
 * 
 */
 @TableName("ejc_income_review")
public class ReviewEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="org_id")
    private Long orgId; // 单据组织id
    @TableField(value="org_name")
    private String orgName; // 单据组织名称
    @TableField(value="org_code")
    private String orgCode; // 单据组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 所属组织编码/区域id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 所属组织编码/区域名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 所属组织编码/区域编码
    @TableField(value="review_type")
    private Integer reviewType; // 评审类型：1、100万以下；2、100以上
    @TableField(value="review_title")
    private String reviewTitle; // 评审标题
    @TableField(value="undertake_unit_id")
    private Long undertakeUnitId; // 承接单位
    @TableField(value="undertake_unit_name")
    private String undertakeUnitName; // 承接单位名称
    @TableField(value="customer_name")
    private String customerName; // 客户名称
    @TableField(value="product_type")
    private String productType; // 产品类型
    @TableField(value="product_type_name")
    private String productTypeName; // 产品类型名称
    @TableField(value="review_date")
    private Date reviewDate; // 评审日期
    @TableField(value="sale_leader_id")
    private Long saleLeaderId; // 销售负责人
    @TableField(value="sale_leader_name")
    private String saleLeaderName; // 销售负责人名称
    @TableField(value="sale_leader_phone")
    private String saleLeaderPhone; // 销售负责人联系电话
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同含税金额
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同无税金额
    @TableField(value="contract_tax")
    private BigDecimal contractTax; // 合同税额
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 合同税率
    @TableField(value="delivery_date")
    private Date deliveryDate; // 交货日期
    @TableField(value="product_name")
    private String productName; // 产品名称
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="num")
    private String num; // 数量
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="review_person_depart")
    private String reviewPersonDepart; // 评审人(部门)
    @TableField(value="review_result")
    private String reviewResult; // 评审结果
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="pay_condition")
    private String payCondition; // 付款条件
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="reviewDepartService",pidName = "reviewId")//此处有pid="xxx"，默认值pid="pid"
    private List<ReviewDepartEntity> departList = new ArrayList<>(); // 收入管理-合同评审-评审部门
    @TableField(exist=false)
    @SubEntity(serviceName="reviewRecordService",pidName = "reviewId")//此处有pid="xxx"，默认值pid="pid"
    private List<ReviewRecordEntity> recordList = new ArrayList<>(); // 收入管理-合同评审-评审记录
    @TableField(exist=false)
    @SubEntity(serviceName="reviewDetailService",pidName = "reviewId")//此处有pid="xxx"，默认值pid="pid"
    private List<ReviewDetailEntity> detailList = new ArrayList<>(); // 收入管理-合同评审-评审产品清单明细

    @TableField(value="contract_register_tax_mny")
    private BigDecimal contractRegisterTaxMny; // 合同登记含税金额
    @TableField(value="contract_register_mny")
    private BigDecimal contractRegisterMny; // 合同登记无税金额

    public BigDecimal getContractRegisterTaxMny() {
        return contractRegisterTaxMny;
    }

    public void setContractRegisterTaxMny(BigDecimal contractRegisterTaxMny) {
        this.contractRegisterTaxMny = contractRegisterTaxMny;
    }

    public BigDecimal getContractRegisterMny() {
        return contractRegisterMny;
    }

    public void setContractRegisterMny(BigDecimal contractRegisterMny) {
        this.contractRegisterMny = contractRegisterMny;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Integer getReviewType() {
        return reviewType;
    }

    public void setReviewType(Integer reviewType) {
        this.reviewType = reviewType;
    }
    public String getReviewTitle() {
        return reviewTitle;
    }

    public void setReviewTitle(String reviewTitle) {
        this.reviewTitle = reviewTitle;
    }
    public Long getUndertakeUnitId() {
        return undertakeUnitId;
    }

    public void setUndertakeUnitId(Long undertakeUnitId) {
        this.undertakeUnitId = undertakeUnitId;
    }
    public String getUndertakeUnitName() {
        return undertakeUnitName;
    }

    public void setUndertakeUnitName(String undertakeUnitName) {
        this.undertakeUnitName = undertakeUnitName;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public String getProductType() {
        return productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }
    public String getProductTypeName() {
        return productTypeName;
    }

    public void setProductTypeName(String productTypeName) {
        this.productTypeName = productTypeName;
    }
    public Date getReviewDate() {
        return reviewDate;
    }

    public void setReviewDate(Date reviewDate) {
        this.reviewDate = reviewDate;
    }
    public Long getSaleLeaderId() {
        return saleLeaderId;
    }

    public void setSaleLeaderId(Long saleLeaderId) {
        this.saleLeaderId = saleLeaderId;
    }
    public String getSaleLeaderName() {
        return saleLeaderName;
    }

    public void setSaleLeaderName(String saleLeaderName) {
        this.saleLeaderName = saleLeaderName;
    }
    public String getSaleLeaderPhone() {
        return saleLeaderPhone;
    }

    public void setSaleLeaderPhone(String saleLeaderPhone) {
        this.saleLeaderPhone = saleLeaderPhone;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public Date getDeliveryDate() {
        return deliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }
    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getNum() {
        return num;
    }

    public void setNum(String num) {
        this.num = num;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getReviewPersonDepart() {
        return reviewPersonDepart;
    }

    public void setReviewPersonDepart(String reviewPersonDepart) {
        this.reviewPersonDepart = reviewPersonDepart;
    }
    public String getReviewResult() {
        return reviewResult;
    }

    public void setReviewResult(String reviewResult) {
        this.reviewResult = reviewResult;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
    public List<ReviewDepartEntity> getDepartList() {
        return departList;
    }

    public void setDepartList(List<ReviewDepartEntity> departList) {
        this.departList = departList;
    }
    public List<ReviewRecordEntity> getRecordList() {
        return recordList;
    }

    public void setRecordList(List<ReviewRecordEntity> recordList) {
        this.recordList = recordList;
    }
    public List<ReviewDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ReviewDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public String getPayCondition() {
        return payCondition;
    }

    public void setPayCondition(String payCondition) {
        this.payCondition = payCondition;
    }
}
