/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.performance.controller;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlincome.performance.bean.SaleReportEntity;
import com.ejianc.business.jlincome.performance.service.ISaleReportService;
import com.ejianc.business.jlincome.performance.vo.PersonalGradeViewVO;
import com.ejianc.business.jlincome.performance.vo.SaleReportByMonthVO;
import com.ejianc.business.jlincome.performance.vo.SaleReportTreeVO;
import com.ejianc.business.jlincome.performance.vo.SaleReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"saleReport"})
public class SaleReportController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ISaleReportService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SaleReportVO> saveOrUpdate(@RequestBody SaleReportVO saveOrUpdateVO) {
        BillCodeParam billCodeParam;
        CommonResponse billCode;
        SaleReportEntity entity = (SaleReportEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SaleReportEntity.class));
        if (!(entity.getId() != null && entity.getId() != 0L || (billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO))).isSuccess())) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.service.saveOrUpdate((Object)entity, false);
        SaleReportVO vo = (SaleReportVO)BeanMapper.map((Object)((Object)entity), SaleReportVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SaleReportVO> queryDetail(Long id) {
        SaleReportEntity entity = (SaleReportEntity)((Object)this.service.selectById(id));
        SaleReportVO vo = (SaleReportVO)BeanMapper.map((Object)((Object)entity), SaleReportVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SaleReportVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SaleReportVO saleReportVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<SaleReportTreeVO>> queryList(@RequestBody QueryParam param) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        List<Object> resDatas = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            resDatas = BeanMapper.mapList((Iterable)page.getRecords(), SaleReportTreeVO.class);
            if (StringUtils.isNotEmpty((CharSequence)param.getSearchText())) {
                Map map = resDatas.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
                LambdaQueryWrapper lambda = new LambdaQueryWrapper();
                lambda.in(SaleReportEntity::getParentId, map.keySet());
                List saleReportEntityList = this.service.list((Wrapper)lambda);
                if (CollectionUtils.isNotEmpty((Collection)saleReportEntityList)) {
                    for (SaleReportEntity e : saleReportEntityList) {
                        if (map.containsKey(e.getId())) continue;
                        resDatas.add(BeanMapper.map((Object)((Object)e), SaleReportTreeVO.class));
                    }
                }
            }
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01(tree)", (Object)TreeNodeBUtil.buildTree(resDatas));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", resDatas);
    }

    @RequestMapping(value={"/queryList2"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SaleReportVO>> queryList2(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("year");
        Long employeeId = this.sessionManager.getUserContext().getEmployeeId();
        param.getParams().put("employeeId", new Parameter("eq", (Object)employeeId));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List resList = new ArrayList();
        ArrayList<SaleReportVO> resList2 = new ArrayList<SaleReportVO>();
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            resList = BeanMapper.mapList((Iterable)page.getRecords(), SaleReportVO.class);
            HashSet parentIds = new HashSet();
            resList.forEach(e -> parentIds.add(e.getParentId()));
            LambdaQueryWrapper lambda = new LambdaQueryWrapper();
            lambda.in(BaseEntity::getId, parentIds);
            List saleReportEntityList = this.service.list((Wrapper)lambda);
            Map map = saleReportEntityList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
            Map<Object, Object> dqMap = new HashMap();
            HashSet dqIds = new HashSet();
            saleReportEntityList.forEach(e -> dqIds.add(e.getParentId()));
            if (CollectionUtils.isNotEmpty(dqIds)) {
                LambdaQueryWrapper lambda2 = new LambdaQueryWrapper();
                lambda2.in(BaseEntity::getId, dqIds);
                List saleReportList = this.service.list((Wrapper)lambda2);
                dqMap = saleReportList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
            }
            for (SaleReportVO e2 : resList) {
                SaleReportEntity saleReportEntity = (SaleReportEntity)((Object)map.get(e2.getParentId()));
                if (null != saleReportEntity && null != saleReportEntity.getSaleType() && 2 == saleReportEntity.getSaleType()) {
                    e2.setParentOrgName(((SaleReportEntity)((Object)dqMap.get(saleReportEntity.getParentId()))).getOrgName());
                }
                if (null != saleReportEntity) {
                    e2.setOrgName(saleReportEntity.getOrgName());
                }
                if (null != e2.getSaleType()) continue;
                resList2.add(e2);
            }
            pageData.setRecords(resList2);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryList3"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PersonalGradeViewVO>> queryList3(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("year");
        String mouth = null;
        if (param.getParams().get("mouth") != null) {
            mouth = ((Parameter)param.getParams().get("mouth")).getValue().toString();
        } else {
            LocalDate currentDate = LocalDate.now();
            int currentMonth = currentDate.getMonthValue();
            if (currentMonth >= 1 && currentMonth <= 9) {
                mouth = "0" + String.valueOf(currentMonth);
            }
        }
        param.getParams().remove("mouth");
        ArrayList resList3 = new ArrayList();
        Long employeeId = this.sessionManager.getUserContext().getEmployeeId();
        param.getParams().put("employeeId", new Parameter("eq", (Object)employeeId));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List resList = new ArrayList();
        ArrayList<SaleReportVO> resList2 = new ArrayList<SaleReportVO>();
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            resList = BeanMapper.mapList((Iterable)page.getRecords(), SaleReportVO.class);
            HashSet parentIds = new HashSet();
            resList.forEach(e -> parentIds.add(e.getParentId()));
            LambdaQueryWrapper lambda = new LambdaQueryWrapper();
            lambda.in(BaseEntity::getId, parentIds);
            List saleReportEntityList = this.service.list((Wrapper)lambda);
            Map map = saleReportEntityList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
            Map<Object, Object> dqMap = new HashMap();
            HashSet dqIds = new HashSet();
            saleReportEntityList.forEach(e -> dqIds.add(e.getParentId()));
            if (CollectionUtils.isNotEmpty(dqIds)) {
                LambdaQueryWrapper lambda2 = new LambdaQueryWrapper();
                lambda2.in(BaseEntity::getId, dqIds);
                List saleReportList = this.service.list((Wrapper)lambda2);
                dqMap = saleReportList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
            }
            for (SaleReportVO e2 : resList) {
                SaleReportEntity saleReportEntity = (SaleReportEntity)((Object)map.get(e2.getParentId()));
                if (null != saleReportEntity && null != saleReportEntity.getSaleType() && 2 == saleReportEntity.getSaleType()) {
                    e2.setParentOrgName(((SaleReportEntity)((Object)dqMap.get(saleReportEntity.getParentId()))).getOrgName());
                }
                if (null != saleReportEntity) {
                    e2.setOrgName(saleReportEntity.getOrgName());
                }
                if (null != e2.getSaleType()) continue;
                resList2.add(e2);
            }
            List<PersonalGradeViewVO> personalGradeList = this.getPersonalGradeByMouth(mouth, resList2);
            pageData.setRecords(personalGradeList);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryList4"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<SaleReportByMonthVO>> queryList4(@RequestBody QueryParam param) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        String mouth = null;
        if (param.getParams().get("mouth") != null) {
            mouth = ((Parameter)param.getParams().get("mouth")).getValue().toString();
        } else {
            LocalDate currentDate = LocalDate.now();
            int currentMonth = currentDate.getMonthValue();
            if (currentMonth >= 1 && currentMonth <= 9) {
                mouth = "0" + String.valueOf(currentMonth);
            }
        }
        param.getParams().remove("mouth");
        this.logger.info("\u5f53\u524d\u6708\u4efd=====\u300b" + mouth);
        IPage page = this.service.queryPage(param, false);
        List<Object> resDatas = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            resDatas = BeanMapper.mapList((Iterable)page.getRecords(), SaleReportTreeVO.class);
            if (StringUtils.isNotEmpty((CharSequence)param.getSearchText())) {
                Map map = resDatas.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
                LambdaQueryWrapper lambda = new LambdaQueryWrapper();
                lambda.in(SaleReportEntity::getParentId, map.keySet());
                List saleReportEntityList = this.service.list((Wrapper)lambda);
                if (CollectionUtils.isNotEmpty((Collection)saleReportEntityList)) {
                    for (SaleReportEntity e2 : saleReportEntityList) {
                        if (map.containsKey(e2.getId())) continue;
                        resDatas.add(BeanMapper.map((Object)((Object)e2), SaleReportTreeVO.class));
                    }
                }
            }
            List<Object> listAll = new ArrayList();
            ArrayList<SaleReportVO> saleReportList = new ArrayList<SaleReportVO>();
            ArrayList saleReportByMonthList = new ArrayList();
            HashMap saleReportMap = new HashMap();
            resDatas.forEach(e -> {
                if (e.getId() != null) {
                    SaleReportVO saleReportVO = (SaleReportVO)BeanMapper.map((Object)e, SaleReportVO.class);
                    saleReportMap.put(e.getId(), saleReportVO);
                    System.out.println("e\uff1a");
                    System.out.println(JSONUtil.toJsonStr((Object)e));
                    saleReportList.add(saleReportVO);
                }
            });
            System.out.println("saleReport:");
            System.out.println(JSONUtil.toJsonStr(saleReportList));
            listAll = this.getPersonalGradeByMouth(mouth, saleReportList);
            listAll.forEach(e -> {
                if (e.getId() != null) {
                    SaleReportByMonthVO saleReportByMonthVO = (SaleReportByMonthVO)BeanMapper.map((Object)e, SaleReportByMonthVO.class);
                    saleReportByMonthVO.setParentId(((SaleReportVO)saleReportMap.get(e.getId())).getParentId());
                    saleReportByMonthVO.setOrgId(((SaleReportVO)saleReportMap.get(e.getId())).getOrgId());
                    saleReportByMonthVO.setOrgCode(((SaleReportVO)saleReportMap.get(e.getId())).getOrgCode());
                    saleReportByMonthVO.setTeamOrgId(((SaleReportVO)saleReportMap.get(e.getId())).getTeamOrgId());
                    saleReportByMonthVO.setTeamOrgCode(((SaleReportVO)saleReportMap.get(e.getId())).getTeamOrgCode());
                    saleReportByMonthVO.setTeamOrgName(((SaleReportVO)saleReportMap.get(e.getId())).getTeamOrgName());
                    saleReportByMonthVO.setEmployeeId(((SaleReportVO)saleReportMap.get(e.getId())).getEmployeeId());
                    saleReportByMonthList.add(saleReportByMonthVO);
                }
            });
            List saleReportTreeVOS = TreeNodeBUtil.buildTree(resDatas);
            System.out.println("resDatas:");
            System.out.println(JSONUtil.toJsonStr(resDatas));
            System.out.println("resDatasTree:");
            System.out.println(JSONUtil.toJsonStr((Object)saleReportTreeVOS));
            System.out.println("saleReportByMonthList:");
            System.out.println(JSONUtil.toJsonStr(saleReportByMonthList));
            List saleReportByMonthVOS = TreeNodeBUtil.buildTree(saleReportByMonthList);
            System.out.println("saleReportByMonthTree:");
            System.out.println(JSONUtil.toJsonStr((Object)saleReportByMonthVOS));
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01(tree)", (Object)TreeNodeBUtil.buildTree(saleReportByMonthList));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", null);
    }

    private List<PersonalGradeViewVO> getPersonalGradeByMouth(String mouth, List<SaleReportVO> saleReportList) {
        ArrayList<PersonalGradeViewVO> personalGradeList = new ArrayList<PersonalGradeViewVO>();
        if (mouth.equals("01")) {
            saleReportList.forEach(e -> {
                PersonalGradeViewVO vo = this.setBaseInfo(new PersonalGradeViewVO(), (SaleReportVO)e);
                BigDecimal saleEndThisMouth = e.getSaleFirstOneMny();
                vo.setSaleEndThisMouth(saleEndThisMouth);
                vo.setSaleThisMouth(e.getSaleFirstOneMny());
                BigDecimal kpEndThisMouth = e.getKpFirstOneMny();
                vo.setKpEndThisMouth(kpEndThisMouth);
                vo.setKpThisMouth(e.getKpFirstOneMny());
                BigDecimal skEndThisMouth = e.getSkFirstOneMny();
                vo.setSkEndThisMouth(skEndThisMouth);
                vo.setSkThisMouth(e.getSkFirstOneMny());
                personalGradeList.add(vo);
            });
        }
        if (mouth.equals("02")) {
            saleReportList.forEach(e -> {
                PersonalGradeViewVO vo = this.setBaseInfo(new PersonalGradeViewVO(), (SaleReportVO)e);
                List<BigDecimal> saleMny = Arrays.asList(e.getSaleFirstOneMny(), e.getSaleFirstTwoMny());
                BigDecimal saleEndThisMouth = SaleReportController.sum(saleMny);
                vo.setSaleEndThisMouth(saleEndThisMouth);
                vo.setSaleThisMouth(e.getSaleFirstTwoMny());
                List<BigDecimal> kpMny = Arrays.asList(e.getKpFirstOneMny(), e.getKpFirstTwoMny());
                BigDecimal kpEndThisMouth = SaleReportController.sum(kpMny);
                vo.setKpEndThisMouth(kpEndThisMouth);
                vo.setKpThisMouth(e.getKpFirstTwoMny());
                List<BigDecimal> skMny = Arrays.asList(e.getSkFirstOneMny(), e.getSkFirstTwoMny());
                BigDecimal skEndThisMouth = SaleReportController.sum(skMny);
                vo.setSkEndThisMouth(skEndThisMouth);
                vo.setSkThisMouth(e.getSkFirstTwoMny());
                personalGradeList.add(vo);
            });
        }
        if (mouth.equals("03")) {
            saleReportList.forEach(e -> {
                PersonalGradeViewVO vo = this.setBaseInfo(new PersonalGradeViewVO(), (SaleReportVO)e);
                List<BigDecimal> saleMny = Arrays.asList(e.getSaleFirstOneMny(), e.getSaleFirstTwoMny(), e.getSaleFirstThreeMny());
                BigDecimal saleEndThisMouth = SaleReportController.sum(saleMny);
                vo.setSaleEndThisMouth(saleEndThisMouth);
                vo.setSaleThisMouth(e.getSaleFirstThreeMny());
                List<BigDecimal> kpMny = Arrays.asList(e.getKpFirstOneMny(), e.getKpFirstTwoMny(), e.getKpFirstThreeMny());
                BigDecimal kpEndThisMouth = SaleReportController.sum(kpMny);
                vo.setKpEndThisMouth(kpEndThisMouth);
                vo.setKpThisMouth(e.getKpFirstThreeMny());
                List<BigDecimal> skMny = Arrays.asList(e.getSkFirstOneMny(), e.getSkFirstTwoMny(), e.getSkFirstThreeMny());
                BigDecimal skEndThisMouth = SaleReportController.sum(skMny);
                vo.setSkEndThisMouth(skEndThisMouth);
                vo.setSkThisMouth(e.getSkFirstThreeMny());
                personalGradeList.add(vo);
            });
        }
        if (mouth.equals("04")) {
            saleReportList.forEach(e -> {
                PersonalGradeViewVO vo = this.setBaseInfo(new PersonalGradeViewVO(), (SaleReportVO)e);
                List<BigDecimal> saleMny = Arrays.asList(e.getSaleFirstOneMny(), e.getSaleFirstTwoMny(), e.getSaleFirstThreeMny(), e.getSaleSecondFourMny());
                BigDecimal saleEndThisMouth = SaleReportController.sum(saleMny);
                vo.setSaleEndThisMouth(saleEndThisMouth);
                vo.setSaleThisMouth(e.getSaleSecondFourMny());
                List<BigDecimal> kpMny = Arrays.asList(e.getKpFirstOneMny(), e.getKpFirstTwoMny(), e.getKpFirstThreeMny(), e.getKpSecondFourMny());
                BigDecimal kpEndThisMouth = SaleReportController.sum(kpMny);
                vo.setKpEndThisMouth(kpEndThisMouth);
                vo.setKpThisMouth(e.getKpSecondFourMny());
                List<BigDecimal> skMny = Arrays.asList(e.getSkFirstOneMny(), e.getSkFirstTwoMny(), e.getSkFirstThreeMny(), e.getSkSecondFourMny());
                BigDecimal skEndThisMouth = SaleReportController.sum(skMny);
                vo.setSkEndThisMouth(skEndThisMouth);
                vo.setSkThisMouth(e.getSkSecondFourMny());
                personalGradeList.add(vo);
            });
        }
        if (mouth.equals("05")) {
            saleReportList.forEach(e -> {
                PersonalGradeViewVO vo = this.setBaseInfo(new PersonalGradeViewVO(), (SaleReportVO)e);
                List<BigDecimal> saleMny = Arrays.asList(e.getSaleFirstOneMny(), e.getSaleFirstTwoMny(), e.getSaleFirstThreeMny(), e.getSaleSecondFourMny(), e.getSaleSecondFiveMny());
                BigDecimal saleEndThisMouth = SaleReportController.sum(saleMny);
                vo.setSaleEndThisMouth(saleEndThisMouth);
                vo.setSaleThisMouth(e.getSaleSecondFiveMny());
                List<BigDecimal> kpMny = Arrays.asList(e.getKpFirstOneMny(), e.getKpFirstTwoMny(), e.getKpFirstThreeMny(), e.getKpSecondFourMny(), e.getKpSecondFiveMny());
                BigDecimal kpEndThisMouth = SaleReportController.sum(kpMny);
                vo.setKpEndThisMouth(kpEndThisMouth);
                vo.setKpThisMouth(e.getKpSecondFiveMny());
                List<BigDecimal> skMny = Arrays.asList(e.getSkFirstOneMny(), e.getSkFirstTwoMny(), e.getSkFirstThreeMny(), e.getSkSecondFourMny(), e.getSkSecondFiveMny());
                BigDecimal skEndThisMouth = SaleReportController.sum(skMny);
                vo.setSkEndThisMouth(skEndThisMouth);
                vo.setSkThisMouth(e.getSkSecondFiveMny());
                personalGradeList.add(vo);
            });
        }
        if (mouth.equals("06")) {
            saleReportList.forEach(e -> {
                PersonalGradeViewVO vo = this.setBaseInfo(new PersonalGradeViewVO(), (SaleReportVO)e);
                List<BigDecimal> saleMny = Arrays.asList(e.getSaleFirstOneMny(), e.getSaleFirstTwoMny(), e.getSaleFirstThreeMny(), e.getSaleSecondFourMny(), e.getSaleSecondFiveMny(), e.getSaleSecondSixMny());
                BigDecimal saleEndThisMouth = SaleReportController.sum(saleMny);
                vo.setSaleEndThisMouth(saleEndThisMouth);
                vo.setSaleThisMouth(e.getSaleSecondSixMny());
                List<BigDecimal> kpMny = Arrays.asList(e.getKpFirstOneMny(), e.getKpFirstTwoMny(), e.getKpFirstThreeMny(), e.getKpSecondFourMny(), e.getKpSecondFiveMny(), e.getKpSecondSixMny());
                BigDecimal kpEndThisMouth = SaleReportController.sum(kpMny);
                vo.setKpEndThisMouth(kpEndThisMouth);
                vo.setKpThisMouth(e.getKpSecondSixMny());
                List<BigDecimal> skMny = Arrays.asList(e.getSkFirstOneMny(), e.getSkFirstTwoMny(), e.getSkFirstThreeMny(), e.getSkSecondFourMny(), e.getSkSecondFiveMny(), e.getSkSecondSixMny());
                BigDecimal skEndThisMouth = SaleReportController.sum(skMny);
                vo.setSkEndThisMouth(skEndThisMouth);
                vo.setSkThisMouth(e.getSkSecondSixMny());
                personalGradeList.add(vo);
            });
        }
        if (mouth.equals("07")) {
            saleReportList.forEach(e -> {
                PersonalGradeViewVO vo = this.setBaseInfo(new PersonalGradeViewVO(), (SaleReportVO)e);
                List<BigDecimal> saleMny = Arrays.asList(e.getSaleFirstOneMny(), e.getSaleFirstTwoMny(), e.getSaleFirstThreeMny(), e.getSaleSecondFourMny(), e.getSaleSecondFiveMny(), e.getSaleSecondSixMny(), e.getSaleThirdSevenMny());
                BigDecimal saleEndThisMouth = SaleReportController.sum(saleMny);
                vo.setSaleEndThisMouth(saleEndThisMouth);
                vo.setSaleThisMouth(e.getSaleThirdSevenMny());
                List<BigDecimal> kpMny = Arrays.asList(e.getKpFirstOneMny(), e.getKpFirstTwoMny(), e.getKpFirstThreeMny(), e.getKpSecondFourMny(), e.getKpSecondFiveMny(), e.getKpSecondSixMny(), e.getKpThirdSevenMny());
                BigDecimal kpEndThisMouth = SaleReportController.sum(kpMny);
                vo.setKpEndThisMouth(kpEndThisMouth);
                vo.setKpThisMouth(e.getKpThirdSevenMny());
                List<BigDecimal> skMny = Arrays.asList(e.getSkFirstOneMny(), e.getSkFirstTwoMny(), e.getSkFirstThreeMny(), e.getSkSecondFourMny(), e.getSkSecondFiveMny(), e.getSkSecondSixMny(), e.getSkThirdSevenMny());
                BigDecimal skEndThisMouth = SaleReportController.sum(skMny);
                vo.setSkEndThisMouth(skEndThisMouth);
                vo.setSkThisMouth(e.getSkThirdSevenMny());
                personalGradeList.add(vo);
            });
        }
        if (mouth.equals("08")) {
            saleReportList.forEach(e -> {
                PersonalGradeViewVO vo = this.setBaseInfo(new PersonalGradeViewVO(), (SaleReportVO)e);
                List<BigDecimal> saleMny = Arrays.asList(e.getSaleFirstOneMny(), e.getSaleFirstTwoMny(), e.getSaleFirstThreeMny(), e.getSaleSecondFourMny(), e.getSaleSecondFiveMny(), e.getSaleSecondSixMny(), e.getSaleThirdSevenMny(), e.getSaleThirdEightMny());
                BigDecimal saleEndThisMouth = SaleReportController.sum(saleMny);
                vo.setSaleEndThisMouth(saleEndThisMouth);
                vo.setSaleThisMouth(e.getSaleThirdEightMny());
                List<BigDecimal> kpMny = Arrays.asList(e.getKpFirstOneMny(), e.getKpFirstTwoMny(), e.getKpFirstThreeMny(), e.getKpSecondFourMny(), e.getKpSecondFiveMny(), e.getKpSecondSixMny(), e.getKpThirdSevenMny(), e.getKpThirdEightMny());
                BigDecimal kpEndThisMouth = SaleReportController.sum(kpMny);
                vo.setKpEndThisMouth(kpEndThisMouth);
                vo.setKpThisMouth(e.getKpThirdEightMny());
                List<BigDecimal> skMny = Arrays.asList(e.getSkFirstOneMny(), e.getSkFirstTwoMny(), e.getSkFirstThreeMny(), e.getSkSecondFourMny(), e.getSkSecondFiveMny(), e.getSkSecondSixMny(), e.getSkThirdSevenMny(), e.getSkThirdEightMny());
                BigDecimal skEndThisMouth = SaleReportController.sum(skMny);
                vo.setSkEndThisMouth(skEndThisMouth);
                vo.setSkThisMouth(e.getSkThirdEightMny());
                personalGradeList.add(vo);
            });
        }
        if (mouth.equals("09")) {
            saleReportList.forEach(e -> {
                PersonalGradeViewVO vo = this.setBaseInfo(new PersonalGradeViewVO(), (SaleReportVO)e);
                List<BigDecimal> saleMny = Arrays.asList(e.getSaleFirstOneMny(), e.getSaleFirstTwoMny(), e.getSaleFirstThreeMny(), e.getSaleSecondFourMny(), e.getSaleSecondFiveMny(), e.getSaleSecondSixMny(), e.getSaleThirdSevenMny(), e.getSaleThirdEightMny(), e.getSaleThirdNineMny());
                BigDecimal saleEndThisMouth = SaleReportController.sum(saleMny);
                vo.setSaleEndThisMouth(saleEndThisMouth);
                vo.setSaleThisMouth(e.getSaleThirdNineMny());
                List<BigDecimal> kpMny = Arrays.asList(e.getKpFirstOneMny(), e.getKpFirstTwoMny(), e.getKpFirstThreeMny(), e.getKpSecondFourMny(), e.getKpSecondFiveMny(), e.getKpSecondSixMny(), e.getKpThirdSevenMny(), e.getKpThirdEightMny(), e.getKpThirdNineMny());
                BigDecimal kpEndThisMouth = SaleReportController.sum(kpMny);
                vo.setKpEndThisMouth(kpEndThisMouth);
                vo.setKpThisMouth(e.getKpThirdNineMny());
                List<BigDecimal> skMny = Arrays.asList(e.getSkFirstOneMny(), e.getSkFirstTwoMny(), e.getSkFirstThreeMny(), e.getSkSecondFourMny(), e.getSkSecondFiveMny(), e.getSkSecondSixMny(), e.getSkThirdSevenMny(), e.getSkThirdEightMny(), e.getSkThirdNineMny());
                BigDecimal skEndThisMouth = SaleReportController.sum(skMny);
                vo.setSkEndThisMouth(skEndThisMouth);
                vo.setSkThisMouth(e.getSkThirdNineMny());
                personalGradeList.add(vo);
            });
        }
        if (mouth.equals("10")) {
            saleReportList.forEach(e -> {
                PersonalGradeViewVO vo = this.setBaseInfo(new PersonalGradeViewVO(), (SaleReportVO)e);
                List<BigDecimal> saleMny = Arrays.asList(e.getSaleFirstOneMny(), e.getSaleFirstTwoMny(), e.getSaleFirstThreeMny(), e.getSaleSecondFourMny(), e.getSaleSecondFiveMny(), e.getSaleSecondSixMny(), e.getSaleThirdSevenMny(), e.getSaleThirdEightMny(), e.getSaleThirdNineMny(), e.getSaleFourthTenMny());
                BigDecimal saleEndThisMouth = SaleReportController.sum(saleMny);
                vo.setSaleEndThisMouth(saleEndThisMouth);
                vo.setSaleThisMouth(e.getSaleFourthTenMny());
                List<BigDecimal> kpMny = Arrays.asList(e.getKpFirstOneMny(), e.getKpFirstTwoMny(), e.getKpFirstThreeMny(), e.getKpSecondFourMny(), e.getKpSecondFiveMny(), e.getKpSecondSixMny(), e.getKpThirdSevenMny(), e.getKpThirdEightMny(), e.getKpThirdNineMny(), e.getKpFourthTenMny());
                BigDecimal kpEndThisMouth = SaleReportController.sum(kpMny);
                vo.setKpEndThisMouth(kpEndThisMouth);
                vo.setKpThisMouth(e.getKpFourthTenMny());
                List<BigDecimal> skMny = Arrays.asList(e.getSkFirstOneMny(), e.getSkFirstTwoMny(), e.getSkFirstThreeMny(), e.getSkSecondFourMny(), e.getSkSecondFiveMny(), e.getSkSecondSixMny(), e.getSkThirdSevenMny(), e.getSkThirdEightMny(), e.getSkThirdNineMny(), e.getSkFourthTenMny());
                BigDecimal skEndThisMouth = SaleReportController.sum(skMny);
                vo.setSkEndThisMouth(skEndThisMouth);
                vo.setSkThisMouth(e.getSkFourthTenMny());
                personalGradeList.add(vo);
            });
        }
        if (mouth.equals("11")) {
            saleReportList.forEach(e -> {
                PersonalGradeViewVO vo = this.setBaseInfo(new PersonalGradeViewVO(), (SaleReportVO)e);
                List<BigDecimal> saleMny = Arrays.asList(e.getSaleFirstOneMny(), e.getSaleFirstTwoMny(), e.getSaleFirstThreeMny(), e.getSaleSecondFourMny(), e.getSaleSecondFiveMny(), e.getSaleSecondSixMny(), e.getSaleThirdSevenMny(), e.getSaleThirdEightMny(), e.getSaleThirdNineMny(), e.getSaleFourthTenMny(), e.getSaleFourthElevenMny());
                BigDecimal saleEndThisMouth = SaleReportController.sum(saleMny);
                vo.setSaleEndThisMouth(saleEndThisMouth);
                vo.setSaleThisMouth(e.getSaleFourthElevenMny());
                List<BigDecimal> kpMny = Arrays.asList(e.getKpFirstOneMny(), e.getKpFirstTwoMny(), e.getKpFirstThreeMny(), e.getKpSecondFourMny(), e.getKpSecondFiveMny(), e.getKpSecondSixMny(), e.getKpThirdSevenMny(), e.getKpThirdEightMny(), e.getKpThirdNineMny(), e.getKpFourthTenMny(), e.getKpFourthElevenMny());
                BigDecimal kpEndThisMouth = SaleReportController.sum(kpMny);
                vo.setKpEndThisMouth(kpEndThisMouth);
                vo.setKpThisMouth(e.getKpFourthElevenMny());
                List<BigDecimal> skMny = Arrays.asList(e.getSkFirstOneMny(), e.getSkFirstTwoMny(), e.getSkFirstThreeMny(), e.getSkSecondFourMny(), e.getSkSecondFiveMny(), e.getSkSecondSixMny(), e.getSkThirdSevenMny(), e.getSkThirdEightMny(), e.getSkThirdNineMny(), e.getSkFourthTenMny(), e.getSkFourthElevenMny());
                BigDecimal skEndThisMouth = SaleReportController.sum(skMny);
                vo.setSkEndThisMouth(skEndThisMouth);
                vo.setSkThisMouth(e.getSkFourthElevenMny());
                personalGradeList.add(vo);
            });
        }
        if (mouth.equals("12")) {
            saleReportList.forEach(e -> {
                PersonalGradeViewVO vo = this.setBaseInfo(new PersonalGradeViewVO(), (SaleReportVO)e);
                List<BigDecimal> saleMny = Arrays.asList(e.getSaleFirstOneMny(), e.getSaleFirstTwoMny(), e.getSaleFirstThreeMny(), e.getSaleSecondFourMny(), e.getSaleSecondFiveMny(), e.getSaleSecondSixMny(), e.getSaleThirdSevenMny(), e.getSaleThirdEightMny(), e.getSaleThirdNineMny(), e.getSaleFourthTenMny(), e.getSaleFourthElevenMny(), e.getSaleFourthTwelveMny());
                BigDecimal saleEndThisMouth = SaleReportController.sum(saleMny);
                vo.setSaleEndThisMouth(saleEndThisMouth);
                vo.setSaleThisMouth(e.getSaleFourthTwelveMny());
                List<BigDecimal> kpMny = Arrays.asList(e.getKpFirstOneMny(), e.getKpFirstTwoMny(), e.getKpFirstThreeMny(), e.getKpSecondFourMny(), e.getKpSecondFiveMny(), e.getKpSecondSixMny(), e.getKpThirdSevenMny(), e.getKpThirdEightMny(), e.getKpThirdNineMny(), e.getKpFourthTenMny(), e.getKpFourthElevenMny(), e.getKpFourthTwelveMny());
                BigDecimal kpEndThisMouth = SaleReportController.sum(kpMny);
                vo.setKpEndThisMouth(kpEndThisMouth);
                vo.setKpThisMouth(e.getKpFourthTwelveMny());
                List<BigDecimal> skMny = Arrays.asList(e.getSkFirstOneMny(), e.getSkFirstTwoMny(), e.getSkFirstThreeMny(), e.getSkSecondFourMny(), e.getSkSecondFiveMny(), e.getSkSecondSixMny(), e.getSkThirdSevenMny(), e.getSkThirdEightMny(), e.getSkThirdNineMny(), e.getSkFourthTenMny(), e.getSkFourthElevenMny(), e.getSkFourthTwelveMny());
                BigDecimal skEndThisMouth = SaleReportController.sum(skMny);
                vo.setSkEndThisMouth(skEndThisMouth);
                vo.setSkThisMouth(e.getSkFourthTwelveMny());
                personalGradeList.add(vo);
            });
        }
        return personalGradeList;
    }

    public static BigDecimal sum(List<BigDecimal> bigDecimals) {
        BigDecimal sum = BigDecimal.ZERO;
        for (BigDecimal bd : bigDecimals) {
            sum = ComputeUtil.safeAdd((BigDecimal)sum, (BigDecimal)bd);
        }
        return sum;
    }

    private PersonalGradeViewVO setBaseInfo(PersonalGradeViewVO personalGradeViewVO, SaleReportVO saleReportVO) {
        personalGradeViewVO.setId(saleReportVO.getId());
        personalGradeViewVO.setOrgName(saleReportVO.getOrgName());
        personalGradeViewVO.setEmployeeName(saleReportVO.getEmployeeName());
        personalGradeViewVO.setYear(saleReportVO.getYear());
        personalGradeViewVO.setSaleYearTaskMny(saleReportVO.getSaleYearTaskMny());
        personalGradeViewVO.setKpYearTaskMny(saleReportVO.getKpYearTaskMny());
        personalGradeViewVO.setSkYearTaskMny(saleReportVO.getSkYearTaskMny());
        return personalGradeViewVO;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.setPageIndex(1);
        param.setPageSize(-1);
        fuzzyFields.add("orgName");
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List<Object> resDatas = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resDatas = BeanMapper.mapList((Iterable)list, SaleReportTreeVO.class);
            if (StringUtils.isNotEmpty((CharSequence)param.getSearchText())) {
                Map map = resDatas.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
                LambdaQueryWrapper lambda = new LambdaQueryWrapper();
                lambda.in(SaleReportEntity::getParentId, map.keySet());
                List saleReportEntityList = this.service.list((Wrapper)lambda);
                if (CollectionUtils.isNotEmpty((Collection)saleReportEntityList)) {
                    for (SaleReportEntity e : saleReportEntityList) {
                        if (map.containsKey(e.getId())) continue;
                        resDatas.add(BeanMapper.map((Object)((Object)e), SaleReportTreeVO.class));
                    }
                }
            }
        }
        HashMap<String, List<Object>> beans = new HashMap<String, List<Object>>();
        beans.put("records", resDatas);
        ExcelExport.getInstance().export("SaleReportCurrentYear-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/saleReortBySaleType12ExcelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void saleReortBySaleType12ExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        String mouth = null;
        if (param.getParams().get("mouth") != null) {
            mouth = ((Parameter)param.getParams().get("mouth")).getValue().toString();
        } else {
            LocalDate currentDate = LocalDate.now();
            int currentMonth = currentDate.getMonthValue();
            if (currentMonth >= 1 && currentMonth <= 9) {
                mouth = "0" + String.valueOf(currentMonth);
            }
        }
        param.getParams().remove("mouth");
        this.logger.info("\u5f53\u524d\u6708\u4efd=====\u300b" + mouth);
        IPage page = this.service.queryPage(param, false);
        List<Object> resDatas = new ArrayList();
        List<Object> listAll = new ArrayList();
        ArrayList<SaleReportVO> saleReportList = new ArrayList<SaleReportVO>();
        ArrayList saleReportByMonthList = new ArrayList();
        HashMap saleReportMap = new HashMap();
        ArrayList saleReportByMonthExport = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            resDatas = BeanMapper.mapList((Iterable)page.getRecords(), SaleReportTreeVO.class);
            if (StringUtils.isNotEmpty((CharSequence)param.getSearchText())) {
                Map map = resDatas.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
                LambdaQueryWrapper lambda = new LambdaQueryWrapper();
                lambda.in(SaleReportEntity::getParentId, map.keySet());
                List saleReportEntityList = this.service.list((Wrapper)lambda);
                if (CollectionUtils.isNotEmpty((Collection)saleReportEntityList)) {
                    for (SaleReportEntity e2 : saleReportEntityList) {
                        if (map.containsKey(e2.getId())) continue;
                        resDatas.add(BeanMapper.map((Object)((Object)e2), SaleReportTreeVO.class));
                    }
                }
            }
            resDatas.forEach(e -> {
                if (e.getId() != null) {
                    SaleReportVO saleReportVO = (SaleReportVO)BeanMapper.map((Object)e, SaleReportVO.class);
                    saleReportMap.put(e.getId(), saleReportVO);
                    System.out.println("e\uff1a");
                    System.out.println(JSONUtil.toJsonStr((Object)e));
                    saleReportList.add(saleReportVO);
                }
            });
            System.out.println("saleReport:");
            System.out.println(JSONUtil.toJsonStr(saleReportList));
            listAll = this.getPersonalGradeByMouth(mouth, saleReportList);
            listAll.forEach(e -> {
                if (e.getId() != null) {
                    SaleReportByMonthVO saleReportByMonthVO = (SaleReportByMonthVO)BeanMapper.map((Object)e, SaleReportByMonthVO.class);
                    saleReportByMonthVO.setParentId(((SaleReportVO)saleReportMap.get(e.getId())).getParentId());
                    saleReportByMonthVO.setOrgId(((SaleReportVO)saleReportMap.get(e.getId())).getOrgId());
                    saleReportByMonthVO.setOrgCode(((SaleReportVO)saleReportMap.get(e.getId())).getOrgCode());
                    saleReportByMonthVO.setTeamOrgId(((SaleReportVO)saleReportMap.get(e.getId())).getTeamOrgId());
                    saleReportByMonthVO.setTeamOrgCode(((SaleReportVO)saleReportMap.get(e.getId())).getTeamOrgCode());
                    saleReportByMonthVO.setTeamOrgName(((SaleReportVO)saleReportMap.get(e.getId())).getTeamOrgName());
                    saleReportByMonthVO.setEmployeeId(((SaleReportVO)saleReportMap.get(e.getId())).getEmployeeId());
                    saleReportByMonthList.add(saleReportByMonthVO);
                }
            });
            List saleReportTreeVOS = TreeNodeBUtil.buildTree(resDatas);
            System.out.println("resDatas:");
            System.out.println(JSONUtil.toJsonStr(resDatas));
            System.out.println("resDatasTree:");
            System.out.println(JSONUtil.toJsonStr((Object)saleReportTreeVOS));
            System.out.println("saleReportByMonthList:");
            System.out.println(JSONUtil.toJsonStr(saleReportByMonthList));
            List saleReportByMonthVOS = TreeNodeBUtil.buildTree(saleReportByMonthList);
            System.out.println("saleReportByMonthTree:");
            System.out.println(JSONUtil.toJsonStr((Object)saleReportByMonthVOS));
            ArrayList<Long> ids = new ArrayList<Long>();
            saleReportByMonthList.forEach(e -> {
                if (e.getParentId().equals(999L)) {
                    ids.add(e.getId());
                }
            });
            ids.add(999L);
            saleReportByMonthList.forEach(e -> {
                if (ids.contains(e.getParentId())) {
                    saleReportByMonthExport.add(e);
                }
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", saleReportByMonthExport);
        ExcelExport.getInstance().export("SaleReportByMonth-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/personalGradeExcelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void personalGradeExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PersonalGrade-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSaleReportData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SaleReportVO>> refSaleReportData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SaleReportVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/savePoolDate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> savePoolDate(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray((String)param);
        this.logger.info("\u62bd\u53d6\u6570\u636e\uff0c\u8ba1\u7b97\u5b9e\u9645\u5b8c\u6210\u4e1a\u7ee9  \u83b7\u53d6\u5230\u7684\u53c2\u6570JSON\u662f\uff1a" + param + "----");
        this.service.saveInitPoolDate(request.getHeader("authority"));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return CommonResponse.success((String)"\u6570\u636e\u52a0\u8f7d\u6210\u529f", (Object)simpleDateFormat.format(new Date()));
    }
}

