/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jlincome.income.bean.ContractRegisterChangeDetailEntity;
import com.ejianc.business.jlincome.income.bean.ContractRegisterChangeEntity;
import com.ejianc.business.jlincome.income.bean.ContractRegisterEntity;
import com.ejianc.business.jlincome.income.enums.ChangeStatusEnum;
import com.ejianc.business.jlincome.income.enums.ChangeTypeEnum;
import com.ejianc.business.jlincome.income.mapper.ContractRegisterChangeMapper;
import com.ejianc.business.jlincome.income.service.IContractRegisterChangeDetailService;
import com.ejianc.business.jlincome.income.service.IContractRegisterChangeService;
import com.ejianc.business.jlincome.income.service.IContractRegisterService;
import com.ejianc.business.jlincome.income.vo.ContractRegisterChangeClauseVO;
import com.ejianc.business.jlincome.income.vo.ContractRegisterChangeDetailVO;
import com.ejianc.business.jlincome.income.vo.ContractRegisterChangeVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractRegisterChangeService")
public class ContractRegisterChangeServiceImpl
extends BaseServiceImpl<ContractRegisterChangeMapper, ContractRegisterChangeEntity>
implements IContractRegisterChangeService {
    @Autowired
    private IContractRegisterService contractRegisterService;
    @Autowired
    private IContractRegisterChangeDetailService contractChangeDetailService;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public ContractRegisterChangeVO addConvertByConId(Long contractId) {
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)this.contractRegisterService.selectById(contractId));
        ContractRegisterChangeVO changeVo = (ContractRegisterChangeVO)BeanMapper.map((Object)((Object)entity), ContractRegisterChangeVO.class);
        changeVo.setContractId(contractId);
        changeVo.setId(Long.valueOf(IdWorker.getId()));
        changeVo.setBillState(null);
        changeVo.setCreateUserCode(null);
        changeVo.setCreateTime(null);
        changeVo.setUpdateUserCode(null);
        changeVo.setUpdateTime(null);
        changeVo.setChangeDate(new Date());
        changeVo.setBeforeContractName(entity.getContractName());
        changeVo.setBeforeChangeMny(entity.getContractMny());
        changeVo.setBeforeChangeTaxMny(entity.getContractTaxMny());
        changeVo.setBeforeContractName(changeVo.getContractName());
        ArrayList<ContractRegisterChangeDetailVO> detailVOList = new ArrayList<ContractRegisterChangeDetailVO>();
        if (CollectionUtils.isNotEmpty((Collection)changeVo.getDetailList())) {
            for (ContractRegisterChangeDetailVO detailVO : changeVo.getDetailList()) {
                if (null != detailVO.getChangeType() && ChangeTypeEnum.\u7ec8\u6b62\u9879.getCode().toString().equals(detailVO.getChangeType())) continue;
                detailVO.setChangeType(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode().toString());
                detailVO.setContractDetailId(detailVO.getId());
                detailVO.setContractId(contractId);
                detailVO.setBeforeChangeNum(detailVO.getDetailNum());
                detailVO.setBeforeChangePrice(detailVO.getDetailTaxPrice());
                detailVO.setBeforeChangeRate(detailVO.getDetailRate());
                detailVO.setRowState("edit");
                detailVOList.add(detailVO);
            }
            changeVo.setDetailList(detailVOList);
        }
        if (CollectionUtils.isNotEmpty((Collection)changeVo.getClauseList())) {
            for (ContractRegisterChangeClauseVO contractRegisterChangeClauseVO : changeVo.getClauseList()) {
                contractRegisterChangeClauseVO.setContractClauseId(contractId);
                contractRegisterChangeClauseVO.setContractId(contractId);
                contractRegisterChangeClauseVO.setRowState("add");
            }
        }
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(contractId), "EJCBT202405000039", "contractRegisterFile", String.valueOf(changeVo.getId()), "EJCBT202405000046", "contractRegisterChangeFile");
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(contractId), "EJCBT202405000039", "contractMgrFile", String.valueOf(changeVo.getId()), "EJCBT202405000046", "contractRegisterMgrChangeFile");
        return changeVo;
    }

    @Override
    public ContractRegisterChangeVO queryChangeRecordByContId(Long id) {
        ContractRegisterChangeVO changeVO = new ContractRegisterChangeVO();
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)this.contractRegisterService.selectById(id));
        BigDecimal baseTaxMny = entity.getBaseTaxMny() == null ? BigDecimal.ZERO : entity.getBaseTaxMny();
        BigDecimal contractTaxMny = entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny();
        changeVO.setId(id);
        changeVO.setBaseTaxMny(baseTaxMny);
        changeVO.setPerformanceStatus(entity.getPerformanceStatus());
        changeVO.setChangeStatus(entity.getChangeStatus());
        changeVO.setContractTaxMny(contractTaxMny);
        changeVO.setSumChangeMny(contractTaxMny.subtract(baseTaxMny));
        if (changeVO.getSumChangeMny().compareTo(BigDecimal.ZERO) != 0 && baseTaxMny.compareTo(BigDecimal.ZERO) != 0) {
            changeVO.setSumScale(new BigDecimal(100).multiply(changeVO.getSumChangeMny().divide(baseTaxMny, 8, 5)));
        } else {
            changeVO.setSumScale(BigDecimal.ZERO);
        }
        if (null != entity.getChangeVersion() && entity.getChangeVersion() > 0) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(ContractRegisterChangeEntity::getContractId, (Object)id);
            lambda.in(ContractRegisterChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
            lambda.orderByDesc(ContractRegisterChangeEntity::getChangeVersion);
            List entities = super.list((Wrapper)lambda);
            changeVO.setChangeRecord(BeanMapper.mapList((Iterable)entities, ContractRegisterChangeVO.class));
        }
        return changeVO;
    }

    @Override
    public CommonResponse<ContractRegisterChangeVO> saveOrUpdate(ContractRegisterChangeVO contractChangeVO) {
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        ContractRegisterChangeEntity entity = null;
        List entitiesc = null;
        List entities = null;
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(ContractRegisterChangeEntity::getContractId, (Object)contractChangeVO.getContractId());
        if (contractChangeVO.getId() != null && contractChangeVO.getId() > 0L) {
            lambdachange.ne(BaseEntity::getId, (Object)contractChangeVO.getId());
        }
        lambdachange.ne(ContractRegisterChangeEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(ContractRegisterChangeEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count((Wrapper)lambdachange);
        if (num > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        ContractRegisterEntity parentEntity = (ContractRegisterEntity)((Object)this.contractRegisterService.selectById(contractChangeVO.getContractId()));
        if (contractChangeVO.getId() != null && contractChangeVO.getId() > 0L && super.getById((Serializable)contractChangeVO.getId()) != null) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(ContractRegisterChangeEntity::getBillCode, (Object)contractChangeVO.getBillCode());
            lambda.ne(ContractRegisterChangeEntity::getContractId, (Object)contractChangeVO.getContractId());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)contractChangeVO.getBillCode()));
            queryParam.getParams().put("id", new Parameter("ne", (Object)contractChangeVO.getContractId()));
            entitiesc = this.contractRegisterService.queryList(queryParam, false);
            parentEntity.setId(contractChangeVO.getContractId());
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(ContractRegisterChangeEntity::getBillCode, (Object)contractChangeVO.getBillCode());
            lambda.ne(ContractRegisterChangeEntity::getContractId, (Object)contractChangeVO.getContractId());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)contractChangeVO.getBillCode()));
            queryParam.getParams().put("id", new Parameter("ne", (Object)contractChangeVO.getContractId()));
            entitiesc = this.contractRegisterService.queryList(queryParam, false);
            parentEntity.setId(contractChangeVO.getContractId());
            parentEntity.setChangeVersion(contractChangeVO.getChangeVersion() + 1);
            contractChangeVO.setChangeVersion(Integer.valueOf(contractChangeVO.getChangeVersion() + 1));
        }
        if (CollectionUtils.isNotEmpty((Collection)entities) || CollectionUtils.isNotEmpty((Collection)entitiesc)) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        if (CollectionUtils.isNotEmpty((Collection)contractChangeVO.getDetailList())) {
            contractChangeVO.getDetailList().forEach(vo -> {
                if (this.isInsertContractChange(contractChangeVO)) {
                    vo.setId(null);
                }
                if ("del".equals(vo.getRowState()) && null != vo.getContractId()) {
                    vo.setChangeType(ChangeTypeEnum.\u7ec8\u6b62\u9879.getCode().toString());
                    vo.setRowState("edit");
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)contractChangeVO.getClauseList())) {
            contractChangeVO.getClauseList().forEach(vo -> {
                if (this.isInsertContractChange(contractChangeVO)) {
                    vo.setId(null);
                }
            });
        }
        entity = (ContractRegisterChangeEntity)((Object)BeanMapper.map((Object)contractChangeVO, ContractRegisterChangeEntity.class));
        entity.setChangeCode(entity.getBillCode() + "-" + entity.getChangeVersion());
        super.saveOrUpdate((Object)entity, false);
        parentEntity.setChangeStatus(ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        parentEntity.setChangingMny(entity.getContractMny());
        parentEntity.setChangingTaxMny(entity.getContractTaxMny());
        parentEntity.setChangeDate(entity.getChangeDate());
        parentEntity.setChangeCode(entity.getBillCode() + "-" + entity.getChangeVersion());
        parentEntity.setChangeId(entity.getId());
        parentEntity.setChangeContractName(entity.getContractName());
        this.contractRegisterService.update((Object)parentEntity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)parentEntity.getId()), false);
        ContractRegisterChangeVO res = (ContractRegisterChangeVO)BeanMapper.map((Object)this.queryDetail(entity.getId()), ContractRegisterChangeVO.class);
        return CommonResponse.success((Object)res);
    }

    private boolean isInsertContractChange(ContractRegisterChangeVO contractChangeVO) {
        return contractChangeVO.getId() == null || contractChangeVO.getId() == 0L;
    }

    @Override
    public void deleteContractChange(List<ContractRegisterChangeVO> vos) {
        ContractRegisterChangeVO changeVo = vos.get(0);
        ContractRegisterChangeEntity entity = (ContractRegisterChangeEntity)((Object)super.selectById((Serializable)changeVo.getId()));
        ContractRegisterEntity parentEntity = (ContractRegisterEntity)((Object)this.contractRegisterService.selectById(entity.getContractId()));
        parentEntity.setId(entity.getContractId());
        parentEntity.setChangeVersion(parentEntity.getChangeVersion() - 1);
        parentEntity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        if (super.list((Wrapper)new QueryWrapper().eq((Object)"contract_id", (Object)entity.getContractId())).size() > 1) {
            parentEntity.setChangeStatus(ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
        }
        parentEntity.setChangingMny(BigDecimal.ZERO);
        parentEntity.setChangingTaxMny(BigDecimal.ZERO);
        parentEntity.setChangeCode(null);
        parentEntity.setChangeId(null);
        this.contractRegisterService.update((Object)parentEntity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)parentEntity.getId()), false);
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }

    @Override
    public ContractRegisterChangeVO queryDetail(Long id) {
        ContractRegisterChangeEntity entity = (ContractRegisterChangeEntity)((Object)super.selectById((Serializable)id));
        entity.setDetailList(null);
        ContractRegisterChangeVO contractVo = (ContractRegisterChangeVO)BeanMapper.map((Object)((Object)entity), ContractRegisterChangeVO.class);
        List details = null;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ContractRegisterChangeDetailEntity::getContractRegisterId, (Object)id);
        lambda.ne(ContractRegisterChangeDetailEntity::getChangeType, (Object)ChangeTypeEnum.\u7ec8\u6b62\u9879.getCode());
        details = this.contractChangeDetailService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            contractVo.setDetailList(BeanMapper.mapList((Iterable)details, ContractRegisterChangeDetailVO.class));
        }
        return contractVo;
    }
}

