/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.jlincome.income.bean.ContractRegisterEntity;
import com.ejianc.business.jlincome.income.enums.PerformanceStatusEnum;
import com.ejianc.business.jlincome.income.service.IContractRegisterService;
import com.ejianc.business.jlincome.income.service.IReviewService;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.consts.ArchiveProjectStatusEnum;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractRegister")
public class ContractRegisterBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IProjectArchiveApi projectArchiveApi;
    @Autowired
    private IContractRegisterService contractRegisterService;
    @Autowired
    private IReviewService reviewService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ContractRegisterEntity contractRegisterEntity = (ContractRegisterEntity)((Object)this.contractRegisterService.selectById(billId));
        ProjectArchiveVO projectArchiveVO = new ProjectArchiveVO();
        projectArchiveVO.setId(contractRegisterEntity.getProjectId());
        if (null != contractRegisterEntity.getCustomerId()) {
            projectArchiveVO.setCustomId(contractRegisterEntity.getCustomerId());
            projectArchiveVO.setCustomName(contractRegisterEntity.getCustomerName());
            projectArchiveVO.setCustomCode(contractRegisterEntity.getCustomerCode());
        }
        projectArchiveVO.setProjectStatus(ArchiveProjectStatusEnum.\u5408\u540c\u9636\u6bb5.getCode());
        CommonResponse updateResponse = this.projectArchiveApi.updateProjectData(projectArchiveVO);
        if (!updateResponse.isSuccess()) {
            throw new BusinessException("\u66f4\u65b0\u9879\u76ee\u4fe1\u606f-\u5ba2\u6237\u4fe1\u606f\u5f02\u5e38\uff01");
        }
        contractRegisterEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        contractRegisterEntity.setEffectDate(new Date());
        this.contractRegisterService.saveOrUpdate((Object)contractRegisterEntity);
        Map<String, BigDecimal> contractMnyByReviewIdMap = this.contractRegisterService.queryContractMnyByReviewId(contractRegisterEntity.getReviewId());
        this.logger.info("\u83b7\u53d6\u5408\u540c\u767b\u8bb0\u5360\u7528\u5408\u540c\u8bc4\u5ba1\u91d1\u989d\uff1acontractMnyByReviewIdMap-{}", (Object)JSONObject.toJSONString(contractMnyByReviewIdMap));
        UpdateWrapper reviewUpdateWrapper = new UpdateWrapper();
        reviewUpdateWrapper.eq((Object)"id", (Object)contractRegisterEntity.getReviewId());
        reviewUpdateWrapper.set((Object)"contract_register_tax_mny", (Object)contractMnyByReviewIdMap.get("contractMny"));
        reviewUpdateWrapper.set((Object)"contract_register_mny", (Object)contractMnyByReviewIdMap.get("contractTaxMny"));
        this.reviewService.update((Wrapper)reviewUpdateWrapper);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        ContractRegisterEntity contractRegisterEntity = (ContractRegisterEntity)((Object)this.contractRegisterService.selectById(billId));
        ProjectArchiveVO projectArchiveVO = new ProjectArchiveVO();
        projectArchiveVO.setId(contractRegisterEntity.getProjectId());
        projectArchiveVO.setCustomId(null);
        projectArchiveVO.setCustomName(null);
        projectArchiveVO.setCustomCode(null);
        projectArchiveVO.setProjectStatus(ArchiveProjectStatusEnum.\u5408\u540c\u9636\u6bb5.getCode());
        CommonResponse updateResponse = this.projectArchiveApi.updateProjectData(projectArchiveVO);
        if (!updateResponse.isSuccess()) {
            throw new BusinessException("\u66f4\u65b0\u9879\u76ee\u4fe1\u606f-\u5ba2\u6237\u4fe1\u606f\u5f02\u5e38\uff01");
        }
        contractRegisterEntity.setPerformanceStatus(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode());
        contractRegisterEntity.setEffectDate(null);
        this.contractRegisterService.saveOrUpdate((Object)contractRegisterEntity);
        Map<String, BigDecimal> contractMnyByReviewIdMap = this.contractRegisterService.queryContractMnyByReviewId(contractRegisterEntity.getReviewId());
        this.logger.info("\u83b7\u53d6\u5408\u540c\u767b\u8bb0\u5360\u7528\u5408\u540c\u8bc4\u5ba1\u91d1\u989d\uff1acontractMnyByReviewIdMap-{}", (Object)JSONObject.toJSONString(contractMnyByReviewIdMap));
        UpdateWrapper reviewUpdateWrapper = new UpdateWrapper();
        reviewUpdateWrapper.eq((Object)"id", (Object)contractRegisterEntity.getReviewId());
        reviewUpdateWrapper.set((Object)"contract_register_tax_mny", (Object)contractMnyByReviewIdMap.get("contractMny"));
        reviewUpdateWrapper.set((Object)"contract_register_mny", (Object)contractMnyByReviewIdMap.get("contractTaxMny"));
        this.reviewService.update((Wrapper)reviewUpdateWrapper);
        return CommonResponse.success();
    }
}

