package com.ejianc.business.jlincome.bid.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ejianc.business.jlincome.bid.bean.BusinessEntity;
import com.ejianc.business.jlincome.bid.mapper.BusinessMapper;
import com.ejianc.business.jlincome.bid.service.IBusinessService;
import com.ejianc.business.jlincome.bid.vo.EngineeringReportExportVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlincome.bid.bean.EngineeringReportEntity;
import com.ejianc.business.jlincome.bid.service.IEngineeringReportService;
import com.ejianc.business.jlincome.bid.vo.EngineeringReportVO;

/**
 * 投标-工程调研报告
 *
 * @author generator
 */
@Controller
@RequestMapping("engineeringReport")
public class EngineeringReportController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IBusinessService businessService;

    private static final String BILL_CODE = "EResearch";//此处需要根据实际修改

    @Autowired
    private IEngineeringReportService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private BusinessMapper businessMapper;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<EngineeringReportVO> saveOrUpdate(@RequestBody EngineeringReportVO saveOrUpdateVO) {
        EngineeringReportEntity entity = BeanMapper.map(saveOrUpdateVO, EngineeringReportEntity.class);
        if (saveOrUpdateVO.getIsAssist()) {
            entity.setIsAssist(1);
        } else {
            entity.setIsAssist(0);
        }
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        EngineeringReportVO vo = BeanMapper.map(entity, EngineeringReportVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EngineeringReportVO> queryDetail(Long id) {
        EngineeringReportEntity entity = service.selectById(id);

        EngineeringReportVO vo = BeanMapper.map(entity, EngineeringReportVO.class);
        if (entity.getIsAssist() == 1) {
            vo.setIsAssist(true);
        } else {
            vo.setIsAssist(false);
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EngineeringReportVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (EngineeringReportVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(EngineeringReportVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<EngineeringReportVO>> queryList(@RequestBody QueryParam param) {

/*        // 获取整个map参数
        Map<String, Parameter> params = param.getParams();
        for (Map.Entry<String, Parameter> stringParameterEntry : params.entrySet()) {

            // 获取key
            String key = stringParameterEntry.getKey();


            Parameter value = stringParameterEntry.getValue();
            // 获取value
            Object value1 = value.getValue();

            if (key.equals("isAssist") && value1.equals("0")) {
                param.getParams().put("isAssist", new Parameter(QueryParam.EQ, 1));
            }
            if (key.equals("isAssist") && value1.equals("1")) {
                param.getParams().put("isAssist", new Parameter(QueryParam.EQ, 0));
            }
        }*/

        Parameter isAssist = param.getParams().get("isAssist");
        if (isAssist != null) {
            Object value = isAssist.getValue();
            if ( value.equals("0")) {
                param.getParams().put("isAssist", new Parameter(QueryParam.EQ, 1));
            }
            if ( value.equals("1")) {
                param.getParams().put("isAssist", new Parameter(QueryParam.EQ, 0));
            }
        }

        /** 模糊搜索配置字段示例 */
        extracted(param);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<EngineeringReportEntity> page = service.queryPage(param, false);
        IPage<EngineeringReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), EngineeringReportVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        Parameter isAssist = param.getParams().get("isAssist");
        if (isAssist != null) {
            Object value = isAssist.getValue();
            if ( value.equals("0")) {
                param.getParams().put("isAssist", new Parameter(QueryParam.EQ, 1));
            }
            if ( value.equals("1")) {
                param.getParams().put("isAssist", new Parameter(QueryParam.EQ, 0));
            }
        }
        /** 模糊搜索配置字段示例 */
        extracted(param);
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<EngineeringReportEntity> list = service.queryList(param);
        List<EngineeringReportExportVO> engineeringReportExportList = BeanMapper.mapList(list, EngineeringReportExportVO.class);

        for (EngineeringReportExportVO engineeringReportExportVO : engineeringReportExportList) {
            if (engineeringReportExportVO.getIsAssist() == 1) {
                engineeringReportExportVO.setNeedAssistance("是");
            } else {
                engineeringReportExportVO.setNeedAssistance("否");
            }
            if(engineeringReportExportVO.getBillState()==0){
                engineeringReportExportVO.setState("自由态");
            }
            if(engineeringReportExportVO.getBillState()==2||engineeringReportExportVO.getBillState()==5){
                engineeringReportExportVO.setState("审批中");
            }
            if(engineeringReportExportVO.getBillState()==1){
                engineeringReportExportVO.setState("已提交");
            }
            if(engineeringReportExportVO.getBillState()==3){
                engineeringReportExportVO.setState("审批通过");
            }
            if(engineeringReportExportVO.getBillState()==4){
                engineeringReportExportVO.setState("审批驳回");
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", engineeringReportExportList);
        ExcelExport.getInstance().export("EngineeringReport-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refEngineeringReportData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<EngineeringReportVO>> refEngineeringReportData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                               String condition,
                                                                               String searchObject,
                                                                               String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<EngineeringReportEntity> page = service.queryPage(param, false);
        IPage<EngineeringReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), EngineeringReportVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 修订时查询最新的数据
     * @param id
     * @return
     */
    @GetMapping("/selectLatest")
    @ResponseBody
    public CommonResponse selectMoney(String id) {
        LambdaQueryWrapper<BusinessEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(BusinessEntity::getId,id);
        BusinessEntity businessEntity = businessMapper.selectOne(wrapper);
        return CommonResponse.success("成功", businessEntity);
    }

    private static void extracted(QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        //模糊搜索：单据编号、工程名称、区域名称、客户名称、业主单位、设计单位、经办人
        fuzzyFields.add("billCode");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("customName");
        fuzzyFields.add("ownerCompany");
        fuzzyFields.add("designCompany");
        fuzzyFields.add("employeeName");
    }
}
