package com.ejianc.business.jlincome.income.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.ejianc.business.jlincome.bid.bean.ResultRegisterEntity;
import com.ejianc.business.jlincome.income.bean.DisclosureDepDetailsEntity;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.google.gson.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlincome.income.mapper.DisclosureMapper;
import com.ejianc.business.jlincome.income.bean.DisclosureEntity;
import com.ejianc.business.jlincome.income.service.IDisclosureService;

import java.util.ArrayList;
import java.util.List;

/**
 * 收入管理-合同交底
 * 
 * @author generator
 * 
 */
@Service("disclosureService")
public class DisclosureServiceImpl extends BaseServiceImpl<DisclosureMapper, DisclosureEntity> implements IDisclosureService{

    @Autowired
    private IPushMessageApi pushMessageApi;

    private static final String PC_URL = "/ejc-jlincome-frontend/#/disclosure/card?id=";
    private static final String MOBILE_URL = "/ejc-jlincome-mobile/#/disclosure/card?id=";


    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Override
    public String sendMsgToInstallPerson(DisclosureEntity entity) {
        logger.info("部门负责人”推送系统消息，OA消息（钉钉消息）");
        //消息内容：XXX项目有一项重要的合同交底需要查看！！！支持链接打开查看详情
        String msg = this.sendMsg(entity,"部门负责人”推送系统消息，OA消息（钉钉消息）",entity.getProjectName()+"项目有一项重要的合同交底需要查看！！！");
        if (StringUtils.isNotBlank(msg)){
            logger.error("部门负责人”推送系统消息，OA消息（钉钉消息） 异常：" + msg);
        }
        logger.info("部门负责人”推送系统消息，OA消息（钉钉消息）结束！");
        return msg;
    }

    private String sendMsg(DisclosureEntity entity, String subject, String content) {
        //disclosureDepDetailsList
        List<DisclosureDepDetailsEntity> list = entity.getDisclosureDepDetailsList();

        List<String> idList=new ArrayList<>();
        for (DisclosureDepDetailsEntity details : list) {

            String id = details.getDepartmentPeopleId();
            idList.add(id);
        }

        String[] departmentPeopleIds=idList.stream().toArray(String[]::new);
        logger.info("消息接收人: {}", StringUtils.join(departmentPeopleIds, ","));

        PushMsgParameter msgParameter = new PushMsgParameter();
        //消息接收人
        msgParameter.setReceivers(departmentPeopleIds);
        //消息内容
        msgParameter.setContent(content);
        //消息主题
        msgParameter.setSubject(content);
        //消息类型
        msgParameter.setMsgType("bpmpass");
        msgParameter.setTenantId(entity.getTenantId().toString());
        //消息保存
        msgParameter.setSaveFlag(true);
        //消息发送人
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        //消息发送渠道
        msgParameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS, "zhiyuanoa"});
        msgParameter.setPcUrl(PC_URL+entity.getId());
        msgParameter.setMobileUrl(MOBILE_URL+entity.getId());
        CommonResponse<String> msgSendResp = pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }


}
