package com.ejianc.business.jlincome.income.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlincome.income.bean.ReviewDetailEntity;
import com.ejianc.business.jlincome.income.bean.SettleDetailEntity;
import com.ejianc.business.jlincome.income.service.IReviewDetailService;
import com.ejianc.business.jlincome.income.vo.ReviewDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.*;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlincome.income.bean.ReviewEntity;
import com.ejianc.business.jlincome.income.service.IReviewService;
import com.ejianc.business.jlincome.income.vo.ReviewVO;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 收入管理-合同评审
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("review")
public class ReviewController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "HTPSC";//此处需要根据实际修改

    @Autowired
    private IReviewService service;
    @Autowired
    private IReviewDetailService detailsService;
    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReviewVO> saveOrUpdate(@RequestBody ReviewVO saveOrUpdateVO) {
    	ReviewEntity entity = BeanMapper.map(saveOrUpdateVO, ReviewEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
            List<ReviewDetailEntity> detailList = entity.getDetailList();
            boolean upFlag = false;
            BigDecimal contractTaxMny = BigDecimal.ZERO;
            BigDecimal contractMny = BigDecimal.ZERO;
            BigDecimal contractTax = BigDecimal.ZERO;
            for (ReviewDetailEntity item : detailList) {
                if (null == item.getRowState() || !item.getRowState().equals("del")) {
                    upFlag = true;
                    contractTaxMny = ComputeUtil.safeAdd(contractTaxMny,item.getDetailTaxMny());
                    contractMny = ComputeUtil.safeAdd(contractMny,item.getDetailMny());
                    contractTax = ComputeUtil.safeAdd(contractTax,item.getDetailTax());
                }
            }
            if (upFlag){
                entity.setContractTaxMny(contractTaxMny);
                entity.setContractMny(contractMny);
                entity.setContractTax(contractTax);
            }
        }
        service.saveOrUpdate(entity, false);
    	ReviewVO vo = BeanMapper.map(entity, ReviewVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReviewVO> queryDetail(Long id) {
    	ReviewEntity entity = service.selectById(id);
    	ReviewVO vo = BeanMapper.map(entity, ReviewVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ReviewVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ReviewVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ReviewVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReviewVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("reviewTitle");
        fuzzyFields.add("undertakeUnitName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("reviewResult");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<ReviewEntity> page = service.queryPage(param,false);
        IPage<ReviewVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ReviewVO> reviewVOS = BeanMapper.mapList(page.getRecords(), ReviewVO.class);
        reviewVOS.forEach(reviewVO -> {
            reviewVO.setReviewTypeStr(reviewVO.getReviewType() == 1 ? "100万以下" : "100万以上");
        });
        pageData.setRecords(reviewVOS);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/queryDetailList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReviewDetailVO>> queryDetailList(@RequestBody QueryParam param) {
        Integer pageIndex =  param.getPageIndex();
        Integer pageSize =  param.getPageSize();

        Map<String, Parameter> params = param.getParams();
        Map<String, Object> queryParam = new HashMap<>();

        if (null!=params&&params.containsKey("reviewDate")){
            String reviewDate = (String) params.get("reviewDate").getValue();
            String[] split = reviewDate.split(",");
            String startDate = split[0];
            String endDate =  split[1];
            queryParam.put("startDate",startDate);
            queryParam.put("endDate",endDate);
        }
        pageIndex = pageIndex < 1 ? 0:(pageIndex-1)*pageSize;
        queryParam.put("orgId",iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(e->e.getId().toString()).collect(Collectors.joining(",")));
        if (StringUtils.isNotBlank(param.getSearchText())){
            queryParam.put("searchText",param.getSearchText());
        }
        queryParam.put("orders",param.getOrderMap().get("reviewDate"));
        IPage<ReviewDetailVO> jsonObjectIPage = service.queryPage(queryParam, pageIndex, pageSize);
        jsonObjectIPage.setSize(pageSize);
        jsonObjectIPage.setCurrent(param.getPageIndex());
        return CommonResponse.success("查询列表数据成功！",jsonObjectIPage);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }
    @RequestMapping(value = "/detail/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelDetailExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<ReviewDetailVO> records = new ArrayList<>();

        CommonResponse<IPage<ReviewDetailVO>> iPageCommonResponse = queryDetailList(param);
        if (iPageCommonResponse.isSuccess()){
            records = iPageCommonResponse.getData().getRecords();
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", records);
        ExcelExport.getInstance().export("ReviewDetail-export.xlsx", beans, response);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("reviewTitle");
        fuzzyFields.add("undertakeUnitName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("reviewResult");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ReviewEntity> page = service.queryList(param,false);
        List<ReviewVO> reviewVOS = BeanMapper.mapList(page, ReviewVO.class);
        reviewVOS.forEach(reviewVO -> {
            reviewVO.setReviewTypeStr(reviewVO.getReviewType() == 1 ? "100万以下" : "100万以上");
            reviewVO.setBillStateName(BillStateEnum.getEnumByStateCode(reviewVO.getBillState()).getDescription());
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", reviewVOS);
        ExcelExport.getInstance().export("Review-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refReviewData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ReviewVO>> refReviewData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("reviewTitle");
        fuzzyFields.add("undertakeUnitName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("productTypeName");
        fuzzyFields.add("reviewResult");

        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()
        )));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", QueryParam.DESC);
        IPage<ReviewEntity> page = service.queryPage(param,false);
        IPage<ReviewVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReviewVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }



    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refReviewDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ReviewDetailVO>> refReviewDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                         String condition,
                                                         String searchObject,
                                                         String searchText) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("detailProductName");
        fuzzyFields.add("detailSpec");
        fuzzyFields.add("detailUnit");
        fuzzyFields.add("detailMemo");

        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("reviewId")){
                param.getParams().put("reviewId", new Parameter(QueryParam.EQ,_con.getString("reviewId")));
            }
        }
        param.getOrderMap().put("createTime", QueryParam.DESC);
        IPage<ReviewDetailEntity> page = detailsService.queryPage(param,false);
        IPage<ReviewDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReviewDetailVO.class));
        return CommonResponse.success("查询参照数据成功！",pageData);
    }


    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "DepartDetailImport.xlsx", "评审产品清单明细导入模板");
    }

    @PostMapping(value = "/excelImport")
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request ) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd"); // 定义日期时间格式
        List<ReviewDetailVO> successList = new ArrayList<>();
        List<ReviewDetailVO> errorList = new ArrayList<>();
        List<List<String>> result = ExcelReader.readExcel(mf);
        if(result != null && result.size() > 0) {
            if(result.size() > 10000) {
                return CommonResponse.error("分类数据超过10000条，请分批上传！");
            }
            ReviewDetailVO vo = null;
            for(int i = 0;i < result.size(); i++) {
                List<String> datas = result.get(i);
                vo = new ReviewDetailVO();
                vo.setId(IdWorker.getId());

                if(StringUtils.isBlank(datas.get(0))){
                    vo.setErrorMsg("产品名称不能为空！");
                    errorList.add(vo);
                    continue;
                }
                vo.setDetailProductName(datas.get(0));

                vo.setDetailSpec(datas.get(1));
                if(StringUtils.isBlank(datas.get(2))){
                    vo.setErrorMsg("单位不能为空！");
                    errorList.add(vo);
                    continue;
                }
                vo.setDetailUnit(datas.get(2));
                if(StringUtils.isBlank(datas.get(3))){
                    vo.setErrorMsg("数量不能为空！");
                    errorList.add(vo);
                    continue;
                }
                String detailNum = datas.get(3);
                try {
                    vo.setDetailNum(new BigDecimal(detailNum));
                } catch (Exception e) {
                    vo.setDetailNum(null);
                    vo.setErrorMsg("数量只能为数字或小数！");
                    errorList.add(vo);

                    continue;
                }
                if(StringUtils.isBlank(datas.get(4))){
                    vo.setErrorMsg("单价不能为空！");
                    errorList.add(vo);
                    continue;
                }
                String detailTaxPrice = datas.get(4);
                try {
                    vo.setDetailTaxPrice(new BigDecimal(detailTaxPrice));
                } catch (Exception e) {
                    vo.setDetailTaxPrice(null);
                    vo.setErrorMsg("单价只能为数字或小数！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(5))){
                    vo.setErrorMsg("税率不能为空！");
                    errorList.add(vo);
                    errorList.add(vo);

                    continue;
                }
                String detailRate = datas.get(5);
                try {
                    vo.setDetailRate(new BigDecimal(detailRate));
                } catch (Exception e) {
                    vo.setDetailRate(null);
                    vo.setErrorMsg("税率只能为数字或小数！");
                    continue;
                }
                if(StringUtils.isNotBlank(datas.get(6))){
                    String detailDeliveryDate = datas.get(6);
                    try {
                        Date date = formatter.parse(detailDeliveryDate);
                        vo.setDetailDeliveryDate(date);
                    } catch (ParseException e) {
                        vo.setDetailDeliveryDate(null);
                        vo.setErrorMsg("日期格式错误！");
                        errorList.add(vo);
                        continue;
                    }
                }
                vo.setDetailProductName(datas.get(0));
                //备注
                vo.setDetailMemo(datas.get(7));

                // 计算金额
                BigDecimal decimal = ComputeUtil.safeDiv(vo.getDetailRate(), new BigDecimal(100));
                decimal = ComputeUtil.safeAdd(decimal, BigDecimal.ONE);
                BigDecimal detailPrice = ComputeUtil.safeDiv(vo.getDetailTaxPrice(), decimal);
                vo.setDetailPrice(detailPrice);
                BigDecimal taxMny = ComputeUtil.safeMultiply(vo.getDetailNum(), vo.getDetailTaxPrice());
                BigDecimal mny = ComputeUtil.safeMultiply(vo.getDetailNum(), vo.getDetailPrice());
                vo.setDetailTaxMny(taxMny);
                vo.setDetailMny(mny);
                BigDecimal tax = ComputeUtil.safeSub(vo.getDetailTaxMny(), vo.getDetailMny());
                vo.setDetailTax(tax);
                vo.setSourceType(2);
                successList.add(vo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("successNum", successList.size());
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
}
