package com.ejianc.business.jlincome.income.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 签章状态 枚举类型
 */
public enum ChangeStatusEnum {
    /**
     * 合同变更状态：1、未变更；
     */
    未变更(1, "未变更"),

    /**
     * 合同变更状态：2、变更中；
     */
    变更中(2, "变更中"),

    /**
     * 合同变更状态：3、已变更；
     */
    已变更(3, "已变更");



    private Integer code;
    private String description;
    private static Map<Integer, ChangeStatusEnum> enumMap = new HashMap<>();

    ChangeStatusEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(ChangeStatusEnum.class).stream().collect(Collectors.toMap(ChangeStatusEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static ChangeStatusEnum getEnumByCode(String billStateCode) {
        return enumMap.get(billStateCode);
    }
}
