package com.ejianc.business.jlincome.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlincome.income.bean.ContractRegisterEntity;
import com.ejianc.business.jlincome.income.bean.SettleDetailEntity;
import com.ejianc.business.jlincome.income.bean.SettleEntity;
import com.ejianc.business.jlincome.income.mapper.SettleMapper;
import com.ejianc.business.jlincome.income.service.IContractRegisterService;
import com.ejianc.business.jlincome.income.service.ISettleDetailService;
import com.ejianc.business.jlincome.income.service.ISettleService;
import com.ejianc.business.jlincome.income.vo.SettleDetailVO;
import com.ejianc.business.jlincome.income.vo.SettleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 收入管理-对甲结算
 *
 * @author generator
 */
@Service("settleService")
public class SettleServiceImpl extends BaseServiceImpl<SettleMapper, SettleEntity> implements ISettleService {
    private static final String BILL_CODE = "DJJSC";//此处需要根据实际修改
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ISettleDetailService detailService;
    @Autowired
    private IContractRegisterService contractRegisterService;

    @Override
    public CommonResponse<SettleVO> saveOrUpdate(SettleVO saveOrUpdateVO) {
        querySettleByContractId(saveOrUpdateVO.getContractId(), saveOrUpdateVO.getId() != null ? saveOrUpdateVO.getId() : null);
        SettleEntity entity = BeanMapper.map(saveOrUpdateVO, SettleEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
            List<SettleDetailEntity> detailList = entity.getDetailList();
            boolean upFlag = false;
            BigDecimal detailTaxMny = BigDecimal.ZERO;
            BigDecimal detailMny = BigDecimal.ZERO;
            BigDecimal detailTax = BigDecimal.ZERO;
            for (SettleDetailEntity item : detailList) {
                if (null == item.getRowState() || !item.getRowState().equals("del")) {
                    upFlag = true;
                    detailTaxMny = ComputeUtil.safeAdd(detailTaxMny,item.getDetailTaxMny());
                    detailMny = ComputeUtil.safeAdd(detailMny,item.getDetailMny());
                    detailTax = ComputeUtil.safeAdd(detailTax,item.getDetailTax());
                }
            }
            if (upFlag){
                entity.setContractDetailTaxMny(detailTaxMny);
                entity.setContractDetailMny(detailMny);
                entity.setContractDetailTax(detailTax);
                //计算金额
                BigDecimal lastTaxMny = entity.getLastTaxMny();
                BigDecimal lastMny = entity.getLastMny();
                BigDecimal taxMny = BigDecimal.ZERO;
                BigDecimal mny = BigDecimal.ZERO;
                BigDecimal tax = BigDecimal.ZERO;
                BigDecimal totalTaxMny = BigDecimal.ZERO;
                BigDecimal totalMny = BigDecimal.ZERO;
                taxMny = ComputeUtil.safeSub(entity.getContractDetailTaxMny(), entity.getFirstDeductionTaxMny());
                taxMny = ComputeUtil.safeAdd(taxMny, entity.getDetailOtherTaxMny());
                mny = ComputeUtil.safeSub(entity.getContractDetailMny(), entity.getFirstDeductionMny());
                mny = ComputeUtil.safeAdd(mny, entity.getDetailOtherMny());
                tax = ComputeUtil.safeSub(entity.getContractDetailTax(), entity.getFirstDeductionTax());
                tax = ComputeUtil.safeAdd(tax, entity.getDetailOtherTax());
                totalTaxMny = ComputeUtil.safeAdd(taxMny, lastTaxMny);
                totalMny = ComputeUtil.safeAdd(mny, lastMny);
                entity.setTaxMny(taxMny);
                entity.setMny(mny);
                entity.setTax(tax);
                entity.setTotalTaxMny(totalTaxMny);
                entity.setTotalMny(totalMny);
            }
        }
        super.saveOrUpdate(entity, false);
        SettleVO vo = BeanMapper.map(entity, SettleVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    @Override
    public CommonResponse<SettleVO> querySettle(Long contractId) {
        querySettleByContractId(contractId, null);
        //查询累计结算金额
        QueryWrapper<SettleEntity> queryWrapper = new QueryWrapper();
        queryWrapper.eq("contract_id", contractId);
        queryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()));
        List<SettleEntity> list = super.list(queryWrapper);
        SettleVO settleVO = new SettleVO();
        //TODO 查询开票、收款金额
        settleVO.setTotalTicketTaxMny(BigDecimal.ZERO);
        settleVO.setTotalTicketMny(BigDecimal.ZERO);
        settleVO.setTotalAccountTaxMny(BigDecimal.ZERO);
        settleVO.setTotalAccountMny(BigDecimal.ZERO);
        if (CollectionUtils.isNotEmpty(list)) {
            BigDecimal lastTaxMny = list.stream().map(SettleEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal lastMny = list.stream().map(SettleEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            settleVO.setLastTaxMny(lastTaxMny);
            settleVO.setLastMny(lastMny);
            settleVO.setTotalTaxMny(lastTaxMny);
            settleVO.setTotalMny(lastMny);
        } else {
            settleVO.setLastTaxMny(BigDecimal.ZERO);
            settleVO.setLastMny(BigDecimal.ZERO);
            settleVO.setTotalTaxMny(BigDecimal.ZERO);
            settleVO.setTotalMny(BigDecimal.ZERO);
        }
        return CommonResponse.success("查询成功！", settleVO);
    }

    @Override
    public CommonResponse<Map<Long, SettleDetailVO>> querySettleDetail(List<String> sourceDetailIds) {
        //根据对应的源明细id查询对应的结算单
        QueryWrapper<SettleDetailEntity> queryWrapper = new QueryWrapper();
        queryWrapper.in("source_detail_id", sourceDetailIds);
        List<SettleDetailEntity> list = detailService.list(queryWrapper);
        Map<Long, List<SettleDetailEntity>> collect = list.stream().collect(Collectors.groupingBy(SettleDetailEntity::getSourceDetailId));
        Map<Long, SettleDetailVO> map = new HashMap<>();
        for (Map.Entry<Long, List<SettleDetailEntity>> entry : collect.entrySet()) {
            List<SettleDetailEntity> value = entry.getValue();
            BigDecimal lastTaxMny = value.stream().map(SettleDetailEntity::getDetailTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal lastTax = value.stream().map(SettleDetailEntity::getDetailTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal lastMny = value.stream().map(SettleDetailEntity::getDetailMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal lastNum = value.stream().map(SettleDetailEntity::getDetailSettleNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            SettleDetailVO valueVO = new SettleDetailVO();
            valueVO.setDetailLastTaxMny(lastTaxMny);
            valueVO.setDetailLastMny(lastMny);
            valueVO.setDetailLastTax(lastTax);
            valueVO.setDetailLastNum(lastNum);
            valueVO.setDetailTotalTaxMny(lastTaxMny);
            valueVO.setDetailTotalMny(lastMny);
            valueVO.setDetailTotalTax(lastTax);
            valueVO.setDetailTotalNum(lastNum);
            map.put(entry.getKey(), valueVO);
        }
        return CommonResponse.success("查询成功！", map);
    }

    @Override
    public void querySettleByContractId(Long contractId, Long id) {

        QueryWrapper<SettleEntity> queryWrapper = new QueryWrapper();
        queryWrapper.eq("contract_id", contractId);
        if (null != id) {
            queryWrapper.ne("id", id);
        }
        queryWrapper.notIn("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()));
        int count = super.count(queryWrapper);
        if (count > 0) {
            throw new BusinessException("一个合同只能有一个未生效的结算单!");
        }
    }

    @Override
    public JSONObject querySettleRecordByContId(Long contractId) {
        ContractRegisterEntity contractEntity = contractRegisterService.selectById(contractId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("contractMny", contractEntity.getContractMny());
        jsonObject.put("contractTaxMny", contractEntity.getContractTaxMny());
        jsonObject.put("performanceStatus", contractEntity.getPerformanceStatus());
        jsonObject.put("changeStatus", contractEntity.getChangeStatus());
        jsonObject.put("billState", contractEntity.getBillState());

        LambdaQueryWrapper<SettleEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SettleEntity::getContractId, contractId);
        queryWrapper.in(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.orderByDesc(SettleEntity::getSettleDate);

        List<SettleEntity> list = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            List<SettleVO> settleVOS = BeanMapper.mapList(list, SettleVO.class);
            settleVOS.sort(Comparator.comparing(SettleVO::getSettleDate));
            BigDecimal sumSettleTaxMny = settleVOS.stream().filter(p -> p.getTaxMny() != null).map(SettleVO::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            jsonObject.put("sumSettleMny", sumSettleTaxMny);
            jsonObject.put("sumSettleScale", ComputeUtil.safeMultiply(ComputeUtil.safeDiv(sumSettleTaxMny, contractEntity.getContractTaxMny()), BigDecimal.valueOf(100)));
            jsonObject.put("detailList", settleVOS);
        }
        return jsonObject;
    }

    @Override
    public Map<Long, JSONObject> querySettleRecordByContIdList(List<Long> contractIds) {
        Map<Long, JSONObject> collectMap = new HashMap<>();
        LambdaQueryWrapper<SettleEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(SettleEntity::getContractId, contractIds);
        queryWrapper.in(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        queryWrapper.orderByDesc(SettleEntity::getSettleDate);

        List<SettleEntity> list = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list) && list.size() > 0) {
            Map<Long, List<SettleEntity>> settleMap = list.stream().collect(Collectors.groupingBy(SettleEntity::getContractId));
            for (Long contractId : settleMap.keySet()) {
                JSONObject jsonObject = new JSONObject();

                List<SettleVO> settleVOS = BeanMapper.mapList(settleMap.get(contractId), SettleVO.class);
                BigDecimal sumSettleTaxMny = settleVOS.stream().filter(p -> p.getTaxMny() != null).map(SettleVO::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                jsonObject.put("sumSettleTaxMny", sumSettleTaxMny);
                jsonObject.put("settleList", settleVOS);
                collectMap.put(contractId, jsonObject);
            }
        }
        return collectMap;
    }


}
