package com.ejianc.business.jlincome.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlincome.income.service.IContractRegisterService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlincome.income.mapper.UserReportMapper;
import com.ejianc.business.jlincome.income.bean.UserReportEntity;
import com.ejianc.business.jlincome.income.service.IUserReportService;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 收入管理-用户报告
 *
 * @author generator
 */
@Service("userReportService")
public class UserReportServiceImpl extends BaseServiceImpl<UserReportMapper, UserReportEntity> implements IUserReportService {

    @Override
    public Boolean checkContractIsExist(UserReportEntity userReport) {
        Long tenantid = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<UserReportEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(UserReportEntity::getTenantId, tenantid);
        lambdaQueryWrapper.eq(UserReportEntity::getContractId, userReport.getContractId());
        if (userReport.getId() != null) {
            lambdaQueryWrapper.ne(UserReportEntity::getId, userReport.getId());
        }
        return super.list(lambdaQueryWrapper).size() > 0;
    }

    @Override
    public Map<Long, Long> queryIdsByContractIds(List<Long> contractIdList) {
        Map<Long, Long> userReportIdMap = new HashMap<>();
        LambdaQueryWrapper<UserReportEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(UserReportEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambdaQueryWrapper.in(UserReportEntity::getContractId, contractIdList);
        lambdaQueryWrapper.in(UserReportEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode());
        List<UserReportEntity> list = super.list(lambdaQueryWrapper);
        if (null != list && list.size() > 0){
            for (UserReportEntity entity : list) {
                userReportIdMap.put(entity.getContractId(), entity.getId());
            }
        }
        return userReportIdMap;
    }
}
