/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.income.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.jlcost.finance.api.IInvoiceReceiveApi;
import com.ejianc.business.jlincome.income.bean.ContractRegisterDetailEntity;
import com.ejianc.business.jlincome.income.bean.ContractRegisterEntity;
import com.ejianc.business.jlincome.income.enums.ChangeTypeEnum;
import com.ejianc.business.jlincome.income.mapper.ContractRegisterMapper;
import com.ejianc.business.jlincome.income.service.IContractRegisterDetailService;
import com.ejianc.business.jlincome.income.service.IContractRegisterService;
import com.ejianc.business.jlincome.income.service.ISettleService;
import com.ejianc.business.jlincome.income.service.IUserReportService;
import com.ejianc.business.jlincome.income.vo.ContractRegisterDetailVO;
import com.ejianc.business.jlincome.income.vo.ContractRegisterReportVO;
import com.ejianc.business.jlincome.income.vo.ContractRegisterVO;
import com.ejianc.business.jlincome.income.vo.ImportContractRegisterDetailVO;
import com.ejianc.business.jlincome.income.vo.ProjectBoardTwoVO;
import com.ejianc.business.jlincome.income.vo.ProjectBoardVO;
import com.ejianc.business.jlprogress.order.api.IOrderApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.consts.ArchiveProjectStatusEnum;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="contractRegisterService")
public class ContractRegisterServiceImpl
extends BaseServiceImpl<ContractRegisterMapper, ContractRegisterEntity>
implements IContractRegisterService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractRegisterDetailService contractDetailService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectArchiveApi projectArchiveApi;
    @Autowired
    private IOrderApi orderApi;
    @Autowired
    private IContractRegisterService service;
    @Autowired
    private ISettleService settleService;
    @Autowired
    private IUserReportService userReportService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IInvoiceReceiveApi invoiceReceiveApi;

    @Override
    public boolean checkSameBillCode(ContractRegisterVO vo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ContractRegisterEntity::getBillCode, (Object)vo.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != vo.getId() && vo.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)vo.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    @Override
    public void performanceStatusUp(Long id, Integer performanceStatus) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.in((Object)"id", new Object[]{id});
        updateWrapper.set((Object)"performance_status", (Object)performanceStatus);
        super.update((Wrapper)updateWrapper);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<ImportContractRegisterDetailVO> successList = new ArrayList<ImportContractRegisterDetailVO>();
        ArrayList<ImportContractRegisterDetailVO> errorList = new ArrayList<ImportContractRegisterDetailVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 9) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            if (result.size() >= 1000) {
                throw new BusinessException("\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u8d85\u8fc71000\u884c\uff0c\u8d85\u8fc7\u8bf7\u5206\u6279\u6b21\u591a\u6b21\u5bfc\u5165");
            }
            for (int i = 1; i < result.size(); ++i) {
                StringBuilder errorMessage = new StringBuilder();
                List datas = (List)result.get(i);
                ImportContractRegisterDetailVO importVO = new ImportContractRegisterDetailVO();
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    errorMessage.append("[\u4ea7\u54c1\u540d\u79f0\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    if (((String)datas.get(0)).length() > 200) {
                        importVO.setErrorMessage("\u586b\u5199\u4ea7\u54c1\u540d\u79f0\u957f\u5ea6\u4e3a1~200\u5b57");
                    }
                    importVO.setDetailProductName(((String)datas.get(0)).trim());
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    errorMessage.append("[\u89c4\u683c\u578b\u53f7\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    if (((String)datas.get(1)).length() > 200) {
                        importVO.setErrorMessage("\u586b\u5199\u89c4\u683c\u578b\u53f7\u957f\u5ea6\u4e3a1~200\u5b57");
                    }
                    importVO.setDetailSpec(((String)datas.get(1)).trim());
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    errorMessage.append("[\u5355\u4f4d\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    if (((String)datas.get(2)).length() > 50) {
                        importVO.setErrorMessage("\u586b\u5199\u5355\u4f4d\u957f\u5ea6\u4e3a1~50\u5b57");
                    }
                    importVO.setDetailUnit(((String)datas.get(2)).trim());
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    errorMessage.append("[\u6570\u91cf\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    try {
                        importVO.setDetailNum(new BigDecimal((String)datas.get(3)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u6570\u91cf\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(4)))) {
                    errorMessage.append("[\u5355\u4ef7\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    try {
                        importVO.setDetailTaxPrice(new BigDecimal((String)datas.get(4)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u5355\u4ef7\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    errorMessage.append("[\u7a0e\u7387\u4e3a\u5fc5\u586b\u9879]");
                } else {
                    try {
                        importVO.setDetailRate(new BigDecimal((String)datas.get(5)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u7a0e\u7387\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6)))) {
                    try {
                        importVO.setDetailTaxMny(new BigDecimal((String)datas.get(6)));
                    }
                    catch (Exception e) {
                        errorMessage.append("[\u91d1\u989d\u5fc5\u987b\u4e3a\u6570\u5b57]");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7)))) {
                    try {
                        importVO.setDetailPlanDeliverDate(DateUtils.parseDate((String)((String)datas.get(7)), (String[])new String[]{"YYYY-MM-dd"}));
                    }
                    catch (ParseException e) {
                        errorMessage.append("[\u9884\u8ba1\u4ea4\u8d27\u65e5\u671f\u586b\u5199\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u586b\u5199 YYYY-MM-dd \u7c7b\u578b\u7684\u65e5\u671f\u683c\u5f0f]");
                        e.printStackTrace();
                    }
                }
                if (((String)datas.get(8)).length() > 200) {
                    importVO.setErrorMessage("\u586b\u5199\u5907\u6ce8\u957f\u5ea6\u4e3a0~200\u5b57");
                }
                importVO.setDetailMemo((String)datas.get(8));
                importVO.setId(Long.valueOf(IdWorker.getId()));
                importVO.setSourceType(Integer.valueOf(2));
                if (StringUtils.isBlank((CharSequence)errorMessage)) {
                    importVO.setDetailTaxMny(ComputeUtil.safeMultiply((BigDecimal)importVO.getDetailTaxPrice(), (BigDecimal)importVO.getDetailNum()));
                    importVO.setDetailMny(ComputeUtil.safeDiv((BigDecimal)importVO.getDetailTaxMny(), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)new BigDecimal(1), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)importVO.getDetailRate(), (BigDecimal)new BigDecimal(100)))));
                    importVO.setDetailPrice(ComputeUtil.safeDiv((BigDecimal)importVO.getDetailTaxPrice(), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)new BigDecimal(1), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)importVO.getDetailRate(), (BigDecimal)new BigDecimal(100)))));
                    importVO.setDetailTax(ComputeUtil.safeSub((BigDecimal)importVO.getDetailTaxMny(), (BigDecimal)importVO.getDetailMny()));
                    importVO.setChangeType(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode().toString());
                    successList.add(importVO);
                    continue;
                }
                importVO.setErrorMessage(String.valueOf(errorMessage));
                errorList.add(importVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @Override
    public JSONObject queryContractMnyByProjectId(Long projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ContractRegisterEntity::getProjectId, (Object)projectId);
        queryWrapper.in(ContractRegisterEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List contractList = super.list((Wrapper)queryWrapper);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("projectId", (Object)projectId);
        if (CollectionUtils.isNotEmpty((Collection)contractList) && contractList.size() > 0) {
            jsonObject.put("contractMny", (Object)contractList.stream().filter(e -> null != e.getContractMny()).map(ContractRegisterEntity::getContractMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            jsonObject.put("contractTaxMny", (Object)contractList.stream().filter(e -> null != e.getContractTaxMny()).map(ContractRegisterEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            jsonObject.put("contractTax", (Object)contractList.stream().filter(e -> null != e.getContractTax()).map(ContractRegisterEntity::getContractTax).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        return jsonObject;
    }

    @Override
    public ContractRegisterVO queryDetail(Long id) {
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)super.selectById((Serializable)id));
        entity.setDetailList(null);
        ContractRegisterVO contractVo = (ContractRegisterVO)BeanMapper.map((Object)((Object)entity), ContractRegisterVO.class);
        List details = null;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ContractRegisterDetailEntity::getContractRegisterId, (Object)id);
        lambda.ne(ContractRegisterDetailEntity::getChangeType, (Object)ChangeTypeEnum.\u7ec8\u6b62\u9879.getCode());
        details = this.contractDetailService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            contractVo.setDetailList(BeanMapper.mapList((Iterable)details, ContractRegisterDetailVO.class));
        }
        return contractVo;
    }

    @Override
    public Map<String, BigDecimal> queryContractMnyByReviewId(Long reviewId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ContractRegisterEntity::getReviewId, (Object)reviewId);
        queryWrapper.in(ContractRegisterEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List contractList = super.list((Wrapper)queryWrapper);
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        if (CollectionUtils.isNotEmpty((Collection)contractList) && contractList.size() > 0) {
            map.put("contractMny", contractList.stream().filter(e -> null != e.getContractMny()).map(ContractRegisterEntity::getContractMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            map.put("contractTaxMny", contractList.stream().filter(e -> null != e.getContractTaxMny()).map(ContractRegisterEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        } else {
            map.put("contractMny", BigDecimal.ZERO);
            map.put("contractTaxMny", BigDecimal.ZERO);
        }
        return map;
    }

    @Override
    public ProjectBoardVO queryContractBoardList() {
        QueryParam param = new QueryParam();
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<Long> orgIds = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter("in", orgIds));
        CommonResponse projectResponse = this.projectArchiveApi.queryProjectArchivePage(param);
        if (!projectResponse.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u83b7\u53d6\u9879\u76ee\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        List projectRecords = ((Page)projectResponse.getData()).getRecords();
        List<Long> projectIds = projectRecords.stream().filter(e -> null != e.getProjectStatus() && Integer.valueOf(e.getProjectStatus()) > Integer.valueOf(ArchiveProjectStatusEnum.\u672a\u4e2d\u6807.getCode())).map(BaseVO::getId).collect(Collectors.toList());
        System.out.println(projectIds);
        ProjectBoardVO projectBoardVO = ((ContractRegisterMapper)this.baseMapper).queryContractBordData(orgIds, projectIds);
        if (null != projectRecords) {
            projectBoardVO.setProjectNum(Integer.valueOf(projectRecords.size()));
            projectBoardVO.setBidProjectNum(Integer.valueOf(projectIds.size()));
        }
        return projectBoardVO;
    }

    @Override
    public List<ProjectBoardTwoVO> queryProjectBoardList(QueryParam param) {
        List orgIds = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter("in", orgIds));
        CommonResponse projectResponse = this.projectArchiveApi.queryProjectArchivePage(param);
        if (!projectResponse.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u83b7\u53d6\u9879\u76ee\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        List projectRecords = ((Page)projectResponse.getData()).getRecords();
        List recordList = BeanMapper.mapList((Iterable)projectRecords, ProjectBoardTwoVO.class);
        List projectIds = projectRecords.stream().filter(e -> null != e.getProjectStatus()).map(BaseVO::getId).collect(Collectors.toList());
        System.out.println(projectIds);
        param.getParams().put("projectId", new Parameter("in", projectIds));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List registerList = super.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)registerList)) {
            return recordList;
        }
        List contractRegisterVOList = BeanMapper.mapList((Iterable)registerList, ContractRegisterVO.class);
        List<Long> contractIdList = contractRegisterVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
        this.logger.info("\u83b7\u53d6\u5408\u540cid\u96c6\u5408\uff1a{}", (Object)JSONObject.toJSONString(contractIdList));
        CommonResponse invoiceReceiveDataRes = this.invoiceReceiveApi.getInvoiceReceiveDataByContractIdList(contractIdList);
        if (!invoiceReceiveDataRes.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5408\u540c\u767b\u8bb0\u4e0b\u6e38\u5f00\u7968\u3001\u6536\u6b3e\u4fe1\u606f\u5931\u8d25\uff01\u539f\u56e0-" + invoiceReceiveDataRes.getMsg());
        }
        String invoiceReceiveDataStr = ((JSONObject)invoiceReceiveDataRes.getData()).toJSONString();
        CommonResponse orderDataRes = this.orderApi.getOrderDataByContractIdList(contractIdList);
        if (!orderDataRes.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5408\u540c\u767b\u8bb0\u4e0b\u6e38\u9500\u552e\u3001\u53d1\u8d27\u3001\u9a8c\u6536\u4fe1\u606f\u5931\u8d25\uff01\u539f\u56e0-" + orderDataRes.getMsg());
        }
        String orderDataStr = ((JSONObject)orderDataRes.getData()).toJSONString();
        Map<Long, JSONObject> settleDataMap = this.settleService.querySettleRecordByContIdList(contractIdList);
        ArrayList<ContractRegisterReportVO> registerReportVOList = new ArrayList<ContractRegisterReportVO>();
        SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd");
        for (ContractRegisterVO record : contractRegisterVOList) {
            JSONObject settle;
            JSONObject order;
            JSONObject orderData;
            JSONObject invoiceReceive;
            ContractRegisterReportVO reportVO = (ContractRegisterReportVO)BeanMapper.map((Object)record, ContractRegisterReportVO.class);
            JSONObject invoiceReceiveData = JSONObject.parseObject((String)invoiceReceiveDataStr);
            if (invoiceReceiveData.containsKey((Object)record.getId()) && (invoiceReceive = (JSONObject)JSONObject.parseObject((String)invoiceReceiveData.getString(record.getId().toString()), JSONObject.class)).size() > 0) {
                if (null != invoiceReceive.get((Object)"sumInvoiceTaxMny")) {
                    reportVO.setSumInvoiceTaxMny(new BigDecimal(invoiceReceive.get((Object)"sumInvoiceTaxMny").toString()));
                }
                if (null != invoiceReceive.get((Object)"sumReceiveTaxMny")) {
                    reportVO.setSumReceiveTaxMny(new BigDecimal(invoiceReceive.get((Object)"sumReceiveTaxMny").toString()));
                }
                if (null != invoiceReceive.get((Object)"invoiceDetailList")) {
                    reportVO.setInvoiceDetailList(JSONObject.parseArray((String)invoiceReceive.get((Object)"invoiceDetailList").toString(), JSONObject.class));
                    for (Object jsonObject : reportVO.getInvoiceDetailList()) {
                        if (null == jsonObject.get((Object)"detailDate")) continue;
                        jsonObject.put("detailDate", (Object)sim.format(new Date(Long.valueOf(jsonObject.get((Object)"detailDate").toString()))));
                    }
                }
                if (null != invoiceReceive.get((Object)"receiveDetailList")) {
                    reportVO.setReceiveDetailList(JSONObject.parseArray((String)invoiceReceive.get((Object)"receiveDetailList").toString(), JSONObject.class));
                    for (Object jsonObject : reportVO.getReceiveDetailList()) {
                        if (null == jsonObject.get((Object)"receiveTime")) continue;
                        jsonObject.put("receiveTime", (Object)sim.format(new Date(Long.valueOf(jsonObject.get((Object)"receiveTime").toString()))));
                    }
                }
            }
            if ((orderData = JSONObject.parseObject((String)orderDataStr)).containsKey((Object)record.getId()) && (order = (JSONObject)JSONObject.parseObject((String)orderData.getString(record.getId().toString()), JSONObject.class)).size() > 0) {
                if (null != order.get((Object)"firstOrderDate")) {
                    reportVO.setFirstOrderDate(new Date(Long.valueOf(order.get((Object)"firstOrderDate").toString())));
                }
                if (null != order.get((Object)"salesList")) {
                    reportVO.setSalesList(JSONObject.parseArray((String)order.get((Object)"salesList").toString(), JSONObject.class));
                }
                if (null != order.get((Object)"productOutState")) {
                    reportVO.setProductOutState(order.get((Object)"productOutState").toString());
                }
                if (null != order.get((Object)"productOutVOList")) {
                    reportVO.setProductOutVOList(JSONObject.parseArray((String)order.get((Object)"productOutVOList").toString(), JSONObject.class));
                }
            }
            if (settleDataMap.containsKey(record.getId()) && (settle = (JSONObject)JSONObject.parseObject((String)String.valueOf(settleDataMap.get(record.getId())), JSONObject.class)).size() > 0) {
                if (null != settle.get((Object)"sumSettleTaxMny")) {
                    reportVO.setSumSettleTaxMny(new BigDecimal(settle.get((Object)"sumSettleTaxMny").toString()));
                }
                if (null != settle.get((Object)"settleList")) {
                    Object jsonObject;
                    reportVO.setSettleList(JSONObject.parseArray((String)settle.get((Object)"settleList").toString(), JSONObject.class));
                    jsonObject = reportVO.getSettleList().iterator();
                    while (jsonObject.hasNext()) {
                        JSONObject jsonObject2 = (JSONObject)jsonObject.next();
                        if (null == jsonObject2.get((Object)"settleDate")) continue;
                        jsonObject2.put("settleDate", (Object)sim.format(new Date(Long.valueOf(jsonObject2.get((Object)"settleDate").toString()))));
                    }
                }
            }
            registerReportVOList.add(reportVO);
        }
        Map<Long, List<ContractRegisterReportVO>> reportMap = registerReportVOList.stream().collect(Collectors.groupingBy(ContractRegisterReportVO::getProjectId));
        for (ProjectBoardTwoVO projectBoardTwoVO : recordList) {
            if (!reportMap.containsKey(projectBoardTwoVO.getId())) continue;
            ArrayList reportVOList = new ArrayList();
            projectBoardTwoVO.setContractTaxMny(reportVOList.stream().filter(p -> p.getContractTaxMny() != null).map(ContractRegisterReportVO::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            projectBoardTwoVO.setInvoiceMny(reportVOList.stream().filter(p -> p.getSumInvoiceTaxMny() != null).map(ContractRegisterReportVO::getSumInvoiceTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            projectBoardTwoVO.setReceiveMny(reportVOList.stream().filter(p -> p.getSumReceiveTaxMny() != null).map(ContractRegisterReportVO::getSumReceiveTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            projectBoardTwoVO.setSettleAMny(reportVOList.stream().filter(p -> p.getSumSettleTaxMny() != null).map(ContractRegisterReportVO::getSumSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            List<ContractRegisterReportVO> registerReportList = reportMap.get(projectBoardTwoVO.getId());
            for (ContractRegisterReportVO registerReportVO : registerReportList) {
                if (null != projectBoardTwoVO.getFirstOrderDate()) {
                    projectBoardTwoVO.setFirstOrderDate(projectBoardTwoVO.getFirstOrderDate().compareTo(registerReportVO.getFirstOrderDate()) < 1 ? projectBoardTwoVO.getFirstOrderDate() : registerReportVO.getFirstOrderDate());
                } else {
                    projectBoardTwoVO.setFirstOrderDate(registerReportVO.getFirstOrderDate());
                }
                if (null != projectBoardTwoVO.getProductOutState()) {
                    if (!"\u5df2\u53d1\u8d27".equals(projectBoardTwoVO.getProjectStatus())) {
                        projectBoardTwoVO.setProductOutState(registerReportVO.getProductOutState());
                    }
                } else {
                    projectBoardTwoVO.setProductOutState(registerReportVO.getProductOutState());
                }
                projectBoardTwoVO.getSalesList().addAll(registerReportVO.getSettleList());
                projectBoardTwoVO.getProductOutVOList().addAll(registerReportVO.getProductOutVOList());
                projectBoardTwoVO.getSettleList().addAll(registerReportVO.getSettleList());
                projectBoardTwoVO.getInvoiceDetailList().addAll(registerReportVO.getInvoiceDetailList());
                projectBoardTwoVO.getReceiveDetailList().addAll(registerReportVO.getReceiveDetailList());
            }
        }
        return recordList;
    }
}

