/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlincome.income.bean.UserReportEntity;
import com.ejianc.business.jlincome.income.mapper.UserReportMapper;
import com.ejianc.business.jlincome.income.service.IUserReportService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service(value="userReportService")
public class UserReportServiceImpl
extends BaseServiceImpl<UserReportMapper, UserReportEntity>
implements IUserReportService {
    @Override
    public Boolean checkContractIsExist(UserReportEntity userReport) {
        Long tenantid = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BaseEntity::getTenantId, (Object)tenantid);
        lambdaQueryWrapper.eq(UserReportEntity::getContractId, (Object)userReport.getContractId());
        if (userReport.getId() != null) {
            lambdaQueryWrapper.ne(BaseEntity::getId, (Object)userReport.getId());
        }
        return super.list((Wrapper)lambdaQueryWrapper).size() > 0;
    }

    @Override
    public Map<Long, Long> queryIdsByContractIds(List<Long> contractIdList) {
        HashMap<Long, Long> userReportIdMap = new HashMap<Long, Long>();
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambdaQueryWrapper.in(UserReportEntity::getContractId, contractIdList);
        lambdaQueryWrapper.in(UserReportEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        List list = super.list((Wrapper)lambdaQueryWrapper);
        if (null != list && list.size() > 0) {
            for (UserReportEntity entity : list) {
                userReportIdMap.put(entity.getContractId(), entity.getId());
            }
        }
        return userReportIdMap;
    }
}

