/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.jlincome.bid.bean.EngineeringChangePersonEntity;
import com.ejianc.business.jlincome.bid.bean.EngineeringReportChangeEntity;
import com.ejianc.business.jlincome.bid.bean.EngineeringReportEntity;
import com.ejianc.business.jlincome.bid.mapper.EngineeringReportChangeMapper;
import com.ejianc.business.jlincome.bid.service.IEngineeringChangePersonService;
import com.ejianc.business.jlincome.bid.service.IEngineeringReportChangeService;
import com.ejianc.business.jlincome.bid.service.IEngineeringReportService;
import com.ejianc.business.jlincome.bid.vo.EngineeringChangePersonVO;
import com.ejianc.business.jlincome.bid.vo.EngineeringChangeResearchVO;
import com.ejianc.business.jlincome.bid.vo.EngineeringReportChangeVO;
import com.ejianc.business.jlincome.income.enums.ChangeStatusEnum;
import com.ejianc.business.jlincome.income.enums.ChangeTypeEnum;
import com.ejianc.business.jlincome.income.vo.ContractRegisterChangeVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="engineeringReportChangeService")
public class EngineeringReportChangeServiceImpl
extends BaseServiceImpl<EngineeringReportChangeMapper, EngineeringReportChangeEntity>
implements IEngineeringReportChangeService {
    @Autowired
    private IEngineeringReportService engineeringReportService;
    @Autowired
    private IEngineeringChangePersonService engineeringChangePersonService;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public EngineeringReportChangeVO addConvertByReportId(Long reportId) {
        EngineeringReportEntity entity = (EngineeringReportEntity)((Object)this.engineeringReportService.selectById(reportId));
        EngineeringReportChangeVO changeVo = (EngineeringReportChangeVO)BeanMapper.map((Object)((Object)entity), EngineeringReportChangeVO.class);
        changeVo.setReportId(reportId);
        changeVo.setId(Long.valueOf(IdWorker.getId()));
        changeVo.setBillState(Integer.valueOf(0));
        changeVo.setCreateUserCode(null);
        changeVo.setCreateTime(null);
        changeVo.setUpdateUserCode(null);
        changeVo.setUpdateTime(null);
        changeVo.setChangeDate(new Date());
        ArrayList<EngineeringChangePersonVO> personVOList = new ArrayList<EngineeringChangePersonVO>();
        if (CollectionUtils.isNotEmpty((Collection)changeVo.getEngineeringPersonList())) {
            for (EngineeringChangePersonVO personVO : changeVo.getEngineeringPersonList()) {
                if (null != personVO.getChangeType() && ChangeTypeEnum.\u7ec8\u6b62\u9879.getCode().toString().equals(personVO.getChangeType())) continue;
                personVO.setChangeType(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode().toString());
                personVO.setSourcePersonId(personVO.getId());
                personVO.setSourceId(reportId);
                personVO.setRowState("edit");
                personVOList.add(personVO);
            }
            changeVo.setEngineeringPersonList(personVOList);
        }
        if (CollectionUtils.isNotEmpty((Collection)changeVo.getEngineeringResearchList())) {
            for (EngineeringChangeResearchVO researchVO : changeVo.getEngineeringResearchList()) {
                researchVO.setSourceResearchId(researchVO.getId());
                researchVO.setSourceId(reportId);
                researchVO.setRowState("add");
            }
        }
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(reportId), "EJCBT202404000021", "file01", String.valueOf(changeVo.getId()), "EJCBT202409000001", "file01");
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(reportId), "EJCBT202404000021", "file1", String.valueOf(changeVo.getId()), "EJCBT202409000001", "file1");
        return changeVo;
    }

    @Override
    public EngineeringReportChangeVO queryChangeRecordByContId(Long id) {
        EngineeringReportChangeVO changeVO = new EngineeringReportChangeVO();
        EngineeringReportEntity entity = (EngineeringReportEntity)((Object)this.engineeringReportService.selectById(id));
        changeVO.setId(id);
        changeVO.setChangeStatus(entity.getChangeStatus());
        if (null != entity.getChangeVersion() && entity.getChangeVersion() > 0) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(EngineeringReportChangeEntity::getReportId, (Object)id);
            lambda.in(EngineeringReportChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
            lambda.orderByDesc(EngineeringReportChangeEntity::getChangeVersion);
            List entities = super.list((Wrapper)lambda);
            changeVO.setChangeRecord(BeanMapper.mapList((Iterable)entities, ContractRegisterChangeVO.class));
        }
        return changeVO;
    }

    @Override
    public CommonResponse<EngineeringReportChangeVO> saveOrUpdate(EngineeringReportChangeVO reportChangeVO) {
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        EngineeringReportChangeEntity entity = null;
        List entitiesc = null;
        List entities = null;
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(EngineeringReportChangeEntity::getReportId, (Object)reportChangeVO.getReportId());
        if (reportChangeVO.getId() != null && reportChangeVO.getId() > 0L) {
            lambdachange.ne(BaseEntity::getId, (Object)reportChangeVO.getId());
        }
        lambdachange.ne(EngineeringReportChangeEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(EngineeringReportChangeEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count((Wrapper)lambdachange);
        if (num > 0) {
            throw new BusinessException("\u8be5\u51fa\u56fe\u8be2\u4ef7\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        EngineeringReportEntity parentEntity = (EngineeringReportEntity)((Object)this.engineeringReportService.selectById(reportChangeVO.getReportId()));
        if (reportChangeVO.getId() != null && reportChangeVO.getId() > 0L && super.getById((Serializable)reportChangeVO.getId()) != null) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(EngineeringReportChangeEntity::getBillCode, (Object)reportChangeVO.getBillCode());
            lambda.ne(EngineeringReportChangeEntity::getReportId, (Object)reportChangeVO.getReportId());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)reportChangeVO.getBillCode()));
            queryParam.getParams().put("id", new Parameter("ne", (Object)reportChangeVO.getReportId()));
            entitiesc = this.engineeringReportService.queryList(queryParam, false);
            parentEntity.setId(reportChangeVO.getReportId());
            entity = (EngineeringReportChangeEntity)((Object)BeanMapper.map((Object)reportChangeVO, EngineeringReportChangeEntity.class));
            entity.setChangeCode(entity.getBillCode() + "-" + entity.getChangeVersion());
            super.saveOrUpdate((Object)entity, false);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(EngineeringReportChangeEntity::getBillCode, (Object)reportChangeVO.getBillCode());
            lambda.ne(EngineeringReportChangeEntity::getReportId, (Object)reportChangeVO.getReportId());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)reportChangeVO.getBillCode()));
            queryParam.getParams().put("id", new Parameter("ne", (Object)reportChangeVO.getReportId()));
            entitiesc = this.engineeringReportService.queryList(queryParam, false);
            parentEntity.setId(reportChangeVO.getReportId());
            parentEntity.setChangeVersion(reportChangeVO.getChangeVersion() + 1);
            reportChangeVO.setChangeVersion(Integer.valueOf(reportChangeVO.getChangeVersion() + 1));
            if (CollectionUtils.isNotEmpty((Collection)entities) || CollectionUtils.isNotEmpty((Collection)entitiesc)) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)reportChangeVO.getEngineeringPersonList())) {
            reportChangeVO.getEngineeringPersonList().forEach(vo -> {
                if (this.isInsertReportChange(reportChangeVO)) {
                    vo.setId(null);
                }
                if ("del".equals(vo.getRowState()) && null != vo.getReportId()) {
                    vo.setChangeType(ChangeTypeEnum.\u7ec8\u6b62\u9879.getCode().toString());
                    vo.setRowState("edit");
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)reportChangeVO.getEngineeringResearchList())) {
            reportChangeVO.getEngineeringResearchList().forEach(vo -> {
                if (this.isInsertReportChange(reportChangeVO)) {
                    vo.setId(null);
                }
            });
        }
        entity = (EngineeringReportChangeEntity)((Object)BeanMapper.map((Object)reportChangeVO, EngineeringReportChangeEntity.class));
        entity.setChangeCode(entity.getBillCode() + "-" + entity.getChangeVersion());
        super.saveOrUpdate((Object)entity, false);
        parentEntity.setChangeStatus(ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        parentEntity.setChangeDate(entity.getChangeDate());
        parentEntity.setChangeCode(entity.getBillCode() + "-" + entity.getChangeVersion());
        parentEntity.setChangeId(entity.getId());
        this.engineeringReportService.update((Object)parentEntity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)parentEntity.getId()), false);
        EngineeringReportChangeVO res = (EngineeringReportChangeVO)BeanMapper.map((Object)this.queryDetail(entity.getId()), EngineeringReportChangeVO.class);
        return CommonResponse.success((Object)res);
    }

    @Override
    public void deleteContractChange(List<EngineeringReportChangeVO> vos) {
        EngineeringReportChangeVO changeVo = vos.get(0);
        EngineeringReportChangeEntity entity = (EngineeringReportChangeEntity)((Object)super.selectById((Serializable)changeVo.getId()));
        EngineeringReportEntity parentEntity = (EngineeringReportEntity)((Object)this.engineeringReportService.selectById(entity.getReportId()));
        parentEntity.setId(entity.getReportId());
        parentEntity.setChangeVersion(parentEntity.getChangeVersion() - 1);
        parentEntity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        if (super.list((Wrapper)new QueryWrapper().eq((Object)"report_id", (Object)entity.getReportId())).size() > 1) {
            parentEntity.setChangeStatus(ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
        }
        parentEntity.setChangeCode(null);
        parentEntity.setChangeId(null);
        this.engineeringReportService.update((Object)parentEntity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)parentEntity.getId()), false);
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }

    private boolean isInsertReportChange(EngineeringReportChangeVO reportChangeVO) {
        return reportChangeVO.getId() == null || reportChangeVO.getId() == 0L;
    }

    @Override
    public EngineeringReportChangeVO queryDetail(Long id) {
        EngineeringReportChangeEntity entity = (EngineeringReportChangeEntity)((Object)super.selectById((Serializable)id));
        entity.setEngineeringPersonList(null);
        EngineeringReportChangeVO contractVo = (EngineeringReportChangeVO)BeanMapper.map((Object)((Object)entity), EngineeringReportChangeVO.class);
        List details = null;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(EngineeringChangePersonEntity::getReportId, (Object)id);
        lambda.ne(EngineeringChangePersonEntity::getChangeType, (Object)ChangeTypeEnum.\u7ec8\u6b62\u9879.getCode());
        details = this.engineeringChangePersonService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            contractVo.setEngineeringPersonList(BeanMapper.mapList((Iterable)details, EngineeringChangePersonVO.class));
        }
        return contractVo;
    }
}

