/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlincome.income.bean.ReviewEntity;
import com.ejianc.business.jlincome.income.service.IContractRegisterService;
import com.ejianc.business.jlincome.income.service.IReviewService;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.consts.ArchiveProjectStatusEnum;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="review")
public class ReviewBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IContractRegisterService contractRegisterService;
    @Autowired
    private IReviewService service;
    @Autowired
    private IProjectArchiveApi projectArchiveApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"review_id", (Object)billId);
        int count = this.contractRegisterService.count((Wrapper)queryWrapper);
        if (count > 0) {
            return CommonResponse.error((String)"\u5f53\u524d\u8bc4\u5ba1\u5355\u5df2\u88ab\u5408\u540c\u5f15\u7528\uff0c\u65e0\u6cd5\u64a4\u56de\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ReviewEntity entity = (ReviewEntity)((Object)this.service.getById(billId));
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(ReviewEntity::getProjectId, (Object)entity.getProjectId());
        lambdaQueryWrapper.in(ReviewEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        lambdaQueryWrapper.ne(BaseEntity::getId, (Object)billId);
        CommonResponse projectArchiveRes = this.projectArchiveApi.updateArchiveProjectStatus(ArchiveProjectStatusEnum.\u5408\u540c\u9636\u6bb5.getCode(), entity.getProjectId(), entity.getId(), Boolean.valueOf(this.service.list((Wrapper)lambdaQueryWrapper).size() > 0), Boolean.valueOf(true));
        if (!projectArchiveRes.isSuccess()) {
            throw new BusinessException("\u4fee\u6539\u9879\u76ee\u9636\u6bb5\u5931\u8d25\uff0c\u539f\u56e0-" + projectArchiveRes.getMsg());
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"review_id", (Object)billId);
        int count = this.contractRegisterService.count((Wrapper)queryWrapper);
        if (count > 0) {
            return CommonResponse.error((String)"\u5f53\u524d\u8bc4\u5ba1\u5355\u5df2\u88ab\u5408\u540c\u5f15\u7528\uff0c\u65e0\u6cd5\u64a4\u56de\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        ReviewEntity entity = (ReviewEntity)((Object)this.service.getById(billId));
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(ReviewEntity::getProjectId, (Object)entity.getProjectId());
        lambdaQueryWrapper.in(ReviewEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        lambdaQueryWrapper.ne(BaseEntity::getId, (Object)billId);
        CommonResponse projectArchiveRes = this.projectArchiveApi.updateArchiveProjectStatus(ArchiveProjectStatusEnum.\u5408\u540c\u9636\u6bb5.getCode(), entity.getProjectId(), entity.getId(), Boolean.valueOf(this.service.list((Wrapper)lambdaQueryWrapper).size() > 0), Boolean.valueOf(false));
        if (!projectArchiveRes.isSuccess()) {
            throw new BusinessException("\u4fee\u6539\u9879\u76ee\u9636\u6bb5\u5931\u8d25\uff0c\u539f\u56e0-" + projectArchiveRes.getMsg());
        }
        return CommonResponse.success();
    }
}

