/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.jlincome.performance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ejianc.business.jlincome.performance.bean.ForecastDetailEntity;
import com.ejianc.business.jlincome.performance.bean.ForecastEntity;
import com.ejianc.business.jlincome.performance.bean.SaleReportEntity;
import com.ejianc.business.jlincome.performance.enums.ChangeStateEnum;
import com.ejianc.business.jlincome.performance.mapper.ForecastDetailMapper;
import com.ejianc.business.jlincome.performance.mapper.ForecastMapper;
import com.ejianc.business.jlincome.performance.mapper.SaleReportMapper;
import com.ejianc.business.jlincome.performance.service.IForecastService;
import com.ejianc.business.jlincome.performance.vo.ForecastDetailVO;
import com.ejianc.business.jlincome.performance.vo.ForecastLedgerVO;
import com.ejianc.business.jlincome.performance.vo.ForecastRecordVO;
import com.ejianc.business.jlincome.performance.vo.ForecastVO;
import com.ejianc.foundation.share.utils.ITreeNodeB;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="forecastService")
public class ForecastServiceImpl
extends BaseServiceImpl<ForecastMapper, ForecastEntity>
implements IForecastService {
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "FORECAST_CODE";
    @Autowired
    private SaleReportMapper saleReportMapper;
    @Autowired
    private ForecastDetailMapper detailMapper;

    @Override
    public CommonResponse<ForecastVO> insertOrUpdate(ForecastVO saveOrUpdateVO) {
        ForecastEntity revise;
        ForecastEntity entity = (ForecastEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ForecastEntity.class));
        if (entity.getIncomeForecastMny() == null) {
            entity.setIncomeForecastMny(BigDecimal.ZERO);
        }
        if (entity.getInvoiceForecastMny() == null) {
            entity.setInvoiceForecastMny(BigDecimal.ZERO);
        }
        if (entity.getSaleForecastMny() == null) {
            entity.setSaleForecastMny(BigDecimal.ZERO);
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            if (null == entity.getLastForecastId()) {
                entity.setForecastVersion(1);
                entity.setOneTime(entity.getCreateTime());
                entity.setChangeState(ChangeStateEnum.\u672a\u53d8\u66f4.getCode());
            }
            entity.setLatestFlag(true);
            entity.setEnableState(false);
            if (null == entity.getBillCode()) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    entity.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
        }
        this.resetPid(entity.getForecastDetailList());
        super.saveOrUpdate((Object)entity, false);
        if (entity.getLastForecastId() != null && (revise = (ForecastEntity)((Object)super.getById((Serializable)entity.getLastForecastId()))).getLatestFlag().booleanValue()) {
            revise.setChangeId(entity.getId());
            revise.setChangeState(ChangeStateEnum.\u53d8\u66f4\u4e2d.getCode());
            revise.setLatestFlag(false);
            revise.setBaseForecastId(null != revise.getBaseForecastId() ? revise.getBaseForecastId() : revise.getId());
            super.saveOrUpdate((Object)revise);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.queryDetail(entity.getId()));
    }

    private void resetPid(List<ForecastDetailEntity> detailList) {
        if (CollectionUtils.isNotEmpty(detailList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (ForecastDetailEntity detail : detailList) {
                if ("del".equals(detail.getRowState())) continue;
                if (detail.getId() == null) {
                    detail.setId(IdWorker.getId());
                }
                idMap.put(detail.getTid(), detail.getId());
                detail.setParentId(null);
            }
            for (ForecastDetailEntity detail : detailList) {
                if ("del".equals(detail.getRowState()) || !StringUtils.isNotEmpty((CharSequence)detail.getTpid())) continue;
                detail.setParentId((Long)idMap.get(detail.getTpid()));
            }
        }
    }

    @Override
    public ForecastVO queryDetail(Long id) {
        ForecastEntity entity = (ForecastEntity)((Object)super.selectById((Serializable)id));
        ForecastVO vo = (ForecastVO)BeanMapper.map((Object)((Object)entity), ForecastVO.class);
        List detailList = vo.getForecastDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            for (ForecastDetailVO detail : detailList) {
                detail.setTid(detail.getId());
                detail.setTpid(detail.getParentId() != null ? detail.getParentId().toString() : null);
            }
            vo.setForecastDetailList(TreeNodeBUtil.buildTree((List)detailList));
        }
        List list = new ArrayList();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ForecastEntity::getBaseForecastId, (Object)entity.getBaseForecastId());
        queryWrapper.in(ForecastEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.ne(BaseEntity::getId, (Object)id);
        queryWrapper.orderByAsc(BaseEntity::getCreateTime);
        List forecastEntityList = super.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)forecastEntityList)) {
            list = BeanMapper.mapList((Iterable)forecastEntityList, ForecastRecordVO.class);
        }
        vo.setRecordList(list);
        return vo;
    }

    @Override
    public ForecastVO queryChangeDetail(Long id) {
        ForecastEntity entity = (ForecastEntity)((Object)super.selectById((Serializable)id));
        ForecastVO vo = (ForecastVO)BeanMapper.map((Object)((Object)entity), ForecastVO.class);
        vo.setId(null);
        vo.setBillState(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setBeforeForecastVersion(vo.getForecastVersion());
        vo.setForecastVersion(Integer.valueOf(vo.getForecastVersion() + 1));
        vo.setLastForecastId(id);
        vo.setBaseForecastId(null != entity.getBaseForecastId() ? entity.getBaseForecastId() : id);
        vo.setChangeEmployeeId(null);
        vo.setChangeEmployeeName(null);
        vo.setChangeReason(null);
        List detailList = vo.getForecastDetailList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            detailList.forEach(changeDetailVO -> {
                changeDetailVO.setCreateTime(null);
                changeDetailVO.setCreateUserCode(null);
                changeDetailVO.setUpdateTime(null);
                changeDetailVO.setUpdateUserCode(null);
                changeDetailVO.setTid(changeDetailVO.getId());
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : null);
                changeDetailVO.setRowState("add");
            });
            detailList = TreeNodeBUtil.buildTree((List)detailList);
            detailList.forEach(detail -> {
                detail.setId(Long.valueOf(IdWorker.getId()));
                detail.getChildren().forEach(child -> {
                    ((ForecastDetailVO)child).setId(Long.valueOf(IdWorker.getId()));
                    ((ForecastDetailVO)child).setParentId(detail.getId());
                });
            });
            vo.setForecastDetailList(detailList);
        }
        return vo;
    }

    @Override
    public CommonResponse<String> deleteVos(List<ForecastVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ForecastVO forecastVO : vos) {
                ForecastEntity forecastEntity = (ForecastEntity)((Object)super.selectById((Serializable)forecastVO.getId()));
                if (forecastEntity.getLastForecastId() == null) continue;
                ForecastEntity revise = (ForecastEntity)((Object)super.getById((Serializable)forecastEntity.getLastForecastId()));
                revise.setChangeId(null);
                revise.setLatestFlag(true);
                revise.setChangeState(1 == forecastEntity.getForecastVersion() ? ChangeStateEnum.\u672a\u53d8\u66f4.getCode() : ChangeStateEnum.\u5df2\u53d8\u66f4.getCode());
                super.saveOrUpdate((Object)revise);
            }
        }
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<String> checkOrgMonth(Long rowId, Long orgId, String forecastMonth) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"org_id", (Object)orgId);
        query.eq((Object)"forecast_month", (Object)(forecastMonth + "-01"));
        if (rowId != null) {
            query.ne((Object)"id", (Object)rowId);
        }
        List billList = super.list((Wrapper)query);
        billList.forEach(bill -> System.out.println(bill.getId()));
        return CommonResponse.success((String)(CollectionUtils.isNotEmpty((Collection)billList) ? "\u672c\u533a\u57df + \u9884\u62a5\u6708\u4efd\u5df2\u6709\u9500\u552e\u9884\u62a5\u7684\u5355\u636e\uff01" : null));
    }

    @Override
    public void updateResDatas(List<ForecastLedgerVO> resDatas) {
        if (CollectionUtils.isNotEmpty(resDatas)) {
            for (ForecastLedgerVO resData : resDatas) {
                BigDecimal child2CompletionCount = new BigDecimal(0);
                BigDecimal child2CompletionGapCount = new BigDecimal(0);
                BigDecimal child2invoiceCompletionMny = new BigDecimal(0);
                BigDecimal child2invoiceCompletionGap = new BigDecimal(0);
                BigDecimal child2incomeCompletionMny = new BigDecimal(0);
                BigDecimal child2incomeCompletionGap = new BigDecimal(0);
                for (ITreeNodeB child : resData.getChildren()) {
                    ForecastLedgerVO child2 = (ForecastLedgerVO)child;
                    BigDecimal child3CompletionCount = new BigDecimal(0);
                    BigDecimal child3CompletionGapCount = new BigDecimal(0);
                    BigDecimal child3invoiceCompletionMny = new BigDecimal(0);
                    BigDecimal child3invoiceCompletionGap = new BigDecimal(0);
                    BigDecimal child3incomeCompletionMny = new BigDecimal(0);
                    BigDecimal child3incomeCompletionGap = new BigDecimal(0);
                    if (!child2.getLeafFlag().booleanValue()) {
                        for (ITreeNodeB childChild : child.getChildren()) {
                            ForecastLedgerVO child3 = (ForecastLedgerVO)childChild;
                            this.extract3(child3);
                            child3CompletionCount = child3CompletionCount.add(child3.getSaleCompletionMny());
                            child3CompletionGapCount = child3CompletionGapCount.add(child3.getSaleCompletionGap());
                            child3invoiceCompletionMny = child3invoiceCompletionMny.add(child3.getInvoiceCompletionMny());
                            child3invoiceCompletionGap = child3invoiceCompletionGap.add(child3.getInvoiceCompletionGap());
                            child3incomeCompletionMny = child3incomeCompletionMny.add(child3.getIncomeCompletionMny());
                            child3incomeCompletionGap = child3incomeCompletionGap.add(child3.getIncomeCompletionGap());
                        }
                        child2.setSaleCompletionMny(child3CompletionCount);
                        child2.setSaleCompletionGap(child3CompletionGapCount);
                        child2.setInvoiceCompletionMny(child3invoiceCompletionMny);
                        child2.setInvoiceCompletionGap(child3invoiceCompletionGap);
                        child2.setIncomeCompletionMny(child3incomeCompletionMny);
                        child2.setIncomeCompletionGap(child3incomeCompletionGap);
                    } else {
                        this.extract2(child2);
                    }
                    child2CompletionCount = child2CompletionCount.add(child2.getSaleCompletionMny());
                    child2CompletionGapCount = child2CompletionGapCount.add(child2.getSaleCompletionGap());
                    child2invoiceCompletionMny = child2invoiceCompletionMny.add(child2.getInvoiceCompletionMny());
                    child2invoiceCompletionGap = child2invoiceCompletionGap.add(child2.getInvoiceCompletionGap());
                    child2incomeCompletionMny = child2incomeCompletionMny.add(child2.getIncomeCompletionMny());
                    child2incomeCompletionGap = child2incomeCompletionGap.add(child2.getIncomeCompletionGap());
                }
                resData.setSaleCompletionMny(child2CompletionCount);
                resData.setSaleCompletionGap(child2CompletionGapCount);
                resData.setInvoiceCompletionMny(child2invoiceCompletionMny);
                resData.setInvoiceCompletionGap(child2invoiceCompletionGap);
                resData.setIncomeCompletionMny(child2incomeCompletionMny);
                resData.setIncomeCompletionGap(child2incomeCompletionGap);
            }
        }
    }

    private void extract3(ForecastLedgerVO child) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.select(new SFunction[]{ForecastEntity::getForecastMonth});
        wrapper.eq(BaseEntity::getId, (Object)child.getPid());
        ForecastEntity forecastEntity = (ForecastEntity)((Object)((ForecastMapper)this.baseMapper).selectOne((Wrapper)wrapper));
        Date forecastMonth = forecastEntity.getForecastMonth();
        SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd");
        String month = sim.format(forecastMonth).substring(5, 7);
        String year = sim.format(forecastMonth).substring(0, 4);
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        wrapper1.eq(BaseEntity::getId, (Object)child.getParentId());
        ForecastDetailEntity forecastDetailEntity = (ForecastDetailEntity)((Object)this.detailMapper.selectOne((Wrapper)wrapper1));
        LambdaQueryWrapper saleReportWrapper = new LambdaQueryWrapper();
        saleReportWrapper.eq(SaleReportEntity::getYear, (Object)year);
        saleReportWrapper.eq(SaleReportEntity::getEmployeeId, (Object)child.getDetailPersonId());
        saleReportWrapper.eq(SaleReportEntity::getTeamOrgId, (Object)forecastDetailEntity.getDetailOrgId());
        switch (month) {
            case "01": {
                List saleReportEntities = this.saleReportMapper.selectList((Wrapper)saleReportWrapper);
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty((Collection)saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFirstOneMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFirstOneMny());
                        }
                        if (saleReportEntity.getKpFirstOneMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpFirstOneMny());
                        }
                        if (saleReportEntity.getSkFirstOneMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkFirstOneMny());
                    }
                    ForecastServiceImpl.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                    break;
                }
                ForecastServiceImpl.setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "02": {
                List saleReportEntities = this.saleReportMapper.selectList((Wrapper)saleReportWrapper);
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty((Collection)saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFirstTwoMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFirstTwoMny());
                            incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkFirstTwoMny());
                        }
                        if (saleReportEntity.getKpFirstTwoMny() != null) {
                            // empty if block
                        }
                        if (saleReportEntity.getSkFirstTwoMny() == null) continue;
                        invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpFirstTwoMny());
                    }
                    ForecastServiceImpl.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                    break;
                }
                ForecastServiceImpl.setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "03": {
                List saleReportEntities = this.saleReportMapper.selectList((Wrapper)saleReportWrapper);
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty((Collection)saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFirstThreeMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFirstThreeMny());
                        }
                        if (saleReportEntity.getKpFirstThreeMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpFirstThreeMny());
                        }
                        if (saleReportEntity.getSkFirstThreeMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkFirstThreeMny());
                    }
                    ForecastServiceImpl.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                    break;
                }
                ForecastServiceImpl.setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "04": {
                List saleReportEntities = this.saleReportMapper.selectList((Wrapper)saleReportWrapper);
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty((Collection)saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleSecondFourMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleSecondFourMny());
                        }
                        if (saleReportEntity.getKpSecondFourMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpSecondFourMny());
                        }
                        if (saleReportEntity.getSkSecondFourMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkSecondFourMny());
                    }
                    ForecastServiceImpl.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                    break;
                }
                ForecastServiceImpl.setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "05": {
                List saleReportEntities = this.saleReportMapper.selectList((Wrapper)saleReportWrapper);
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty((Collection)saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleSecondFiveMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleSecondFiveMny());
                        }
                        if (saleReportEntity.getKpSecondFiveMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpSecondFiveMny());
                        }
                        if (saleReportEntity.getSkSecondFiveMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkSecondFiveMny());
                    }
                    ForecastServiceImpl.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                    break;
                }
                ForecastServiceImpl.setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "06": {
                List saleReportEntities = this.saleReportMapper.selectList((Wrapper)saleReportWrapper);
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty((Collection)saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleSecondSixMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleSecondSixMny());
                        }
                        if (saleReportEntity.getKpSecondSixMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpSecondSixMny());
                        }
                        if (saleReportEntity.getSkSecondSixMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkSecondSixMny());
                    }
                    ForecastServiceImpl.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                    break;
                }
                ForecastServiceImpl.setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "07": {
                List saleReportEntities = this.saleReportMapper.selectList((Wrapper)saleReportWrapper);
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty((Collection)saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleThirdSevenMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleThirdSevenMny());
                        }
                        if (saleReportEntity.getKpThirdSevenMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpThirdSevenMny());
                        }
                        if (saleReportEntity.getSkThirdSevenMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkThirdSevenMny());
                    }
                    ForecastServiceImpl.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                    break;
                }
                ForecastServiceImpl.setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "08": {
                List saleReportEntities = this.saleReportMapper.selectList((Wrapper)saleReportWrapper);
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty((Collection)saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleThirdEightMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleThirdEightMny());
                        }
                        if (saleReportEntity.getKpThirdEightMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpThirdEightMny());
                        }
                        if (saleReportEntity.getSkThirdEightMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkThirdEightMny());
                    }
                    ForecastServiceImpl.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                    break;
                }
                ForecastServiceImpl.setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "09": {
                List saleReportEntities = this.saleReportMapper.selectList((Wrapper)saleReportWrapper);
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty((Collection)saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleThirdNineMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleThirdNineMny());
                        }
                        if (saleReportEntity.getKpThirdNineMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpThirdNineMny());
                        }
                        if (saleReportEntity.getSkThirdNineMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkThirdNineMny());
                    }
                    ForecastServiceImpl.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                    break;
                }
                ForecastServiceImpl.setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "10": {
                List saleReportEntities = this.saleReportMapper.selectList((Wrapper)saleReportWrapper);
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty((Collection)saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFourthTenMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFourthTenMny());
                        }
                        if (saleReportEntity.getKpFourthTenMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpFourthTenMny());
                        }
                        if (saleReportEntity.getSkFourthTenMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkFourthTenMny());
                    }
                    ForecastServiceImpl.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                    break;
                }
                ForecastServiceImpl.setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "11": {
                List saleReportEntities = this.saleReportMapper.selectList((Wrapper)saleReportWrapper);
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty((Collection)saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFourthElevenMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFourthElevenMny());
                        }
                        if (saleReportEntity.getKpFourthElevenMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpFourthElevenMny());
                        }
                        if (saleReportEntity.getSkFourthElevenMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkFourthElevenMny());
                    }
                    ForecastServiceImpl.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                    break;
                }
                ForecastServiceImpl.setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "12": {
                List saleReportEntities = this.saleReportMapper.selectList((Wrapper)saleReportWrapper);
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty((Collection)saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFourthTwelveMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFourthTwelveMny());
                        }
                        if (saleReportEntity.getKpFourthTwelveMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpFourthTwelveMny());
                        }
                        if (saleReportEntity.getSkFourthTwelveMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkFourthTwelveMny());
                    }
                    ForecastServiceImpl.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                    break;
                }
                ForecastServiceImpl.setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
        }
    }

    private void extract2(ForecastLedgerVO child) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.select(new SFunction[]{ForecastEntity::getForecastMonth});
        wrapper.eq(BaseEntity::getId, (Object)child.getPid());
        ForecastEntity forecastEntity = (ForecastEntity)((Object)((ForecastMapper)this.baseMapper).selectOne((Wrapper)wrapper));
        Date forecastMonth = forecastEntity.getForecastMonth();
        SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd");
        String month = sim.format(forecastMonth).substring(5, 7);
        String year = sim.format(forecastMonth).substring(0, 4);
        LambdaQueryWrapper saleReportWrapper = new LambdaQueryWrapper();
        saleReportWrapper.eq(SaleReportEntity::getYear, (Object)year);
        saleReportWrapper.eq(SaleReportEntity::getEmployeeId, (Object)child.getDetailPersonId());
        saleReportWrapper.eq(SaleReportEntity::getTeamOrgId, (Object)child.getDetailOrgId());
        switch (month) {
            case "01": {
                List saleReportEntities = this.saleReportMapper.selectList((Wrapper)saleReportWrapper);
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty((Collection)saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFirstOneMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFirstOneMny());
                        }
                        if (saleReportEntity.getKpFirstOneMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpFirstOneMny());
                        }
                        if (saleReportEntity.getSkFirstOneMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkFirstOneMny());
                    }
                    ForecastServiceImpl.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                    break;
                }
                ForecastServiceImpl.setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "02": {
                List saleReportEntities = this.saleReportMapper.selectList((Wrapper)saleReportWrapper);
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty((Collection)saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFirstTwoMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFirstTwoMny());
                            incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkFirstTwoMny());
                        }
                        if (saleReportEntity.getKpFirstTwoMny() != null) {
                            // empty if block
                        }
                        if (saleReportEntity.getSkFirstTwoMny() == null) continue;
                        invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpFirstTwoMny());
                    }
                    ForecastServiceImpl.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                    break;
                }
                ForecastServiceImpl.setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "03": {
                List saleReportEntities = this.saleReportMapper.selectList((Wrapper)saleReportWrapper);
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty((Collection)saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFirstThreeMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFirstThreeMny());
                        }
                        if (saleReportEntity.getKpFirstThreeMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpFirstThreeMny());
                        }
                        if (saleReportEntity.getSkFirstThreeMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkFirstThreeMny());
                    }
                    ForecastServiceImpl.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                    break;
                }
                ForecastServiceImpl.setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "04": {
                List saleReportEntities = this.saleReportMapper.selectList((Wrapper)saleReportWrapper);
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty((Collection)saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleSecondFourMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleSecondFourMny());
                        }
                        if (saleReportEntity.getKpSecondFourMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpSecondFourMny());
                        }
                        if (saleReportEntity.getSkSecondFourMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkSecondFourMny());
                    }
                    ForecastServiceImpl.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                    break;
                }
                ForecastServiceImpl.setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "05": {
                List saleReportEntities = this.saleReportMapper.selectList((Wrapper)saleReportWrapper);
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty((Collection)saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleSecondFiveMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleSecondFiveMny());
                        }
                        if (saleReportEntity.getKpSecondFiveMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpSecondFiveMny());
                        }
                        if (saleReportEntity.getSkSecondFiveMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkSecondFiveMny());
                    }
                    ForecastServiceImpl.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                    break;
                }
                ForecastServiceImpl.setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "06": {
                List saleReportEntities = this.saleReportMapper.selectList((Wrapper)saleReportWrapper);
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty((Collection)saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleSecondSixMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleSecondSixMny());
                        }
                        if (saleReportEntity.getKpSecondSixMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpSecondSixMny());
                        }
                        if (saleReportEntity.getSkSecondSixMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkSecondSixMny());
                    }
                    ForecastServiceImpl.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                    break;
                }
                ForecastServiceImpl.setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "07": {
                List saleReportEntities = this.saleReportMapper.selectList((Wrapper)saleReportWrapper);
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty((Collection)saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleThirdSevenMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleThirdSevenMny());
                        }
                        if (saleReportEntity.getKpThirdSevenMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpThirdSevenMny());
                        }
                        if (saleReportEntity.getSkThirdSevenMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkThirdSevenMny());
                    }
                    ForecastServiceImpl.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                    break;
                }
                ForecastServiceImpl.setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "08": {
                List saleReportEntities = this.saleReportMapper.selectList((Wrapper)saleReportWrapper);
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty((Collection)saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleThirdEightMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleThirdEightMny());
                        }
                        if (saleReportEntity.getKpThirdEightMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpThirdEightMny());
                        }
                        if (saleReportEntity.getSkThirdEightMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkThirdEightMny());
                    }
                    ForecastServiceImpl.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                    break;
                }
                ForecastServiceImpl.setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "09": {
                List saleReportEntities = this.saleReportMapper.selectList((Wrapper)saleReportWrapper);
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty((Collection)saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleThirdNineMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleThirdNineMny());
                        }
                        if (saleReportEntity.getKpThirdNineMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpThirdNineMny());
                        }
                        if (saleReportEntity.getSkThirdNineMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkThirdNineMny());
                    }
                    ForecastServiceImpl.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                    break;
                }
                ForecastServiceImpl.setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "10": {
                List saleReportEntities = this.saleReportMapper.selectList((Wrapper)saleReportWrapper);
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty((Collection)saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFourthTenMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFourthTenMny());
                        }
                        if (saleReportEntity.getKpFourthTenMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpFourthTenMny());
                        }
                        if (saleReportEntity.getSkFourthTenMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkFourthTenMny());
                    }
                    ForecastServiceImpl.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                    break;
                }
                ForecastServiceImpl.setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "11": {
                List saleReportEntities = this.saleReportMapper.selectList((Wrapper)saleReportWrapper);
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty((Collection)saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFourthElevenMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFourthElevenMny());
                        }
                        if (saleReportEntity.getKpFourthElevenMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpFourthElevenMny());
                        }
                        if (saleReportEntity.getSkFourthElevenMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkFourthElevenMny());
                    }
                    ForecastServiceImpl.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                    break;
                }
                ForecastServiceImpl.setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
            case "12": {
                List saleReportEntities = this.saleReportMapper.selectList((Wrapper)saleReportWrapper);
                BigDecimal CompletionMny = new BigDecimal(0);
                BigDecimal completionGap = new BigDecimal(0);
                BigDecimal invoiceCompletionMny = new BigDecimal(0);
                BigDecimal invoiceCompletionGap = new BigDecimal(0);
                BigDecimal incomeCompletionMny = new BigDecimal(0);
                BigDecimal incomeCompletionGap = new BigDecimal(0);
                if (CollectionUtils.isNotEmpty((Collection)saleReportEntities)) {
                    for (SaleReportEntity saleReportEntity : saleReportEntities) {
                        if (saleReportEntity.getSaleFourthTwelveMny() != null) {
                            CompletionMny = CompletionMny.add(saleReportEntity.getSaleFourthTwelveMny());
                        }
                        if (saleReportEntity.getKpFourthTwelveMny() != null) {
                            invoiceCompletionMny = invoiceCompletionMny.add(saleReportEntity.getKpFourthTwelveMny());
                        }
                        if (saleReportEntity.getSkFourthTwelveMny() == null) continue;
                        incomeCompletionMny = incomeCompletionMny.add(saleReportEntity.getSkFourthTwelveMny());
                    }
                    ForecastServiceImpl.setMny1(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                    break;
                }
                ForecastServiceImpl.setMny2(child, CompletionMny, invoiceCompletionMny, incomeCompletionMny);
                break;
            }
        }
    }

    private static void setMny2(ForecastLedgerVO child, BigDecimal CompletionMny, BigDecimal invoiceCompletionMny, BigDecimal incomeCompletionMny) {
        child.setSaleCompletionMny(CompletionMny);
        child.setInvoiceCompletionMny(invoiceCompletionMny);
        child.setIncomeCompletionMny(incomeCompletionMny);
        child.setSaleCompletionGap(BigDecimal.valueOf(0L).subtract(child.getSaleForecastMny()));
        child.setInvoiceCompletionGap(BigDecimal.valueOf(0L).subtract(child.getInvoiceForecastMny()));
        child.setIncomeCompletionGap(BigDecimal.valueOf(0L).subtract(child.getIncomeForecastMny()));
    }

    private static void setMny1(ForecastLedgerVO child, BigDecimal CompletionMny, BigDecimal invoiceCompletionMny, BigDecimal incomeCompletionMny) {
        child.setSaleCompletionMny(CompletionMny);
        child.setInvoiceCompletionMny(invoiceCompletionMny);
        child.setIncomeCompletionMny(incomeCompletionMny);
        BigDecimal completionGap = child.getSaleCompletionMny().subtract(child.getSaleForecastMny());
        BigDecimal invoiceCompletionGap = child.getInvoiceCompletionMny().subtract(child.getInvoiceForecastMny());
        BigDecimal incomeCompletionGap = child.getIncomeCompletionMny().subtract(child.getIncomeForecastMny());
        child.setSaleCompletionGap(completionGap);
        child.setInvoiceCompletionGap(invoiceCompletionGap);
        child.setIncomeCompletionGap(incomeCompletionGap);
    }
}

