package com.ejianc.business.jlincome.bid.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlincome.bid.bean.EngineeringReportEntity;
import com.ejianc.business.jlincome.bid.vo.BidInitiationVO;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlincome.bid.mapper.BidInitiationMapper;
import com.ejianc.business.jlincome.bid.bean.BidInitiationEntity;
import com.ejianc.business.jlincome.bid.service.IBidInitiationService;

/**
 * 投标-投标立项
 *
 * @author generator
 */
@Service("bidInitiationService")
public class BidInitiationServiceImpl extends BaseServiceImpl<BidInitiationMapper, BidInitiationEntity> implements IBidInitiationService {

    @Autowired
    private IProjectArchiveApi projectArchiveApi;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public Boolean checkProjectIsExist(BidInitiationEntity bidInitiation) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<BidInitiationEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(BidInitiationEntity::getProjectId, bidInitiation.getProjectId());
        lambdaQueryWrapper.eq(BidInitiationEntity::getTenantId, tenantId);
        if (bidInitiation.getId() != null) {
            lambdaQueryWrapper.ne(BidInitiationEntity::getId, bidInitiation.getId());
        }
        return super.list(lambdaQueryWrapper).size() > 0;
    }

    /**
     * 更新商机合同阶段状态
     * @param projectStatus
     * @param projectId
     * @return
     */
    @Override
    public CommonResponse<String> pushResultRegisterProjectArchive(String projectStatus, Long projectId) {
        logger.info("投标立项-推送项目信息数据----" + "projectId = " + projectId.toString() + ",projectStatus" + projectStatus);
        return projectArchiveApi.updateProjectStatus(projectStatus, projectId);
    }
}
