package com.ejianc.business.jlincome.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlincome.bid.bean.BusinessEntity;
import com.ejianc.business.jlincome.bid.mapper.BusinessMapper;
import com.ejianc.business.jlincome.bid.vo.EngineeringReportVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.jlincome.bid.mapper.EngineeringReportMapper;
import com.ejianc.business.jlincome.bid.bean.EngineeringReportEntity;
import com.ejianc.business.jlincome.bid.service.IEngineeringReportService;
import org.springframework.util.CollectionUtils;

import java.nio.file.Watchable;
import java.util.ArrayList;
import java.util.List;

/**
 * 投标-工程调研报告
 *
 * @author generator
 */
@Service("engineeringReportService")
public class EngineeringReportServiceImpl extends BaseServiceImpl<EngineeringReportMapper, EngineeringReportEntity> implements IEngineeringReportService {
    @Autowired
    private BusinessMapper businessMapper;

    @Override
    public boolean checkIsExist(EngineeringReportVO reportVO) {

        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<EngineeringReportEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(EngineeringReportEntity::getEngineeringId, reportVO.getEngineeringId());
        lambda.eq(EngineeringReportEntity::getTenantId, tenantId);
        if (null != reportVO.getId() && reportVO.getId() > 0) {
            lambda.ne(EngineeringReportEntity::getId, reportVO.getId());
        }
        return super.list(lambda).size() > 0;

    }
}
