package com.ejianc.business.jlincome.income.controller;

import java.io.Serializable;

import com.ejianc.business.jlincome.bid.vo.EngineeringReportExportVO;
import com.ejianc.business.jlincome.income.bean.ContractRegisterDetailEntity;
import com.ejianc.business.jlincome.income.bean.ContractRegisterRecordDetailEntity;
import com.ejianc.business.jlincome.income.bean.DisclosureConDetailsEntity;
import com.ejianc.business.jlincome.income.service.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.jlincome.income.bean.DisclosureEntity;
import com.ejianc.business.jlincome.income.vo.DisclosureVO;

/**
 * 收入管理-合同交底
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("disclosure")
public class DisclosureController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Contract_Disclosure";//此处需要根据实际修改

    @Autowired
    private IDisclosureService service;



    @Autowired
    private IContractRegisterDetailService detailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DisclosureVO> saveOrUpdate(@RequestBody DisclosureVO saveOrUpdateVO) {
    	DisclosureEntity entity = BeanMapper.map(saveOrUpdateVO, DisclosureEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
               // entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	DisclosureVO vo = BeanMapper.map(entity, DisclosureVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DisclosureVO> queryDetail(Long id) {
    	DisclosureEntity entity = service.selectById(id);
    	DisclosureVO vo = BeanMapper.map(entity, DisclosureVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DisclosureVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (DisclosureVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(DisclosureVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DisclosureVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        extracted(param);

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<DisclosureEntity> page = service.queryPage(param,false);
        IPage<DisclosureVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), DisclosureVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {

        /** 模糊搜索配置字段示例 */
        extracted(param);
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<DisclosureEntity> list = service.queryList(param);
        List<DisclosureVO> disclosureVOS = BeanMapper.mapList(list, DisclosureVO.class);
        for (DisclosureVO disclosureVO : disclosureVOS) {

            if(disclosureVO.getBillState()==0){
                disclosureVO.setState("自由态");
            }
            if(disclosureVO.getBillState()==2||disclosureVO.getBillState()==5){
                disclosureVO.setState("审批中");
            }
            if(disclosureVO.getBillState()==1){
                disclosureVO.setState("已提交");
            }
            if(disclosureVO.getBillState()==3){
                disclosureVO.setState("审批通过");
            }
            if(disclosureVO.getBillState()==4){
                disclosureVO.setState("审批驳回");
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", disclosureVOS);
        ExcelExport.getInstance().export("Disclosure-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refDisclosureData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DisclosureVO>> refDisclosureData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DisclosureEntity> page = service.queryPage(param,false);
        IPage<DisclosureVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DisclosureVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    @GetMapping("/selectContractDetails")
    @ResponseBody
    public CommonResponse selectMoney(Long id) {
        System.out.println(id);
        List<ContractRegisterDetailEntity> list = detailService.selectContractDetails(id);
        return CommonResponse.success("成功", list);
    }

    private static void extracted(QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();

        //单据编号、合同名称、项目名称、区域名称、承接单位、客户名称、项目类型、产品类型、交底人姓名、经办人
        fuzzyFields.add("billCode");//单据编号
        fuzzyFields.add("contractName");//合同名称
        fuzzyFields.add("projectName");//项目名称
        fuzzyFields.add("parentOrgName");//区域名称
        fuzzyFields.add("undertakeUnitName");//承接单位
        fuzzyFields.add("customerName");//客户名称
        fuzzyFields.add("projectTypeName");//项目类型
        fuzzyFields.add("productTypeName");//产品类型
        fuzzyFields.add("disclosurePeopleName");//交底人姓名
        fuzzyFields.add("employeeName");//经办人
    }
}
