package com.ejianc.business.jlincome.income.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.jlincome.income.vo.ContractRegisterVO;
import com.ejianc.foundation.share.vo.ProjectArchiveVO;
import com.ejianc.business.jlincome.income.vo.ProjectBoardTwoVO;
import com.ejianc.business.jlincome.income.vo.ProjectBoardVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.jlincome.income.bean.ContractRegisterEntity;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 收入管理-合同登记
 * 
 * @author generator
 * 
 */
public interface IContractRegisterService extends IBaseService<ContractRegisterEntity> {

    boolean checkSameBillCode(ContractRegisterVO vo);
    void performanceStatusUp(Long id , Integer performanceStatus);

    CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response);

    JSONObject queryContractMnyByProjectId(Long projectId);

    ContractRegisterVO queryDetail(Long id);

    Map<String, BigDecimal> queryContractMnyByReviewId(Long reviewId);

    ProjectBoardVO queryContractBoardList(QueryParam param);

    List<ContractRegisterEntity> selectExpireContractList();
    List<ProjectBoardTwoVO> queryProjectBoardList(QueryParam param, List<ProjectArchiveVO> projectRecords);
}
