package com.ejianc.business.jlincome.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.jlincome.income.bean.ContractRegisterEntity;
import com.ejianc.business.jlincome.income.bean.ReviewEntity;
import com.ejianc.business.jlincome.income.service.IContractRegisterService;
import com.ejianc.business.jlincome.income.service.IReviewService;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.consts.ArchiveProjectStatusEnum;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Arrays;

@Service("review") 
public class ReviewBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	//查询
	private IContractRegisterService contractRegisterService;

	@Autowired
	private IReviewService service;
	@Autowired
	private IProjectArchiveApi projectArchiveApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		QueryWrapper<ContractRegisterEntity> queryWrapper = new QueryWrapper<ContractRegisterEntity>();
		queryWrapper.eq("review_id",billId);
		int count = contractRegisterService.count(queryWrapper);
		if (count>0){
			return CommonResponse.error("当前评审单已被合同引用，无法撤回！");
		}
		return CommonResponse.success();

	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return bpmBackCheck(billId, state, billTypeCode);
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ReviewEntity entity = service.getById(billId);

		LambdaQueryWrapper<ReviewEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
		lambdaQueryWrapper.eq(ReviewEntity::getProjectId, entity.getProjectId());
		lambdaQueryWrapper.in(ReviewEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
		lambdaQueryWrapper.ne(ReviewEntity::getId, billId);

		CommonResponse<String> projectArchiveRes = projectArchiveApi.updateArchiveProjectStatus(ArchiveProjectStatusEnum.合同阶段.getCode(), entity.getProjectId(), entity.getId(), service.list(lambdaQueryWrapper).size() > 0 ? true : false, true);
		if (!projectArchiveRes.isSuccess()){
			throw new BusinessException("修改项目阶段失败，原因-" + projectArchiveRes.getMsg());
		}
		//TODO
		return CommonResponse.success();
	}


	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		QueryWrapper<ContractRegisterEntity> queryWrapper = new QueryWrapper<ContractRegisterEntity>();
		queryWrapper.eq("review_id",billId);
		int count = contractRegisterService.count(queryWrapper);
		if (count>0){
			return CommonResponse.error("当前评审单已被合同引用，无法撤回！");
		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {

		ReviewEntity entity = service.getById(billId);

		LambdaQueryWrapper<ReviewEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
		lambdaQueryWrapper.eq(ReviewEntity::getProjectId, entity.getProjectId());
		lambdaQueryWrapper.in(ReviewEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
		lambdaQueryWrapper.ne(ReviewEntity::getId, billId);

		CommonResponse<String> projectArchiveRes = projectArchiveApi.updateArchiveProjectStatus(ArchiveProjectStatusEnum.合同阶段.getCode(), entity.getProjectId(), entity.getId(), service.list(lambdaQueryWrapper).size() > 0 ? true : false, false);
		if (!projectArchiveRes.isSuccess()){
			throw new BusinessException("修改项目阶段失败，原因-" + projectArchiveRes.getMsg());
		}
		return CommonResponse.success();
	}

}
