package com.ejianc.business.jlincome.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.jlincome.income.bean.SettleDeductionEntity;
import com.ejianc.business.jlincome.income.bean.SettleEntity;
import com.ejianc.business.jlincome.income.service.IContractRegisterService;
import com.ejianc.business.jlincome.income.service.IDeductionService;
import com.ejianc.business.jlincome.income.service.ISettleService;
import com.ejianc.foundation.share.api.IProjectArchiveApi;
import com.ejianc.foundation.share.consts.ArchiveProjectStatusEnum;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@Service("settle")
public class SettleBpmServiceImpl implements ICommonBusinessService {
    @Autowired
    private ISettleService service;
    @Autowired
    private IContractRegisterService contractService;
    @Autowired
    private IDeductionService deductedService;
    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IProjectArchiveApi projectArchiveApi;
    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        SettleEntity settleEntity = service.selectById(billId);

        //若当前合同有其他结算的自由态的结算单，也不能弃审/撤回！
        LambdaQueryWrapper<SettleEntity> settleLambda = new LambdaQueryWrapper<>();
        settleLambda.eq(SettleEntity::getContractId, settleEntity.getContractId());
        settleLambda.ne(SettleEntity::getId, billId);
        settleLambda.and(c -> c.notIn(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));

        List<SettleEntity> resultList = service.list(settleLambda);

        if (resultList.size() > 0 && null != resultList.get(0)) {
            return CommonResponse.error("当前合同有未审批的结算单，不能弃审/撤回!");
        }
        //若当前过程结算单不是最新的，则不能弃审/撤回
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, settleEntity.getContractId()));
        param.getOrderMap().put("create_time", QueryParam.DESC);
        List<SettleEntity> settleList = service.queryList(param);
        if (CollectionUtils.isNotEmpty(settleList) && null != settleList.get(0)) {
            return CommonResponse.error("当前单据已有新的结算单，不能弃审/撤回！");
        }
        return CommonResponse.success();
    }



    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        SettleEntity settleEntity = service.selectById(billId);
        //回写项目信息-项目阶段
        LambdaQueryWrapper<SettleEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(SettleEntity::getProjectId, settleEntity.getProjectId());
        lambdaQueryWrapper.in(SettleEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        lambdaQueryWrapper.ne(SettleEntity::getId, billId);

        String projectStatus = settleEntity.getSettleType() == 1 ? ArchiveProjectStatusEnum.结算阶段.getCode() : ArchiveProjectStatusEnum.完工.getCode();
        Boolean manyFlag = settleEntity.getSettleType() == 1 ? (service.list(lambdaQueryWrapper).size() > 0 ? true : false) : false;
        CommonResponse<String> projectArchiveRes = projectArchiveApi.updateArchiveProjectStatus(projectStatus, settleEntity.getProjectId(), settleEntity.getId(), manyFlag, false);
        if (!projectArchiveRes.isSuccess()){
            throw new BusinessException("修改项目阶段失败，原因-" + projectArchiveRes.getMsg());
        }
        return CommonResponse.success();
    }


    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }


    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SettleEntity settleEntity = service.selectById(billId);

        //回写项目信息-项目阶段
        LambdaQueryWrapper<SettleEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(SettleEntity::getProjectId, settleEntity.getProjectId());
        lambdaQueryWrapper.in(SettleEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        lambdaQueryWrapper.ne(SettleEntity::getId, billId);

        String projectStatus = settleEntity.getSettleType() == 1 ? ArchiveProjectStatusEnum.结算阶段.getCode() : ArchiveProjectStatusEnum.完工.getCode();
        Boolean manyFlag = settleEntity.getSettleType() == 1 ? (service.list(lambdaQueryWrapper).size() > 0 ? true : false) : false;
        CommonResponse<String> projectArchiveRes = projectArchiveApi.updateArchiveProjectStatus(projectStatus, settleEntity.getProjectId(), settleEntity.getId(), manyFlag, true);
        if (!projectArchiveRes.isSuccess()){
            throw new BusinessException("修改项目阶段失败，原因-" + projectArchiveRes.getMsg());
        }


        //回写合同
		if(settleEntity.getSettleType()==2){
			//回写合同
			contractService.performanceStatusUp(settleEntity.getContractId(), 3);
		}
		if (CollectionUtils.isNotEmpty(settleEntity.getDeductionList())) {
            //回写扣款
            List<SettleDeductionEntity> detailList = settleEntity.getDeductionList();
            deductedService.hasRecordUp(detailList.stream().map(SettleDeductionEntity::getSourceId).collect(Collectors.toList()), 1);
        }
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        SettleEntity settleEntity = service.selectById(billId);

        //若当前合同有其他结算的自由态的结算单，也不能弃审/撤回！
        LambdaQueryWrapper<SettleEntity> settleLambda = new LambdaQueryWrapper<>();
        settleLambda.eq(SettleEntity::getContractId, settleEntity.getContractId());
        settleLambda.ne(SettleEntity::getId, billId);
        settleLambda.and(c -> c.notIn(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));

        List<SettleEntity> resultList = service.list(settleLambda);

        if (resultList.size() > 0 && null != resultList.get(0)) {
            return CommonResponse.error("当前合同有未审批的结算单，不能弃审/撤回!");
        }
        //若当前过程结算单不是最新的，则不能弃审/撤回
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, settleEntity.getContractId()));
        param.getOrderMap().put("create_time", QueryParam.DESC);
        List<SettleEntity> settleList = service.queryList(param);
        if (CollectionUtils.isNotEmpty(settleList) && null != settleList.get(0)) {
            SettleEntity nodeSettle = settleList.get(0);
            if (!nodeSettle.getId().equals(billId)) {
                return CommonResponse.error("当前单据已有新的结算单，不能弃审/撤回！");
            }
        }


        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        SettleEntity settleEntity = service.selectById(billId);

        //回写项目信息-项目阶段
        LambdaQueryWrapper<SettleEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(SettleEntity::getProjectId, settleEntity.getProjectId());
        lambdaQueryWrapper.in(SettleEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        lambdaQueryWrapper.ne(SettleEntity::getId, billId);

        String projectStatus = settleEntity.getSettleType() == 1 ? ArchiveProjectStatusEnum.结算阶段.getCode() : ArchiveProjectStatusEnum.完工.getCode();
        Boolean manyFlag = settleEntity.getSettleType() == 1 ? (service.list(lambdaQueryWrapper).size() > 0 ? true : false) : false;
        CommonResponse<String> projectArchiveRes = projectArchiveApi.updateArchiveProjectStatus(projectStatus, settleEntity.getProjectId(), settleEntity.getId(), manyFlag, false);
        if (!projectArchiveRes.isSuccess()){
            throw new BusinessException("修改项目阶段失败，原因-" + projectArchiveRes.getMsg());
        }

        //若当前合同有其他结算的自由态的结算单，也不能弃审/撤回！
        LambdaQueryWrapper<SettleEntity> settleLambda = new LambdaQueryWrapper<>();
        settleLambda.eq(SettleEntity::getContractId, settleEntity.getContractId());
        settleLambda.ne(SettleEntity::getId, billId);
        settleLambda.and(c -> c.notIn(SettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()));

        List<SettleEntity> resultList = service.list(settleLambda);

        if (resultList.size() > 0 && null != resultList.get(0)) {
            return CommonResponse.error("当前合同有未审批的结算单，不能弃审/撤回!");
        }
        //若当前过程结算单不是最新的，则不能弃审/撤回
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, settleEntity.getContractId()));
        param.getOrderMap().put("create_time", QueryParam.DESC);
        List<SettleEntity> settleList = service.queryList(param);
        if (CollectionUtils.isNotEmpty(settleList) && null != settleList.get(0)) {
            SettleEntity nodeSettle = settleList.get(0);
            if (!nodeSettle.getId().equals(billId)) {
                return CommonResponse.error("当前单据已有新的结算单，不能弃审/撤回！");
            }
        }
		if(settleEntity.getSettleType()==2){
			//回写合同
			contractService.performanceStatusUp(settleEntity.getContractId(), 2);
		}
        if (CollectionUtils.isNotEmpty(settleEntity.getDeductionList())) {
            //回写扣款
            List<SettleDeductionEntity> detailList = settleEntity.getDeductionList();
            deductedService.hasRecordUp(detailList.stream().map(SettleDeductionEntity::getSourceId).collect(Collectors.toList()), 0);
        }
        return CommonResponse.success();
    }

}
